/*

xmalloc.h

Author: Tatu Ylonen <ylo@cs.hut.fi>

Copyright (c) 1995 Tatu Ylonen <ylo@cs.hut.fi>, Espoo, Finland
                   All rights reserved

Created: Mon Mar 20 22:09:17 1995 ylo

Versions of malloc and friends that check their results, and never return
failure (they call fatal if they encounter an error).

*/

/*
 * xmalloc.h,v 1.1.1.3 1999/10/22 18:32:32 woods Exp
 * xmalloc.h,v
 * Revision 1.1.1.3  1999/10/22 18:32:32  woods
 * SSH version 1.2.27 distribution
 *
 * Revision 1.1.1.1  1996/02/18 21:38:10  ylo
 * 	Imported ssh-1.2.13.
 *
 * Revision 1.2  1995/07/13  01:41:41  ylo
 * 	Removed "Last modified" header.
 * 	Added cvs log.
 *
 * $Endlog$
 */

#ifndef XMALLOC_H
#define XMALLOC_H

/* Like malloc, but calls fatal() if out of memory. */
void *xmalloc(size_t size);

/* Like realloc, but calls fatal() if out of memory. */
void *xrealloc(void *ptr, size_t new_size);

/* Frees memory allocated using xmalloc or xrealloc. */
void xfree(void *ptr);

/* Allocates memory using xmalloc, and copies the string into that memory. */
char *xstrdup(const char *str);

#endif /* XMALLOC_H */
