/*
 * This file is part of the Webmaster's Starter Kit Bootstrap Programs
 *
 * Copyright 1994 by Enterprise Integration Technologies Corporation
 *
 * This is freeware with commercialization rights reserved; see the
 * LICENSE included in the distribution for specifics.
 *
 * based on the statform 1.0 program fy Brian Behlendorf, gw@wired.com
 * and Kevin Hughes, kevinh@eit.com
 *
 * IN ORDER TO COMPILE THIS YOU WILL NEED THE LIBCGI LIBRARY,
 * available at ftp://wsk.eit.com/wsk/....
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include <cgi.h>

static char *argv0 = "cgi-bin/statform";
static char errstr[BUFSIZ];

static void progerr();

#define SUBJECT		"Getstats results"
#define MAXGETSTATSARGS	1024

int /* void ??? */
cgi_main(ci)
	cgi_info *ci;
{
  form_entry *p;
  form_entry *get_form_entries __P((cgi_info *));
  char *bdir, *mailaddress;
  char *gsargv[MAXGETSTATSARGS];
  int gsargc, i;
  
  switch(mcode(ci)) {
    
  case MCODE_HEAD:
  case MCODE_GET:
    puts("Location: /statform.html\n");
    break;
    
  case MCODE_POST:
    bdir = getenv("DOCUMENT_ROOT");
    if (bdir == NULL)
      bdir = "..";
    else
      strcat(bdir, "/..");
    chdir(bdir);
    
    mailaddress = NULL;
    gsargc = 0;
    gsargv[gsargc++] = "cgi-bin/getstats";
    gsargv[gsargc++] = "-dr";
    gsargv[gsargc++] = "doc";
    gsargv[gsargc++] = "-df";
    gsargv[gsargc++] = "conf/domain.codes.txt";
    gsargv[gsargc++] = "-ht";

    print_mimeheader("text/html");

    for(p=get_form_entries(ci); p; p = p->next) {
      if (!strcmp(p->name, "protocol")) {
	switch (*(p->val)) {
	case 'G':
	case 'N':
	case 'C':
	case 'P':
	  sprintf(gsargv[gsargc++] = malloc(3), "-%c", *(p->val));
	  break;
	case 'M':
	  gsargv[gsargc++] = "-A";
	  break;
	case 'U':
	  gsargv[gsargc++] = "-O";
	  break;
	default:
	  gsargv[gsargc++] = "-z";
	}
      }
      else if (!strcmp(p->name, "logfilename")) {
	gsargv[gsargc++] = "-l";
	gsargv[gsargc++] = (p->val && *(p->val)) ? p->val : "logs/access_log";
      }
      else if (!strcmp(p->name, "common") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-M";
      else if (!strcmp(p->name, "concise") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-c";
      else if (!strcmp(p->name, "toplines") && p->val && *(p->val)) {
	gsargv[gsargc++] = "-t";
	gsargv[gsargc++] = p->val;
      }
      else if (!strcmp(p->name, "all") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-a";
      else if (!strcmp(p->name, "monthly") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-m";
      else if (!strcmp(p->name, "weekly") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-w";
      else if (!strcmp(p->name, "daysweek") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-ds";
      else if (!strcmp(p->name, "daily") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-d";
      else if (!strcmp(p->name, "hoursday") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-hs";
      else if (!strcmp(p->name, "hourly") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-h";
      else if (!strcmp(p->name, "full-hostname") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-f";
      else if (!strcmp(p->name, "full-access") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-fa";
      else if (!strcmp(p->name, "full-lastaccess") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-fd";
      else if (!strcmp(p->name, "full-bytes") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-fb";
      else if (!strcmp(p->name, "request-name") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-r";
      else if (!strcmp(p->name, "request-accesses") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-ra";
      else if (!strcmp(p->name, "request-lastaccesses") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-rd";
      else if (!strcmp(p->name, "request-bytes") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-rb";
      else if (!strcmp(p->name, "request-filesize") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-rf";
      else if (!strcmp(p->name, "domain-name") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-dn";
      else if (!strcmp(p->name, "domain-requests") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-da";
      else if (!strcmp(p->name, "domain-lastaccesses") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-dd";
      else if (!strcmp(p->name, "domain-bytes") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-db";
      else if (!strcmp(p->name, "domain-sub") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-ds";
      else if (!strcmp(p->name, "filetree") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-dt";
      else if (!strcmp(p->name, "error") && !strcmp(p->val, "on"))
	gsargv[gsargc++] = "-e";
      else if (!strcmp(p->name, "samask") && p->val && *(p->val)) {
	gsargv[gsargc++] = "-sa";
	sprintf(gsargv[gsargc++]=malloc(strlen(p->val)+3), "\"%s\"", p->val);
      }
      else if (!strcmp(p->name, "ssmask") && p->val && *(p->val)) {
	gsargv[gsargc++] = "-ss";
	sprintf(gsargv[gsargc++]=malloc(strlen(p->val)+3), "\"%s\"", p->val);
      }
      else if (!strcmp(p->name, "srmask") && p->val && *(p->val)) {
	gsargv[gsargc++] = "-sr";
	sprintf(gsargv[gsargc++]=malloc(strlen(p->val)+3), "\"%s\"", p->val);
      }
      else if (!strcmp(p->name, "spmask") && p->val && *(p->val)) {
	gsargv[gsargc++] = "-sp";
	sprintf(gsargv[gsargc++]=malloc(strlen(p->val)+3), "\"%s\"", p->val);
      }
      else if (!strcmp(p->name, "sdmask") && p->val && *(p->val)) {
	gsargv[gsargc++] = "-sd";
	sprintf(gsargv[gsargc++]=malloc(strlen(p->val)+3), "\"%s\"", p->val);
      }
      else if (!strcmp(p->name, "shmask") && p->val && *(p->val)) {
	gsargv[gsargc++] = "-sh";
	sprintf(gsargv[gsargc++]=malloc(strlen(p->val)+3), "\"%s\"", p->val);
      }
      else if (!strcmp(p->name, "swmask") && p->val && *(p->val)) {
	gsargv[gsargc++] = "-sw";
	sprintf(gsargv[gsargc++]=malloc(strlen(p->val)+3), "\"%s\"", p->val);
      }
      else if (!strcmp(p->name, "mailme")) mailaddress = p->val;
    }

    if (mailaddress && *mailaddress) {
      int fd[2];
      puts("<h1>Getstats by mail</h1>");
      printf("<p>Sending the getstats report to %s.\n", mailaddress);
      fflush(stdout);
      if (fork()) exit(0); /* detach so server responds */
      pipe(fd);
      if (fork() == 0) {
	dup2(fd[0], STDIN_FILENO);
	execl("/usr/lib/sendmail", "sendmail", "-t", NULL);
      }
      dup2(fd[1], STDOUT_FILENO);
      printf("To: %s\nSubject: getstats report\n\n", mailaddress);
      print_mimeheader("text/html");
    }
    fflush(stdout);
    gsargv[gsargc] = NULL;
    execv(gsargv[0], gsargv);

    break;

  default:
    sprintf(errstr, "Unrecognized method '%s'.\n", ci->request_method);
    progerr(errstr);
  }
}

static void
progerr(errorstr)
     char *errorstr;
{
	printf("Content-type: text/html\n\n");

	printf("<title>Getstats error</title>\n");
	printf("<h1>Getstats error</h1>\n<p>\n");
	printf("<code>%s: %s</code>\n", argv0, errorstr);

	fprintf(stderr, "%s: %s\n", argv0, errorstr);

	exit(1);
}
