#ifndef lint
static char rcsid[] = "daemon.c,v 1.1 1997/04/29 05:12:20 woods Exp";
#endif

#include <fcntl.h>
#include "../../conf/portability.h"
#include "../../named/pathnames.h"

#if !defined(NEED_DAEMON)
int __bindcompat_daemon;
#else

int
daemon(nochdir, noclose)
	int nochdir;
	int noclose;
{
	int fd;

	switch (fork()) {
	case -1:
		return(-1);
		/* NOTREACHED */
	case 0:
		/* child */
		break;
	default:
		/* parent */
		_exit(0);
		/* NOTREACHED */
	}
	if (!nochdir) {
		if (chdir("/") == -1)
			return(-1);
	}
# ifdef USE_SETSID
	if (setsid() == -1)
		return(-1);
# else
#  if defined(SYSV) || defined(hpux)
	if (setpgrp() == -1)
		return(-1);
#  else
	{
		struct itimerval ival;
		/*
		 * The open below may hang on pseudo ttys if the person
		 * who starts named logs out before this point.
		 *
		 * needmaint may get set inapropriately if the open
		 * hangs, but all that will happen is we will see that
		 * no maintenance is required.
		 */
		bzero((char *)&ival, sizeof(ival));
		ival.it_value.tv_sec = 120;
		(void) setitimer(ITIMER_REAL, &ival,
			    (struct itimerval *)NULL);
		if ((n = open(_PATH_TTY, O_RDWR)) == -1)
			panic(errno, "open(_PATH_TTY)");
		ival.it_value.tv_sec = 0;
		(void) setitimer(ITIMER_REAL, &ival,
			    (struct itimerval *)NULL);
		if (n > 0) {
			(void) ioctl(n, TIOCNOTTY, (char *)NULL);
			(void) my_close(n);
		}
	}
#  endif /* SYSV || hpux */
# endif /* USE_SETSID */
	if (!noclose && (fd = open(_PATH_DEVNULL, O_RDWR, 0)) != -1) {
		(void) dup2(fd, STDIN_FILENO);
		(void) dup2(fd, STDOUT_FILENO);
		(void) dup2(fd, STDERR_FILENO);
		if (fd > 2)
			(void) close (fd);
        }
        return (0);
}

#endif /* NEED_DAEMON */
