/*
** Declaration of functions.
**
**	@(#)defs.h              e07@nikhef.nl (Eric Wassenaar) 971006
*/

/*
** Internal modules of the traceroute utility
** ------------------------------------------
*/
	/* main.c */

int main		PROTO((int, char **));
void set_defaults	PROTO((char *, int, char **));
int getval		PROTO((char *, char *, int, int));
void fatal		PROTO((char *, ...));
void error		PROTO((char *, ...));
void check_proto	PROTO((void));
void get_socket		PROTO((void));
#ifdef IP_OPTIONS
void set_options	PROTO((ipaddr_t *, int));
#endif /*IP_OPTIONS*/

	/* traceroute.c */

bool ping		PROTO((ipaddr_t));
bool trace_route	PROTO((ipaddr_t));
int send_probe		PROTO((int, int, int, int));
int recv_reply		PROTO((int, struct timeval *));
int check_reply		PROTO((u_char *, int, int));

	/* dump.c */

void print_icmph	PROTO((struct icmp *, int));
void print_ippkt	PROTO((struct ip *, int));
void print_iphdr	PROTO((struct ip *, int));
#ifdef IP_OPTIONS
void print_options	PROTO((u_char *, int));
void print_route	PROTO((u_char *));
#endif /*IP_OPTIONS*/

	/* util.c */

char *pr_port		PROTO((char *, u_short));
#ifdef obsolete
char *pr_type		PROTO((int));
char *pr_code		PROTO((int));
#endif /*obsolete*/
void print_from		PROTO((u_char *, int, struct in_addr));
char *inetname		PROTO((struct in_addr));
char *pr_addr		PROTO((struct in_addr));
char *maphostbyaddr	PROTO((struct in_addr));
ipaddr_t getgate	PROTO((char *));
bool gatewayaddr	PROTO((struct in_addr));
#ifdef notyet
u_short in_checksum	PROTO((u_short *, int));
#endif /*notyet*/
time_t tvsub		PROTO((struct timeval *, struct timeval *));
char *tvprint		PROTO((time_t));
void print_stats	PROTO((int));
void record_stats	PROTO((time_t));
void clear_stats	PROTO((void));
int select_mtu		PROTO((int));
bool regular_ttl	PROTO((int));

	/* misc.c */

char *maxstr		PROTO((char *, int, bool));
ptr_t *xalloc		PROTO((ptr_t *, siz_t));
char *itoa		PROTO((int));
double xsqrt		PROTO((double));

	/* aslookup.c */

char *as_lookup		PROTO((struct in_addr, char *, int, bool));
int as_connect		PROTO((char *, int));
void as_disconnect	PROTO((void));
void as_put		PROTO((char *));
char *as_get		PROTO((char *, int));
char *as_netof		PROTO((struct in_addr));

/*
** External library functions
** --------------------------
*/
	/* extern */

#if !defined(NO_INET_H)
#include <arpa/inet.h>
#else

ipaddr_t inet_addr	PROTO((CONST char *));
char *inet_ntoa		PROTO((struct in_addr));

#endif

	/* avoid <strings.h> */

#if !defined(index)

char *index		PROTO((const char *, int));
char *rindex		PROTO((const char *, int));

#endif

	/* <string.h> */

#if !defined(NO_STRING_H)
#include <string.h>
#else

char *strcpy		PROTO((char *, const char *));
char *strncpy		PROTO((char *, const char *, siz_t));

#endif

	/* <stdlib.h> */

#if defined(__STDC__) && !defined(apollo)
#include <stdlib.h>
#else

char *getenv		PROTO((const char *));
ptr_t *malloc		PROTO((siz_t));
ptr_t *realloc		PROTO((ptr_t *, siz_t));
free_t free		PROTO((ptr_t *));
void exit		PROTO((int));

#endif

	/* <unistd.h> */

#if defined(__STDC__) && !defined(apollo)
#include <unistd.h>
#else

unsigned int alarm	PROTO((unsigned int));

#endif
