/*
** Various configuration definitions.
**
**	@(#)conf.h              e07@nikhef.nl (Eric Wassenaar) 961230
*/

/*
 * Well-known TTL values. These are checked in module regular_ttl().
 */

#define	MAX_START_TTL	255	/* Cisco and BSD4.3 */
#define	NETWARE_TTL	128	/* Netware routers */
#define	OLD_PROTEON_TTL	29	/* Proteon 8.1 and lower */
#define	NEW_PROTEON_TTL	59	/* Proteon 8.2 and higher */
#define	OLD_BSD_TCP	30
#define	NEW_BSD_TCP	60

/*
 * Table of MTU sizes in decreasing order. See RFC 1191 for details.
 */

int mtusize[] =
{
	65535,	/* absolute maximum */
	32000,	/* arbitrary big value */
	17914,	/* IBM token ring */
	8166,	/* IEEE 802.4 */
	4464,	/* IEEE 802.5 */
	4352,	/* FDDI */
	2048,	/* Wideband network */
	2002,	/* IEEE 802.5 */
	1500,	/* Ethernet */
	1492,	/* IEEE 802.3 */
	1268,	/* Apollo token ring */
	1006,	/* SLIP */
	576,	/* X.25 */
	544,	/* DEC IP Portal */
	512,	/* NetBios */
	508,	/* IEEE 802 */
	296,	/* point-to-point */
	68,	/* official minimum */
	0
};

/*
 * Miscellaneous default values.
 */

#define DEF_MAXHOPS	30	/* -m  max number of hops */
#define DEF_NPROBES	3	/* -q  number of probe packets to send */
#define DEF_MAXQUIT	5	/* -Q  quit after this consecutive timeouts */
#define DEF_TIMEOUT	3	/* -w  time to wait for response (seconds) */
#define DEF_RETRIES	2	/* number of datagram retries per nameserver */
#define DEF_RETRANS	3	/* timeout (seconds) between datagram retries */
