/*
** Various configuration definitions.
**
**	@(#)aslookup.h          e07@nikhef.nl (Eric Wassenaar) 990207
*/

/*
 * Default whois server.
 * This can be overruled via the environment variable AS_SERVER_HOST,
 * or (both commands) via the ``-h server'' command line option.
 * If neither is defined, and no default server is defined, you lose.
 *
#define AS_SERVER_HOST	"whois.ripe.net"
 */

#ifndef AS_SERVER_HOST
#undef  AS_SERVER_HOST		/* default is to have no server */
#endif

/*
 * Default service port.
 * This can be overruled via the environment variable AS_SERVER_PORT,
 * or (for aslookup only) via the ``-p port'' command line option.
 * If neither is defined, the default service port below is used.
 */

#ifndef AS_SERVER_PORT
#define AS_SERVER_PORT	43	/* default whois service */
#endif

/*
 * Special server options.
 * This can be overruled via the environment variable AS_SERVER_OPTIONS.
 * If not defined, no special options will be used.
 * Note that the special option "-k" will be automatically inserted if
 * the ``-k'' flag is specified on the command line (both commands).
 * If you include the "-k" option here, it *must* be first.
 *
#define AS_SERVER_OPTIONS "-k"		[always keep connection open]
#define AS_SERVER_OPTIONS "-a"		[search all available databases]
#define AS_SERVER_OPTIONS "-T route"	[only select this type of records]
 */

#ifndef AS_SERVER_OPTIONS
#undef  AS_SERVER_OPTIONS	/* default is to have no special options */
#endif

/*
 * Mask network addresses.
 * It may be necessary to present only network addresses to whois servers
 * instead of full IP addresses. Setting this flag forces that behaviour.
 * Servers that conform to the RIPE181/RPSL standard database format accept
 * full IP addresses however, and will compute the proper network address
 * themselves, allowing for CIDR addresses.
 * We assume that this is the default for the servers that are queried.
 */

#ifndef AS_NETMASK
#undef  AS_NETMASK		/* default is to not mask the network */
#endif

/*
 * Miscellaneous constants.
 */

#define CONNTIMEOUT	6	/* timeout in secs for connect */
#define READTIMEOUT	60	/* timeout in secs for read reply */
