<JSB>
    <JSB_DESCRIPTOR NAME="netscape.peas.DBexport" DISPLAYNAME="Database Export"
        SHORTDESCRIPTION="Export query result to file on server"
        ISHIDDEN ENV="server">

    <JSB_PROPERTY NAME="cursor" DISPLAYNAME="Cursor" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of Cursor to use">

    <JSB_PROPERTY NAME="filename" DISPLAYNAME="File Name" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name and path of file to export to">

    <JSB_PROPERTY NAME="separator" DISPLAYNAME="Separator Character" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Separator String to use">

    <JSB_PROPERTY NAME="includeColNames" DISPLAYNAME="Include Column Names" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Include Column Names as First Row?">

    <JSB_METHOD NAME="export" TYPE="void"> </JSB_METHOD>

    <JSB_CONSTRUCTOR>
function _typeof( val ) {

    if (server.httpdlwVersion.indexOf("1.0") != -1) { //----- Server 2.0
	    if ( val == null )  return ("number");
	    if ( val.charAt != null )  return ("string");
	    var valStr = "" + val
	    var intValue = parseInt( valStr )
	    var floatValue = parseFloat( valStr )
	    if ( isNaN(intValue) && isNaN(floatValue) )
	        return("object")
	    else
	        return("number")

	} else {  //----- Server 3.x+
	    return( typeof( val ) )
	}
}

function quote(str) {
	return "\"" + str + "\""
}

function quoteIfNeeded(obj) {
	if (_typeof( obj )=="string")
		return quote( obj )
	else
		return obj
}

function netscape_peas_DBexport(params) {
	f = new File(params.filename)
	f.open("w")
	c = params.cursor
	s = params.separator
	if (params.includeColNames) {
		for (i = 0;i < c.columns()-1; i++) {
			f.write(quote(c.columnName(i))+s)
		}
		f.writeln(quote(c[i]))
	}

	while( c.next() ) {
		for (i = 0; i < c.columns()-1; i++) {
			f.write(quoteIfNeeded(c[i])+s)
		}
		f.writeln(quoteIfNeeded(c[i]))
	}
	f.close()
	c.close()

}
    </JSB_CONSTRUCTOR>
</JSB>