<JSB>
    <JSB_DESCRIPTOR NAME="netscape.peas.CustomTable" DISPLAYNAME="Custom Server Table"
        HELP_URL="$installdir/doc/compref1.htm#Custom Server Table"
        SHORTDESCRIPTION="Custom Database Table Display (server-side)"
        ISHIDDEN ENV="server">

    <JSB_PROPERTY NAME="align" DISPLAYNAME="Alignment" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="left,right"
        SHORTDESCRIPTION="Alignment of table on page">

    <JSB_PROPERTY NAME="bgColor" DISPLAYNAME="Background Color" PROPTYPE="JS" TYPE="color"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Background color of table">

    <JSB_PROPERTY NAME="border" DISPLAYNAME="Border Width" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="" VALUESET="1:99"
        SHORTDESCRIPTION="Width of table border">

    <JSB_PROPERTY NAME="captionPos" DISPLAYNAME="Caption Position" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="top,bottom"
        SHORTDESCRIPTION="Position of caption">

    <JSB_PROPERTY NAME="captionFontSize" DISPLAYNAME="Caption Font Size" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="" VALUESET="1:7"
        SHORTDESCRIPTION="Font size of caption">

    <JSB_PROPERTY NAME="caption" DISPLAYNAME="Caption Text" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Text for table caption">

    <JSB_PROPERTY NAME="cellPadding" DISPLAYNAME="Cell Padding" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="" VALUESET="1:99"
        SHORTDESCRIPTION="Pixels between cell border and contents">

    <JSB_PROPERTY NAME="cellSpacing" DISPLAYNAME="Cell Spacing" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="" VALUESET="1:99"
        SHORTDESCRIPTION="Pixels between cells">

    <JSB_PROPERTY NAME="colHeadings" DISPLAYNAME="Column Headings?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Whether to display column headings">

    <JSB_PROPERTY NAME="customHeadings" DISPLAYNAME="Custom Headings" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="String to use for custom headings instead of column names">

    <JSB_PROPERTY NAME="dateFormat" DISPLAYNAME="Date Format" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="mm/dd/yy,dd/mm/yy,None"
        SHORTDESCRIPTION="Format for display of date fields">

    <JSB_PROPERTY NAME="enableSortSelection" DISPLAYNAME="Enable Sort Selection?" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Whether to enable links in columns to specify sorting">

    <JSB_PROPERTY NAME="sourceCursor" DISPLAYNAME="Cursor" PROPTYPE="JS" TYPE="object"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of cursor from which to get data">

    <JSB_PROPERTY NAME="detailPage" DISPLAYNAME="Detail Page" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="URL of detail page to link to (if any)">

    <JSB_PROPERTY NAME="detailTarget" DISPLAYNAME="Detail Target" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Frame name of detail link (if any)">

    <JSB_PROPERTY NAME="FkeyCol" DISPLAYNAME="Foreign Key Column" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Foreign Key Column for detail linking (if any)">

    <JSB_PROPERTY NAME="hAlign" DISPLAYNAME="Horizontal Alignment" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="left,right,center"
        SHORTDESCRIPTION="Horizontal alignment of contents within cells">

    <JSB_PROPERTY NAME="headBGColor" DISPLAYNAME="Heading BG Color" PROPTYPE="JS" TYPE="color"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Background color of heading">

    <JSB_PROPERTY NAME="keyCol" DISPLAYNAME="Key Column" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Key Column for detail linking (if any)">

    <JSB_PROPERTY NAME="nowrap" DISPLAYNAME="No Wrapping" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Do not cell contents or not">

    <JSB_PROPERTY NAME="vAlign" DISPLAYNAME="Vertical Alignment" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="top,center,bottom,baseline"
        SHORTDESCRIPTION="Vertical alignment of contents within cells">

    <JSB_PROPERTY NAME="width" DISPLAYNAME="Width" PROPTYPE="JS" TYPE="number"
        READMETHOD="" WRITEMETHOD="" TYPE="numberOrPercent"
        SHORTDESCRIPTION="Width of table (pixels or percent)">

    <JSB_PROPERTY NAME="layout" DISPLAYNAME="Layout" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="columnar,horizontal,horizontal-centered"
        SHORTDESCRIPTION="Display as table (columnar) or label-style (horizontal)">

    <JSB_PROPERTY NAME="separator" DISPLAYNAME="Separator" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD="" VALUESET="none,line,half-line"
        SHORTDESCRIPTION="Separator between row data (horizontal layout only)">

    <!-JSB_PROPERTY NAME="release" DISPLAYNAME="Release Connection" PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""  DEFAULT_VALUE="true"
        SHORTDESCRIPTION="Whether to release the database connection when finished processing"-!>

    <JSB_CONSTRUCTOR>
function _typeOf( val ) {

    if (server.httpdlwVersion.indexOf("1.0") != -1) { //----- Server 2.0
	    if ( val == null )  return ("number");
	    if ( val.charAt != null )  return ("string");
	    var valStr = "" + val
	    var intValue = parseInt( valStr )
	    var floatValue = parseFloat( valStr )
	    if ( isNaN(intValue) && isNaN(floatValue) )
	        return("object")
	    else
	        return("number")

	} else { //----- Server 3.x+
	    return( typeof( val ) )
	}
}

function formatDate(format, dateObj) {
    month = dateObj.getMonth() + 1
    day = dateObj.getDate()
    year = dateObj.getYear()
    if (format == "mm/dd/yy")
      return month + "/" + day + "/" + year
    else if (format == "dd/mm/yy")
      return day + "/" + month + "/" + year
    else
      return dateObj.toString()
}


function detailLink(ct, c, colName) {
    if ( (ct.detailPage != null) && (ct.FkeyCol != null) && (ct.keyCol.toUpperCase() == colName.toUpperCase()) ) {
      if ( ct.detailTarget != null ) {
        sTarget = " TARGET='" + ct.detailTarget + "'";
      } else {
        sTarget = "";
      }
      linkStr = "<A HREF='" + ct.detailPage + "?_" + ct.FkeyCol + "=" + escape(c[colName]) + "'" + sTarget + ">" + c[colName] + "</A>"
      return linkStr
    } else {
      if ( (_typeOf(c[colName]) == "object") && (c[colName]!=null) ) //its a date
         return formatDate(ct.dateFormat, c[colName])
      else
         return c[colName]
    }
} //detailLink

function createSortLink(ct, colName) {
   if (ct.enableSortSelection)
      return ("<SCRIPT>document.write(\"" + displayColName(ct.custHeadingsObj, colName) + "\".link(setSearch(document.URL,\"" + colName + "\")))</SCRIPT>")
   else
      return displayColName(ct.custHeadingsObj, colName)
}

function sep(s, w) {
   pre = "<TR ><TD COLSPAN=2>"
   post = "</TD></TR>"

   if ( (s=="none") || (s=="") || (s==null) )
      line = ""
   else if (s == "line")
      line = "<HR WIDTH=" + w +">"
   else if (s == "half-line") {
      if ( w.indexOf("%") == -1 )
          width = 0.5 * parseFloat(w)
      else {
          width = 0.5 * parseFloat(w.substring(0, w.length-1))
	      width += "%"
      }
	  line = "<HR WIDTH=" + width + ">"
   }
   return pre + line + post
}

function getWidth(w) {
   if ((w == null) || (w == "") )
      return ""
   else
      return " WIDTH=" + w
}

function parseCustColNames(str) {
   if ((str == "") | (str == null))
      return null
   obj = new Object()
   while (str.length>0) {
      end = str.indexOf(";")
      if (end==-1) end = str.length
      pair = str.substring(0,end)
      colName = pair.substring(0,str.indexOf(","))
      custName = pair.substring(colName.length+1, pair.length)
      obj[colName] = custName
      str = str.substring(pair.length+1, str.length)
   }
   return obj
}

function displayColName(custHeadings, colName) {
   if (custHeadings == null) return colName
   else if (custHeadings[colName] == null) {
      debug("Returning " + custHeadings[colName])
      return colName }
   else return custHeadings[colName]
}

function netscape_peas_CustomTable(params) {
   write("<SCRIPT SRC='cCustomTable.js'></SCRIPT>")
   params.custHeadingsObj = parseCustColNames(params.customHeadings)

   curs = params.sourceCursor
   h = "<TABLE ALIGN=" + params.align + " BGCOLOR=" + params.bgColor + " BORDER=" + params.border
   h += " CELLPADDING=" + params.cellPadding + " CELLSPACING=" + params.cellSpacing + getWidth(params.width) + " >"

   if (params.caption != null)
      h += "<CAPTION ALIGN=" + params.captionPos + "><FONT SIZE=" + params.captionFontSize + ">" + params.caption + "</FONT></CAPTION>"

   if ( (params.layout == "columnar") || (params.layout=="") || (params.layout==null) ) {
       if (params.colHeadings) {
          h += "<TR>"
          for (i = 0; i < curs.columns(); i++)
             h += "<TH BGCOLOR=" + params.headBGColor + ">" + createSortLink(params, curs.columnName(i)) + "</TH>"
          h += "</TR>"
       }

       while  ( curs.next() ) {
          h+= "<TR ALIGN=" + params.hAlign + " VALIGN=" + params.vAlign + ">"
          for (i = 0; i < curs.columns(); i++)
             h += "<TD" + ( (params.nowrap) ? " NOWRAP>" : ">") + detailLink(params, curs, curs.columnName(i)) + "</TD>"
          h += "</TR>"
       }
   } else {
      if (params.layout=="horizontal-centered") {
         LColAlign = "right"
         RColAlign = "left"
      } else {
         LColAlign = params.hAlign
         RColAlign = params.hAlign
      }

      while (curs.next()) {
         for (i = 0; i < curs.columns(); i++) {
            if (params.colHeadings)
               h += "<TR ALIGN=" + " VALIGN=" + params.vAlign + "><TH ALIGN=" + LColAlign + " BGCOLOR=" + params.headBGColor + ( (params.nowrap) ? " NOWRAP>" : ">") + displayColName(params.custHeadingsObj, curs.columnName(i)) +"</B></TH>"
            h += "<TD ALIGN=" + RColAlign + ( (params.nowrap) ? " NOWRAP>" : ">") + detailLink(params, curs, curs.columnName(i)) +"</TD></TR>"
         }
	     h+= sep(params.separator, params.width)
      }
   }

   h += "</TABLE>"
   curs.close()
   //if ( (params.release) && (server.httpdlwVersion.indexOf("1.0") == -1) ) {
   if ( (server.httpdlwVersion.indexOf("1.0") == -1) ) {
      curs.DBConnection.release()
   }
   write( h )
} // function netscape_peas_CustomTable
    </JSB_CONSTRUCTOR>
</JSB>