var webdeveloper_appliedStyles               = new Array();
var webdeveloper_debug                       = false;
var webdeveloper_javaScriptConsoleListener   = false;
var webdeveloper_javaScriptCurrentTime       = null;
var webdeveloper_javaScriptPreviousTime      = null;
var webdeveloper_keyboardShortcutsConfigured = false;
var webdeveloper_localizedOptionsSetup       = false;
var webdeveloper_outlinedElements            = new Array();
var webdeveloper_selectedTab                 = -1;
var webdeveloper_userStyleSheet              = null;

webdeveloper_initialize();

// Displays the about dialog
function webdeveloper_about()
{
    window.openDialog("chrome://webdeveloper/content/about/about.xul", "webdeveloper-about-dialog", "centerscreen,chrome,modal");
}

// Add applied style
function webdeveloper_addAppliedStyle(id)
{
    webdeveloper_appliedStyles.push(id);
}

// Adds the style sheet at the given location with the given id
function webdeveloper_addStyleSheet(location, id, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var headElementList = null;
    var linkElement     = null;
    var pageDocument    = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument    = documentList[i];
        headElementList = pageDocument.getElementsByTagName("head");
        linkElement     = pageDocument.createElement("link");

        linkElement.setAttribute("href", location);
        linkElement.setAttribute("id", id);
        linkElement.setAttribute("media", "all");
        linkElement.setAttribute("rel", "stylesheet");
        linkElement.setAttribute("type", "text/css");

        // If there is a head element
        if(headElementList.length > 0)
        {
            headElementList[0].appendChild(linkElement);
        }
        else
        {
            pageDocument.documentElement.appendChild(linkElement);
        }
    }

    // If applying style
    if(applyStyle)
    {
        webdeveloper_addAppliedStyle(id);
    }
}

// Applies all selected style sheets
function webdeveloper_applyStyleSheets(reload)
{
    var appliedStyle = null;

    // Loop through the applied styles
    for(var i = 0; i < webdeveloper_appliedStyles.length; i++)
    {
        appliedStyle = webdeveloper_appliedStyles[i];

        // Switch on the style
        switch(appliedStyle)
        {
            case "webdeveloper-add-user-style-sheet":
                webdeveloper_addUserStyleSheet(document.getElementById("webdeveloper-add-user-style-sheet-menu"), false);
                break;
            case "webdeveloper-disable-all-styles":
                webdeveloper_toggleStyles(document.getElementById("webdeveloper-disable-all-styles-menu"), false);
                break;
            case "webdeveloper-disable-default-styles":
                webdeveloper_toggleStyles(document.getElementById("webdeveloper-disable-default-styles-menu"), false);
                break;
            case "webdeveloper-disable-embedded-styles":
                webdeveloper_toggleEmbeddedStyles(document.getElementById("webdeveloper-disable-embedded-styles-menu"), false);
                break;
            case "webdeveloper-disable-inline-styles":
                webdeveloper_toggleInlineStyles(document.getElementById("webdeveloper-disable-inline-styles-menu"), false);
                break;
            case "webdeveloper-disable-linked-styles":
                webdeveloper_toggleLinkedStyles(document.getElementById("webdeveloper-disable-linked-styles-menu"), false);
                break;
            case "webdeveloper-display-access-keys":
                webdeveloper_displayAccessKeys(document.getElementById("webdeveloper-display-access-keys-menu"), false);
                break;
            case "webdeveloper-display-anchors":
                webdeveloper_displayAnchors(document.getElementById("webdeveloper-display-anchors-menu"), false);
                break;
            case "webdeveloper-display-block-size":
                webdeveloper_displayBlockSize(document.getElementById("webdeveloper-display-block-size-menu"), false);
                break;
            case "webdeveloper-display-current-size-title":
                // If the page has been reloaded
                if(reload)
                {
                    webdeveloper_displayWindowSizeInTitle(document.getElementById("webdeveloper-display-current-size-title-menu"), false);
                }
                break;
            case "webdeveloper-display-form-details":
                webdeveloper_displayFormDetails(document.getElementById("webdeveloper-display-form-details-menu"), false);
                break;
            case "webdeveloper-display-id-class-details":
                webdeveloper_displayIDClassDetails(document.getElementById("webdeveloper-display-id-class-details-menu"), false);
                break;
            case "webdeveloper-display-image-dimensions":
                webdeveloper_displayImageDimensions(document.getElementById("webdeveloper-display-image-dimensions-menu"), false);
                break;
            case "webdeveloper-display-image-file-sizes":
                webdeveloper_displayImageFileSizes(document.getElementById("webdeveloper-display-image-file-sizes-menu"), false);
                break;
            case "webdeveloper-display-image-paths":
                webdeveloper_displayImagePaths(document.getElementById("webdeveloper-display-image-paths-menu"), false);
                break;
            case "webdeveloper-display-link-paths":
                webdeveloper_displayLinkPaths(document.getElementById("webdeveloper-display-link-paths-menu"), false);
                break;
            case "webdeveloper-display-tab-index":
                webdeveloper_displayTabIndex(document.getElementById("webdeveloper-display-tab-index-menu"), false);
                break;
            case "webdeveloper-display-topographic-information":
                webdeveloper_displayTopographicInformation(document.getElementById("webdeveloper-display-topographic-information-menu"), false);
                break;
            case "webdeveloper-hide-background-images":
                webdeveloper_hideBackgroundImages(document.getElementById("webdeveloper-hide-background-images-menu"), false);
                break;
            case "webdeveloper-hide-images":
                webdeveloper_hideImages(document.getElementById("webdeveloper-hide-images-menu"), "webdeveloper-hide-images", false);
                break;
            case "webdeveloper-linearize-page":
                webdeveloper_linearizePage(document.getElementById("webdeveloper-linearize-page-menu"), false);
                break;
            case "webdeveloper-make-images-invisible":
                webdeveloper_makeImagesInvisible(document.getElementById("webdeveloper-make-images-invisible-menu"), "webdeveloper-make-images-invisible", false);
                break;
            case "webdeveloper-outline-block-level-elements":
                webdeveloper_outlineBlockLevelElements(document.getElementById("webdeveloper-outline-block-level-elements-menu"), false);
                break;
            case "webdeveloper-outline-custom-elements":
                webdeveloper_outlineElements(document.getElementById("webdeveloper-outline-custom-elements-menu"), false);
                break;
            case "webdeveloper-outline-deprecated-elements":
                webdeveloper_outlineDeprecatedElements(document.getElementById("webdeveloper-outline-deprecated-elements-menu"), false);
                break;
            case "webdeveloper-outline-frames":
                webdeveloper_outlineFrames(document.getElementById("webdeveloper-outline-frames-menu"), false);
                break;
            case "webdeveloper-outline-images-with-adjusted-dimensions":
                webdeveloper_outlineImagesWithAdjustedDimensions(document.getElementById("webdeveloper-outline-images-with-adjusted-dimensions-menu"), false);
                break;
            case "webdeveloper-outline-images-with-empty-alt-attributes":
                webdeveloper_outlineImagesWithEmptyAltAttributes(document.getElementById("webdeveloper-outline-images-with-empty-alt-attributes-menu"), false);
                break;
            case "webdeveloper-outline-images-without-alt-attributes":
                webdeveloper_outlineImagesWithoutAltAttributes(document.getElementById("webdeveloper-outline-images-without-alt-attributes-menu"), false);
                break;
            case "webdeveloper-outline-images-without-dimensions":
                webdeveloper_outlineImagesWithoutDimensions(document.getElementById("webdeveloper-outline-images-without-dimensions-menu"), false);
                break;
            case "webdeveloper-outline-images-without-title-attributes":
                webdeveloper_outlineImagesWithoutTitleAttributes(document.getElementById("webdeveloper-outline-images-without-title-attributes-menu"), false);
                break;
            case "webdeveloper-outline-links-without-title-attributes":
                webdeveloper_outlineLinksWithoutTitleAttributes(document.getElementById("webdeveloper-outline-links-without-title-attributes-menu"), false);
                break;
            case "webdeveloper-outline-selected-element":
                webdeveloper_outlineSelectedElement(document.getElementById("webdeveloper-outline-selected-element-menu"), false);
                break;
            case "webdeveloper-outline-table-cells":
                webdeveloper_outlineTableCells(document.getElementById("webdeveloper-outline-table-cells-menu"), false);
                break;
            case "webdeveloper-outline-tables":
                webdeveloper_outlineTables(document.getElementById("webdeveloper-outline-tables-menu"), false);
                break;
            case "webdeveloper-replace-images-with-alt-attributes":
                webdeveloper_replaceImagesWithAltAttributes(document.getElementById("webdeveloper-replace-images-with-alt-attributes-menu"), false);
                break;
            case "webdeveloper-show-comments":
                webdeveloper_toggleComments(document.getElementById("webdeveloper-show-comments-menu"), false);
                break;
            case "webdeveloper-use-border-box-model":
                webdeveloper_useBorderBoxModel(document.getElementById("webdeveloper-use-border-box-model-menu"), false);
                break;
            case "webdeveloper-view-style-information":
                webdeveloper_viewStyleInformation(document.getElementById("webdeveloper-view-style-information-menu"), false);
                break;
        }
    }
}

// Changes the options
function webdeveloper_changeOptions(currentDocument)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const toolbar            = document.getElementById("webdeveloper-toolbar");

    var element                   = null;
    var hideMenuPreference        = false;
    var hideContextMenuPreference = false;

    // If the hide menu preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.menu.hide"))
    {
        hideMenuPreference = preferencesService.getBoolPref("webdeveloper.menu.hide");
    }

    // If the hide context menu preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.context.hide"))
    {
        hideContextMenuPreference = preferencesService.getBoolPref("webdeveloper.context.hide");
    }

    // If the toolbar exists
    if(toolbar)
    {
        const toolbarVisible = window.toolbar.visible;

        // If the toolbar is visible and the toolbar icons preference is set
        if(toolbarVisible && preferencesService.prefHasUserValue("webdeveloper.toolbar.icons"))
        {
            const toolbarButtons = toolbar.getElementsByTagName("toolbarbutton");

            var toolbarPreference = preferencesService.getComplexValue("webdeveloper.toolbar.icons", Components.interfaces.nsISupportsString).data.trim();

            toolbar.setAttribute("mode", toolbarPreference);

            // If the toolbar preference is set to full
            if(toolbarPreference == "full")
            {
                toolbarPreference = null;
            }
            else if(toolbarPreference == "icons")
            {
                toolbarPreference = "pictures";
            }

            toolbar.setAttribute("buttonstyle", toolbarPreference);

            // Loop through the toolbar buttons
            for(var i = 0; i < toolbarButtons.length; i++)
            {
                toolbarButtons[i].setAttribute("buttonstyle", toolbarPreference);
            }

            // If the toolbar preference is set to text
            if(toolbarPreference == "text")
            {
                element = document.getElementById("webdeveloper-toggle-statusbar");

                // If the element exists
                if(element)
                {
                    const stringBundle = document.getElementById("webdeveloper-string-bundle");

                    element.setAttribute("label", stringBundle.getString("webdeveloper_toggleLabel"));
                }
            }
            else
            {
                element = document.getElementById("webdeveloper-javascript-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }

                element = document.getElementById("webdeveloper-render-mode-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }

                element = document.getElementById("webdeveloper-toggle-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }
            }
        }
    }

    element = document.getElementById("webdeveloper-menu");

    // If the element exists
    if(element)
    {
        element.setAttribute("hidden", hideMenuPreference);
    }

    element = document.getElementById("webdeveloper-context");

    // If the element exists
    if(element)
    {
        element.setAttribute("hidden", hideContextMenuPreference);
    }

    element = document.getElementById("webdeveloper-context-separator");

    // If the element exists
    if(element)
    {
        element.setAttribute("hidden", hideContextMenuPreference);
    }

    // If the keyboard shortcuts have not been configured
    if(!webdeveloper_keyboardShortcutsConfigured)
    {
        webdeveloper_keyboardShortcutsConfigured = webdeveloper_configureKeyboardShortcuts(false);
    }
}

// Configures the equivalent element to whichever one is set
function webdeveloper_configureEquivalentElements(element, attribute, value)
{
    const elementId = element.getAttribute("id");

    var equivalentElement   = null;
    var equivalentElementId = null;

    // If the element exists
    if(element)
    {
        // If the value is set
        if(value)
        {
            element.setAttribute(attribute, value);
        }
        else
        {
            element.removeAttribute(attribute);
        }
    }

    // If the element is the context
    if(elementId.indexOf("context") != -1)
    {
        equivalentElementId = elementId.split("context").join("menu");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If the value is set
            if(value)
            {
                equivalentElement.setAttribute(attribute, value);
            }
            else
            {
                equivalentElement.removeAttribute(attribute);
            }
        }

        equivalentElementId = elementId.split("context").join("toolbar");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If the value is set
            if(value)
            {
                equivalentElement.setAttribute(attribute, value);
            }
            else
            {
                equivalentElement.removeAttribute(attribute);
            }
        }
    }
    else if(elementId.indexOf("menu") != -1)
    {
        equivalentElementId = elementId.split("menu").join("context");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If the value is set
            if(value)
            {
                equivalentElement.setAttribute(attribute, value);
            }
            else
            {
                equivalentElement.removeAttribute(attribute);
            }
        }

        equivalentElementId = elementId.split("menu").join("toolbar");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If the value is set
            if(value)
            {
                equivalentElement.setAttribute(attribute, value);
            }
            else
            {
                equivalentElement.removeAttribute(attribute);
            }
        }
    }
    else if(elementId.indexOf("toolbar") != -1)
    {
        equivalentElementId = elementId.split("toolbar").join("context");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If the value is set
            if(value)
            {
                equivalentElement.setAttribute(attribute, value);
            }
            else
            {
                equivalentElement.removeAttribute(attribute);
            }
        }

        equivalentElementId = elementId.split("toolbar").join("menu");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If the value is set
            if(value)
            {
                equivalentElement.setAttribute(attribute, value);
            }
            else
            {
                equivalentElement.removeAttribute(attribute);
            }
        }
    }
}

// Configure the keyboard shortcuts
function webdeveloper_configureKeyboardShortcuts(reset)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const string             = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
    const windowEnumeration  = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator).getEnumerator("navigator:browser");

    var mainDocument = null;
    var success      = false;

    // Loop through the open windows
    while(windowEnumeration.hasMoreElements())
    {
        mainDocument = windowEnumeration.getNext().document;

        // If a main document was found
        if(mainDocument)
        {
            var id                 = null;
            var key                = null;
            var keyPreference      = null;
            var keyPreferenceValue = null;
            var keys               = null;
            var keySet             = mainDocument.getElementById("mainKeyset");
            var toolCount          = 0;
            var url                = null;

            // If the key set was not found
            if(!keySet)
            {
                keySet = mainDocument.getElementById("navKeys");
            }

            // If the key set was found
            if(keySet)
            {
                keys = keySet.childNodes;

                // Loop through the keys
                for(var i = 0; i < keys.length; i++)
                {
                    key = keys.item(i);

                    // If the key has an id starting with webdeveloper
                    if(key.hasAttribute("id") && key.getAttribute("id").indexOf("webdeveloper") == 0)
                    {
                        id = key.getAttribute("id").split("-").join(".");

                        // If the key preference is set
                        if(preferencesService.prefHasUserValue(id))
                        {
                            key.setAttribute("key", preferencesService.getComplexValue(id, Components.interfaces.nsISupportsString).data.trim());
                        }
                        else if(!reset)
                        {
                            string.data = key.getAttribute("key");

                            preferencesService.setComplexValue(id, Components.interfaces.nsISupportsString, string);
                        }

                        success = true;
                    }
                }

                // If the tool count preference is set
                if(preferencesService.prefHasUserValue("webdeveloper.tool.count"))
                {
                    toolCount = preferencesService.getIntPref("webdeveloper.tool.count");
                }

                // Loop through the possible tools
                for(i = 1; i <= toolCount; i++)
                {
                    keyPreference = "webdeveloper.tool." + i + ".key";
                    url           = "webdeveloper.tool." + i + ".url";

                    // If the URL and key preferences are set
                    if(preferencesService.prefHasUserValue(url) && preferencesService.prefHasUserValue(keyPreference))
                    {
                        keyPreferenceValue = preferencesService.getComplexValue(keyPreference, Components.interfaces.nsISupportsString).data.trim();

                        // If the key preference value is set
                        if(keyPreferenceValue)
                        {
                            key = mainDocument.createElement("key");

                            key.setAttribute("id", keyPreference);
                            key.setAttribute("key", keyPreferenceValue);
                            key.setAttribute("modifiers", "accel,shift");
                            key.setAttribute("oncommand", "webdeveloper_loadURL('" + preferencesService.getComplexValue(url, Components.interfaces.nsISupportsString).data.trim() + "' + escape(getBrowser().currentURI.spec))");
                            keySet.appendChild(key);
                        }
                    }
                }
            }
        }
    }

    return success;
}

// Disables the extension
function webdeveloper_disable(forceDisable)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const stringBundle       = document.getElementById("webdeveloper-string-bundle");

    var disable     = true;
    var element     = null;
    var keys        = null;
    var keySet      = document.getElementById("mainKeyset");
    var textToolbar = false;

    // If the key set was not found
    if(!keySet)
    {
        keySet = document.getElementById("navKeys");
    }

    keys = keySet.childNodes;

    // If not forcing disable and the disable extension preference is set
    if(!forceDisable && preferencesService.prefHasUserValue("webdeveloper.disabled"))
    {
        disable = !preferencesService.getBoolPref("webdeveloper.disabled");
    }

    // If the toolbar preference has a value and is set to text
    if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons") && preferencesService.getComplexValue("webdeveloper.toolbar.icons", Components.interfaces.nsISupportsString).data.trim() == "text")
    {
        textToolbar = true;
    }

    preferencesService.setBoolPref("webdeveloper.disabled", disable);

    // Loop through the keys
    for(var i = 0; i < keys.length; i++)
    {
        element = keys.item(i);

        // If the key has an id starting with webdeveloper
        if(element.hasAttribute("id") && element.getAttribute("id").indexOf("webdeveloper") == 0)
        {
            webdeveloper_disableElement(element, disable);
        }
    }

    webdeveloper_disableElement(document.getElementById("webdeveloper-context"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-menu"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-edit-css-sidebar"), disable);

    webdeveloper_disableElement(document.getElementById("webdeveloper-disable-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-css-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-forms-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-images-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-information-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-miscellaneous-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-outline-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-resize-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-tools-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-view-source-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-options-toolbar"), disable);

    element = document.getElementById("webdeveloper-render-mode-statusbar");

    // If the element exists
    if(element)
    {
        // If disabling
        if(disable)
        {
            element.setAttribute("class", "webdeveloper-statusbar-button");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_standardsComplianceModeTooltip"));

            // If the toolbar is in text mode
            if(textToolbar)
            {
                element.setAttribute("label", stringBundle.getString("webdeveloper_standardsComplianceModeLabel"));
            }
        }
        else
        {
            const selectedTab     = getBrowser().mTabBox.selectedIndex;
            const currentDocument = getBrowser().browsers[selectedTab].contentWindow.document;

            webdeveloper_updateRenderMode(currentDocument);
        }

        webdeveloper_disableElement(element, disable);
    }

    element = document.getElementById("webdeveloper-javascript-statusbar");

    // If the element exists
    if(element)
    {
        element.setAttribute("class", "webdeveloper-statusbar-button");
        element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_javaScriptNoErrorsTooltip"));
        webdeveloper_disableElement(element, disable);

        // If the toolbar is in text mode
        if(textToolbar)
        {
            element.setAttribute("label", stringBundle.getString("webdeveloper_javaScriptNoErrorsLabel"));
        }
    }

    element = document.getElementById("sidebar-box");

    // If the element exists and is visible
    if(element && !element.getAttribute("hidden"))
    {
        // If the element is showing the edit CSS sidebar
        if(element.getAttribute("src") == "chrome://webdeveloper/content/sidebar/edit_css.xul")
        {
            toggleSidebar("webdeveloper-edit-css-sidebar");
        }
        else if(element.getAttribute("src") == "chrome://webdeveloper/content/sidebar/view_style_information.xul")
        {
            toggleSidebar("webdeveloper-view-style-information-sidebar");
        }
    }

    element = document.getElementById("webdeveloper-toggle-statusbar");

    // If the element exists
    if(element)
    {
        // If disabling the extension
        if(disable)
        {
            element.setAttribute("class", "enable webdeveloper-statusbar-button");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_enable"));
        }
        else
        {
            element.setAttribute("class", "webdeveloper-statusbar-button");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_disable"));
        }
    }

    // If disabling
    if(disable)
    {
        // If already listening to the console
        if(webdeveloper_javaScriptConsoleListener)
        {
            const consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService().QueryInterface(Components.interfaces.nsIConsoleService);

            // Try to unregister the listener
            try
            {
                consoleService.unregisterListener(WebDeveloperJavaScriptConsoleListener);
            }
            catch(exception)
            {
                // Do nothing
            }

            webdeveloper_javaScriptConsoleListener = false;
        }

        webdeveloper_resetPage();
    }
}

// Disables an element
function webdeveloper_disableElement(element, disable)
{
    // If the element exists
    if(element)
    {
        element.setAttribute("disabled", disable);
    }
}

// Disables the given preference
function webdeveloper_disablePreference(element, preference)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    preferencesService.setBoolPref(preference, !checked);
    webdeveloper_configureEquivalentElements(element, "checked", checked);
}

// Displays the elements ancestors in the status bar
function webdeveloper_displayElementAncestors(event)
{
    const eventTarget = event.target;

    // If there is a target
    if(eventTarget)
    {
        getBrowser().contentWindow.status = webdeveloper_getElementAncestors(eventTarget, "");

        event.preventDefault();
    }
}

// Enables the given preference
function webdeveloper_enablePreference(element, preference)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the element is checked - explicit if required
    if(checked)
    {
        preferencesService.setBoolPref(preference, true);
    }
    else
    {
        preferencesService.setBoolPref(preference, false);
    }

    webdeveloper_configureEquivalentElements(element, "checked", checked);
}

// Generates a page in a new tab or window
function webdeveloper_generatePage(url)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var generatedPage = null;

    // If the open tabs preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.open.tabs") && preferencesService.getBoolPref("webdeveloper.open.tabs"))
    {
        const newTab = getBrowser().addTab(url);

        getBrowser().selectedTab = newTab;
        generatedPage = window;
    }
    else
    {
        generatedPage = window.open(url);
    }

    return generatedPage;
}

// Get the cookies
function webdeveloper_getCookies(host, sort)
{
    const cookieEnumeration = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager).enumerator;

    var cookies = new Array();

    // Loop through the cookies
    while(cookieEnumeration.hasMoreElements())
    {
        const cookie = cookieEnumeration.getNext().QueryInterface(Components.interfaces.nsICookie);

        var cookieHost = cookie.host;

        // If there is a host for this cookie
        if(cookieHost)
        {
            // If the cookie host starts with '.'
            if(cookieHost.charAt(0) == ".")
            {
                cookieHost = cookieHost.substring(1);
            }

            // If the host and cookie host match
            if(host == cookieHost || host.indexOf("." + cookieHost) != -1)
            {
                cookies.push(cookie);
            }
        }
    }

    // If sorting cookies
    if(sort)
    {
        cookies.sort(webdeveloper_sortCookies);
    }

    return cookies;
}

// Gets all the documents from the current page
function webdeveloper_getDocuments(frame, documentList)
{
    const framesList = frame.frames;

    documentList.push(frame.document);

    // Loop through the frames
    for(var i = 0; i < framesList.length; i++)
    {
        webdeveloper_getDocuments(framesList[i], documentList);
    }

    return documentList;
}

// Get an elements ancestors
function webdeveloper_getElementAncestors(element, ancestorList)
{
    const classAttribute = element.getAttribute("class");
    const idAttribute    = element.getAttribute("id");
    const parentElement  = element.parentNode;

    var elementText = element.tagName.toLowerCase();

    // If there is a class attribute
    if(classAttribute)
    {
        elementText += "." + classAttribute;
    }

    // If there is an id attribute
    if(idAttribute)
    {
        elementText += "#" + idAttribute;
    }

    // If there is an ancestor list
    if(ancestorList)
    {
        elementText += " > " + ancestorList
    }

    // If there is a parent element with a tag name
    if(parentElement && parentElement.tagName)
    {
        return webdeveloper_getElementAncestors(parentElement, elementText);
    }
    else
    {
        return elementText;
    }
}

// Initializes the extension
function webdeveloper_initialize()
{
    const content            = window.document.getElementById("content");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    webdeveloper_setupDefaultOptions();

    // If the debug preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.debug"))
    {
        webdeveloper_debug = preferencesService.getBoolPref("webdeveloper.debug");
    }

    // If the content exists
    if(content)
    {
        const tabBox = content.mTabBox;

        // Try to remove the event listener
        try
        {
            tabBox.removeEventListener("select", webdeveloper_tabSelect, true);
        }
        catch(exception)
        {
            // Do nothing
        }

        tabBox.addEventListener("select", webdeveloper_tabSelect, true);
    }

    // Try to remove the load event listener
    try
    {
        window.removeEventListener("load", webdeveloper_pageLoad, true);
    }
    catch(exception)
    {
        // Do nothing
    }

    // Try to remove the unload event listener
    try
    {
        window.removeEventListener("unload", webdeveloper_pageUnload, true);
    }
    catch(exception)
    {
        // Do nothing
    }

    window.addEventListener("load", webdeveloper_pageLoad, true);
    window.addEventListener("unload", webdeveloper_pageUnload, true);
}

// Loads the given URL
function webdeveloper_loadURL(url)
{
    const oldTab             = getBrowser().selectedTab;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    webdeveloper_generatePage(url);

    // If the open tabs in background preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.open.tabs.background") && preferencesService.getBoolPref("webdeveloper.open.tabs.background"))
    {
        getBrowser().selectedTab = oldTab;
    }
}

// Opens the JavaScript console
function webdeveloper_openJavaScriptConsole()
{
    webdeveloper_javaScriptPreviousTime = webdeveloper_javaScriptCurrentTime;
    webdeveloper_javaScriptCurrentTime  = new Date().getTime();

    // If the previous time is not set or the current time is greater than a second different from the previous time
    if(!webdeveloper_javaScriptPreviousTime || webdeveloper_javaScriptCurrentTime - webdeveloper_javaScriptPreviousTime > 1000)
    {
        toJavaScriptConsole();
    }
}

// Displays the options dialog
function webdeveloper_options()
{
    window.openDialog("chrome://webdeveloper/content/options/options.xul", "webdeveloper-options-dialog", "centerscreen,chrome,modal");

    webdeveloper_changeOptions();
}

// Handles the page being loaded
function webdeveloper_pageLoad(event)
{
    const eventTarget        = event.target;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var disable = false;

    // If the disabled preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.disabled"))
    {
        disable = preferencesService.getBoolPref("webdeveloper.disabled");
    }

    // If the page is the target
    if(eventTarget && eventTarget.hasAttribute && eventTarget.hasAttribute("id") && eventTarget.getAttribute("id").toLowerCase() == "content")
    {
        const stringBundle = document.getElementById("webdeveloper-string-bundle");

        webdeveloper_changeOptions();

        // If the extension should be disabled, but is not
        if(disable && document.getElementById("webdeveloper-toggle-statusbar").getAttribute("tooltiptext") == stringBundle.getString("webdeveloper_disable"))
        {
            webdeveloper_disable(true);
        }
        else if(!disable)
        {
            const contentDocument               = eventTarget.contentDocument;
            const disableCachePreference        = !preferencesService.getBoolPref("browser.cache.disk.enable") && !preferencesService.getBoolPref("browser.cache.memory.enable");
            const disableJavaPreference         = !preferencesService.getBoolPref("security.enable_java");
            const disableJavaScriptPreference   = !preferencesService.getBoolPref("javascript.enabled");
            const disablePageColorsPreference   = !preferencesService.getBoolPref("browser.display.use_document_colors");
            const disablePopupBlockerPreference = !preferencesService.getBoolPref("dom.disable_open_during_load");
            const loadedDocument                = event.originalTarget;

            var disableCookiesPreference         = false;
            var disableImagesPreference          = false;
            var disableImageAnimationsPreference = false;
            var disableReferrerPreference        = false;
            var element                          = null;
            var persistStyles                    = false;

            // If the localized options have not been setup
            if(!webdeveloper_localizedOptionsSetup)
            {
                webdeveloper_setupLocalizedOptions();
            }

            // If not already listening to the console
            if(!webdeveloper_javaScriptConsoleListener)
            {
                const consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService().QueryInterface(Components.interfaces.nsIConsoleService);

                // Try to unregister the listener
                try
                {
                    consoleService.unregisterListener(WebDeveloperJavaScriptConsoleListener);
                }
                catch(exception)
                {
                    // Do nothing
                }

                consoleService.registerListener(WebDeveloperJavaScriptConsoleListener);

                webdeveloper_javaScriptConsoleListener = true;
            }

            // Try to get the cookie preference
            try
            {
                // If the preference is set to 2
                if(preferencesService.getIntPref("network.cookie.cookieBehavior") == 2)
                {
                    disableCookiesPreference = true;
                }
            }
            catch(exception)
            {
                disableCookiesPreference = !preferencesService.getBoolPref("network.cookie.enable");
            }

            // If the image animation preference is set to none
            if(preferencesService.getCharPref("image.animation_mode") == "none")
            {
                disableImageAnimationsPreference = true;
            }

            // If the image preference exists and is set to 2
            if(preferencesService.prefHasUserValue("network.image.imageBehavior") && preferencesService.getIntPref("network.image.imageBehavior") == 2)
            {
                disableImagesPreference = true;
            }

            // If the referrer preference is set to 0
            if(preferencesService.getIntPref("network.http.sendRefererHeader") == 0)
            {
                disableReferrerPreference = true;
            }

            // If the DOM inspector is not available
            if(!Components.classes["@mozilla.org/inspector/dom-utils;1"])
            {
                element = document.getElementById("webdeveloper-view-style-information-menu");

                // If the view style information menu is enabled
                if(!element.disabled)
                {
                    webdeveloper_configureEquivalentElements(element, "disabled", true);
                }

                element = document.getElementById("webdeveloper-view-style-information-key");

                // If the view style information key is enabled
                if(!element.disabled)
                {
                    webdeveloper_disableElement(element, true);
                }

                element = document.getElementById("webdeveloper-open-dom-inspector-menu");

                // If the open DOM inspector menu is enabled
                if(!element.disabled)
                {
                    webdeveloper_configureEquivalentElements(element, "disabled", true);
                }
            }

            element = document.getElementById("webdeveloper-disable-cache-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableCachePreference);

            element = document.getElementById("webdeveloper-disable-cookies-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableCookiesPreference);

            element = document.getElementById("webdeveloper-disable-image-animations-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableImageAnimationsPreference);

            element = document.getElementById("webdeveloper-disable-images-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableImagesPreference);

            element = document.getElementById("webdeveloper-disable-java-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableJavaPreference);

            element = document.getElementById("webdeveloper-disable-javascript-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableJavaScriptPreference);

            element = document.getElementById("webdeveloper-disable-page-colors-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disablePageColorsPreference);

            element = document.getElementById("webdeveloper-disable-popup-blocker-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disablePopupBlockerPreference);

            element = document.getElementById("webdeveloper-disable-referrer-logging-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableReferrerPreference);

            element = document.getElementById("webdeveloper-open-java-console-key");
            webdeveloper_configureEquivalentElements(element, "disabled", disableJavaPreference);

            element = document.getElementById("webdeveloper-open-java-console-menu");
            webdeveloper_configureEquivalentElements(element, "disabled", disableJavaPreference);

            // If the persist styles preference is set and is true
            if(preferencesService.prefHasUserValue("webdeveloper.styles.persist") && preferencesService.getBoolPref("webdeveloper.styles.persist"))
            {
                persistStyles = true;

                // If the loaded document is set
                if(contentDocument)
                {
                    webdeveloper_applyStyleSheets(true);
                    webdeveloper_updateRenderMode(contentDocument);
                }
            }
            else if(contentDocument && loadedDocument && contentDocument.documentURI == loadedDocument.documentURI)
            {
                webdeveloper_appliedStyles = new Array();
                webdeveloper_resetMenu(true);
                webdeveloper_updateRenderMode(contentDocument);
            }

            element = document.getElementById("webdeveloper-persist-styles-menu");
            webdeveloper_configureEquivalentElements(element, "checked", persistStyles);
        }
    }
}

// Handles the page being unloaded
function webdeveloper_pageUnload(event)
{
    const eventTarget    = event.target;
    const originalTarget = event.originalTarget;

    // If the page is the target and the URI matches
    if(eventTarget && originalTarget && eventTarget.contentDocument && eventTarget.hasAttribute && eventTarget.hasAttribute("id") && eventTarget.getAttribute("id").toLowerCase() == "content" && eventTarget.contentDocument.documentURI == originalTarget.documentURI)
    {
        webdeveloper_resetJavaScriptStatus();
    }
}

// Remove applied style
function webdeveloper_removeAppliedStyle(id)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the persist styles preference is set and is true
    if(preferencesService.prefHasUserValue("webdeveloper.styles.persist") && preferencesService.getBoolPref("webdeveloper.styles.persist"))
    {
        // Loop through the applied styles
        for(var i = 0; i < webdeveloper_appliedStyles.length; i++)
        {
            // If this style sheet is in the applied styles
            if(webdeveloper_appliedStyles[i] == id)
            {
                webdeveloper_appliedStyles.splice(i, 1);
            }
        }
    }
}

// Removes all the generated menu items from the menu
function webdeveloper_removeGeneratedMenuItems(menu)
{
    var menuItem  = null;
    var menuItems = menu.getElementsByAttribute("class", "webdeveloper-generated-menu");

    // Loop through the menu items
    for(var i = 0; i < menuItems.length; i++)
    {
        menu.removeChild(menuItems[i]);
    }

    menuItems = menu.getElementsByAttribute("class", "webdeveloper-generated-menu");

    // Loop through the menu items again because of the change to the behavior of getElementsByAttribute
    while(menuItems.length > 0)
    {
        menu.removeChild(menuItems[0]);
    }
}

// Removes the style sheet with the given id
function webdeveloper_removeStyleSheet(id, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var element      = null;
    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];

        // Remove all elements with that id
        while((element = pageDocument.getElementById(id)) != null)
        {
            element.parentNode.removeChild(element);
        }
    }

    // If applying style
    if(applyStyle)
    {
        webdeveloper_removeAppliedStyle(id);
    }
}

// Resets the JavaScript status button
function webdeveloper_resetJavaScriptStatus()
{
    const javaScriptButton = document.getElementById("webdeveloper-javascript-statusbar");

    webdeveloper_javaScriptCurrentTime  = null;
    webdeveloper_javaScriptPreviousTime = null;

    // If the JavaScript button exists
    if(javaScriptButton)
    {
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
        const stringBundle       = document.getElementById("webdeveloper-string-bundle");

        javaScriptButton.setAttribute("class", "webdeveloper-statusbar-button");
        javaScriptButton.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_javaScriptNoErrorsTooltip"));

        // If the toolbar preference has a value and is set to text
        if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons") && preferencesService.getComplexValue("webdeveloper.toolbar.icons", Components.interfaces.nsISupportsString).data.trim() == "text")
        {
            javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javaScriptNoErrorsLabel"));
        }
    }
}

// Resets the menu
function webdeveloper_resetMenu(disableStylesMenu)
{
    var element = document.getElementById("webdeveloper-add-user-style-sheet-menu");

    webdeveloper_configureEquivalentElements(element, "checked", false);

    // If including the disable styles menu
    if(disableStylesMenu)
    {
        element = document.getElementById("webdeveloper-disable-all-styles-menu");
        webdeveloper_configureEquivalentElements(element, "checked", false);
        webdeveloper_configureEquivalentElements(element, "disabled", false);

        element = document.getElementById("webdeveloper-disable-embedded-styles-menu");
        webdeveloper_configureEquivalentElements(element, "checked", false);
        webdeveloper_configureEquivalentElements(element, "disabled", false);

        element = document.getElementById("webdeveloper-disable-inline-styles-menu");
        webdeveloper_configureEquivalentElements(element, "checked", false);
        webdeveloper_configureEquivalentElements(element, "disabled", false);

        element = document.getElementById("webdeveloper-disable-linked-styles-menu");
        webdeveloper_configureEquivalentElements(element, "checked", false);
        webdeveloper_configureEquivalentElements(element, "disabled", false);
    }

    element = document.getElementById("webdeveloper-disable-default-styles-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-disable-embedded-styles-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-disable-inline-styles-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-access-keys-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-anchors-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-block-size-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-current-size-title-menu");

    // If the display current size in title menu is checked
    if(element.getAttribute("checked"))
    {
        window.onresize = null;
    }

    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-form-details-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-id-class-details-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-image-dimensions-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-image-file-sizes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-image-paths-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-link-paths-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-tab-index-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-topographic-information-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-hide-background-images-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-hide-images-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-linearize-page-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-make-images-invisible-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-block-level-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-custom-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-deprecated-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-frames-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-images-with-adjusted-dimensions-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-images-with-empty-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-images-without-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-images-without-dimensions-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-images-without-title-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-links-without-title-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-table-cells-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-tables-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-replace-images-with-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-show-comments-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-use-border-box-model-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-view-style-information-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);
}

// Resets the page
function webdeveloper_resetPage()
{
    const selectedTab     = getBrowser().mTabBox.selectedIndex;
    const currentDocument = getBrowser().browsers[selectedTab].contentWindow.document;

    webdeveloper_resetMenu(true);
    webdeveloper_applyStyleSheets(false);

    webdeveloper_appliedStyles    = new Array();
    webdeveloper_outlinedElements = new Array();
}

// Retrieves the style sheet text from a style sheet
function webdeveloper_retrieveStyleSheetText(pageDocument, styleSheet)
{
    const mediaList      = styleSheet.media.mediaText;
    const ownerNode      = styleSheet.ownerNode;
    const request        = new XMLHttpRequest();
    const styleSheetHref = styleSheet.href;

    var cssRule    = null;
    var stylesText = "";

    // If this style sheet is for the screen and is not an alternate style sheet
    if((!mediaList || mediaList.indexOf("screen") != -1 || mediaList.indexOf("all") != -1) && (!ownerNode || !ownerNode.hasAttribute("rel") || ownerNode.getAttribute("rel").toLowerCase() != "alternate stylesheet"))
    {
        // If the style sheet href is the current document
        if(styleSheetHref == pageDocument.documentURI)
        {
            const stringBundle = document.getElementById("webdeveloper-string-bundle");

            stylesText += "/* " + stringBundle.getFormattedString("webdeveloper_inlineStyles", [styleSheetHref]) + " */\n\n";

            // Loop through the the style sheet rules
            for(var k = 0; k < styleSheet.cssRules.length; k++)
            {
                cssRule = styleSheet.cssRules[k];

                // If this is not an import rule
                if(cssRule.type != 3)
                {
                    stylesText += cssRule.cssText + "\n\n";
                }
            }
        }
        else
        {
            request.open("get", styleSheetHref, false);
            request.send("");

            stylesText += "/*  " + styleSheetHref + " */\n\n";
            stylesText += request.responseText;
        }

        // Loop through the the style sheet rules
        for(k = 0; k < styleSheet.cssRules.length; k++)
        {
            cssRule = styleSheet.cssRules[k];

            // If this is an import rule
            if(cssRule.type == 3)
            {
                stylesText += webdeveloper_retrieveStyleSheetText(pageDocument, cssRule.styleSheet);
            }
        }
    }

    return stylesText;
}

// Sets up the default options
function webdeveloper_setupDefaultOptions()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const string             = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);

    // If the open tabs preference is not set
    if(!preferencesService.prefHasUserValue("webdeveloper.open.tabs"))
    {
        // If the open windows preference is set
        if(preferencesService.prefHasUserValue("webdeveloper.open.windows"))
        {
            preferencesService.setBoolPref("webdeveloper.open.tabs", !preferencesService.getBoolPref("webdeveloper.open.windows"));
            preferencesService.clearUserPref("webdeveloper.open.windows");
        }
        else
        {
            preferencesService.setBoolPref("webdeveloper.open.tabs", true);
        }
    }

    // Set default edit CSS settings
    if(!preferencesService.prefHasUserValue("webdeveloper.edit.css.font"))
    {
        preferencesService.setIntPref("webdeveloper.edit.css.font", 12);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.edit.css.color.text"))
    {
        string.data = "#000000";

        preferencesService.setComplexValue("webdeveloper.edit.css.color.text", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.edit.css.color.background"))
    {
        string.data = "#ffffff";

        preferencesService.setComplexValue("webdeveloper.edit.css.color.background", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.edit.css.update.frequency"))
    {
        preferencesService.setIntPref("webdeveloper.edit.css.update.frequency", 1000);
    }

    // Set default custom colors
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.1.color"))
    {
        string.data = "#ff0000";

        preferencesService.setComplexValue("webdeveloper.custom.1.color", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.2.color"))
    {
        string.data = "#33ff33";

        preferencesService.setComplexValue("webdeveloper.custom.2.color", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.3.color"))
    {
        string.data = "#3333ff";

        preferencesService.setComplexValue("webdeveloper.custom.3.color", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.4.color"))
    {
        string.data = "#ff0000";

        preferencesService.setComplexValue("webdeveloper.custom.4.color", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.5.color"))
    {
        string.data = "#33ff33";

        preferencesService.setComplexValue("webdeveloper.custom.5.color", Components.interfaces.nsISupportsString, string);
    }

    // Set default feature tooltip colors
    if(!preferencesService.prefHasUserValue("webdeveloper.color.feature.tooltip.text"))
    {
        string.data = "#000000";

        preferencesService.setComplexValue("webdeveloper.color.feature.tooltip.text", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.feature.tooltip.background"))
    {
        string.data = "#ffff99";

        preferencesService.setComplexValue("webdeveloper.color.feature.tooltip.background", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.feature.tooltip.opacity"))
    {
        string.data = "0.7";

        preferencesService.setComplexValue("webdeveloper.feature.tooltip.opacity", Components.interfaces.nsISupportsString, string);
    }

    // Set default ID & class colors
    if(!preferencesService.prefHasUserValue("webdeveloper.color.class.text"))
    {
        string.data = "#ffffff";

        preferencesService.setComplexValue("webdeveloper.color.class.text", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.class.background"))
    {
        string.data = "#990000";

        preferencesService.setComplexValue("webdeveloper.color.class.background", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.id.text"))
    {
        string.data = "#ffffff";

        preferencesService.setComplexValue("webdeveloper.color.id.text", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.id.background"))
    {
        string.data = "#009900";

        preferencesService.setComplexValue("webdeveloper.color.id.background", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.id.class.text"))
    {
        string.data = "#ffffff";

        preferencesService.setComplexValue("webdeveloper.color.id.class.text", Components.interfaces.nsISupportsString, string);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.id.class.background"))
    {
        string.data = "#000099";

        preferencesService.setComplexValue("webdeveloper.color.id.class.background", Components.interfaces.nsISupportsString, string);
    }

    // Set default populate form fields email
    if(!preferencesService.prefHasUserValue("webdeveloper.populate.form.fields.email"))
    {
        string.data = "noemail@noemail.org";

        preferencesService.setComplexValue("webdeveloper.populate.form.fields.email", Components.interfaces.nsISupportsString, string);
    }

    // Set default tidied HTML settings
    if(!preferencesService.prefHasUserValue("webdeveloper.tidied.html.close.br"))
    {
        preferencesService.setBoolPref("webdeveloper.tidied.html.close.br", true);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.tidied.html.escape.ampersand"))
    {
        preferencesService.setBoolPref("webdeveloper.tidied.html.escape.ampersand", true);
    }
}

// Sets up the localized options
function webdeveloper_setupLocalizedOptions()
{
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the string bundle is set
    if(stringBundle)
    {
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
        const string             = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);

        // Set default resize sizes
        if(!preferencesService.prefHasUserValue("webdeveloper.resize.count"))
        {
            preferencesService.setIntPref("webdeveloper.resize.count", 1);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.resize.1.description"))
        {
            string.data = stringBundle.getString("webdeveloper_resize800x600");

            preferencesService.setComplexValue("webdeveloper.resize.1.description", Components.interfaces.nsISupportsString, string);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.resize.1.width"))
        {
            preferencesService.setIntPref("webdeveloper.resize.1.width", 800);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.resize.1.height"))
        {
            preferencesService.setIntPref("webdeveloper.resize.1.height", 600);
        }

        // Set default tool count
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.count"))
        {
            preferencesService.setIntPref("webdeveloper.tool.count", 7);
        }

        // Set CSS validator
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.1.description"))
        {
            string.data = stringBundle.getString("webdeveloper_validateCSS");

            preferencesService.setComplexValue("webdeveloper.tool.1.description", Components.interfaces.nsISupportsString, string);

        }
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.1.url"))
        {
            string.data = "http://jigsaw.w3.org/css-validator/validator?profile=css2&warning=2&uri=";

            preferencesService.setComplexValue("webdeveloper.tool.1.url", Components.interfaces.nsISupportsString, string);
        }

        // Set feed validator
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.2.description"))
        {
            string.data = stringBundle.getString("webdeveloper_validateFeed");

            preferencesService.setComplexValue("webdeveloper.tool.2.description", Components.interfaces.nsISupportsString, string);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.2.url"))
        {
            string.data = "http://feedvalidator.org/check.cgi?url=";

            preferencesService.setComplexValue("webdeveloper.tool.2.url", Components.interfaces.nsISupportsString, string);
        }

        // Set HTML validator
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.3.description"))
        {
            string.data = stringBundle.getString("webdeveloper_validateHTML");

            preferencesService.setComplexValue("webdeveloper.tool.3.description", Components.interfaces.nsISupportsString, string);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.3.key"))
        {
            string.data = "H";

            preferencesService.setComplexValue("webdeveloper.tool.3.key", Components.interfaces.nsISupportsString, string);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.3.url"))
        {
            string.data = "http://validator.w3.org/check?verbose=1&uri=";

            preferencesService.setComplexValue("webdeveloper.tool.3.url", Components.interfaces.nsISupportsString, string);
        }

        // Set links validator
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.4.description"))
        {
            string.data = stringBundle.getString("webdeveloper_validateLinks");

            preferencesService.setComplexValue("webdeveloper.tool.4.description", Components.interfaces.nsISupportsString, string);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.4.url"))
        {
            string.data = "http://validator.w3.org/checklink?check=Check&hide_type=all&summary=on&uri=";

            preferencesService.setComplexValue("webdeveloper.tool.4.url", Components.interfaces.nsISupportsString, string);
        }

        // Set section 508 validator
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.5.description"))
        {
            string.data = stringBundle.getString("webdeveloper_validateSection508");

            preferencesService.setComplexValue("webdeveloper.tool.5.description", Components.interfaces.nsISupportsString, string);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.5.url"))
        {
            string.data = "http://www.contentquality.com/mynewtester/cynthia.exe?rptmode=-1&url1=";

            preferencesService.setComplexValue("webdeveloper.tool.5.url", Components.interfaces.nsISupportsString, string);
        }

        // Set WAI validator
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.6.description"))
        {
            string.data = stringBundle.getString("webdeveloper_validateWAI");

            preferencesService.setComplexValue("webdeveloper.tool.6.description", Components.interfaces.nsISupportsString, string);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.6.url"))
        {
            string.data = "http://www.contentquality.com/mynewtester/cynthia.exe?rptmode=2&url1=";

            preferencesService.setComplexValue("webdeveloper.tool.6.url", Components.interfaces.nsISupportsString, string);
        }

        // Set speed report
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.7.description"))
        {
            string.data = stringBundle.getString("webdeveloper_viewSpeedReport");

            preferencesService.setComplexValue("webdeveloper.tool.7.description", Components.interfaces.nsISupportsString, string);
        }
        if(!preferencesService.prefHasUserValue("webdeveloper.tool.7.url"))
        {
            string.data = "http://www.websiteoptimization.com/cgi-bin/wso/wso.pl?url=";

            preferencesService.setComplexValue("webdeveloper.tool.7.url", Components.interfaces.nsISupportsString, string);
        }

        webdeveloper_localizedOptionsSetup = true;
    }
}

// Sorts two cookies
function webdeveloper_sortCookies(cookieOne, cookieTwo)
{
    const cookieOneHost = cookieOne.host;
    const cookieOneName = cookieOne.name;
    const cookieTwoHost = cookieTwo.host;
    const cookieTwoName = cookieOne.name;

    var sortValue = 1;

    // If the cookies are equal
    if(cookieOneHost == cookieTwoHost && cookieOneName == cookieTwoName)
    {
        sortValue = 0;
    }
    else if(cookieOneHost < cookieTwoHost || (cookieOneHost == cookieTwoHost && cookieOneName < cookieTwoName))
    {
        sortValue = -1;
    }

    return sortValue;
}

// Handles a tab being selected
function webdeveloper_tabSelect(event)
{
    const selectedTab     = getBrowser().mTabBox.selectedIndex;
    const currentDocument = getBrowser().browsers[selectedTab].contentWindow.document;

    // If the selected tab is different
    if(selectedTab != webdeveloper_selectedTab)
    {
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

        webdeveloper_selectedTab = selectedTab;

        webdeveloper_updateMenu(currentDocument);
        webdeveloper_updateRenderMode(currentDocument);
        webdeveloper_resetJavaScriptStatus();
    }
}

// Toggles the feature tooltip styles
function webdeveloper_toggleFeatureTooltipStyles(element, styleSheetId, selectors)
{
    webdeveloper_removeStyleSheet(styleSheetId, false);

    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        const mainTabBox         = getBrowser().mTabBox;
        const documentList       = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
        const colors             = " background-color: " + preferencesService.getComplexValue("webdeveloper.color.feature.tooltip.background", Components.interfaces.nsISupportsString).data.trim() + " !important; color: " + preferencesService.getComplexValue("webdeveloper.color.feature.tooltip.text", Components.interfaces.nsISupportsString).data.trim() + " !important; ";
        const opacity            = " -moz-opacity: " + preferencesService.getComplexValue("webdeveloper.feature.tooltip.opacity", Components.interfaces.nsISupportsString).data.trim() + " !important; ";

        var headElementList = null;
        var pageDocument    = null;
        var styleElement    = null;

        // Loop through the documents
        for(var i = 0; i < documentList.length; i++)
        {
            pageDocument    = documentList[i];
            headElementList = pageDocument.getElementsByTagName("head");
            styleElement    = pageDocument.createElement("style");

            styleElement.appendChild(pageDocument.createTextNode(selectors + " {" + colors + opacity + "}"));
            styleElement.setAttribute("id", styleSheetId);
            styleElement.setAttribute("type", "text/css");

            // If there is a head element
            if(headElementList.length > 0)
            {
                headElementList[0].appendChild(styleElement);
            }
            else
            {
                pageDocument.documentElement.appendChild(styleElement);
            }
        }
    }
}

// Toggles an individual style sheet
function webdeveloper_toggleIndividualStyleSheet(selectedStyleSheetHref)
{
    const mainTabBox      = getBrowser().mTabBox;
    const currentDocument = getBrowser().browsers[mainTabBox.selectedIndex].contentDocument;

    var styleSheet     = null;
    var styleSheetHref = null;
    var styleSheetList = currentDocument.styleSheets;

    // Loop through the style sheets
    for(var i = 0; i < styleSheetList.length; i++)
    {
        styleSheet     = styleSheetList[i];
        styleSheetHref = styleSheet.href;

        // If this is the selected style sheet
        if(styleSheetHref == selectedStyleSheetHref)
        {
            styleSheet.disabled = !styleSheet.disabled;
        }
    }
}

// Toggles the style sheet with the given id
function webdeveloper_toggleStyleSheet(element, location, id, applyStyle)
{
    const checked = element.getAttribute("checked");

    webdeveloper_configureEquivalentElements(element, "checked", checked);
    webdeveloper_removeStyleSheet(id, applyStyle);

    // If the menu is checked
    if(checked)
    {
        webdeveloper_addStyleSheet(location, id, applyStyle);
    }
}

// Toggles the toolbar
function webdeveloper_toggleToolbar()
{
    const toolbar = document.getElementById("webdeveloper-toolbar");

    toolbar.collapsed = !toolbar.collapsed;
}

// Updates the menu
function webdeveloper_updateMenu(currentDocument)
{
    const addUserStylesheet                             = currentDocument.getElementById("webdeveloper-add-user-style-sheet");
    const disableDefaultStylesStylesheet                = currentDocument.getElementById("webdeveloper-disable-default-styles");
    const displayAccessKeysStylesheet                   = currentDocument.getElementById("webdeveloper-display-access-keys");
    const displayAnchorsStylesheet                      = currentDocument.getElementById("webdeveloper-display-anchors");
    const displayBlockSizeStylesheet                    = currentDocument.getElementById("webdeveloper-display-block-size");
    const displayCurrentSizeTitleStylesheet             = currentDocument.getElementById("webdeveloper-display-current-size-title");
    const displayFormDetailsStylesheet                  = currentDocument.getElementById("webdeveloper-display-form-details");
    const displayIDClassDetailsStylesheet               = currentDocument.getElementById("webdeveloper-display-id-class-details");
    const displayImageDimensionsStylesheet              = currentDocument.getElementById("webdeveloper-display-image-dimensions");
    const displayImageFileSizesStylesheet               = currentDocument.getElementById("webdeveloper-display-image-file-sizes");
    const displayImagePathsStylesheet                   = currentDocument.getElementById("webdeveloper-display-image-paths");
    const displayLinkPathsStylesheet                    = currentDocument.getElementById("webdeveloper-display-link-paths");
    const displayTabIndexStylesheet                     = currentDocument.getElementById("webdeveloper-display-tab-index");
    const displayTopographicInformationStylesheet       = currentDocument.getElementById("webdeveloper-display-tab-index");
    const hideBackgroundImagesStylesheet                = currentDocument.getElementById("webdeveloper-hide-background-images");
    const hideImagesStylesheet                          = currentDocument.getElementById("webdeveloper-hide-images");
    const linearizePageStylesheet                       = currentDocument.getElementById("webdeveloper-linearize-page");
    const makeImagesInvisibleStylesheet                 = currentDocument.getElementById("webdeveloper-make-images-invisible");
    const outlineBlockLevelElementsStylesheet           = currentDocument.getElementById("webdeveloper-outline-block-level-elements");
    const outlineCustomElementsStylesheet               = currentDocument.getElementById("webdeveloper-outline-custom-elements");
    const outlineDeprecatedElementsStylesheet           = currentDocument.getElementById("webdeveloper-outline-deprecated-elements");
    const outlineFramesStylesheet                       = currentDocument.getElementById("webdeveloper-outline-frames");
    const outlineImagesWithAdjustedDimensionsStylesheet = currentDocument.getElementById("webdeveloper-outline-images-with-adjusted-dimensions");
    const outlineImagesWithEmptyAltAttributesStylesheet = currentDocument.getElementById("webdeveloper-outline-images-with-empty-alt-attributes");
    const outlineImagesWithoutAltAttributesStylesheet   = currentDocument.getElementById("webdeveloper-outline-images-without-alt-attributes");
    const outlineImagesWithoutDimensionsStylesheet      = currentDocument.getElementById("webdeveloper-outline-images-without-dimensions");
    const outlineImagesWithoutTitleAttributesStylesheet = currentDocument.getElementById("webdeveloper-outline-images-without-title-attributes");
    const outlineLinksWithoutTitleAttributesStylesheet  = currentDocument.getElementById("webdeveloper-outline-links-without-title-attributes");
    const outlineSelectedElementStylesheet              = currentDocument.getElementById("webdeveloper-outline-selected-element");
    const outlineTableCellsStylesheet                   = currentDocument.getElementById("webdeveloper-outline-table-cells");
    const outlineTablesStylesheet                       = currentDocument.getElementById("webdeveloper-outline-tables");
    const replaceImagesWithAltAttributesStylesheet      = currentDocument.getElementById("webdeveloper-replace-images-with-alt-attributes");
    const showCommentsStylesheet                        = currentDocument.getElementById("webdeveloper-show-comments");
    const useBorderBoxModelStylesheet                   = currentDocument.getElementById("webdeveloper-use-border-box-model");
    const viewStyleInformationStylesheet                = currentDocument.getElementById("webdeveloper-view-style-information");

    var checked = false;
    var element = null;

    checked = addUserStylesheet && !addUserStylesheet.disabled;
    element = document.getElementById("webdeveloper-add-user-style-sheet-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = disableDefaultStylesStylesheet && !disableDefaultStylesStylesheet.disabled;
    element = document.getElementById("webdeveloper-disable-default-styles-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayAccessKeysStylesheet && !displayAccessKeysStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-access-keys-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayAnchorsStylesheet && !displayAnchorsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-anchors-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayBlockSizeStylesheet && !displayBlockSizeStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-block-size-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayCurrentSizeTitleStylesheet && !displayCurrentSizeTitleStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-current-size-title-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayFormDetailsStylesheet && !displayFormDetailsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-form-details-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayIDClassDetailsStylesheet && !displayIDClassDetailsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-id-class-details-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayImageDimensionsStylesheet && !displayImageDimensionsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-image-dimensions-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayImageFileSizesStylesheet && !displayImageFileSizesStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-image-file-sizes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayImagePathsStylesheet && !displayImagePathsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-image-paths-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayLinkPathsStylesheet && !displayLinkPathsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-link-paths-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayTabIndexStylesheet && !displayTabIndexStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-tab-index-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayTopographicInformationStylesheet && !displayTopographicInformationStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-topographic-information-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = hideBackgroundImagesStylesheet && !hideBackgroundImagesStylesheet.disabled;
    element = document.getElementById("webdeveloper-hide-background-images-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = hideImagesStylesheet && !hideImagesStylesheet.disabled;
    element = document.getElementById("webdeveloper-hide-images-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = linearizePageStylesheet && !linearizePageStylesheet.disabled;
    element = document.getElementById("webdeveloper-linearize-page-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = makeImagesInvisibleStylesheet && !makeImagesInvisibleStylesheet.disabled;
    element = document.getElementById("webdeveloper-make-images-invisible-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineBlockLevelElementsStylesheet && !outlineBlockLevelElementsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-block-level-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineCustomElementsStylesheet && !outlineCustomElementsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-custom-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineDeprecatedElementsStylesheet && !outlineDeprecatedElementsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-deprecated-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineFramesStylesheet && !outlineFramesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-frames-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineImagesWithAdjustedDimensionsStylesheet && !outlineImagesWithAdjustedDimensionsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-images-with-adjusted-dimensions-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineImagesWithEmptyAltAttributesStylesheet && !outlineImagesWithEmptyAltAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-images-with-empty-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineImagesWithoutAltAttributesStylesheet && !outlineImagesWithoutAltAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-images-without-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineImagesWithoutDimensionsStylesheet && !outlineImagesWithoutDimensionsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-images-without-dimensions-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineImagesWithoutTitleAttributesStylesheet && !outlineImagesWithoutTitleAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-images-without-title-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineLinksWithoutTitleAttributesStylesheet && !outlineLinksWithoutTitleAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-links-without-title-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineSelectedElementStylesheet && !outlineSelectedElementStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-selected-element-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineTableCellsStylesheet && !outlineTableCellsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-table-cells-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineTablesStylesheet && !outlineTablesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-tables-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = replaceImagesWithAltAttributesStylesheet && !replaceImagesWithAltAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-replace-images-with-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = showCommentsStylesheet && !showCommentsStylesheet.disabled;
    element = document.getElementById("webdeveloper-show-comments-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = useBorderBoxModelStylesheet && !useBorderBoxModelStylesheet.disabled;
    element = document.getElementById("webdeveloper-use-border-box-model-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = viewStyleInformationStylesheet && !viewStyleInformationStylesheet.disabled;
    element = document.getElementById("webdeveloper-view-style-information-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);
}

// Updates the render mode status button
function webdeveloper_updateRenderMode(currentDocument)
{
    var element = document.getElementById("webdeveloper-render-mode-statusbar");

    // If the render mode button exists
    if(element)
    {
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
        const renderMode         = currentDocument.compatMode;
        const stringBundle       = document.getElementById("webdeveloper-string-bundle");

        var textToolbar = false;

        // If the toolbar preference has a value and is set to text
        if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons") && preferencesService.getComplexValue("webdeveloper.toolbar.icons", Components.interfaces.nsISupportsString).data.trim() == "text")
        {
            textToolbar = true;
        }

        // If the render mode is quirks mode
        if(renderMode == "BackCompat")
        {
            element.setAttribute("class", "quirks webdeveloper-statusbar-button");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_quirksModeTooltip"));

            // If the toolbar is in text mode
            if(textToolbar)
            {
                element.setAttribute("label", stringBundle.getString("webdeveloper_quirksModeLabel"));
            }
        }
        else
        {
            element.setAttribute("class", "webdeveloper-statusbar-button");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_standardsComplianceModeTooltip"));

            // If the toolbar is in text mode
            if(textToolbar)
            {
                element.setAttribute("label", stringBundle.getString("webdeveloper_standardsComplianceModeLabel"));
            }
        }
    }
}

// View source
function webdeveloper_viewSource()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the view source in tab preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.view.source.tab") && preferencesService.getBoolPref("webdeveloper.view.source.tab"))
    {
        const newTab = getBrowser().addTab("view-source:" + getBrowser().currentURI.spec);

        // If the open tabs in background preference is not set or is set to false
        if(!preferencesService.prefHasUserValue("webdeveloper.open.tabs.background") || !preferencesService.getBoolPref("webdeveloper.open.tabs.background"))
        {
            getBrowser().selectedTab = newTab;
        }
    }
    else
    {
        BrowserViewSourceOfDocument(getBrowser().contentDocument);
    }
}

// JavaScript console listener
const WebDeveloperJavaScriptConsoleListener =
{
    // Observes changes in the console
    observe: function(error)
    {
        // If the document, error and error message are set
        if(document && error && error.message)
        {
            const javaScriptButton = document.getElementById("webdeveloper-javascript-statusbar");

            // If the JavaScript button is set
            if(javaScriptButton)
            {
                // Try to convert the error to a script error
                try
                {
                    const tempError = error.QueryInterface(Components.interfaces.nsIScriptError);

                    var errorCategory = error.category;

                    // If the error category is set
                    if(errorCategory)
                    {
                        // If the error category is content javascript or DOM:HTML
                        if(errorCategory == "content javascript" || errorCategory == "DOM:HTML")
                        {
                            const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
                            const stringBundle       = document.getElementById("webdeveloper-string-bundle");
                            const warning            = error.flags & error.warningFlag != 0;

                            var textToolbar = false;

                            // If the toolbar preference has a value and is set to text
                            if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons") && preferencesService.getComplexValue("webdeveloper.toolbar.icons", Components.interfaces.nsISupportsString).data.trim() == "text")
                            {
                                textToolbar = true;
                            }

                            // If this is a warning
                            if(warning)
                            {
                                javaScriptButton.setAttribute("class", "warning webdeveloper-statusbar-button");
                                javaScriptButton.setAttribute("tooltiptext", stringBundle.getFormattedString("webdeveloper_javaScriptWarningTooltip", [error.message]));

                                // If the toolbar is in text mode
                                if(textToolbar)
                                {
                                    javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javascriptWarningLabel"));
                                }

                                // If the open JavaScript console warning preference is set
                                if(preferencesService.prefHasUserValue("webdeveloper.open.javascript.console.warning") && preferencesService.getBoolPref("webdeveloper.open.javascript.console.warning"))
                                {
                                    webdeveloper_openJavaScriptConsole();
                                }
                            }
                            else
                            {
                                javaScriptButton.setAttribute("class", "error webdeveloper-statusbar-button");
                                javaScriptButton.setAttribute("tooltiptext", stringBundle.getFormattedString("webdeveloper_javaScriptErrorTooltip", [error.message]));

                                // If the toolbar is in text mode
                                if(textToolbar)
                                {
                                    javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javascriptErrorLabel"));
                                }

                                // If the open JavaScript console error preference is set
                                if(preferencesService.prefHasUserValue("webdeveloper.open.javascript.console.error") && preferencesService.getBoolPref("webdeveloper.open.javascript.console.error"))
                                {
                                    webdeveloper_openJavaScriptConsole();
                                }
                            }
                        }
                        else if(webdeveloper_debug && error.sourceName.indexOf("chrome://webdeveloper/") != -1)
                        {
                            toJavaScriptConsole();
                        }
                    }
                }
                catch(exception)
                {
                    // Do nothing
                }
            }
        }

        return false;
    }
}
