// Displays the tools menu
function webdeveloper_displayToolsMenu(menu, separatorName, tooltips)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const validatorSeparator = menu.getElementsByAttribute("id", separatorName)[0];

    var description           = null;
    var descriptionPreference = null;
    var key                   = null;
    var menuItem              = document.createElement("menuitem");
    var url                   = null;
    var toolsCount            = 0;

    // If the tools count preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.tool.count"))
    {
        toolsCount = preferencesService.getIntPref("webdeveloper.tool.count");
    }

    webdeveloper_removeGeneratedMenuItems(menu);

    // Loop through the possible tools
	for(var i = 1; i <= toolsCount; i++)
	{
        description = "webdeveloper.tool." + i + ".description";
        key         = "webdeveloper.tool." + i + ".key";
        url         = "webdeveloper.tool." + i + ".url";

        // If the description and URL are set
        if(preferencesService.prefHasUserValue(description) && preferencesService.prefHasUserValue(url))
        {
    	    descriptionPreference = preferencesService.getComplexValue(description, Components.interfaces.nsISupportsString).data.trim();

            // If the description is not blank
            if(descriptionPreference != "")
            {
                menuItem = document.createElement("menuitem");
                menuItem.setAttribute("class", "webdeveloper-generated-menu");
                menuItem.setAttribute("label", descriptionPreference);
                menuItem.setAttribute("oncommand", "webdeveloper_loadURL('" + preferencesService.getComplexValue(url, Components.interfaces.nsISupportsString).data.trim() + escape(getBrowser().currentURI.spec) + "')");

                // If the key preference is set
                if(preferencesService.prefHasUserValue(key))
                {
                    menuItem.setAttribute("key", key);
                }

                // If displaying tooltips
                if(tooltips)
                {
                    menuItem.setAttribute("tooltiptext", descriptionPreference);
                }

                menu.insertBefore(menuItem, validatorSeparator);
            }
        }
	}
}

// Validates local CSS
function webdeveloper_validateLocalCSS()
{
    const mainTabBox         = getBrowser().mTabBox;
    const documentList       = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const oldTab             = getBrowser().selectedTab;
    const oldURL             = getBrowser().currentURI.spec;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const request            = new XMLHttpRequest();

    var cssRule        = null;
    var formElement    = null;
    var generatedPage  = null;
    var inputElement   = null;
    var pageDocument   = null;
    var styleSheet     = null;
    var styleSheetHref = null;
    var styleSheetList = null;
    var styleText      = "";

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument   = documentList[i];
        styleSheetList = pageDocument.styleSheets;

        // Loop through the style sheets
        for(var j = 0; j < styleSheetList.length; j++)
        {
            styleText += webdeveloper_retrieveStyleSheetText(pageDocument, styleSheetList[j]);
        }
    }

    generatedPage = webdeveloper_generatePage("");

    // This must be done to make generated content render
    request.open("get", "about:blank", false);
    request.send("");

    formElement = generatedPage.content.document.createElement("form")
    formElement.setAttribute("method", "get");
    formElement.setAttribute("action", "http://jigsaw.w3.org/css-validator/validator");

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "profile");
    inputElement.setAttribute("value", "css2");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "usermedium");
    inputElement.setAttribute("value", "all");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "warning");
    inputElement.setAttribute("value", "2");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input")
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "text");
    inputElement.setAttribute("value", styleText);
    formElement.appendChild(inputElement);

    generatedPage.content.document.body.appendChild(formElement);
    formElement.submit();

    // If the open tabs in background preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.open.tabs.background") && preferencesService.getBoolPref("webdeveloper.open.tabs.background"))
    {
        getBrowser().selectedTab = oldTab;
    }
}

// Validates a local HTML file
function webdeveloper_validateLocalHTML()
{
    const oldTab             = getBrowser().selectedTab;
    const oldURL             = getBrowser().currentURI.spec;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const request            = new XMLHttpRequest();

    var defaultCharacterSet = null;
    var formElement         = null;
    var generatedPage       = null;
    var inputElement        = null;

    // If the character set preference is set
    if(preferencesService.prefHasUserValue("intl.charset.default"))
    {
        defaultCharacterSet = preferencesService.getCharPref("intl.charset.default");
    }

    preferencesService.setCharPref("intl.charset.default", getBrowser().contentDocument.characterSet);

    generatedPage = webdeveloper_generatePage("");

    // This must be done to make generated content render
    request.open("get", oldURL, false);
    request.send("");

    formElement = generatedPage.content.document.createElement("form")
    formElement.setAttribute("method", "post");
    formElement.setAttribute("action", "http://validator.w3.org/check");

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "verbose");
    inputElement.setAttribute("value", "1");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "fragment");
    inputElement.setAttribute("value", request.responseText);
    formElement.appendChild(inputElement);

    generatedPage.content.document.body.appendChild(formElement);
    formElement.submit();

    // If the default character set is set
    if(defaultCharacterSet)
    {
        preferencesService.setCharPref("intl.charset.default", defaultCharacterSet);
    }
    else
    {
        preferencesService.clearUserPref("intl.charset.default");
    }

    // If the open tabs in background preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.open.tabs.background") && preferencesService.getBoolPref("webdeveloper.open.tabs.background"))
    {
        getBrowser().selectedTab = oldTab;
    }
}

// Tidies the HTML before validating
function webdeveloper_validateTidiedHTML()
{
    const oldTab             = getBrowser().selectedTab;
    const oldURL             = getBrowser().currentURI.spec;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const request            = new XMLHttpRequest();

    var formElement   = null;
    var generatedPage = null;
    var inputElement  = null;
    var output        = "";

    generatedPage = webdeveloper_generatePage("");

    // This must be done to make generated content render
    request.open("get", oldURL, false);
    request.send("");

    output = request.responseText;

    // If closing <br> tags
    if(preferencesService.prefHasUserValue("webdeveloper.tidied.html.close.br") && preferencesService.getBoolPref("webdeveloper.tidied.html.close.br"))
    {
        output = output.replace(new RegExp("<br>", "gi"), "<br />");
    }

    // If escaping ampersands
    if(preferencesService.prefHasUserValue("webdeveloper.tidied.html.escape.ampersand") && preferencesService.getBoolPref("webdeveloper.tidied.html.escape.ampersand"))
    {
        output = output.replace(new RegExp("&(?!#?[xX]?(?:[0-9a-fA-F]+|\w{1,8});)", "gi"), "&amp;");
    }

    formElement = generatedPage.content.document.createElement("form")
    formElement.setAttribute("method", "post");
    formElement.setAttribute("action", "http://validator.w3.org/check");

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "verbose");
    inputElement.setAttribute("value", "1");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "doctype");
    inputElement.setAttribute("value", "HTML 4.01 Transitional");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "fbd");
    inputElement.setAttribute("value", "1");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "ss");
    inputElement.setAttribute("value", "1");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "fragment");
    inputElement.setAttribute("value", output);
    formElement.appendChild(inputElement);

    generatedPage.content.document.body.appendChild(formElement);
    formElement.submit();

    // If the open tabs in background preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.open.tabs.background") && preferencesService.getBoolPref("webdeveloper.open.tabs.background"))
    {
        getBrowser().selectedTab = oldTab;
    }
}

// Validates the page against the validator
function webdeveloper_validateURL(validator)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var validatorURL = "";

    // If the validator preference is set
    if(preferencesService.prefHasUserValue(validator) && preferencesService.getComplexValue(validator, Components.interfaces.nsISupportsString).data.trim() != "")
    {
        validatorURL = preferencesService.getComplexValue(validator, Components.interfaces.nsISupportsString).data.trim();
    }
    else
    {
        const stringBundle = document.getElementById("webdeveloper-string-bundle");

        alert(stringBundle.getString("webdeveloper_validateURLConfigure"));
        webdeveloper_options();

        // If the validator preference is set
        if(preferencesService.prefHasUserValue(validator))
        {
            validatorURL = preferencesService.getComplexValue(validator, Components.interfaces.nsISupportsString).data.trim();
        }
    }

    // If the validator URL is not empty
    if(validatorURL != "")
    {
        webdeveloper_loadURL(validatorURL + escape(getBrowser().currentURI.spec));
    }
}
