var webdeveloper_editCSSSelectedTab = -1;
var webdeveloper_intervalID         = null;
var webdeveloper_updateFrequency    = 500;

// Applies the CSS
function webdeveloper_applyCSS()
{
    const content         = window.top.getBrowser();
    const mainTabBox      = content.mTabBox;
    const contentDocument = content.browsers[mainTabBox.selectedIndex].contentDocument;
    const styleElement    = contentDocument.getElementById("webdeveloper-edit-css-style");
    const textBoxes       = document.getElementById("webdeveloper-edit-css-tab-panels").getElementsByTagName("textbox");

    var styleText = "";

    // Loop through the text boxes
    for(var i = 0; i < textBoxes.length; i++)
    {
        styleText += textBoxes[i].value;
    }

    // If the style element exists and the style text is not the same
    if(styleElement && styleText != styleElement.innerHTML)
    {
        webdeveloper_removeAllChildNodes(styleElement);
        styleElement.appendChild(contentDocument.createTextNode(styleText));
    }
}

// Clear the CSS
function webdeveloper_clearCSS()
{
    webdeveloper_getSelectedPanel().firstChild.value = "";
}

// Reinitializes the sidebar when the page changes
function webdeveloper_contentPageLoad(event)
{
    const eventTarget        = event.target;
    const originalTarget     = event.originalTarget;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the page is the target and the URI matches
    if(originalTarget && eventTarget && eventTarget.contentDocument && eventTarget.hasAttribute && eventTarget.hasAttribute("id") && eventTarget.getAttribute("id").toLowerCase() == "content" && originalTarget.documentURI == eventTarget.contentDocument.documentURI)
    {
        // If the CSS stick preference is set to true
        if(preferencesService.prefHasUserValue("webdeveloper.edit.css.stick") && preferencesService.getBoolPref("webdeveloper.edit.css.stick"))
        {
            webdeveloper_initializeEditCSS(false);
        }
        else
        {
            webdeveloper_resetCSS();
        }
    }
}

// Handles a browser tab being selected
function webdeveloper_editCSSMainTabSelect(event)
{
    const selectedTab = window.top.getBrowser().mTabBox.selectedIndex;

    // If the selected tab is different
    if(selectedTab != webdeveloper_editCSSSelectedTab)
    {
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

        webdeveloper_editCSSSelectedTab = selectedTab;

        // If the CSS stick preference is set to true
        if(preferencesService.prefHasUserValue("webdeveloper.edit.css.stick") && preferencesService.getBoolPref("webdeveloper.edit.css.stick"))
        {
            webdeveloper_initializeEditCSS(false);
        }
        else
        {
            webdeveloper_resetCSS();
        }
    }
}

// Handles a tab being selected
function webdeveloper_editCSSTabSelect(event)
{
    const selectedTab = document.getElementById("webdeveloper-edit-css-tab-box").selectedTab;
    const nextTab     = selectedTab.nextSibling;
    const previousTab = selectedTab.previousSibling;

    // If there is a previous tab
    if(previousTab)
    {
        // Remove the after selected attribute
        if(previousTab.hasAttribute("afterselected"))
        {
            previousTab.removeAttribute("afterselected");
        }

        // Remove the before selected attribute
        if(previousTab.hasAttribute("beforeselected"))
        {
            previousTab.removeAttribute("beforeselected");
        }
    }

    // If there is a next tab
    if(nextTab)
    {
        // Remove the after selected attribute
        if(nextTab.hasAttribute("afterselected"))
        {
            nextTab.removeAttribute("afterselected");
        }

        // Remove the before selected attribute
        if(nextTab.hasAttribute("beforeselected"))
        {
            nextTab.removeAttribute("beforeselected");
        }
    }
}

// Unloads edit CSS
function webdeveloper_editCSSUnload()
{
    const content         = window.top.getBrowser();
    const mainTabBox      = content.mTabBox;
    const currentDocument = content.browsers[mainTabBox.selectedIndex].contentDocument;
    const styleElement    = currentDocument.getElementById("webdeveloper-edit-css-style");
    const styleSheetList  = currentDocument.styleSheets;
    const tabBox          = document.getElementById("webdeveloper-edit-css-tab-box");

    var styleSheet = null;

    window.clearInterval(webdeveloper_intervalID);

    mainTabBox.removeEventListener("select", webdeveloper_editCSSMainTabSelect, true);
    tabBox.removeEventListener("select", webdeveloper_editCSSTabSelect, true);
    window.top.removeEventListener("load", webdeveloper_contentPageLoad, true);

    // If the style element exists
    if(styleElement)
    {
        styleElement.parentNode.removeChild(styleElement);
    }

    // Loop through the style sheets
    for(var i = 0; i < styleSheetList.length; i++)
    {
        styleSheet = styleSheetList[i];

        webdeveloper_enableStyleSheet(styleSheet);
    }
}

// Enables a style sheet
function webdeveloper_enableStyleSheet(styleSheet)
{
    const ownerNode = styleSheet.ownerNode;

    var cssRule = null;

    // Loop through the the style sheet rules
    for(var i = 0; i < styleSheet.cssRules.length; i++)
    {
        cssRule = styleSheet.cssRules[i];

        // If this is an import rule
        if(cssRule.type == 3)
        {
            webdeveloper_enableStyleSheet(cssRule.styleSheet);
        }
    }

    // If the style sheet does not have an owner node or is not an alternate style sheet
    if(!ownerNode || ownerNode.nodeType == 7 || !ownerNode.hasAttribute("rel") || ownerNode.getAttribute("rel").toLowerCase() != "alternate stylesheet")
    {
        styleSheet.disabled = false;
    }
}

// Returns the selected panel
function webdeveloper_getSelectedPanel()
{
    var selectedPanel = document.getElementById("webdeveloper-edit-css-tab-panels").selectedPanel;

    // If the selected panel is not set
    if(!selectedPanel)
    {
        selectedPanel = document.getElementById("webdeveloper-edit-css-tab-panels").firstChild;
    }

    return selectedPanel;
}

// Initializes the edit CSS sidebar
function webdeveloper_initializeEditCSS(reset)
{
    const content            = window.top.getBrowser();
    const mainTabBox         = content.mTabBox;
    const currentDocument    = content.browsers[mainTabBox.selectedIndex].contentDocument;
    const headElementList    = currentDocument.getElementsByTagName("head");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const tabBox             = document.getElementById("webdeveloper-edit-css-tab-box");
    const textBoxes          = document.getElementById("webdeveloper-edit-css-tab-panels").getElementsByTagName("textbox");

    var styleElement = currentDocument.getElementById("webdeveloper-edit-css-style");
    var styleText    = "";

    // Try to remove the main tab box select event listener
    try
    {
        mainTabBox.removeEventListener("select", webdeveloper_editCSSMainTabSelect, true);
    }
    catch(exception)
    {
        // Do nothing
    }

    // Try to remove the tab box event select listener
    try
    {
        tabBox.removeEventListener("select", webdeveloper_editCSSTabSelect, true);
    }
    catch(exception)
    {
        // Do nothing
    }

    // Try to remove the load event listener
    try
    {
        window.top.removeEventListener("load", webdeveloper_contentPageLoad, true);
    }
    catch(exception)
    {
        // Do nothing
    }

    mainTabBox.addEventListener("select", webdeveloper_editCSSMainTabSelect, true);
    tabBox.addEventListener("select", webdeveloper_editCSSTabSelect, true);
    window.top.addEventListener("load", webdeveloper_contentPageLoad, true);

    // If resetting
    if(reset)
    {
        webdeveloper_updateStickCSS();
        webdeveloper_retrieveCSS();
    }

    // If the style element does not exist
    if(!styleElement)
    {
        styleElement = currentDocument.createElement("style");

        styleElement.setAttribute("id", "webdeveloper-edit-css-style");
        styleElement.setAttribute("type", "text/css");

        // If there is a head element
        if(headElementList.length > 0)
        {
            headElementList[0].appendChild(styleElement);
        }
        else
        {
            currentDocument.documentElement.appendChild(styleElement);
        }
    }

    // If the edit CSS update frequency preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.edit.css.update.frequency"))
    {
        webdeveloper_updateFrequency = preferencesService.getIntPref("webdeveloper.edit.css.update.frequency");
    }

    webdeveloper_applyCSS();

    webdeveloper_intervalID = window.setInterval(webdeveloper_applyCSS, webdeveloper_updateFrequency);
}

// Loads new CSS
function webdeveloper_loadCSS()
{
    const filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    filePicker.appendFilter(stringBundle.getString("webdeveloper_styleSheetDescription"), "*.css");
    filePicker.init(window, stringBundle.getString("webdeveloper_editCSSLoadStyleSheetTitle"), filePicker.modeOpen);

    // If the user selected a style sheet
    if(filePicker.show() == filePicker.returnOK)
    {
        const inputStream      = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
        const scriptableStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);

        inputStream.init(filePicker.file, 0x01, 0444, null);
        scriptableStream.init(inputStream);

        webdeveloper_getSelectedPanel().firstChild.value = scriptableStream.read(scriptableStream.available());

        scriptableStream.close();
        inputStream.close();
    }
}

// Resets the edited CSS
function webdeveloper_resetCSS()
{
    const content      = window.top.getBrowser();
    const mainTabBox   = content.mTabBox;
    const styleElement = content.browsers[mainTabBox.selectedIndex].contentDocument.getElementById("webdeveloper-edit-css-style");
    const tabPanels    = document.getElementById("webdeveloper-edit-css-tab-panels");
    const tabs         = document.getElementById("webdeveloper-edit-css-tabs");

    // If the style element exists
    if(styleElement)
    {
        styleElement.parentNode.removeChild(styleElement);
    }

    webdeveloper_removeAllChildNodes(tabPanels);
    webdeveloper_removeAllChildNodes(tabs);

    webdeveloper_initializeEditCSS(true);
}

// Retrieves the CSS from the current page
function webdeveloper_retrieveCSS()
{
    const content            = window.top.getBrowser();
    const mainTabBox         = content.mTabBox;
    const currentDocument    = content.browsers[mainTabBox.selectedIndex].contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const stringBundle       = document.getElementById("webdeveloper-string-bundle");
    const tabs               = document.getElementById("webdeveloper-edit-css-tabs");
    const tabPanels          = document.getElementById("webdeveloper-edit-css-tab-panels");

    var cssRule          = null;
    var inlineStylesText = "";
    var mediaList        = null;
    var ownerNode        = null;
    var result           = null;
    var results          = new Array();
    var styleSheet       = null;
    var styleSheetHref   = null;
    var styleSheetList   = currentDocument.styleSheets;
    var tab              = null;
    var tabPanel         = null;
    var textBox          = null;
    var textBoxStyle     = "";

    // If the edit CSS background color preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.edit.css.color.background"))
    {
        textBoxStyle += "background-color: " + preferencesService.getComplexValue("webdeveloper.edit.css.color.background", Components.interfaces.nsISupportsString).data.trim() + " !important;";
    }

    // If the edit CSS text color preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.edit.css.color.text"))
    {
        textBoxStyle += "color: " + preferencesService.getComplexValue("webdeveloper.edit.css.color.text", Components.interfaces.nsISupportsString).data.trim() + " !important;";
    }

    // If the edit CSS font preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.edit.css.font"))
    {
        textBoxStyle += "font-size: " + preferencesService.getIntPref("webdeveloper.edit.css.font") + "px !important;";
    }

    // Loop through the style sheets
    for(i = 0; i < styleSheetList.length; i++)
    {
        styleSheet     = styleSheetList[i];
        mediaList      = styleSheet.media.mediaText;
        ownerNode      = styleSheet.ownerNode;
        styleSheetHref = styleSheet.href;

        // If this is an inline style sheet
        if(styleSheetHref == currentDocument.documentURI)
        {
            // Loop through the the style sheet rules
            for(var j = 0; j < styleSheet.cssRules.length; j++)
            {
                cssRule = styleSheet.cssRules[j];

                // If this is an import rule
                if(cssRule.type == 3)
                {
                    results = webdeveloper_retrieveStyleSheetDetails(cssRule.styleSheet, textBoxStyle, results);
                }
            }
        }
        else if(styleSheetHref && styleSheetHref.indexOf("resource://") != 0 && styleSheetHref.indexOf("about:PreferenceStyleSheet") != 0 && styleSheetHref.indexOf("jar:file://") != 0 && styleSheetHref.indexOf("chrome://") != 0 && (!mediaList || mediaList.indexOf("screen") != -1 || mediaList.indexOf("all") != -1) && (!ownerNode || ownerNode.nodeType == 7 || !ownerNode.hasAttribute("rel") || ownerNode.getAttribute("rel").toLowerCase() != "alternate stylesheet"))
        {
            results = webdeveloper_retrieveStyleSheetDetails(styleSheet, textBoxStyle, results);
        }
    }

    styleSheetList = currentDocument.getElementsByTagName("style");

    // Loop through the inline style sheets
    for(var i = 0; i < styleSheetList.length; i++)
    {
        styleSheet = styleSheetList[i];

        inlineStylesText += styleSheet.innerHTML.trim() + "\n\n";

        styleSheet.disabled = true;
    }

    // If there are inline styles
    if(inlineStylesText != "")
    {
        tab      = document.createElement("tab");
        tabPanel = document.createElement("tabpanel");
        textBox  = document.createElement("textbox");

        tab.setAttribute("label", stringBundle.getString("webdeveloper_editCSSInlineStyles"));
        textBox.setAttribute("flex", "1");
        textBox.setAttribute("multiline", "true");
        textBox.setAttribute("style", textBoxStyle);
        textBox.setAttribute("value", inlineStylesText);

        // If the edit CSS wrap preference is not set to true
        if(!preferencesService.prefHasUserValue("webdeveloper.edit.css.wrap") || !preferencesService.getBoolPref("webdeveloper.edit.css.wrap"))
        {
            textBox.setAttribute("wrap", "off");
        }

        tabPanel.appendChild(textBox);

        results.push(new Array(tab, tabPanel));
    }

    // Loop through the results
    for(i = 0; i < results.length; i++)
    {
        result = results[i];

        tabPanels.appendChild(result[1]);
        tabs.appendChild(result[0]);
    }

    // If there are no tabs
    if(tabs.childNodes.length == 0)
    {
        tab      = document.createElement("tab");
        tabPanel = document.createElement("tabpanel");
        textBox  = document.createElement("textbox");

        tab.setAttribute("label", stringBundle.getString("webdeveloper_editCSS"));
        textBox.setAttribute("flex", "1");
        textBox.setAttribute("multiline", "true");
        textBox.setAttribute("style", textBoxStyle);

        // If the edit CSS wrap preference is not set to true
        if(!preferencesService.prefHasUserValue("webdeveloper.edit.css.wrap") || !preferencesService.getBoolPref("webdeveloper.edit.css.wrap"))
        {
            textBox.setAttribute("wrap", "off");
        }

        tabPanel.appendChild(textBox);
        tabPanels.appendChild(tabPanel);
        tabs.appendChild(tab);
    }

    tabs.selectedIndex = 0;
}

// Retrieves the style sheet details
function webdeveloper_retrieveStyleSheetDetails(styleSheet, textBoxStyle, results)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const request            = new XMLHttpRequest();
    const styleSheetHref     = styleSheet.href;
    const position           = styleSheetHref.lastIndexOf("/");
    const url                = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURL);

    var cssRule    = null;
    var stylesText = "";
    var tab        = document.createElement("tab");
    var tabPanel   = document.createElement("tabpanel");
    var textBox    = document.createElement("textbox");

    // Loop through the the style sheet rules
    for(var i = 0; i < styleSheet.cssRules.length; i++)
    {
        cssRule = styleSheet.cssRules[i];

        // If this is an import rule
        if(cssRule.type == 3)
        {
            results = webdeveloper_retrieveStyleSheetDetails(cssRule.styleSheet, textBoxStyle, results);
        }
    }

    request.open("get", styleSheetHref, false);
    request.send("");

    stylesText = request.responseText;
    url.spec   = styleSheetHref;

    tab.setAttribute("label", url.fileName);
    textBox.setAttribute("flex", "1");
    textBox.setAttribute("multiline", "true");
    textBox.setAttribute("style", textBoxStyle);
    textBox.setAttribute("value", stylesText);

    // If the edit CSS wrap preference is not set to true
    if(!preferencesService.prefHasUserValue("webdeveloper.edit.css.wrap") || !preferencesService.getBoolPref("webdeveloper.edit.css.wrap"))
    {
        textBox.setAttribute("wrap", "off");
    }

    tabPanel.appendChild(textBox);

    results.push(new Array(tab, tabPanel));

    styleSheet.disabled = true;

    return results;
}

// Saves the CSS
function webdeveloper_saveCSS()
{
    const filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const styleText    = webdeveloper_getSelectedPanel().firstChild.value;

    var result = null;

    filePicker.appendFilter(stringBundle.getString("webdeveloper_styleSheetDescription"), "*.css");
    filePicker.init(window, stringBundle.getString("webdeveloper_editCSSSaveStyleSheetTitle"), filePicker.modeSave);
    result = filePicker.show();

    // If the user selected a style sheet
    if(result == filePicker.returnOK || result == filePicker.returnReplace)
    {
        const outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

        // If the file does not exist
        if(!filePicker.file.exists())
        {
            filePicker.file.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 444);
        }

        outputStream.init(filePicker.file, 0x04 | 0x08 | 0x20, 0444, null);

        outputStream.write(styleText, styleText.length);
        outputStream.close();
    }
}

// Toggles sticking the CSS
function webdeveloper_toggleStickCSS()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var stick = true;

    // If the edit CSS stick preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.edit.css.stick"))
    {
        stick = !preferencesService.getBoolPref("webdeveloper.edit.css.stick");
    }

    preferencesService.setBoolPref("webdeveloper.edit.css.stick", stick);

    webdeveloper_updateStickCSS();
}

// Updates the stick CSS button
function webdeveloper_updateStickCSS()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const stringBundle       = document.getElementById("webdeveloper-string-bundle");

    var element = document.getElementById("webdeveloper-stick-css-sidebar");
    var label   = null;
    var stick   = false;

    // If the edit CSS stick preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.edit.css.stick"))
    {
        stick = preferencesService.getBoolPref("webdeveloper.edit.css.stick");
    }

    // If the element exists
    if(element)
    {
        // If sticking the CSS
        if(stick)
        {
            label = stringBundle.getString("webdeveloper_unstickTooltip");

            element.setAttribute("class", "unstick webdeveloper-sidebar-button");
            element.setAttribute("tooltiptext", label);
        }
        else
        {
            label = stringBundle.getString("webdeveloper_stickTooltip");

            element.setAttribute("class", "webdeveloper-sidebar-button");
            element.setAttribute("tooltiptext", label);
        }
    }
}