// Resizes the window to a custom size
function webdeveloper_customWindowSize()
{
    window.openDialog("chrome://webdeveloper/content/dialogs/resize.xul", "webdeveloper-resize-dialog", "centerscreen,chrome,modal", window.outerWidth, window.outerHeight);
}

// Displays the resize menu
function webdeveloper_displayResizeMenu(menu, separatorName, tooltips)
{
    const resizeSeparator    = menu.getElementsByAttribute("id", separatorName)[0];
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var description           = null;
    var descriptionPreference = null;
    var height                = null;
    var heightPreference      = null;
    var menuItem              = document.createElement("menuitem");
    var resizeCount           = 0;
    var windowHeight          = window.outerHeight;
    var windowWidth           = window.outerWidth;
    var width                 = null;
    var widthPreference       = null;

    // If the resize count preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.resize.count"))
    {
        resizeCount = preferencesService.getIntPref("webdeveloper.resize.count");
    }

    webdeveloper_removeGeneratedMenuItems(menu);

    // Loop through the possible resize options
	for(var i = 1; i <= resizeCount; i++)
	{
        description = "webdeveloper.resize." + i + ".description";
        height      = "webdeveloper.resize." + i + ".height";
        width       = "webdeveloper.resize." + i + ".width";

        // If the description, width and height are set
        if(preferencesService.prefHasUserValue(description) && preferencesService.prefHasUserValue(width) && preferencesService.prefHasUserValue(height))
        {
    	    descriptionPreference = preferencesService.getComplexValue(description, Components.interfaces.nsISupportsString).data.trim();

            // If the description is not blank
            if(descriptionPreference != "")
            {
                heightPreference = preferencesService.getIntPref(height);
                menuItem         = document.createElement("menuitem");
                widthPreference  = preferencesService.getIntPref(width);

                // If the window values are set to this item's values
                if(windowWidth == widthPreference && windowHeight == heightPreference)
                {
                    menuItem.setAttribute("checked", true);
                }

                menuItem.setAttribute("class", "webdeveloper-generated-menu");
                menuItem.setAttribute("label", descriptionPreference);
                menuItem.setAttribute("oncommand", "webdeveloper_resizeWindow(" + widthPreference + ", " + heightPreference + ")");
                menuItem.setAttribute("type", "radio");

                // If displaying tooltips
                if(tooltips)
                {
                    menuItem.setAttribute("tooltiptext", descriptionPreference);
                }

                menu.insertBefore(menuItem, resizeSeparator);
            }
        }
	}
}

// Displays the current window size
function webdeveloper_displayWindowSize()
{
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    alert(stringBundle.getFormattedString("webdeveloper_displayWindowSize", [getBrowser().contentWindow.outerWidth, getBrowser().contentWindow.outerHeight, getBrowser().contentWindow.innerWidth, getBrowser().contentWindow.innerHeight]));
}

// Displays the current window size in the title bar
function webdeveloper_displayWindowSizeInTitle(element, applyStyle)
{
    const checked = element.getAttribute("checked");

    // If the menu is checked
    if(checked)
    {
        getBrowser().contentDocument.title += " - " + window.outerWidth + "x" + window.outerHeight;
        window.onresize                     = webdeveloper_updateWindowSizeInTitle;
    }
    else
    {
        const title = getBrowser().contentTitle;

        getBrowser().contentDocument.title = title.substring(0, title.lastIndexOf(" - "));
        window.onresize                    = null;
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-display-current-size-title", applyStyle);
}

// Resizes the window to the given width and height
function webdeveloper_resizeWindow(width, height)
{
    window.resizeTo(width, height);
}

// Updates the window size in the title bar
function webdeveloper_updateWindowSizeInTitle()
{
    const title = getBrowser().contentTitle;

    getBrowser().contentDocument.title = title.substring(0, title.lastIndexOf(" - ")) + " - " + window.outerWidth + "x" + window.outerHeight;
}
