// Ignores the click event
function webdeveloper_ignoreClick(event)
{
    // If there is an event target and the click was not a right click
    if(event.target && event.button != 2)
    {
        event.preventDefault();
    }
}

// Outlines all block level elements
function webdeveloper_outlineBlockLevelElements(element, applyStyle)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_block_level_elements.css", "webdeveloper-outline-block-level-elements", applyStyle);

    // If the show outlined element names preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.outline.show.element.names") && preferencesService.getBoolPref("webdeveloper.outline.show.element.names"))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_block_level_elements_before.css", "webdeveloper-outline-block-level-elements-before", applyStyle);
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-block-level-elements-before-tooltips", "*:before");
    }
}

// Outlines the given element
function webdeveloper_outlineCustomElements(element)
{
    webdeveloper_outlinedElements = new Array();

    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        window.openDialog("chrome://webdeveloper/content/dialogs/outline_elements.xul", "webdeveloper-outline-elements-dialog", "centerscreen,chrome,modal", webdeveloper_outlinedElements);

        // If the user clicked cancel in the dialog
        if(webdeveloper_outlinedElements.length == 0)
        {
           element.removeAttribute("checked");
        }
    }

    webdeveloper_outlineElements(element, true);
}

// Outlines all deprecated elements
function webdeveloper_outlineDeprecatedElements(element, applyStyle)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_deprecated_elements.css", "webdeveloper-outline-deprecated-elements", applyStyle);

    // If the show outlined element names preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.outline.show.element.names") && preferencesService.getBoolPref("webdeveloper.outline.show.element.names"))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_deprecated_elements_before.css", "webdeveloper-outline-deprecated-elements-before", applyStyle);
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-deprecated-elements-before-tooltips", "*:before");
    }
}

// Outlines the given element
function webdeveloper_outlineElements(element, applyStyle)
{
    // If the menu is checked
    if(element.getAttribute("checked") && webdeveloper_outlinedElements.length > 0)
    {
        const mainTabBox         = getBrowser().mTabBox;
        const documentList       = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

        var headElementList     = null;
        var outlineColor        = null;
        var outlineElement      = null;
        var outlineElementList  = null;
        var outlineElementValue = null;
        var pageDocument        = null;
        var styleElement        = null;

        // Loop through the documents
        for(var i = 0; i < documentList.length; i++)
        {
            pageDocument    = documentList[i];
            headElementList = pageDocument.getElementsByTagName("head");
            styleElement    = pageDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-outline-custom-elements");
            styleElement.setAttribute("type", "text/css");

            // Loop through outline colors and elements
            for(var j = 0; j <= 5; j++)
            {
                outlineColor   = "webdeveloper.custom." + j + ".color";
                outlineElement = "webdeveloper.custom." + j + ".element";

                // If the color and element are set and not blank
                if(preferencesService.prefHasUserValue(outlineColor) && preferencesService.prefHasUserValue(outlineElement) && preferencesService.getComplexValue(outlineColor, Components.interfaces.nsISupportsString).data.trim() != "" && preferencesService.getComplexValue(outlineElement, Components.interfaces.nsISupportsString).data.trim() != "")
                {
                    outlineElementList = preferencesService.getComplexValue(outlineElement, Components.interfaces.nsISupportsString).data.trim().split(",");

                    // Loop through the elements
                    for(var k = 0; k < outlineElementList.length; k++)
                    {
                        outlineElementValue = outlineElementList[k];
                        styleElement.appendChild(pageDocument.createTextNode(outlineElementValue + " { -moz-outline: 1px solid " + preferencesService.getComplexValue(outlineColor, Components.interfaces.nsISupportsString).data.trim() + " !important; }"));

                        // If the show outlined element names preference is set
                        if(preferencesService.prefHasUserValue("webdeveloper.outline.show.element.names") && preferencesService.getBoolPref("webdeveloper.outline.show.element.names"))
                        {
                            styleElement.appendChild(pageDocument.createTextNode(outlineElementValue + ":before { content: \"<" + outlineElementValue + ">\" !important; }"));
                        }
                    }
                }
            }

            // If there is a head element
            if(headElementList.length > 0)
            {
                headElementList[0].appendChild(styleElement);
            }
            else
            {
                pageDocument.documentElement.appendChild(styleElement);
            }
        }

        // If applying styles
        if(applyStyle)
        {
            webdeveloper_addAppliedStyle("webdeveloper-outline-custom-elements");
        }
    }
    else
    {
        webdeveloper_removeStyleSheet("webdeveloper-outline-custom-elements", true);
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/imports/before.css", "webdeveloper-outline-custom-elements-before", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-custom-elements-before-tooltips", "*:before");
}

// Outlines all frames
function webdeveloper_outlineFrames(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_frames.css", "webdeveloper-outline-frames", applyStyle);
}

// Outlines all the links without title attributes
function webdeveloper_outlineLinksWithoutTitleAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_links_without_title_attributes.css", "webdeveloper-outline-links-without-title-attributes", applyStyle);
}

// Outlines the selected element
function webdeveloper_outlineSelectedElement(element, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var checked      = element.getAttribute("checked");
    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];

        // If outlining the selected element
        if(checked)
        {
            pageDocument.addEventListener("mouseover", webdeveloper_displayElementAncestors, true);
            pageDocument.addEventListener("click", webdeveloper_ignoreClick, true);
        }
        else
        {
            pageDocument.removeEventListener("mouseover", webdeveloper_displayElementAncestors, true);
            pageDocument.removeEventListener("click", webdeveloper_ignoreClick, true);
            getBrowser().contentWindow.status = null;
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_selected_element.css", "webdeveloper-outline-selected-element", applyStyle);
}

// Outlines all table cells
function webdeveloper_outlineTableCells(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_table_cells.css", "webdeveloper-outline-table-cells", applyStyle);
}

// Outlines all tables
function webdeveloper_outlineTables(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_tables.css", "webdeveloper-outline-tables", applyStyle);
}
