var webdeveloper_optionsDataBoolean = new Array();
var webdeveloper_optionsDataInteger = new Array();
var webdeveloper_optionsDataString  = new Array();
var webdeveloper_resizeDescription  = null;
var webdeveloper_resizeHeight       = null;
var webdeveloper_resizeWidth        = null;
var webdeveloper_toolDescription    = null;
var webdeveloper_toolKey            = null;
var webdeveloper_toolURL            = null;

// Adds a resize option
function webdeveloper_addResize()
{
    const pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const resizeBox    = pageDocument.getElementById("webdeveloper-listbox");

    window.openDialog("chrome://webdeveloper/content/options/dialogs/resize.xul", "webdeveloper-resize-dialog", "centerscreen,chrome,modal", "add");

    // If the description, height and width are set
    if(webdeveloper_resizeDescription && webdeveloper_resizeHeight && webdeveloper_resizeWidth)
    {
        var listCell = pageDocument.createElement("listcell");
        var listItem = pageDocument.createElement("listitem");

        listCell.setAttribute("label", webdeveloper_resizeDescription);
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");
        listCell.setAttribute("label", webdeveloper_resizeWidth);
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");
        listCell.setAttribute("label", webdeveloper_resizeHeight);
        listItem.appendChild(listCell);

        resizeBox.selectItem(resizeBox.appendChild(listItem));
    }
}

// Adds a tool
function webdeveloper_addTool()
{
    const pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const toolBox      = pageDocument.getElementById("webdeveloper-listbox");

    window.openDialog("chrome://webdeveloper/content/options/dialogs/tool.xul", "webdeveloper-tool-dialog", "centerscreen,chrome,modal", "add");

    // If the description and URL are set
    if(webdeveloper_toolDescription && webdeveloper_toolURL)
    {
        var listCell = pageDocument.createElement("listcell");
        var listItem = pageDocument.createElement("listitem");

        listCell.setAttribute("label", webdeveloper_toolDescription);
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");
        listCell.setAttribute("label", webdeveloper_toolURL);
        listCell.setAttribute("crop", "end");
        listItem.appendChild(listCell);

        listCell = pageDocument.createElement("listcell");
        listCell.setAttribute("label", webdeveloper_toolKey);
        listItem.appendChild(listCell);

        toolBox.selectItem(toolBox.appendChild(listItem));
    }
}

// Handles changing the options page
function webdeveloper_changePage(pageList)
{
    webdeveloper_storeOptions();

    document.getElementById("webdeveloper-options-iframe").setAttribute("src", pageList.selectedItem.value);
}

// Deletes a resize option
function webdeveloper_deleteResize()
{
    const pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const resizeBox    = pageDocument.getElementById("webdeveloper-listbox");
    const selectedItem = resizeBox.selectedItem;
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If an item is selected and the deletion is confirmed
    if(selectedItem && confirm(stringBundle.getString("webdeveloper_resizeDeleteConfirmation")))
    {
        resizeBox.removeChild(selectedItem);
    }
}

// Deletes a tool
function webdeveloper_deleteTool()
{
    const pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const toolBox      = pageDocument.getElementById("webdeveloper-listbox");
    const selectedItem = toolBox.selectedItem;

    // If an item is selected and the deletion is confirmed
    if(selectedItem && confirm(stringBundle.getString("webdeveloper_toolDeleteConfirmation")))
    {
        toolBox.removeChild(selectedItem);
    }
}

// Edits a resize option
function webdeveloper_editResize()
{
    const pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const resizeBox    = pageDocument.getElementById("webdeveloper-listbox");
    const selectedItem = resizeBox.selectedItem;

    // If an option is selected
    if(selectedItem)
    {
        window.openDialog("chrome://webdeveloper/content/options/dialogs/resize.xul", "webdeveloper-resize-dialog", "centerscreen,chrome,modal", "edit", selectedItem.childNodes[0].getAttribute("label"), selectedItem.childNodes[1].getAttribute("label"), selectedItem.childNodes[2].getAttribute("label"));

        // If the description, height and width are set
        if(webdeveloper_resizeDescription && webdeveloper_resizeHeight && webdeveloper_resizeWidth)
        {
            var listCell = pageDocument.createElement("listcell");

            webdeveloper_removeAllChildNodes(selectedItem);

            listCell.setAttribute("label", webdeveloper_resizeDescription);
            selectedItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", webdeveloper_resizeWidth);
            selectedItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", webdeveloper_resizeHeight);
            selectedItem.appendChild(listCell);
        }
    }
}

// Edits a tool
function webdeveloper_editTool()
{
    const pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const toolBox      = pageDocument.getElementById("webdeveloper-listbox");
    const selectedItem = toolBox.selectedItem;

    // If an option is selected
    if(selectedItem)
    {
        window.openDialog("chrome://webdeveloper/content/options/dialogs/tool.xul", "webdeveloper-tool-dialog", "centerscreen,chrome,modal", "edit", selectedItem.childNodes[0].getAttribute("label"), selectedItem.childNodes[1].getAttribute("label"), selectedItem.childNodes[2].getAttribute("label"));

        // If the description and url are set
        if(webdeveloper_toolDescription && webdeveloper_toolURL)
        {
            var listCell = pageDocument.createElement("listcell");

            webdeveloper_removeAllChildNodes(selectedItem);

            listCell.setAttribute("label", webdeveloper_toolDescription);
            selectedItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", webdeveloper_toolURL);
            listCell.setAttribute("crop", "end");
            selectedItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", webdeveloper_toolKey);
            selectedItem.appendChild(listCell);
        }
    }
}

// Initializes the colors page
function webdeveloper_initializeColors()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the feature tooltip text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.feature.tooltip.text").color = webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.text"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.feature.tooltip.text"))
    {
        pageDocument.getElementById("webdeveloper.color.feature.tooltip.text").color = preferencesService.getComplexValue("webdeveloper.color.feature.tooltip.text", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the feature tooltip background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.feature.tooltip.background").color = webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.background"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.feature.tooltip.background"))
    {
        pageDocument.getElementById("webdeveloper.color.feature.tooltip.background").color = preferencesService.getComplexValue("webdeveloper.color.feature.tooltip.background", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the feature tooltip opacity is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.feature.tooltip.opacity"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.opacity").value = webdeveloper_optionsDataString["webdeveloper.feature.tooltip.opacity"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.feature.tooltip.opacity"))
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.opacity").value = preferencesService.getComplexValue("webdeveloper.feature.tooltip.opacity", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the class text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.class.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.class.text").color = webdeveloper_optionsDataString["webdeveloper.color.class.text"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.class.text"))
    {
        pageDocument.getElementById("webdeveloper.color.class.text").color = preferencesService.getComplexValue("webdeveloper.color.class.text", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the class background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.class.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.class.background").color = webdeveloper_optionsDataString["webdeveloper.color.class.background"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.class.background"))
    {
        pageDocument.getElementById("webdeveloper.color.class.background").color = preferencesService.getComplexValue("webdeveloper.color.class.background", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the ID text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.id.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.id.text").color = webdeveloper_optionsDataString["webdeveloper.color.id.text"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.id.text"))
    {
        pageDocument.getElementById("webdeveloper.color.id.text").color = preferencesService.getComplexValue("webdeveloper.color.id.text", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the ID background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.id.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.id.background").color = webdeveloper_optionsDataString["webdeveloper.color.id.background"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.id.background"))
    {
        pageDocument.getElementById("webdeveloper.color.id.background").color = preferencesService.getComplexValue("webdeveloper.color.id.background", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the ID and class text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.id.class.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.id.class.text").color = webdeveloper_optionsDataString["webdeveloper.color.id.class.text"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.id.class.text"))
    {
        pageDocument.getElementById("webdeveloper.color.id.class.text").color = preferencesService.getComplexValue("webdeveloper.color.id.class.text", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the ID and class background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.id.class.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.id.class.background").color = webdeveloper_optionsDataString["webdeveloper.color.id.class.background"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.id.class.background"))
    {
        pageDocument.getElementById("webdeveloper.color.id.class.background").color = preferencesService.getComplexValue("webdeveloper.color.id.class.background", Components.interfaces.nsISupportsString).data.trim();
    }
}

// Initializes the forms page
function webdeveloper_initializeForms()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the populate form fields email preference is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.populate.form.fields.email"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.populate.form.fields.email").value = webdeveloper_optionsDataString["webdeveloper.populate.form.fields.email"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.populate.form.fields.email"))
    {
        pageDocument.getElementById("webdeveloper.populate.form.fields.email").value = preferencesService.getComplexValue("webdeveloper.populate.form.fields.email", Components.interfaces.nsISupportsString).data.trim();
    }
}

// Initializes the general page
function webdeveloper_initializeGeneral()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the hide menu preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.menu.hide"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.menu.hide").checked = webdeveloper_optionsDataBoolean["webdeveloper.menu.hide"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.menu.hide"))
    {
        pageDocument.getElementById("webdeveloper.menu.hide").checked = preferencesService.getBoolPref("webdeveloper.menu.hide");
    }
    else
    {
        pageDocument.getElementById("webdeveloper.menu.hide").checked = false;
    }

    // If the hide context menu preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.context.hide"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.context.hide").checked = webdeveloper_optionsDataBoolean["webdeveloper.context.hide"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.context.hide"))
    {
        pageDocument.getElementById("webdeveloper.context.hide").checked = preferencesService.getBoolPref("webdeveloper.context.hide");
    }
    else
    {
        pageDocument.getElementById("webdeveloper.context.hide").checked = false;
    }

    // If the show outlined element names preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.outline.show.element.names"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.outline.show.element.names").checked = webdeveloper_optionsDataBoolean["webdeveloper.outline.show.element.names"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.outline.show.element.names"))
    {
        pageDocument.getElementById("webdeveloper.outline.show.element.names").checked = preferencesService.getBoolPref("webdeveloper.outline.show.element.names");
    }
    else
    {
        pageDocument.getElementById("webdeveloper.outline.show.element.names").checked = false;
    }

    // If the toolbar icons preference is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.toolbar.icons"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.toolbar.icons").value = webdeveloper_optionsDataString["webdeveloper.toolbar.icons"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons"))
    {
        pageDocument.getElementById("webdeveloper.toolbar.icons").value = preferencesService.getComplexValue("webdeveloper.toolbar.icons", Components.interfaces.nsISupportsString).data.trim();
    }
    else
    {
        pageDocument.getElementById("webdeveloper.toolbar.icons").selectedIndex = 0;
    }

    // If the open tabs preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.tabs"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.tabs").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.tabs"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.open.tabs"))
    {
        pageDocument.getElementById("webdeveloper.open.tabs").checked = preferencesService.getBoolPref("webdeveloper.open.tabs");
    }

    // If the open tabs background preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.tabs.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.tabs.background").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.tabs.background"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.open.tabs.background"))
    {
        pageDocument.getElementById("webdeveloper.open.tabs.background").checked = preferencesService.getBoolPref("webdeveloper.open.tabs.background");
    }
    else
    {
        pageDocument.getElementById("webdeveloper.open.tabs.background").checked = false;
    }

    // If the view source in tab preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.view.source.tab"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.view.source.tab").checked = webdeveloper_optionsDataBoolean["webdeveloper.view.source.tab"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.view.source.tab"))
    {
        pageDocument.getElementById("webdeveloper.view.source.tab").checked = preferencesService.getBoolPref("webdeveloper.view.source.tab");
    }
    else
    {
        pageDocument.getElementById("webdeveloper.view.source.tab").checked = false;
    }

    pageDocument.getElementById("webdeveloper.open.tabs.background").disabled = !pageDocument.getElementById("webdeveloper.open.tabs").checked;
}

// Initializes the JavaScript page
function webdeveloper_initializeJavaScript()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the JavaScript options strict preference is set
    if(typeof webdeveloper_optionsDataBoolean["javascript.options.strict"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.javascript.options.strict").checked = webdeveloper_optionsDataBoolean["javascript.options.strict"];
    }
    else if(preferencesService.prefHasUserValue("javascript.options.strict"))
    {
        pageDocument.getElementById("webdeveloper.javascript.options.strict").checked = preferencesService.getBoolPref("javascript.options.strict");
    }
    else
    {
        pageDocument.getElementById("webdeveloper.javascript.options.strict").checked = false;
    }

    // If the open JavaScript console warning preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.warning"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.warning").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.warning"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.open.javascript.console.warning"))
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.warning").checked = preferencesService.getBoolPref("webdeveloper.open.javascript.console.warning");
    }
    else
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.warning").checked = false;
    }

    // If the open JavaScript console error preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.error"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.error").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.error"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.open.javascript.console.error"))
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.error").checked = preferencesService.getBoolPref("webdeveloper.open.javascript.console.error");
    }
    else
    {
        pageDocument.getElementById("webdeveloper.open.javascript.console.error").checked = false;
    }
}

// Initializes the keys page
function webdeveloper_initializeKeys()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var mainDocument = null;

    // If there is a parent window
    if(window.opener)
    {
        // If there is a grand parent window
        if(window.opener.opener)
        {
            mainDocument = window.opener.opener.document;
        }
        else
        {
            mainDocument = window.opener.document;
        }
    }
    else
    {
        mainDocument = document;
    }

    // If a main document was found
    if(mainDocument)
    {
        const rows         = pageDocument.getElementById("webdeveloper-key-rows");
        const stringBundle = document.getElementById("webdeveloper-string-bundle");

        var description = null;
        var hbox        = null;
        var id          = null;
        var label       = null;
        var key         = null;
        var keys        = null;
        var keySet      = mainDocument.getElementById("mainKeyset");
        var row         = null;
        var spacer      = null;
        var textbox     = null;

        // If the key set was not found
        if(!keySet)
        {
            keySet = mainDocument.getElementById("navKeys");
        }

        // If the key set was found
        if(keySet)
        {
            keys = keySet.childNodes;

            // Loop through the keys
            for(var i = 0; i < keys.length; i++)
            {
                key = keys.item(i);

                // If the key has and id attribute starting with webdeveloper-
                if(key.hasAttribute("id") && key.getAttribute("id").indexOf("webdeveloper-") == 0)
                {
                    description = pageDocument.createElement("description");
                    hbox        = pageDocument.createElement("hbox");
                    id          = key.getAttribute("id").split("-").join(".");
                    label       = pageDocument.createElement("label");
                    row         = pageDocument.createElement("row");
                    spacer      = pageDocument.createElement("spacer");
                    textbox     = pageDocument.createElement("textbox");

                    label.setAttribute("value", key.getAttribute("label"));
                    label.setAttribute("control", id);
                    row.appendChild(label);

                    spacer.setAttribute("class", "small-spacer");
                    row.appendChild(spacer);

                    description.setAttribute("value", stringBundle.getString("webdeveloper_keyboardShortcutsModifier"));
                    hbox.appendChild(description);

                    // If the option is defined
                    if(typeof webdeveloper_optionsDataString[id] != "undefined")
                    {
                        textbox.setAttribute("value", webdeveloper_optionsDataString[id].trim());
                    }
                    else if(preferencesService.prefHasUserValue(id))
                    {
                        textbox.setAttribute("value", preferencesService.getComplexValue(id, Components.interfaces.nsISupportsString).data.trim());
                    }

                    textbox.setAttribute("id", id);
                    textbox.setAttribute("size", "1");
                    textbox.setAttribute("maxlength", "1");
                    hbox.appendChild(textbox);

                    hbox.setAttribute("align", "center");
                    row.appendChild(hbox);

                    row.setAttribute("align", "center");
                    rows.appendChild(row);
                }
            }
        }
    }
}

// Initializes the options dialog
function webdeveloper_initializeOptions()
{
    const selectedPage = document.getElementById("webdeveloper-page-list").selectedItem.value;

    // If this is the general page
    if(selectedPage.indexOf("general") != -1)
    {
        webdeveloper_initializeGeneral();
    }
    else if(selectedPage.indexOf("colors") != -1)
    {
        webdeveloper_initializeColors();
    }
    else if(selectedPage.indexOf("forms") != -1)
    {
        webdeveloper_initializeForms();
    }
    else if(selectedPage.indexOf("javascript") != -1)
    {
        webdeveloper_initializeJavaScript();
    }
    else if(selectedPage.indexOf("keys") != -1)
    {
        webdeveloper_initializeKeys();
    }
    else if(selectedPage.indexOf("resize") != -1)
    {
        webdeveloper_initializeResize();
    }
    else if(selectedPage.indexOf("sidebar") != -1)
    {
        webdeveloper_initializeSidebar();
    }
    else if(selectedPage.indexOf("tidied_html") != -1)
    {
        webdeveloper_initializeTidiedHTML();
    }
    else if(selectedPage.indexOf("tools") != -1)
    {
        webdeveloper_initializeTools();
    }
}

// Initializes the resize page
function webdeveloper_initializeResize()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const resizeBox          = pageDocument.getElementById("webdeveloper-listbox");

    var description      = null;
    var descriptionValue = null;
    var height           = null;
    var heightValue      = null;
    var listCell         = null;
    var listItem         = null;
    var resizeCount      = 0;
    var width            = null;
    var widthValue       = null;

    // If the resize count preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.resize.count"] != "undefined")
    {
        resizeCount = webdeveloper_optionsDataInteger["webdeveloper.resize.count"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.resize.count"))
    {
        resizeCount = preferencesService.getIntPref("webdeveloper.resize.count");
    }

    // Loop through the possible resize options
    for(var i = 1; i <= resizeCount; i++)
    {
	    description = "webdeveloper.resize." + i + ".description";
	    height      = "webdeveloper.resize." + i + ".height";
	    width       = "webdeveloper.resize." + i + ".width";

        // If the description is set
        if(typeof webdeveloper_optionsDataString[description] != "undefined")
        {
            descriptionValue = webdeveloper_optionsDataString[description].trim();
        }
        else if(preferencesService.prefHasUserValue(description))
        {
	        descriptionValue = preferencesService.getComplexValue(description, Components.interfaces.nsISupportsString).data.trim();
        }
        else
        {
            descriptionValue = null;
        }

        // If the width is set
        if(typeof webdeveloper_optionsDataInteger[width] != "undefined")
        {
            widthValue = webdeveloper_optionsDataInteger[width];
        }
        else if(preferencesService.prefHasUserValue(width))
        {
            widthValue = preferencesService.getIntPref(width);
        }
        else
        {
            widthValue = null;
        }

        // If the height is set
        if(typeof webdeveloper_optionsDataInteger[height] != "undefined")
        {
            heightValue = webdeveloper_optionsDataInteger[height];
        }
        else if(preferencesService.prefHasUserValue(height))
        {
            heightValue = preferencesService.getIntPref(height);
        }
        else
        {
            heightValue = null;
        }

        // If the description, width and height are set
        if(descriptionValue && widthValue && heightValue)
        {
            listItem = pageDocument.createElement("listitem");

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", descriptionValue);
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", widthValue);
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", heightValue);
            listItem.appendChild(listCell);

            resizeBox.appendChild(listItem);
        }
    }
}

// Initializes the sidebar page
function webdeveloper_initializeSidebar()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the edit CSS font preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.edit.css.font"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.css.font").value = webdeveloper_optionsDataInteger["webdeveloper.edit.css.font"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.edit.css.font"))
    {
        pageDocument.getElementById("webdeveloper.edit.css.font").value = preferencesService.getIntPref("webdeveloper.edit.css.font");
    }

    // If the edit CSS wrap preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.edit.css.wrap"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.css.wrap").checked = webdeveloper_optionsDataBoolean["webdeveloper.edit.css.wrap"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.edit.css.wrap"))
    {
        pageDocument.getElementById("webdeveloper.edit.css.wrap").checked = preferencesService.getBoolPref("webdeveloper.edit.css.wrap");
    }

    // If the edit CSS text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.edit.css.color.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.css.color.text").color = webdeveloper_optionsDataString["webdeveloper.edit.css.color.text"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.edit.css.color.text"))
    {
        pageDocument.getElementById("webdeveloper.edit.css.color.text").color = preferencesService.getComplexValue("webdeveloper.edit.css.color.text", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the edit CSS background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.edit.css.color.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.css.color.background").color = webdeveloper_optionsDataString["webdeveloper.edit.css.color.background"].trim();
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.edit.css.color.background"))
    {
        pageDocument.getElementById("webdeveloper.edit.css.color.background").color = preferencesService.getComplexValue("webdeveloper.edit.css.color.background", Components.interfaces.nsISupportsString).data.trim();
    }

    // If the edit CSS update frequency preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.edit.css.update.frequency"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.css.update.frequency").value = webdeveloper_optionsDataInteger["webdeveloper.edit.css.update.frequency"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.edit.css.update.frequency"))
    {
        pageDocument.getElementById("webdeveloper.edit.css.update.frequency").value = preferencesService.getIntPref("webdeveloper.edit.css.update.frequency");
    }

    // If the view style information sidebar preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.view.style.information.sidebar"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.view.style.information.sidebar").checked = webdeveloper_optionsDataBoolean["webdeveloper.view.style.information.sidebar"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.view.style.information.sidebar"))
    {
        pageDocument.getElementById("webdeveloper.view.style.information.sidebar").checked = preferencesService.getBoolPref("webdeveloper.view.style.information.sidebar");
    }
}

// Initializes the tidied HTML page
function webdeveloper_initializeTidiedHTML()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the close <br> preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.tidied.html.close.br"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.tidied.html.close.br").checked = webdeveloper_optionsDataBoolean["webdeveloper.tidied.html.close.br"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.tidied.html.close.br"))
    {
        pageDocument.getElementById("webdeveloper.tidied.html.close.br").checked = preferencesService.getBoolPref("webdeveloper.tidied.html.close.br");
    }

    // If the escape ampersand preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.tidied.html.escape.ampersand"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.tidied.html.escape.ampersand").checked = webdeveloper_optionsDataBoolean["webdeveloper.tidied.html.escape.ampersand"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.tidied.html.escape.ampersand"))
    {
        pageDocument.getElementById("webdeveloper.tidied.html.escape.ampersand").checked = preferencesService.getBoolPref("webdeveloper.tidied.html.escape.ampersand");
    }
}

// Initializes the tools page
function webdeveloper_initializeTools()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const toolBox            = pageDocument.getElementById("webdeveloper-listbox");

    var description      = null;
    var descriptionValue = null;
    var key              = null;
    var keyValue         = null;
    var listCell         = null;
    var listItem         = null;
    var toolCount        = 0;
    var url              = null;
    var urlValue         = null;

    // If the tool count preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.tool.count"] != "undefined")
    {
        toolCount = webdeveloper_optionsDataInteger["webdeveloper.tool.count"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.tool.count"))
    {
        toolCount = preferencesService.getIntPref("webdeveloper.tool.count");
    }

    // Loop through the possible tools
    for(var i = 1; i <= toolCount; i++)
    {
	    description = "webdeveloper.tool." + i + ".description";
	    key         = "webdeveloper.tool." + i + ".key";
	    url         = "webdeveloper.tool." + i + ".url";

        // If the description is set
        if(typeof webdeveloper_optionsDataString[description] != "undefined")
        {
            descriptionValue = webdeveloper_optionsDataString[description].trim();
        }
        else if(preferencesService.prefHasUserValue(description))
        {
	        descriptionValue = preferencesService.getComplexValue(description, Components.interfaces.nsISupportsString).data.trim();
        }
        else
        {
            descriptionValue = null;
        }

        // If the key is set
        if(typeof webdeveloper_optionsDataString[key] != "undefined")
        {
            keyValue = webdeveloper_optionsDataString[key].trim();
        }
        else if(preferencesService.prefHasUserValue(key))
        {
            keyValue = preferencesService.getComplexValue(key, Components.interfaces.nsISupportsString).data.trim();
        }
        else
        {
            keyValue = null;
        }

        // If the URL is set
        if(typeof webdeveloper_optionsDataString[url] != "undefined")
        {
            urlValue = webdeveloper_optionsDataString[url].trim();
        }
        else if(preferencesService.prefHasUserValue(url))
        {
            urlValue = preferencesService.getComplexValue(url, Components.interfaces.nsISupportsString).data.trim();
        }
        else
        {
            urlValue = null;
        }

        // If the description and URL are set
        if(descriptionValue && urlValue)
        {
            listItem = pageDocument.createElement("listitem");

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", descriptionValue);
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");
            listCell.setAttribute("label", urlValue);
            listCell.setAttribute("crop", "end");
            listItem.appendChild(listCell);

            listCell = pageDocument.createElement("listcell");

            // If the key is set
            if(keyValue)
            {
                listCell.setAttribute("label", keyValue);
            }

            listItem.appendChild(listCell);

            toolBox.appendChild(listItem);
       }
    }
}

// Moves the selected item down
function webdeveloper_moveDown()
{
    const pageDocument  = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const resizeBox     = pageDocument.getElementById("webdeveloper-listbox");
    const resizeCount   = resizeBox.getRowCount();
    const selectedIndex = resizeBox.selectedIndex;
    const selectedItem  = resizeBox.selectedItem;

    // If an item is selected and it is not at the bottom
    if(selectedItem && selectedIndex != resizeCount - 1)
    {
        resizeBox.selectItem(resizeBox.insertBefore(selectedItem, resizeBox.getNextItem(selectedItem, 2)));
    }
}

// Moves the selected item up
function webdeveloper_moveUp()
{
    const pageDocument  = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const resizeBox     = pageDocument.getElementById("webdeveloper-listbox");
    const selectedIndex = resizeBox.selectedIndex;
    const selectedItem  = resizeBox.selectedItem;

    // If an item is selected and it is not at the top
    if(selectedItem && selectedIndex != 0)
    {
        resizeBox.selectItem(resizeBox.insertBefore(selectedItem, resizeBox.getPreviousItem(selectedItem, 1)));
    }
}

// Resets the user's options
function webdeveloper_resetOptions()
{
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the reset is confirmed
    if(confirm(stringBundle.getString("webdeveloper_resetConfirmation")))
    {
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

        webdeveloper_localizedOptionsSetup = false;
        webdeveloper_optionsDataBoolean    = new Array();
        webdeveloper_optionsDataInteger    = new Array();
        webdeveloper_optionsDataString     = new Array();

        preferencesService.deleteBranch("webdeveloper.");

        webdeveloper_configureKeyboardShortcuts(true);
        webdeveloper_setupDefaultOptions();
        webdeveloper_setupLocalizedOptions();
        webdeveloper_initializeOptions();
    }
}

// Saves the user's options
function webdeveloper_saveOptions()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const string             = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);

    var parentWindow = null;
    var option       = null;
    var optionValue  = null;

    // Make sure current page is stored
    webdeveloper_storeOptions();

    // Loop through the boolean options
    for(option in webdeveloper_optionsDataBoolean)
    {
        preferencesService.setBoolPref(option, webdeveloper_optionsDataBoolean[option]);
    }

    // Loop through the integer options
    for(option in webdeveloper_optionsDataInteger)
    {
        optionValue = webdeveloper_optionsDataInteger[option];

        // If the option value is set
        if(optionValue)
        {
            preferencesService.setIntPref(option, optionValue);
        }
        else if(preferencesService.prefHasUserValue(option))
        {
            preferencesService.clearUserPref(option);
        }
    }

    // Loop through the string options
    for(option in webdeveloper_optionsDataString)
    {
        optionValue = webdeveloper_optionsDataString[option];

        // If the option value is set or the preference currently has a value
        if(optionValue || preferencesService.prefHasUserValue(option))
        {
            string.data = optionValue;

            preferencesService.setComplexValue(option, Components.interfaces.nsISupportsString, string);
        }
    }
}

// Stores the user's options to be saved later
function webdeveloper_storeOptions()
{
    const iFrame             = document.getElementById("webdeveloper-options-iframe");
    const iFrameSrc          = iFrame.getAttribute("src");
    const pageDocument       = iFrame.contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var childNodes  = null;
    var description = null;
    var i           = 0;
    var listItem    = null;

    // If this is the colors page
    if(iFrameSrc.indexOf("colors") != -1)
    {
        webdeveloper_optionsDataString["webdeveloper.color.class.background"]           = pageDocument.getElementById("webdeveloper.color.class.background").color;
        webdeveloper_optionsDataString["webdeveloper.color.class.text"]                 = pageDocument.getElementById("webdeveloper.color.class.text").color;
        webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.background"] = pageDocument.getElementById("webdeveloper.color.feature.tooltip.background").color;
        webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.text"]       = pageDocument.getElementById("webdeveloper.color.feature.tooltip.text").color;
        webdeveloper_optionsDataString["webdeveloper.color.id.background"]              = pageDocument.getElementById("webdeveloper.color.id.background").color;
        webdeveloper_optionsDataString["webdeveloper.color.id.class.background"]        = pageDocument.getElementById("webdeveloper.color.id.class.background").color;
        webdeveloper_optionsDataString["webdeveloper.color.id.class.text"]              = pageDocument.getElementById("webdeveloper.color.id.class.text").color;
        webdeveloper_optionsDataString["webdeveloper.color.id.text"]                    = pageDocument.getElementById("webdeveloper.color.id.text").color;
        webdeveloper_optionsDataString["webdeveloper.feature.tooltip.opacity"]          = pageDocument.getElementById("webdeveloper.feature.tooltip.opacity").value;
    }
    else if(iFrameSrc.indexOf("forms") != -1)
    {
        webdeveloper_optionsDataString["webdeveloper.populate.form.fields.email"] = pageDocument.getElementById("webdeveloper.populate.form.fields.email").value;
    }
    else if(iFrameSrc.indexOf("general") != -1)
    {
        webdeveloper_optionsDataBoolean["webdeveloper.context.hide"]               = pageDocument.getElementById("webdeveloper.context.hide").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.menu.hide"]                  = pageDocument.getElementById("webdeveloper.menu.hide").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.open.tabs"]                  = pageDocument.getElementById("webdeveloper.open.tabs").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.open.tabs.background"]       = pageDocument.getElementById("webdeveloper.open.tabs.background").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.outline.show.element.names"] = pageDocument.getElementById("webdeveloper.outline.show.element.names").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.view.source.tab"]            = pageDocument.getElementById("webdeveloper.view.source.tab").checked;
        webdeveloper_optionsDataString["webdeveloper.toolbar.icons"]               = pageDocument.getElementById("webdeveloper.toolbar.icons").value;
    }
    else if(iFrameSrc.indexOf("javascript") != -1)
    {
        webdeveloper_optionsDataBoolean["javascript.options.strict"]                    = pageDocument.getElementById("webdeveloper.javascript.options.strict").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.warning"] = pageDocument.getElementById("webdeveloper.open.javascript.console.warning").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.open.javascript.console.error"]   = pageDocument.getElementById("webdeveloper.open.javascript.console.error").checked;
    }
    else if(iFrameSrc.indexOf("keys") != -1)
    {
        const textBoxes = pageDocument.getElementById("webdeveloper-key-rows").getElementsByTagName("textbox");

        var textbox = null;

        // Loop through the text boxes
        for(i = 0; i < textBoxes.length; i++)
        {
            textbox = textBoxes.item(i);

            webdeveloper_optionsDataString[textbox.getAttribute("id")] = textbox.value.trim();
        }
    }
    else if(iFrameSrc.indexOf("resize") != -1)
    {
        const resizeBox = pageDocument.getElementById("webdeveloper-listbox");

        var height      = null;
        var resizeCount = 0;
        var width       = null;

        // If the resize count preference is set
        if(preferencesService.prefHasUserValue("webdeveloper.resize.count"))
        {
            resizeCount = preferencesService.getIntPref("webdeveloper.resize.count");
        }

        // Loop through the previous resize options
        for(i = 1; i <= resizeCount; i++)
        {
            description = "webdeveloper.resize." + i + ".description";
            height      = "webdeveloper.resize." + i + ".height";
            width       = "webdeveloper.resize." + i + ".width";

            webdeveloper_optionsDataInteger[height]     = "";
            webdeveloper_optionsDataInteger[width]      = "";
            webdeveloper_optionsDataString[description] = "";
        }

        resizeCount = resizeBox.getRowCount();

        // Loop through the possible resize options
        for(i = 1; i <= resizeCount; i++)
        {
            description = "webdeveloper.resize." + i + ".description";
            height      = "webdeveloper.resize." + i + ".height";
            listItem    = resizeBox.getItemAtIndex(i - 1);
            childNodes  = listItem.childNodes;
            width       = "webdeveloper.resize." + i + ".width";

            webdeveloper_optionsDataInteger[width]      = listItem.childNodes[1].getAttribute("label");
            webdeveloper_optionsDataInteger[height]     = listItem.childNodes[2].getAttribute("label");
            webdeveloper_optionsDataString[description] = listItem.childNodes[0].getAttribute("label").trim();
        }

        webdeveloper_optionsDataInteger["webdeveloper.resize.count"] = resizeCount;
    }
    else if(iFrameSrc.indexOf("sidebar") != -1)
    {
        var updateFrequency = pageDocument.getElementById("webdeveloper.edit.css.update.frequency").value;

        webdeveloper_optionsDataBoolean["webdeveloper.edit.css.wrap"]                  = pageDocument.getElementById("webdeveloper.edit.css.wrap").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.view.style.information.sidebar"] = pageDocument.getElementById("webdeveloper.view.style.information.sidebar").checked;
        webdeveloper_optionsDataInteger["webdeveloper.edit.css.font"]                  = pageDocument.getElementById("webdeveloper.edit.css.font").value;
        webdeveloper_optionsDataString["webdeveloper.edit.css.color.background"]       = pageDocument.getElementById("webdeveloper.edit.css.color.background").color;
        webdeveloper_optionsDataString["webdeveloper.edit.css.color.text"]             = pageDocument.getElementById("webdeveloper.edit.css.color.text").color;

        // If the update frequency is set and is a valid integer and is positive
        if(updateFrequency && parseInt(updateFrequency) == updateFrequency && updateFrequency >= 0)
        {
            webdeveloper_optionsDataInteger["webdeveloper.edit.css.update.frequency"] = updateFrequency;
        }
        else
        {
            webdeveloper_optionsDataInteger["webdeveloper.edit.css.update.frequency"] = 0;
        }
    }
    else if(iFrameSrc.indexOf("tidied_html") != -1)
    {
        webdeveloper_optionsDataBoolean["webdeveloper.tidied.html.close.br"]         = pageDocument.getElementById("webdeveloper.tidied.html.close.br").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.tidied.html.escape.ampersand"] = pageDocument.getElementById("webdeveloper.tidied.html.escape.ampersand").checked;
    }
    else if(iFrameSrc.indexOf("tools") != -1)
    {
        const toolBox = pageDocument.getElementById("webdeveloper-listbox");

        var key       = null;
        var toolCount = 0;
        var url       = null;

        // If the tool count preference is set
        if(preferencesService.prefHasUserValue("webdeveloper.tool.count"))
        {
            toolCount = preferencesService.getIntPref("webdeveloper.tool.count");
        }

        // Loop through the previous tools
        for(i = 1; i <= toolCount; i++)
        {
            description = "webdeveloper.tool." + i + ".description";
            key         = "webdeveloper.tool." + i + ".key";
            url         = "webdeveloper.tool." + i + ".url";

            webdeveloper_optionsDataString[description] = "";
            webdeveloper_optionsDataString[key]         = "";
            webdeveloper_optionsDataString[url]         = "";
        }

        toolCount = toolBox.getRowCount();

        // Loop through the possible tools
        for(i = 1; i <= toolCount; i++)
        {
            description = "webdeveloper.tool." + i + ".description";
            listItem    = toolBox.getItemAtIndex(i - 1);
            childNodes  = listItem.childNodes;
            key         = "webdeveloper.tool." + i + ".key";
            url         = "webdeveloper.tool." + i + ".url";

            webdeveloper_optionsDataString[description] = listItem.childNodes[0].getAttribute("label").trim();
            webdeveloper_optionsDataString[key]         = listItem.childNodes[2].getAttribute("label").trim();
            webdeveloper_optionsDataString[url]         = listItem.childNodes[1].getAttribute("label").trim();
        }

        webdeveloper_optionsDataInteger["webdeveloper.tool.count"] = toolCount;
    }
}

// Updates the tab option status
function webdeveloper_updateTabOptionStatus()
{
    const pageDocument = document.getElementById("webdeveloper-options-iframe").contentDocument;

    var disabled = false;

    // If open tabs is checked
    if(pageDocument.getElementById("webdeveloper.open.tabs").checked)
    {
        disabled = true;
    }

    pageDocument.getElementById("webdeveloper.open.tabs.background").disabled = disabled;
}