// Clears the tool
function webdeveloper_clearTool()
{
    window.opener.webdeveloper_toolDescription = null;
    window.opener.webdeveloper_toolKey         = null;
    window.opener.webdeveloper_toolURL         = null;
}

// Initializes the tool dialog box
function webdeveloper_initializeTool()
{
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the first argument equals add
    if(window.arguments[0] == "add")
    {
        title = stringBundle.getString("webdeveloper_addToolTitle");
    }
    else
    {
        title = stringBundle.getString("webdeveloper_editToolTitle");

        document.getElementById("webdeveloper.tool.description").value = window.arguments[1];
        document.getElementById("webdeveloper.tool.key").value         = window.arguments[3];
        document.getElementById("webdeveloper.tool.url").value         = window.arguments[2];
    }
}

// Saves the tool
function webdeveloper_saveTool()
{
    const description  = document.getElementById("webdeveloper.tool.description").value.trim();
    const key          = document.getElementById("webdeveloper.tool.key").value.trim();
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const url          = document.getElementById("webdeveloper.tool.url").value.trim();

    var errors = "";

    // If the description is empty
    if(!description)
    {
        errors += stringBundle.getString("webdeveloper_emptyDescription") + "\n";
    }

    // If the URL is empty
    if(!url)
    {
        errors += stringBundle.getString("webdeveloper_emptyURL") + "\n";
    }

    // If there are errors
    if(errors)
    {
        alert(errors.trim());

        return false;
    }
    else
    {
        window.opener.webdeveloper_toolDescription = description;
        window.opener.webdeveloper_toolKey         = key;
        window.opener.webdeveloper_toolURL         = url;

        return true;
    }
}
