// Clears the cache
function webdeveloper_clearCache()
{
    const cacheService = Components.classes["@mozilla.org/network/cache-service;1"].getService(Components.interfaces.nsICacheService);
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    cacheService.evictEntries(Components.interfaces.nsICache.STORE_ON_DISK);
    cacheService.evictEntries(Components.interfaces.nsICache.STORE_IN_MEMORY);

    alert(stringBundle.getString("webdeveloper_clearCacheResult"));
}

// Clears the history
function webdeveloper_clearHistory()
{
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    Components.classes["@mozilla.org/browser/global-history;2"].getService(Components.interfaces.nsIBrowserHistory).removeAllPages();

    alert(stringBundle.getString("webdeveloper_clearHistoryResult"));
}

// Clears the HTTP authentication
function webdeveloper_clearHTTPAuthentication()
{
    const authenticationManager = Components.classes["@mozilla.org/network/http-auth-manager;1"].getService(Components.interfaces.nsIHttpAuthManager);
    const stringBundle          = document.getElementById("webdeveloper-string-bundle");

    authenticationManager.clearAll();

    alert(stringBundle.getString("webdeveloper_clearHTTPAuthenticationResult"));
}

// Clears all session cookies
function webdeveloper_clearSessionCookies()
{
    const cookieManager = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
    const cookies       = cookieManager.enumerator;
    const stringBundle  = document.getElementById("webdeveloper-string-bundle");

    var removed = 0;

    // Loop through the cookies
    while(cookies.hasMoreElements())
    {
        var cookie = cookies.getNext();

        // If this is a cookie with no expiration
        if(cookie instanceof Components.interfaces.nsICookie && cookie.expires == "0")
        {
            cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
            removed++;
        }
    }

    // If one session cookie was removed
    if(removed == 1)
    {
        alert(stringBundle.getString("webdeveloper_clearSessionCookiesSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_clearSessionCookiesMultipleResult", [removed]));
    }
}

// Deletes all the cookies for the current domain
function webdeveloper_deleteDomainCookies()
{
    const cookieManager = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
    const mainTabBox    = getBrowser().mTabBox;
    const documentList  = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle  = document.getElementById("webdeveloper-string-bundle");

    var cookie        = null;
    var cookies       = new Array();
    var cookiesLength = null;
    var pageDocument  = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        cookies      = cookies.concat(webdeveloper_getCookies(pageDocument.location.hostname, false));
    }

    cookiesLength = cookies.length;

    // Loop through all the cookies
    for(i = 0 ; i < cookiesLength; i++)
    {
        cookie = cookies[i];

        cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
    }

    // If one cookie was found
    if(cookiesLength == 1)
    {
        alert(stringBundle.getString("webdeveloper_deleteDomainCookiesSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_deleteDomainCookiesMultipleResult", [cookiesLength]));
    }
}

// Linearizes all elements
function webdeveloper_linearizePage(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/linearize_page.css", "webdeveloper-linearize-page", applyStyle);
}

// Opens the Java Console
function webdeveloper_openJavaConsole()
{
    Components.classes["@mozilla.org/oji/jvm-mgr;1"].getService(Components.interfaces.nsIJVMManager).showJavaConsole();
}

// Toggles comments
function webdeveloper_toggleComments(element, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const show         = element.getAttribute("checked");

    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        webdeveloper_toggleCommentsForDocument(pageDocument, show);
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/show_comments.css", "webdeveloper-show-comments", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-show-comments-tooltips", "div.webdeveloper-comment-icon, div.webdeveloper-comment-text, div.webdeveloper-comment-text *");
}

// Toggles all links on the page between visited and unvisited
function webdeveloper_toggleVisitedLinks(visited)
{
    const globalHistory  = Components.classes["@mozilla.org/browser/global-history;1"].getService(Components.interfaces.nsIGlobalHistory);
    const mainTabBox     = getBrowser().mTabBox;
    const documentList   = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var browserHistory = null;
    var href           = null;
    var link           = null;
    var linkList       = null;
    var pageDocument   = null;

    // Try to get the new history component
    try
    {
        browserHistory = Components.classes["@mozilla.org/browser/global-history;2"].getService(Components.interfaces.nsIBrowserHistory);
    }
    catch(exception)
    {
        browserHistory = Components.classes["@mozilla.org/browser/global-history;1"].getService(Components.interfaces.nsIBrowserHistory);
    }

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        linkList     = pageDocument.getElementsByTagName("a");

        // Loop through all the links
        for(var j = 0; j < linkList.length; j++)
        {
            link = linkList[j];
            href = link.href;

            // If this link has an href
            if(href)
            {
                // If marking links as visited
                if(visited && !globalHistory.isVisited(href))
                {
                    globalHistory.addPage(href);
                }
                else if(globalHistory.isVisited(href))
                {
                    const uri = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);

                    uri.spec = href;

                    // Try to remove the page as a URI
                    try
                    {
                        browserHistory.removePage(uri);
                    }
                    catch(exception)
                    {
                        browserHistory.removePage(href);
                    }
                }

                // Force the browser to recheck the history by changing the href
                link.href = "";
                link.href = href;
            }
        }
    }
}

// Zooms the content
function webdeveloper_zoom(factor)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var image        = null;
    var imageList    = null;
    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        imageList    = pageDocument.getElementsByTagName("img");

        webdeveloper_zoomText(pageDocument.documentElement, factor);

        // Loop through the images
        for(var j = 0; j < imageList.length; j++)
        {
            image = imageList[j];

            image.setAttribute("width", parseInt(image.getAttribute("width") * factor));
            image.setAttribute("height", parseInt(image.getAttribute("height") * factor));
        }
    }
}

// Zooms the text
function webdeveloper_zoomText(node, factor)
{
    const childNodeList = node.childNodes;
    const lineHeight    = window.getComputedStyle(node, "").getPropertyValue("line-height");
    const textSize      = window.getComputedStyle(node, "").getPropertyValue("font-size");

    var childNode = null;

    // Loop through the child nodes
    for(var i = 0; i < childNodeList.length; i++)
    {
        childNode = childNodeList[i];

        // If this is an element
        if(childNode.nodeType == 1)
        {
            webdeveloper_zoomText(childNode, factor);
        }
    }

    node.style.fontSize = parseInt(textSize.substr(0, textSize.length - 2) * factor) + "px";

    // If the line height is not normal
    if(lineHeight != "normal")
    {
        node.style.lineHeight = parseInt(lineHeight.substr(0, lineHeight.length - 2) * factor) + "px";
    }
}
