// Displays all image dimensions
function webdeveloper_displayImageDimensions(element, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const heightText   = stringBundle.getString("webdeveloper_height");
    const widthText    = stringBundle.getString("webdeveloper_width");

    var dimensions       = null;
    var height           = null;
    var imageElement     = null;
    var imageElementList = null;
    var pageDocument     = null;
    var spanElement      = null;
    var spanElementList  = null;
    var width            = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageElementList = pageDocument.getElementsByTagName("img");
        spanElementList  = pageDocument.getElementsByTagName("span");

        // Loop through all the span tags
        for(var j = 0; j < spanElementList.length; j++)
        {
            spanElement = spanElementList[j];

            // If the class exists and is set to webdeveloper-dimensions-span
            if(spanElement.hasAttribute("class") && spanElement.getAttribute("class") == "webdeveloper-dimensions-span")
            {
                spanElement.parentNode.removeChild(spanElement);
                j--;
            }
        }

        // Loop through all the img tags
        for(j = 0; j < imageElementList.length; j++)
        {
            dimensions   = null;
            imageElement = imageElementList[j];
            height       = imageElement.getAttribute("height");
            width        = imageElement.getAttribute("width");

            // If the width and height are set
            if(width && height)
            {
                dimensions = width + "x" + height;
            }
            else if(width)
            {
                dimensions = widthText + "=" + width;
            }
            else if(height)
            {
                dimensions = heightText + "=" + height;
            }

            // If the element is checked and the dimensions are set
            if(element.getAttribute("checked") && dimensions)
            {
                spanElement = pageDocument.createElement("span");

                spanElement.setAttribute("class", "webdeveloper-dimensions-span");
                spanElement.appendChild(pageDocument.createTextNode(dimensions));
                imageElement.parentNode.insertBefore(spanElement, imageElement);
            }

            height = null;
            width  = null;
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_image_dimensions.css", "webdeveloper-display-image-dimensions", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-image-dimensions-tooltips", ".webdeveloper-dimensions-span");
}

// Displays all image file sizes
function webdeveloper_displayImageFileSizes(element, applyStyle)
{
    const fileProtocolHandler = Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler);
    const httpCacheSession    = Components.classes["@mozilla.org/network/cache-service;1"].getService(Components.interfaces.nsICacheService).createSession("HTTP", 0, true);
    const mainTabBox          = getBrowser().mTabBox;
    const documentList        = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle        = document.getElementById("webdeveloper-string-bundle");
    const fileSizeText        = stringBundle.getString("webdeveloper_fileSize");

    var file             = null;
    var fileSize         = null;
    var imageElement     = null;
    var imageElementList = null;
    var pageDocument     = null;
    var spanElement      = null;
    var spanElementList  = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageElementList = pageDocument.getElementsByTagName("img");
        spanElementList  = pageDocument.getElementsByTagName("span");

        // Loop through all the span tags
        for(var j = 0; j < spanElementList.length; j++)
        {
            spanElement = spanElementList[j];

            // If the class exists and is set to webdeveloper-file-sizes-span
            if(spanElement.hasAttribute("class") && spanElement.getAttribute("class") == "webdeveloper-file-sizes-span")
            {
                spanElement.parentNode.removeChild(spanElement);
                j--;
            }
        }

        // Loop through all the img tags
        for(j = 0; j < imageElementList.length; j++)
        {
            fileSize     = null;
            imageElement = imageElementList[j];

            // If the element is checked
            if(element.getAttribute("checked"))
            {
				// Try to get the file size
				try
				{
				    file = httpCacheSession.openCacheEntry(imageElement.src, Components.interfaces.nsICache.ACCESS_READ, false);

                    // If there is a file
                    if(file)
                    {
                        fileSize = file.dataSize;
                    }
				}
				catch(exception)
				{
                    try
                    {
                        file = fileProtocolHandler.getFileFromURLSpec(imageElement.src);

                        // If the file is set and it exists and is a file
                        if(file && file.exists() && file.isFile())
                        {
                            fileSize = file.fileSize;
                        }
                    }
                    catch(exceptionNested)
                    {
                        // Do nothing
                    }
				}

                // If there is a file size
                if(fileSize)
                {
                    spanElement = pageDocument.createElement("span");

                    spanElement.setAttribute("class", "webdeveloper-file-sizes-span");
                    spanElement.appendChild(pageDocument.createTextNode(fileSizeText + "=" + webdeveloper_formatFileSize(fileSize)));
                    imageElement.parentNode.insertBefore(spanElement, imageElement);
                }
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_image_file_sizes.css", "webdeveloper-display-image-file-sizes", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-image-file-sizes-tooltips", ".webdeveloper-file-sizes-span");
}

// Displays all image paths
function webdeveloper_displayImagePaths(element, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const srcText      = stringBundle.getString("webdeveloper_src");

    var imageElement     = null;
    var imageElementList = null;
    var pageDocument     = null;
    var spanElement      = null;
    var spanElementList  = null;
    var src              = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageElementList = pageDocument.getElementsByTagName("img");
        spanElementList  = pageDocument.getElementsByTagName("span");

        // Loop through all the span tags
        for(var j = 0; j < spanElementList.length; j++)
        {
            spanElement = spanElementList[j];

            // If the class exists and is set to webdeveloper-path-span
            if(spanElement.hasAttribute("class") && spanElement.getAttribute("class") == "webdeveloper-path-span")
            {
                spanElement.parentNode.removeChild(spanElement);
                j--;
            }
        }

        // Loop through all the img tags
        for(j = 0; j < imageElementList.length; j++)
        {
            imageElement = imageElementList[j];
            spanElement  = pageDocument.createElement("span");
            src          = imageElement.getAttribute("src");

            // If the element is checked and the src is set
            if(element.getAttribute("checked") && src)
            {
                spanElement.setAttribute("class", "webdeveloper-path-span");
                spanElement.appendChild(pageDocument.createTextNode(srcText + "=" + src));
                imageElement.parentNode.insertBefore(spanElement, imageElement);
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_image_paths.css", "webdeveloper-display-image-paths", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-image-paths-tooltips", ".webdeveloper-path-span");
}

// Finds all the broken images on the page
function webdeveloper_findBrokenImages()
{
    const mainTabBox         = getBrowser().mTabBox;
    const documentList       = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const oldTab             = getBrowser().selectedTab;
    const oldURL             = getBrowser().currentURI.spec;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const request            = new XMLHttpRequest();
    const stringBundle       = document.getElementById("webdeveloper-string-bundle");
    const title              = stringBundle.getFormattedString("webdeveloper_findBrokenImagesTitle", [oldURL]);

    var backgroundImage = null;
    var brokenURLs      = null;
    var documentURL     = null;
    var element         = null;
    var generatedPage   = null;
    var headerElement   = null;
    var image           = null;
    var imageList       = null;
    var linkElement     = null;
    var pageDocument    = null;
    var pElement        = null;
    var preElement      = null;

    generatedPage = webdeveloper_generatePage("");

    // This must be done to make generated content render
    request.open("get", "about:blank", false);
    request.send("");

    generatedPage.content.document.title = title;

    linkElement = generatedPage.content.document.createElement("link");
    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated_content.css");
    linkElement.setAttribute("media", "all");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    generatedPage.content.document.getElementsByTagName("head")[0].appendChild(linkElement);

    headerElement = generatedPage.content.document.createElement("h1");
    headerElement.appendChild(generatedPage.content.document.createTextNode(title));
    generatedPage.content.document.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        brokenURLs   = "";
        pageDocument = documentList[i];
        documentURL  = pageDocument.documentURI;
        imageList    = pageDocument.getElementsByTagName("img");

        headerElement = generatedPage.content.document.createElement("h2");
        linkElement   = generatedPage.content.document.createElement("a");
        linkElement.setAttribute("href", documentURL);
        linkElement.appendChild(generatedPage.content.document.createTextNode(documentURL));
        headerElement.appendChild(linkElement);
        generatedPage.content.document.body.appendChild(headerElement);

        // Loop through all the images
        for(var j = 0; j < imageList.length; j++)
        {
            image = imageList[j];

            // If the image is broken
            if(!image.naturalWidth)
            {
                brokenURLs += "\n" + image.src;
            }
        }

        const treeWalker = pageDocument.createTreeWalker(pageDocument.body, NodeFilter.SHOW_ELEMENT, null, false);

        // While the tree walker has more nodes
        while((element = treeWalker.nextNode()) != null)
        {
            backgroundImage = element.ownerDocument.defaultView.getComputedStyle(element, "").getPropertyCSSValue("background-image");

            // If this element has a background image and it is a URL
            if(backgroundImage && backgroundImage.primitiveType == CSSPrimitiveValue.CSS_URI)
            {
                image     = new Image();
                image.src = backgroundImage.getStringValue();

                // If the image is broken
                if(!image.naturalWidth)
                {
                    brokenURLs += "\n" + image.src;
                }
            }
        }

        // If there are no broken images
        if(brokenURLs == "")
        {
            pElement = generatedPage.content.document.createElement("p");
            pElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_noBrokenImages")));
            generatedPage.content.document.body.appendChild(pElement);
        }
        else
        {
            preElement = generatedPage.content.document.createElement("pre");
            preElement.appendChild(generatedPage.content.document.createTextNode(brokenURLs));
            generatedPage.content.document.body.appendChild(preElement);
        }
    }

    // If the open tabs in background preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.open.tabs.background") && preferencesService.getBoolPref("webdeveloper.open.tabs.background"))
    {
        getBrowser().selectedTab = oldTab;
    }
}

// Hides/shows all background images
function webdeveloper_hideBackgroundImages(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/hide_background_images.css", "webdeveloper-hide-background-images", applyStyle);
}

// Hides/shows all the images
function webdeveloper_hideImages(element, id, applyStyle)
{
    const hide         = element.getAttribute("checked");
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var inputElement     = null;
    var inputElementList = null;
    var pageDocument     = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        inputElementList = pageDocument.getElementsByTagName("input");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If hiding images and the element is an image
            if(hide && inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "image")
            {
                inputElement.setAttribute("type", "submit");

                // If the element has a class attribute
                if(inputElement.hasAttribute("class"))
                {
                    inputElement.setAttribute("class", inputElement.getAttribute("class") + " webdeveloper-image");
                }
                else
                {
                    inputElement.setAttribute("class", "webdeveloper-image");
                }
            }
            else if(inputElement.hasAttribute("class") && inputElement.getAttribute("class").indexOf("webdeveloper-image") != -1)
            {
                inputElement.setAttribute("type", "image");
                inputElement.setAttribute("class", webdeveloper_removeSubstring(inputElement.getAttribute("class"), "webdeveloper-image").trim());
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/hide_images.css", id, applyStyle);
}

// Makes all the images invisible
function webdeveloper_makeImagesInvisible(element, id, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const invisible    = element.getAttribute("checked");

    var image            = null;
    var imageList        = null;
    var inputElement     = null;
    var inputElementList = null;
    var pageDocument     = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageList        = pageDocument.getElementsByTagName("img");
        inputElementList = pageDocument.getElementsByTagName("input");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If making images invisible and the element is an image
            if(invisible && inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "image")
            {
                inputElement.setAttribute("type", "submit");

                // If the element has a class attribute
                if(inputElement.hasAttribute("class"))
                {
                    inputElement.setAttribute("class", inputElement.getAttribute("class") + " webdeveloper-image");
                }
                else
                {
                    inputElement.setAttribute("class", "webdeveloper-image");
                }
            }
            else if(inputElement.hasAttribute("class") && inputElement.getAttribute("class").indexOf("webdeveloper-image") != -1)
            {
                inputElement.setAttribute("type", "image");
                inputElement.setAttribute("class", webdeveloper_removeSubstring(inputElement.getAttribute("class"), "webdeveloper-image").trim());
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }

        // Loop through all the images
        for(j = 0; j < imageList.length; j++)
        {
            image = imageList[j];

            // If making images invisible
            if(invisible)
            {
                // If the image width is not set and the image is not broken
                if(!image.getAttribute("width") && image.naturalWidth)
                {
                    image.setAttribute("width", image.naturalWidth);
                }

                // If the image height is not set and the image is not broken
                if(!image.getAttribute("height") && image.naturalHeight)
                {
                    image.setAttribute("height", image.naturalHeight);
                }

                image.setAttribute("src", "chrome://webdeveloper/content/spacer.gif?" + image.getAttribute("src"));
            }
            else
            {
                image.setAttribute("src", webdeveloper_removeSubstring(image.getAttribute("src"), "chrome://webdeveloper/content/spacer.gif?"));
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/make_images_invisible.css", id, applyStyle);
}

// Outlines all the images with adjusted dimensions
function webdeveloper_outlineImagesWithAdjustedDimensions(element, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var imageElement     = null;
    var imageElementList = null;
    var naturalHeight    = null;
    var naturalWidth     = null;
    var pageDocument     = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageElementList = pageDocument.getElementsByTagName("img");

        // Loop through all the img tags
        for(var j = 0; j < imageElementList.length; j++)
        {
            imageElement  = imageElementList[j];
            naturalHeight = imageElement.naturalHeight;
            naturalWidth  = imageElement.naturalWidth;

            // If outlining
            if(element.getAttribute("checked"))
            {
                // If the width or height has been adjusted
                if((naturalWidth && imageElement.hasAttribute("width") && imageElement.getAttribute("width") != naturalWidth)
                    || (naturalHeight && imageElement.hasAttribute("height") && imageElement.getAttribute("height") != naturalHeight))
                {
                    // If the image has a class attribute
                    if(imageElement.hasAttribute("class"))
                    {
                        imageElement.setAttribute("class", imageElement.getAttribute("class") + " webdeveloper-adjusted-image");
                    }
                    else
                    {
                        imageElement.setAttribute("class", "webdeveloper-adjusted-image");
                    }
                }
            }
            else if(imageElement.hasAttribute("class") && imageElement.getAttribute("class").indexOf("webdeveloper-adjusted-image") != -1)
            {
                imageElement.setAttribute("class", webdeveloper_removeSubstring(imageElement.getAttribute("class"), "webdeveloper-adjusted-image").trim());
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_with_adjusted_dimensions.css", "webdeveloper-outline-images-with-adjusted-dimensions", applyStyle);
}

// Outlines all the images with empty alt attributes
function webdeveloper_outlineImagesWithEmptyAltAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_with_empty_alt_attributes.css", "webdeveloper-outline-images-with-empty-alt-attributes", applyStyle);
}

// Outlines all the images without alt attributes
function webdeveloper_outlineImagesWithoutAltAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_without_alt_attributes.css", "webdeveloper-outline-images-without-alt-attributes", applyStyle);
}

// Outlines all the images without dimensions
function webdeveloper_outlineImagesWithoutDimensions(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_without_dimensions.css", "webdeveloper-outline-images-without-dimensions", applyStyle);
}

// Outlines all the images without title attributes
function webdeveloper_outlineImagesWithoutTitleAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_without_title_attributes.css", "webdeveloper-outline-images-without-title-attributes", applyStyle);
}

// Replaces all images with their alt attributes
function webdeveloper_replaceImagesWithAltAttributes(element, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var altAttribute     = null;
    var imageElement     = null;
    var imageElementList = null;
    var pageDocument     = null;
    var previousElement  = null;
    var spanElement      = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageElementList = pageDocument.getElementsByTagName("img");

        // Loop through all the img tags
        for(var j = 0; j < imageElementList.length; j++)
        {
            imageElement    = imageElementList[j];
            altAttribute    = imageElement.getAttribute("alt");
            previousElement = imageElement.previousSibling;
            spanElement     = pageDocument.createElement("span");

            // If the previous element is an element with class webdeveloper-alt-span
            if(previousElement && previousElement.nodeType == 1 && previousElement.getAttribute("class") == "webdeveloper-alt-span")
            {
                previousElement.parentNode.removeChild(previousElement);
            }

            // If the element is checked and the alt attribute exists
            if(element.getAttribute("checked") && altAttribute)
            {
                spanElement.setAttribute("class", "webdeveloper-alt-span");
                spanElement.appendChild(pageDocument.createTextNode(altAttribute));
                imageElement.parentNode.insertBefore(spanElement, imageElement);
            }
        }
    }

    webdeveloper_hideImages(element, "webdeveloper-replace-images-with-alt-attributes", applyStyle);
}

// Sorts two images
function webdeveloper_sortImages(imageOne, imageTwo)
{
    const imageOneSrc = imageOne.src;
    const imageTwoSrc = imageTwo.src;

    var sortValue = 1;

    // If the images are equal
    if(imageOneSrc == imageTwoSrc)
    {
        sortValue = 0;
    }
    else if(imageOneSrc < imageTwoSrc)
    {
        sortValue = -1;
    }

    return sortValue;
}

// Tidies a list of images by removing duplicates and sorting
function webdeveloper_tidyImages(imageList)
{
    var image              = null;
    var imageSrc           = null;
    var newImageList       = new Array();
    var newImageListLength = null;
    var tidiedImageList    = new Array();

    // Loop through the images
    for(var i = 0; i < imageList.length; i++)
    {
        image    = imageList[i];
        imageSrc = image.src;

        // If the image src is set and does not end in '.xul' 
        if(imageSrc && !imageSrc.endsWith(".xul"))
        {
            newImageList.push(image);
        }
    }

    newImageList.sort(webdeveloper_sortImages);
    newImageListLength = newImageList.length;

    // Loop through the images
    for(i = 0; i < newImageListLength; i++)
    {
        image = newImageList[i];

        // If this is not the last image and the image is the same as the next image
        if(i + 1 < newImageListLength && image.src == newImageList[i + 1].src)
        {
            continue;
        }

        tidiedImageList.push(image);
    }

    return tidiedImageList;
}

// Displays all the images for the page
function webdeveloper_viewImageInformation()
{
    const fileProtocolHandler = Components.classes["@mozilla.org/network/protocol;1?name=file"].createInstance(Components.interfaces.nsIFileProtocolHandler);
    const httpCacheSession    = Components.classes["@mozilla.org/network/cache-service;1"].getService(Components.interfaces.nsICacheService).createSession("HTTP", 0, true);
    const mainTabBox          = getBrowser().mTabBox;
    const documentList        = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const oldTab              = getBrowser().selectedTab;
    const oldURL              = getBrowser().currentURI.spec;
    const preferencesService  = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const request             = new XMLHttpRequest();
    const stringBundle        = document.getElementById("webdeveloper-string-bundle");
    const title               = stringBundle.getFormattedString("webdeveloper_viewImageInformationTitle", [oldURL]);

    var backgroundImage   = null;
    var cellDataElement   = null;
    var cellHeaderElement = null;
    var documentImageList = null;
    var documentURL       = null;
    var element           = null;
    var file              = null;
    var fileSize          = null;
    var generatedPage     = null;
    var headerElement     = null;
    var image             = null;
    var imageElement      = null;
    var imageList         = new Array();
    var imageSrc          = null;
    var linkElement       = null;
    var pageDocument      = null;
    var pElement          = null;
    var tableElement      = null;
    var tableRowElement   = null;
    var treeWalker        = null;

    generatedPage = webdeveloper_generatePage("");

    // This must be done to make generated content render
    request.open("get", "about:blank", false);
    request.send("");

    generatedPage.content.document.title = title;

    linkElement = generatedPage.content.document.createElement("link");
    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated_content.css");
    linkElement.setAttribute("media", "all");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    generatedPage.content.document.getElementsByTagName("head")[0].appendChild(linkElement);

    headerElement = generatedPage.content.document.createElement("h1");
    headerElement.appendChild(generatedPage.content.document.createTextNode(title));
    generatedPage.content.document.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument      = documentList[i];
        documentImageList = pageDocument.getElementsByTagName("img");
        documentURL       = pageDocument.documentURI;
        imageList         = new Array();
        treeWalker        = pageDocument.createTreeWalker(pageDocument.body, NodeFilter.SHOW_ELEMENT, null, false);

        headerElement = generatedPage.content.document.createElement("h2");
        linkElement   = generatedPage.content.document.createElement("a");
        linkElement.setAttribute("href", documentURL);
        linkElement.appendChild(generatedPage.content.document.createTextNode(documentURL));
        headerElement.appendChild(linkElement);
        generatedPage.content.document.body.appendChild(headerElement);

        // Loop through the document images
        for(var j = 0; j < documentImageList.length; j++)
        {
            imageList.push(documentImageList[j]);
        }

        // While the tree walker has more nodes
        while((element = treeWalker.nextNode()) != null)
        {
            backgroundImage = element.ownerDocument.defaultView.getComputedStyle(element, "").getPropertyCSSValue("background-image");

            // If this element has a background image and it is a URL
            if(backgroundImage && backgroundImage.primitiveType == CSSPrimitiveValue.CSS_URI)
            {
                image     = new Image();
                image.src = backgroundImage.getStringValue();

                imageList.push(image);
            }
        }

        imageList = webdeveloper_tidyImages(imageList);

        // Loop through the images
        for(j = 0; j < imageList.length; j++)
        {
            fileSize     = null;
            image        = imageList[j];
            imageElement = generatedPage.content.document.createElement("img");
            imageSrc     = image.src;
            pElement     = generatedPage.content.document.createElement("p");
            tableElement = generatedPage.content.document.createElement("table");

            imageElement.setAttribute("src", imageSrc);
            pElement.appendChild(imageElement);
            generatedPage.content.document.body.appendChild(pElement);

            // Src
            cellDataElement   = generatedPage.content.document.createElement("td");
            cellHeaderElement = generatedPage.content.document.createElement("th");
            linkElement       = generatedPage.content.document.createElement("a");
            tableRowElement   = generatedPage.content.document.createElement("tr");

            cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_src")));
            tableRowElement.appendChild(cellHeaderElement);
            linkElement.setAttribute("href", imageSrc);
            linkElement.appendChild(generatedPage.content.document.createTextNode(imageSrc));
            cellDataElement.appendChild(linkElement);
            tableRowElement.appendChild(cellDataElement);
            tableElement.appendChild(tableRowElement);

            // Width
            cellDataElement   = generatedPage.content.document.createElement("td");
            cellHeaderElement = generatedPage.content.document.createElement("th");
            tableRowElement   = generatedPage.content.document.createElement("tr");

            cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_width")));
            tableRowElement.appendChild(cellHeaderElement);
            cellDataElement.appendChild(generatedPage.content.document.createTextNode(image.naturalWidth));
            tableRowElement.appendChild(cellDataElement);
            tableElement.appendChild(tableRowElement);

            // Height
            cellDataElement   = generatedPage.content.document.createElement("td");
            cellHeaderElement = generatedPage.content.document.createElement("th");
            tableRowElement   = generatedPage.content.document.createElement("tr");

            cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_height")));
            tableRowElement.appendChild(cellHeaderElement);
            cellDataElement.appendChild(generatedPage.content.document.createTextNode(image.naturalHeight));
            tableRowElement.appendChild(cellDataElement);
            tableElement.appendChild(tableRowElement);

            // Try to get the file size
            try
            {
                file = httpCacheSession.openCacheEntry(imageSrc, Components.interfaces.nsICache.ACCESS_READ, false);

                // If there is a file
                if(file)
                {
                    fileSize = file.dataSize;
                }
            }
            catch(exception)
            {
                try
                {
                    file = fileProtocolHandler.getFileFromURLSpec(imageSrc);

                    // If the file is set and it exists and is a file
                    if(file && file.exists() && file.isFile())
                    {
                        fileSize = file.fileSize;
                    }
                }
                catch(exceptionNested)
                {
                    // Do nothing
                }
            }

            // If there is a file size
            if(fileSize)
            {
                cellDataElement   = generatedPage.content.document.createElement("td");
                cellHeaderElement = generatedPage.content.document.createElement("th");
                tableRowElement   = generatedPage.content.document.createElement("tr");

                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_fileSize")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(webdeveloper_formatFileSize(fileSize)));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);
            }

            generatedPage.content.document.body.appendChild(tableElement);
            generatedPage.content.document.body.appendChild(generatedPage.content.document.createElement("hr"));
        }
    }

    // If the open tabs in background preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.open.tabs.background") && preferencesService.getBoolPref("webdeveloper.open.tabs.background"))
    {
        getBrowser().selectedTab = oldTab;
    }
}
