// Clears all radio buttons
function webdeveloper_clearRadioButtons()
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    var inputElement     = null;
    var inputElementList = null;
    var pageDocument     = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        inputElementList = pageDocument.getElementsByTagName("input");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If the element is a radio button
            if(inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "radio")
            {
                inputElement.checked = false;
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }
    }

    alert(stringBundle.getString("webdeveloper_clearRadioButtonsResult"));
}

// Displays/hides the form details for the page
function webdeveloper_displayFormDetails(element, applyStyle)
{
    const display      = element.getAttribute("checked");
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var inputElement        = null;
    var inputElementList    = null;
    var pageDocument        = null;
    var selectElement       = null;
    var selectElementList   = null;
    var spanElement         = null;
    var spanElementList     = null;
    var text                = null;
    var textareaElement     = null;
    var textareaElementList = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument        = documentList[i];
        inputElementList    = pageDocument.getElementsByTagName("input");
        selectElementList   = pageDocument.getElementsByTagName("select");
        spanElementList     = pageDocument.getElementsByTagName("span");
        textareaElementList = pageDocument.getElementsByTagName("textarea");

        // Loop through all the span tags
        for(var j = 0; j < spanElementList.length; j++)
        {
            spanElement = spanElementList[j];

            // If the class exists and is set to webdeveloper-form-span
            if(spanElement.hasAttribute("class") && spanElement.getAttribute("class") == "webdeveloper-form-span")
            {
                spanElement.parentNode.removeChild(spanElement);
                j--;
            }
        }

        // Loop through all the input tags
        for(j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If displaying
            if(display)
            {
                spanElement = pageDocument.createElement("span");
                text        = "<input";

                // If the element is hidden
                if(inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "hidden")
                {
                    inputElement.setAttribute("type", "text");

                    // If the element has a class attribute
                    if(inputElement.hasAttribute("class"))
                    {
                        inputElement.setAttribute("class", inputElement.getAttribute("class") + " webdeveloper-unhidden");
                    }
                    else
                    {
                        inputElement.setAttribute("class", "webdeveloper-unhidden");
                    }
                }

                // If the element has an id attribute
                if(inputElement.hasAttribute("id"))
                {
                    text += ' id="' + inputElement.getAttribute("id") + '"';
                }

                // If the element has an name attribute
                if(inputElement.hasAttribute("name"))
                {
                    text += ' name="' + inputElement.getAttribute("name") + '"';
                }

                // If the element has a size attribute
                if(inputElement.hasAttribute("size"))
                {
                    text += ' size="' + inputElement.getAttribute("size") + '"';
                }

                // If the element has a maxlength attribute
                if(inputElement.hasAttribute("maxlength"))
                {
                    text += ' maxlength="' + inputElement.getAttribute("maxlength") + '"';
                }

                text += ">";

                spanElement.setAttribute("class", "webdeveloper-form-span");
                spanElement.appendChild(pageDocument.createTextNode(text));
                inputElement.parentNode.insertBefore(spanElement, inputElement);
            }
            else if(inputElement.hasAttribute("class") && inputElement.getAttribute("class").indexOf("webdeveloper-unhidden") != -1)
            {
                inputElement.setAttribute("type", "hidden");
                inputElement.setAttribute("class", webdeveloper_removeSubstring(inputElement.getAttribute("class"), "webdeveloper-unhidden").trim());
            }

            // This stops the fields reordering
            inputElement.setAttribute("type", inputElement.getAttribute("type"));
        }

        // Loop through all the select tags
        for(j = 0; j < selectElementList.length; j++)
        {
            selectElement = selectElementList[j];

            // If displaying
            if(display)
            {
                spanElement = pageDocument.createElement("span");
                text        = "<select";

                // If the element has an id attribute
                if(selectElement.hasAttribute("id"))
                {
                    text += ' id="' + selectElement.getAttribute("id") + '"';
                }

                // If the element has an name attribute
                if(selectElement.hasAttribute("name"))
                {
                    text += ' name="' + selectElement.getAttribute("name") + '"';
                }

                text += ">";

                spanElement.setAttribute("class", "webdeveloper-form-span");
                spanElement.appendChild(pageDocument.createTextNode(text));
                selectElement.parentNode.insertBefore(spanElement, selectElement);
            }
        }

        // Loop through all the textarea tags
        for(j = 0; j < textareaElementList.length; j++)
        {
            textareaElement = textareaElementList[j];

            // If displaying
            if(display)
            {
                spanElement = pageDocument.createElement("span");
                text        = "<textarea";

                // If the element has an id attribute
                if(textareaElement.hasAttribute("id"))
                {
                    text += ' id="' + textareaElement.getAttribute("id") + '"';
                }

                // If the element has an name attribute
                if(textareaElement.hasAttribute("name"))
                {
                    text += ' name="' + textareaElement.getAttribute("name") + '"';
                }

                text += ">";

                spanElement.setAttribute("class", "webdeveloper-form-span");
                spanElement.appendChild(pageDocument.createTextNode(text));
                textareaElement.parentNode.insertBefore(spanElement, textareaElement);
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_form_details.css", "webdeveloper-display-form-details", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-form-details-tooltips", "*:before, .webdeveloper-form-span");
}

// Enables form auto completion
function webdeveloper_enableFormAutoCompletion()
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    var enabledForms = 0;
    var form         = null;
    var formList     = null;
    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        formList     = pageDocument.getElementsByTagName("form");

        // Loop through all the forms
        for(var j = 0; j < formList.length; j++)
        {
            form = formList[j];

            // If this form has autocomplete off
            if(form.hasAttribute("autocomplete") && form.getAttribute("autocomplete").toLowerCase() == "off")
            {
                form.setAttribute("autocomplete", "on");
                enabledForms++;
            }
        }
    }

    // If one form was enabled
    if(enabledForms == 1)
    {
        alert(stringBundle.getString("webdeveloper_enableAutoCompletionSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_enableAutoCompletionMultipleResult", [enabledForms]));
    }
}

// Makes all the form fields writable
function webdeveloper_makeFormFieldsWritable()
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    var writableFields      = 0;
    var inputElement        = null;
    var inputElementType    = null;
    var inputElementList    = null;
    var pageDocument        = null;
    var textAreaElement     = null;
    var textAreaElementList = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument        = documentList[i];
        inputElementList    = pageDocument.getElementsByTagName("input");
        textAreaElementList = pageDocument.getElementsByTagName("textarea");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If the input element has a read only attribute
            if(inputElement.hasAttribute("readonly"))
            {
                inputElement.removeAttribute("readonly");
                writableFields++;
            }
        }

        // Loop through all the text area tags
        for(j = 0; j < textAreaElementList.length; j++)
        {
            textAreaElement = textAreaElementList[j];

            // If the text area element has a read only attribute
            if(textAreaElement.hasAttribute("readonly"))
            {
                textAreaElement.removeAttribute("readonly");
                writableFields++;
            }
        }
    }

    // If one field was made writable
    if(writableFields == 1)
    {
        alert(stringBundle.getString("webdeveloper_makeFormFieldsWritableSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_makeFormFieldsWritableMultipleResult", [writableFields]));
    }
}

// Populates the form fields on the page
function webdeveloper_populateFormFields()
{
    const mainTabBox         = getBrowser().mTabBox;
    const documentList       = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var inputElement        = null;
    var inputElementList    = null;
    var inputElementName    = null;
    var inputElementType    = null;
    var inputElementValue   = null;
    var pageDocument        = null;
    var selectElement       = null;
    var selectElementList   = null;
    var textAreaElement     = null;
    var textAreaElementList = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument        = documentList[i];
        inputElementList    = pageDocument.getElementsByTagName("input");
        selectElementList   = pageDocument.getElementsByTagName("select");
        textAreaElementList = pageDocument.getElementsByTagName("textarea");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement      = inputElementList[j];
            inputElementType  = inputElement.getAttribute("type");
            inputElementValue = inputElement.value;

            // If the input element is not disabled
            if(!inputElement.disabled)
            {
                // If the input element value is not set and the type is not set or is password or text
                if((!inputElementValue || inputElementValue.trim() == "") && (!inputElementType || inputElementType == "password" || inputElementType == "text"))
                {
                    inputElementName = inputElement.getAttribute("name");

                    // If the input element type is text, the name contains email and the populate form fields email preference is set
                    if(inputElementType == "text" && inputElementName.toLowerCase().indexOf("email") != -1 && preferencesService.prefHasUserValue("webdeveloper.populate.form.fields.email"))
                    {
                        inputElement.value = preferencesService.getComplexValue("webdeveloper.populate.form.fields.email", Components.interfaces.nsISupportsString).data.trim();
                    }
                    else
                    {
                        inputElement.value = inputElementName;
                    }
                }
                else if(inputElementType == "checkbox" || inputElementType == "radio")
                {
                    inputElement.setAttribute("checked", true);
                }
            }
        }

        // Loop through all the select tags
        for(j = 0; j < selectElementList.length; j++)
        {
            selectElement = selectElementList[j];

            // If the select element is not disabled and the size is set greater than 1
            if(!selectElement.disabled && selectElement.hasAttribute("size") && selectElement.getAttribute("size") > 1)
            {
                selectElement.selectedIndex = 0;
            }
        }

        // Loop through all the text area tags
        for(j = 0; j < textAreaElementList.length; j++)
        {
            textAreaElement = textAreaElementList[j];

            // If the text area element is not disabled and the value is not set
            if(!textAreaElement.disabled && textAreaElement.value.trim() == "")
            {
                textAreaElement.value = textAreaElement.getAttribute("name");
            }
        }
    }
}

// Removes all maximum lengths on form elements
function webdeveloper_removeMaximumLengths()
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    var inputElement     = null;
    var inputElementList = null;
    var pageDocument     = null;
    var removed          = 0;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        inputElementList = pageDocument.getElementsByTagName("input");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If the element has a maxlength attribute
            if(inputElement.hasAttribute("maxlength"))
            {
                inputElement.removeAttribute("maxlength");
                removed++;
            }
        }
    }

    // If one maxlength was removed
    if(removed == 1)
    {
        alert(stringBundle.getString("webdeveloper_removeMaximumLengthsSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_removeMaximumLengthsMultipleResult", [removed]));
    }
}

// Shows all passwords on a form
function webdeveloper_showPasswords()
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    var inputElement     = null;
    var inputElementList = null;
    var pageDocument     = null;
    var shownPasswords   = 0;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        inputElementList = pageDocument.getElementsByTagName("input");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If the element is password
            if(inputElement.hasAttribute("type") && inputElement.getAttribute("type").toLowerCase() == "password")
            {
                inputElement.setAttribute("type", "text");
                shownPasswords++;
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }
    }

    // If one password was shown
    if(shownPasswords == 1)
    {
        alert(stringBundle.getString("webdeveloper_showPasswordsSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_showPasswordsMultipleResult", [shownPasswords]));
    }
}

// Toggles form methods
function webdeveloper_toggleFormMethods(method)
{
    const displayFormDetailsMenu = document.getElementById("webdeveloper-display-form-details-menu");
    const mainTabBox             = getBrowser().mTabBox;
    const documentList           = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const stringBundle           = document.getElementById("webdeveloper-string-bundle");

    var convertedForms = 0;
    var form           = null;
    var formList       = null;
    var pageDocument   = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        formList     = pageDocument.getElementsByTagName("form");

        // Loop through all the forms
        for(var j = 0; j < formList.length; j++)
        {
            form = formList[j];

            // If this form is not already the right method
            if(form.hasAttribute("method") && form.getAttribute("method") != method)
            {
                form.setAttribute("method", method);
                convertedForms++;
            }
        }
    }

    // Reapply the display form details style sheet if it is currently on - fixes bug with form method not updating
    if(displayFormDetailsMenu.getAttribute("checked"))
    {
        webdeveloper_removeStyleSheet("webdeveloper-display-form-details", false);
        webdeveloper_displayFormDetails(displayFormDetailsMenu, false);
    }

    // If one form was converted
    if(convertedForms == 1)
    {
        alert(stringBundle.getFormattedString("webdeveloper_toggleFormMethodsSingleResult", [method.toUpperCase()]));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_toggleFormMethodsMultipleResult", [convertedForms, method.toUpperCase()]));
    }
}

// Displays all the forms for the page
function webdeveloper_viewFormInformation()
{
    const mainTabBox         = getBrowser().mTabBox;
    const documentList       = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());
    const oldTab             = getBrowser().selectedTab;
    const oldURL             = getBrowser().currentURI.spec;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const request            = new XMLHttpRequest();
    const stringBundle       = document.getElementById("webdeveloper-string-bundle");
    const title              = stringBundle.getFormattedString("webdeveloper_viewFormInformationTitle", [oldURL]);

    var cellDataElement   = null;
    var cellHeaderElement = null;
    var documentURL       = null;
    var elementType       = null;
    var elementValue      = null;
    var form              = null;
    var formElement       = null;
    var formElementId     = null;
    var formElementList   = null;
    var formLength        = null;
    var formList          = null;
    var generatedPage     = null;
    var headerElement     = null;
    var label             = null;
    var labelList         = null;
    var labelValue        = null;
    var linkElement       = null;
    var pageDocument      = null;
    var pElement          = null;
    var preElement        = null;
    var tableElement      = null;
    var tableRowElement   = null;

    generatedPage = webdeveloper_generatePage("");

    // This must be done to make generated content render
    request.open("get", "about:blank", false);
    request.send("");

    generatedPage.content.document.title = title;

    linkElement = generatedPage.content.document.createElement("link");
    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated_content.css");
    linkElement.setAttribute("media", "all");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    generatedPage.content.document.getElementsByTagName("head")[0].appendChild(linkElement);

    headerElement = generatedPage.content.document.createElement("h1");
    headerElement.appendChild(generatedPage.content.document.createTextNode(title));
    generatedPage.content.document.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        documentURL  = pageDocument.documentURI;
        formList     = pageDocument.getElementsByTagName("form");
        formLength   = formList.length;

        headerElement = generatedPage.content.document.createElement("h2");
        linkElement   = generatedPage.content.document.createElement("a");
        linkElement.setAttribute("href", documentURL);
        linkElement.appendChild(generatedPage.content.document.createTextNode(documentURL));
        headerElement.appendChild(linkElement);
        generatedPage.content.document.body.appendChild(headerElement);

        // If there are no forms
        if(formLength == 0)
        {
            pElement = generatedPage.content.document.createElement("p");
            pElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_noForms")));
            generatedPage.content.document.body.appendChild(pElement);
        }
        else
        {
            labelList = pageDocument.getElementsByTagName("label");

            // Loop through the forms
            for(var j = 0; j < formLength; j++)
            {
                form            = formList[j];
                formElementList = form.elements;
                headerElement   = generatedPage.content.document.createElement("h2");
                tableElement    = generatedPage.content.document.createElement("table");
                tableRowElement = generatedPage.content.document.createElement("tr");

                headerElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationForm")));
                generatedPage.content.document.body.appendChild(headerElement);

                //  Form id heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationId")));
                tableRowElement.appendChild(cellHeaderElement);

                //  Form name heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationName")));
                tableRowElement.appendChild(cellHeaderElement);

                //  Form method heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationMethod")));
                tableRowElement.appendChild(cellHeaderElement);

                //  Form action heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationAction")));
                tableRowElement.appendChild(cellHeaderElement);
                tableElement.appendChild(tableRowElement);

                tableRowElement = generatedPage.content.document.createElement("tr");

                //  Form id
                cellDataElement = generatedPage.content.document.createElement("td");
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(form.getAttribute("id")));
                tableRowElement.appendChild(cellDataElement);

                //  Form name
                cellDataElement = generatedPage.content.document.createElement("td");
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(form.getAttribute("name")));
                tableRowElement.appendChild(cellDataElement);

                //  Form method
                cellDataElement = generatedPage.content.document.createElement("td");
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(form.getAttribute("method")));
                tableRowElement.appendChild(cellDataElement);

                //  Form action
                cellDataElement = generatedPage.content.document.createElement("td");
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(form.getAttribute("action")));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                generatedPage.content.document.body.appendChild(tableElement);

                pElement = generatedPage.content.document.createElement("p");
                generatedPage.content.document.body.appendChild(pElement);

                headerElement = generatedPage.content.document.createElement("h2");
                tableElement  = generatedPage.content.document.createElement("table");
                tableRowElement = generatedPage.content.document.createElement("tr");

                headerElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationElements")));
                generatedPage.content.document.body.appendChild(headerElement);

                //  Element label heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationLabel")));
                tableRowElement.appendChild(cellHeaderElement);

                //  Element id heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationId")));
                tableRowElement.appendChild(cellHeaderElement);

                //  Element name heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationName")));
                tableRowElement.appendChild(cellHeaderElement);
                tableElement.appendChild(tableRowElement);

                //  Element type heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationType")));
                tableRowElement.appendChild(cellHeaderElement);
                tableElement.appendChild(tableRowElement);

                //  Element value heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationValue")));
                tableRowElement.appendChild(cellHeaderElement);
                tableElement.appendChild(tableRowElement);

                // Loop through the form elements
                for(var k = 0; k < formElementList.length; k++)
                {
                    formElement     = formElementList[k];
                    formElementId   = formElement.getAttribute("id");
                    elementType     = formElement.tagName.toLowerCase();
                    elementValue    = "";
                    label           = "";
                    labelValue      = "";
                    tableRowElement = generatedPage.content.document.createElement("tr");

                    // If the element has an id
                    if(formElementId)
                    {
                        // Loop through the labels
                        for(var l = 0; l < labelList.length; l++)
                        {
                            label = labelList[l];

                            // If this is the label for the element
                            if(label.hasAttribute("for") && label.getAttribute("for") == formElementId)
                            {
                                labelValue = label.innerHTML;
                            }
                        }
                    }

                    // If this is an odd row
                    if(k % 2 != 0)
                    {
                        tableRowElement.setAttribute("class", "odd");
                    }

                    // If this is an input element
                    if(elementType == "input")
                    {
                        elementType  = formElement.getAttribute("type");
                        elementValue = formElement.value;
                    }
                    else if(elementType == "textarea")
                    {
                        elementValue = formElement.value;
                    }

                    //  Element label
                    cellDataElement = generatedPage.content.document.createElement("td");
                    cellDataElement.appendChild(generatedPage.content.document.createTextNode(labelValue));
                    tableRowElement.appendChild(cellDataElement);
                    tableElement.appendChild(tableRowElement);

                    //  Element id
                    cellDataElement = generatedPage.content.document.createElement("td");
                    cellDataElement.appendChild(generatedPage.content.document.createTextNode(formElementId));
                    tableRowElement.appendChild(cellDataElement);

                    //  Element name
                    cellDataElement = generatedPage.content.document.createElement("td");
                    cellDataElement.appendChild(generatedPage.content.document.createTextNode(formElement.getAttribute("name")));
                    tableRowElement.appendChild(cellDataElement);
                    tableElement.appendChild(tableRowElement);

                    //  Element type
                    cellDataElement = generatedPage.content.document.createElement("td");
                    cellDataElement.appendChild(generatedPage.content.document.createTextNode(elementType));
                    tableRowElement.appendChild(cellDataElement);
                    tableElement.appendChild(tableRowElement);

                    //  Element value
                    cellDataElement = generatedPage.content.document.createElement("td");
                    cellDataElement.appendChild(generatedPage.content.document.createTextNode(elementValue));
                    tableRowElement.appendChild(cellDataElement);
                    tableElement.appendChild(tableRowElement);
                }

                generatedPage.content.document.body.appendChild(tableElement);
                generatedPage.content.document.body.appendChild(generatedPage.content.document.createElement("hr"));
            }
        }
    }

    // If the open tabs in background preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.open.tabs.background") && preferencesService.getBoolPref("webdeveloper.open.tabs.background"))
    {
        getBrowser().selectedTab = oldTab;
    }
}
