// Toggles the cache
function webdeveloper_toggleCache(element)
{
    webdeveloper_disablePreference(element, "browser.cache.disk.enable");
    webdeveloper_disablePreference(element, "browser.cache.memory.enable");
}

// Toggles cookies
function webdeveloper_toggleCookies(element)
{
    const checked                      = element.getAttribute("checked");
    const preferencesService           = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const viewCookieInformationElement = document.getElementById("webdeveloper-view-cookie-information-menu");

    // Try to get the cookie preference
    try
    {
        preferencesService.getIntPref("network.cookie.cookieBehavior");

        var cookieBehavior = 0;

        // If disabling cookies
        if(checked)
        {
            cookieBehavior = 2;
        }

        preferencesService.setIntPref("network.cookie.cookieBehavior", cookieBehavior);
    }
    catch(exception)
    {
        preferencesService.setBoolPref("network.cookie.enable", !checked);
    }

    webdeveloper_configureEquivalentElements(element, "checked", checked);
}

// Toggles all the inline styles in elements in the document
function webdeveloper_toggleDocumentInlineStyles(node, disable)
{
    // If the node exists and is an element
    if(node && node.nodeType == 1)
    {
        const childNodes = node.childNodes;

        // If disabling styles and the node has a style attribute
        if(disable && node.hasAttribute("style"))
        {
            node.setAttribute("webdeveloper-inline-style", node.getAttribute("style"));
            node.removeAttribute("style");
        }
        else if(!disable && node.hasAttribute("webdeveloper-inline-style"))
        {
            node.setAttribute("style", node.getAttribute("webdeveloper-inline-style"));
            node.removeAttribute("webdeveloper-inline-style");
        }

        // Loop through the child nodes
        for(var i = 0; i < childNodes.length; i++)
        {
            webdeveloper_toggleDocumentInlineStyles(childNodes[i], disable);
        }
    }
}

// Toggles all the embedded styles on the page
function webdeveloper_toggleEmbeddedStyles(element, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var disable        = element.getAttribute("checked");
    var pageDocument   = null;
    var styleSheetList = null;

    webdeveloper_configureEquivalentElements(element, "checked", disable);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument   = documentList[i];
        styleSheetList = pageDocument.getElementsByTagName("style");

        // Loop through all the stylesheets
        for(var j = 0; j < styleSheetList.length; j++)
        {
            styleSheetList[j].disabled = disable;
        }

    }

    // If applying styles
    if(applyStyle)
    {
        // If style sheets are being disabled
        if(disable)
        {
            webdeveloper_addAppliedStyle("webdeveloper-disable-embedded-styles");
        }
        else
        {
            webdeveloper_removeAppliedStyle("webdeveloper-disable-embedded-styles");
        }
    }
}

// Toggles image animations
function webdeveloper_toggleImageAnimations(element)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var imageBehavior = "normal";

    // If disabling images
    if(checked)
    {
        imageBehavior = "none";
    }

    preferencesService.setCharPref("image.animation_mode", imageBehavior);

    webdeveloper_configureEquivalentElements(element, "checked", checked);
    BrowserReloadSkipCache();
}

// Toggles images
function webdeveloper_toggleImages(element)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var imageBehavior = 0;

    // If disabling images
    if(checked)
    {
        imageBehavior = 2;
    }

    preferencesService.setIntPref("network.image.imageBehavior", imageBehavior);

    webdeveloper_configureEquivalentElements(element, "checked", checked);
    BrowserReloadSkipCache();
}

// Toggles all the inline styles in elements on the page
function webdeveloper_toggleInlineStyles(element, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var disable = element.getAttribute("checked");

    webdeveloper_configureEquivalentElements(element, "checked", disable);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        webdeveloper_toggleDocumentInlineStyles(documentList[i].documentElement, disable);
    }

    // If applying styles
    if(applyStyle)
    {
        // If style sheets are being disabled
        if(disable)
        {
            webdeveloper_addAppliedStyle("webdeveloper-disable-inline-styles");
        }
        else
        {
            webdeveloper_removeAppliedStyle("webdeveloper-disable-inline-styles");
        }
    }
}

// Toggles all the linked styles on the page
function webdeveloper_toggleLinkedStyles(element, applyStyle)
{
    const mainTabBox   = getBrowser().mTabBox;
    const documentList = webdeveloper_getDocuments(getBrowser().browsers[mainTabBox.selectedIndex].contentWindow, new Array());

    var disable        = element.getAttribute("checked");
    var ownerNode      = null;
    var pageDocument   = null;
    var styleSheet     = null;
    var styleSheetList = null;

    webdeveloper_configureEquivalentElements(element, "checked", disable);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument   = documentList[i];
        styleSheetList = pageDocument.styleSheets;

        // Loop through all the stylesheets
        for(var j = 0; j < styleSheetList.length; j++)
        {
            styleSheet = styleSheetList[j];
            ownerNode  = styleSheet.ownerNode;

            // If this style sheet is not embedded, has an owner node and is not an alternate style
            if(styleSheet.href != pageDocument.documentURI && ownerNode && (!ownerNode.hasAttribute("rel") || ownerNode.getAttribute("rel").toLowerCase() != "alternate stylesheet"))
            {
                styleSheet.disabled = disable;
            }
        }
    }

    // If applying styles
    if(applyStyle)
    {
        // If style sheets are being disabled
        if(disable)
        {
            webdeveloper_addAppliedStyle("webdeveloper-disable-linked-styles");
        }
        else
        {
            webdeveloper_removeAppliedStyle("webdeveloper-disable-linked-styles");
        }
    }
}

// Toggles Java
function webdeveloper_toggleJava(element)
{
    const checked                = element.getAttribute("checked");
    const openJavaConsoleElement = document.getElementById("webdeveloper-open-java-console-menu");

    webdeveloper_disablePreference(element, "security.enable_java");
    webdeveloper_configureEquivalentElements(openJavaConsoleElement, "disabled", checked);
    webdeveloper_disableElement(document.getElementById("webdeveloper-open-java-console-key"), checked);
}

// Toggles the page colors
function webdeveloper_togglePageColors(element)
{
    webdeveloper_disablePreference(element, "browser.display.use_document_colors");
    BrowserReloadSkipCache();
}

// Toggles referrer logging
function webdeveloper_toggleReferrerLogging(element)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var sendReferrer = 2;

    // If disabling referrer logging
    if(checked)
    {
        sendReferrer = 0;
    }

    preferencesService.setIntPref("network.http.sendRefererHeader", sendReferrer);

    webdeveloper_configureEquivalentElements(element, "checked", checked);
}

// Toggles the styles for the page
function webdeveloper_toggleStyles(element, applyStyle)
{
    const mainTabBox      = getBrowser().mTabBox;
    const contentWindow   = getBrowser().browsers[mainTabBox.selectedIndex].contentWindow;
    const currentDocument = contentWindow.document;
    const documentList    = webdeveloper_getDocuments(contentWindow, new Array());

    var disable        = null;
    var ownerNode      = null;
    var pageDocument   = null;
    var styleElement   = null;
    var styleSheet     = null;
    var styleSheetList = null;

    // If the element is not set we are coming from a keyboard shortcut
    if(!element)
    {
        element = document.getElementById("webdeveloper-disable-all-styles-menu");

        // If the element has a checked attribute
        if(element.getAttribute("checked") == "true")
        {
            element.removeAttribute("checked");
        }
        else
        {
            element.setAttribute("checked", true);
        }
    }

    disable = element.getAttribute("checked");
    webdeveloper_configureEquivalentElements(element, "checked", disable);

    // Explictly convert the value of disable to a boolean
    if(disable == "true")
    {
        disable = true;
    }
    else
    {
        disable = false;
    }

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument   = documentList[i];
        styleSheetList = pageDocument.styleSheets;

        // Loop through all the stylesheets
        for(var j = 0; j < styleSheetList.length; j++)
        {
            styleSheet = styleSheetList[j];

            // If the style sheet is set
            if(styleSheet)
            {
                ownerNode  = styleSheet.ownerNode;

                // If this style sheet does not have an owner node or the owner node is a processing instruction or is not an alternate style
                if(!ownerNode || ownerNode.nodeType == 7 || !ownerNode.hasAttribute("rel") || ownerNode.getAttribute("rel").toLowerCase() != "alternate stylesheet")
                {
                    styleSheet.disabled = disable;
                }
            }
        }

        webdeveloper_toggleDocumentInlineStyles(pageDocument.documentElement, disable);
    }

    // If disabling styles
    if(disable)
    {
        webdeveloper_resetMenu(false);
    }
    else
    {
        webdeveloper_updateMenu(currentDocument);
    }

    styleElement = document.getElementById("webdeveloper-disable-embedded-styles-menu");
    webdeveloper_configureEquivalentElements(styleElement, "checked", false);
    webdeveloper_configureEquivalentElements(styleElement, "disabled", disable);

    styleElement = document.getElementById("webdeveloper-disable-inline-styles-menu");
    webdeveloper_configureEquivalentElements(styleElement, "checked", false);
    webdeveloper_configureEquivalentElements(styleElement, "disabled", disable);

    styleElement = document.getElementById("webdeveloper-disable-linked-styles-menu");
    webdeveloper_configureEquivalentElements(styleElement, "checked", false);
    webdeveloper_configureEquivalentElements(styleElement, "disabled", disable);

    // If applying styles
    if(applyStyle)
    {
        // If style sheets are being disabled
        if(disable)
        {
            webdeveloper_addAppliedStyle("webdeveloper-disable-all-styles");
        }
        else
        {
            webdeveloper_removeAppliedStyle("webdeveloper-disable-all-styles");
        }
    }
}
