// Cancels the outline elements
function webdeveloper_cancelOutlineElements()
{
    window.opener.document.getElementById("webdeveloper-outline-custom-elements-menu").setAttribute("checked", false);

    window.close();
}

// Initializes the outline elements dialog
function webdeveloper_initializeOutlineElements()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var color   = null;
    var element = null;

    // Loop through the possible custom elements
	for(var i = 1; i <= 5; i++)
	{
	    color   = "webdeveloper.custom." + i + ".color";
	    element = "webdeveloper.custom." + i + ".element";

        // If the color is set
        if(preferencesService.prefHasUserValue(color))
        {
		    document.getElementById(color).color = preferencesService.getComplexValue(color, Components.interfaces.nsISupportsString).data.trim();
		}

        // If the element is set
        if(preferencesService.prefHasUserValue(element))
        {
		    document.getElementById(element).value = preferencesService.getComplexValue(element, Components.interfaces.nsISupportsString).data.trim();
		}
	}
}

// Saves the list of colors and elements to outline
function webdeveloper_saveOutlineElements()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const string             = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);

    var color   = null;
    var element = null;

    // Loop through the possible custom elements
	for(var i = 1; i <= 5; i++)
	{
	    color   = "webdeveloper.custom." + i + ".color";
	    element = "webdeveloper.custom." + i + ".element";

        string.data = document.getElementById(color).color;

        preferencesService.setComplexValue(color, Components.interfaces.nsISupportsString, string);

        string.data = document.getElementById(element).value.trim();

        preferencesService.setComplexValue(element, Components.interfaces.nsISupportsString, string);
	}

	window.arguments[0].push(true);
}