// Formats a file size
function webdeveloper_formatFileSize(fileSize)
{
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the file size is set
    if(fileSize)
    {
        // If the file size is greater than a kilobyte
        if(fileSize > 1024)
        {
            return Math.round(fileSize / 1024) + " " + stringBundle.getString("webdeveloper_kilobytes");
        }
        else
        {
            return fileSize + " " + stringBundle.getString("webdeveloper_bytes");
        }
    }
    else
    {
        return "";
    }
}

// Removes all child nodes from a node
function webdeveloper_removeAllChildNodes(node)
{
    var childNodes = node.childNodes;

    // Loop through the child nodes
    for(var i = 0; i < childNodes.length; i++)
    {
        node.removeChild(childNodes[i]);
    }

    childNodes = node.childNodes;

    // Loop through the child nodes
    while(childNodes.length > 0)
    {
        node.removeChild(childNodes[0]);
    }
}

// Removes a substring from a string
function webdeveloper_removeSubstring(string, substring)
{
    // If the string was not empty
    if(string)
    {
        const substringStart = string.indexOf(substring);

        // If the substring was found in the string
        if(substring && substringStart != -1)
        {
            return string.substring(0, substringStart) + string.substring(substringStart + substring.length, string.length);
        }
        else
        {
            return string;
        }
    }
    else
    {
        return "";
    }
}

// Tests if a string ends with the given string
String.prototype.endsWith = function(endsWithString)
{
	return (this.substr(this.length - endsWithString.length) == endsWithString);
}

// Trims leading and trailing spaces from a string
String.prototype.trim = function()
{
    return this.replace(new RegExp("^\\s+|\\s+$", "gi"), "");
}
