// Loads the extension home page in a new tab
function webdeveloper_visitHomePage()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const url                = "http://www.chrispederick.com/work/firefox/webdeveloper/";

    var parentWindow = null;

    // If there is a parent window
    if(window.opener)
    {
        // If there is a grand parent window
        if(window.opener.opener)
        {
            parentWindow = window.opener.opener;
        }
        else
        {
            parentWindow = window.opener;
        }
    }

    // If a parent window was found
    if(parentWindow)
    {
        // If the open in windows preference is set to true
        if(preferencesService.prefHasUserValue("webdeveloper.open.tabs") && preferencesService.getBoolPref("webdeveloper.open.tabs"))
        {
            const newTab = parentWindow.getBrowser().addTab(url);

            // If the open tabs in background preference is not set or is set to false
            if(!preferencesService.prefHasUserValue("webdeveloper.open.tabs.background") || !preferencesService.getBoolPref("webdeveloper.open.tabs.background"))
            {
                parentWindow.getBrowser().selectedTab = newTab;
            }
        }
        else
        {
            parentWindow.open(url);
        }

        window.close();
    }
}