var webdeveloper_appliedStyles               = new Array();
var webdeveloper_javaScriptConsoleListener   = false;
var webdeveloper_keyboardShortcutsConfigured = false;
var webdeveloper_outlinedElements            = new Array();
var webdeveloper_selectedTab                 = 0;
var webdeveloper_userStyleSheet              = null;

webdeveloper_initialize();

// Displays the about dialog
function webdeveloper_about()
{
    window.openDialog("chrome://webdeveloper/content/about/about.xul", "webdeveloper-about-dialog", "centerscreen,chrome,modal");
}

// Add applied style
function webdeveloper_addAppliedStyle(id)
{
    webdeveloper_appliedStyles.push(id);
}

// Adds the style sheet at the given location with the given id
function webdeveloper_addStyleSheet(location, id, applyStyle)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var headElementList = null;
    var linkElement     = null;
    var pageDocument    = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument    = documentList[i];
        headElementList = pageDocument.getElementsByTagName("head");
        linkElement     = pageDocument.createElement("link");

        linkElement.setAttribute("href", location);
        linkElement.setAttribute("id", id);
        linkElement.setAttribute("rel", "stylesheet");
        linkElement.setAttribute("type", "text/css");

        // If there is a head element
        if(headElementList.length > 0)
        {
            headElementList[0].appendChild(linkElement);
        }
        else
        {
            pageDocument.documentElement.childNodes[0].appendChild(linkElement);
        }
    }

    // If applying style
    if(applyStyle)
    {
        webdeveloper_addAppliedStyle(id);
    }
}

// Adds a user style sheet to the page
function webdeveloper_addUserStyleSheet(element, applyStyle)
{
    const addStyleSheet = element.getAttribute("checked");

    // If adding a style sheet and applying styles
    if(addStyleSheet && applyStyle)
    {
        const filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
        const stringBundle = document.getElementById("webdeveloper-string-bundle");

        filePicker.appendFilter(stringBundle.getString("webdeveloper_styleSheetDescription"), "*.css");
        filePicker.init(window, stringBundle.getString("webdeveloper_addUserStyleSheetTitle"), filePicker.modeOpen);

        // If the user selected a style sheet
        if(filePicker.show() == filePicker.returnOK)
        {
            const inputStream      = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
            const scriptableStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);

            inputStream.init(filePicker.file, 0x01, 0444, null);
            scriptableStream.init(inputStream);

            webdeveloper_userStyleSheet = scriptableStream.read(scriptableStream.available());

            scriptableStream.close();
            inputStream.close();
        }
        else
        {
            addStyleSheet               = false;
            webdeveloper_userStyleSheet = null;
        }
    }

    // If adding a style sheet and the style sheet is not empty
    if(addStyleSheet && webdeveloper_userStyleSheet)
    {
        const documentList = webdeveloper_getDocuments(window.content, new Array());

        var headElementList = null;
        var pageDocument    = null;
        var styleElement    = null;

        // Loop through the documents
        for(var i = 0; i < documentList.length; i++)
        {
            pageDocument    = documentList[i];
            headElementList = pageDocument.getElementsByTagName("head");
            styleElement    = pageDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-add-user-style-sheet");
            styleElement.setAttribute("type", "text/css");
            styleElement.appendChild(pageDocument.createTextNode(webdeveloper_userStyleSheet));

            // If there is a head element
            if(headElementList.length > 0)
            {
                headElementList[0].appendChild(styleElement);
            }
            else
            {
                pageDocument.documentElement.childNodes[0].appendChild(styleElement);
            }
        }

        // If applying styles
        if(applyStyle)
        {
            webdeveloper_addAppliedStyle("webdeveloper-add-user-style-sheet");
        }
    }
    else
    {
        webdeveloper_userStyleSheet = null;
        webdeveloper_removeStyleSheet("webdeveloper-add-user-style-sheet", true);
    }

    webdeveloper_configureEquivalentElements(element, "checked", addStyleSheet);
}

// Applies all selected style sheets
function webdeveloper_applyStyleSheets(reload)
{
    var appliedStyle = null;

    // Loop through the applied styles
    for(var i = 0; i < webdeveloper_appliedStyles.length; i++)
    {
        appliedStyle = webdeveloper_appliedStyles[i];

        // Switch on the style
        switch(appliedStyle)
        {
            case "webdeveloper-add-user-style-sheet":
                webdeveloper_addUserStyleSheet(document.getElementById("webdeveloper-add-user-style-sheet-menu"), false);
                break;
            case "webdeveloper-disable-styles":
                webdeveloper_toggleStyles(document.getElementById("webdeveloper-disable-styles-menu"), false);
                break;
            case "webdeveloper-display-access-keys":
                webdeveloper_displayAccessKeys(document.getElementById("webdeveloper-display-access-keys-menu"), false);
                break;
            case "webdeveloper-display-block-size":
                webdeveloper_displayBlockSize(document.getElementById("webdeveloper-display-block-size-menu"), false);
                break;
            case "webdeveloper-display-current-size-title":
                // If the page has been reloaded
                if(reload)
                {
                    webdeveloper_displayWindowSizeInTitle(document.getElementById("webdeveloper-display-current-size-title-menu"), false);
                }
                break;
            case "webdeveloper-display-form-details":
                webdeveloper_displayFormDetails(document.getElementById("webdeveloper-display-form-details-menu"), false);
                break;
            case "webdeveloper-display-id-class-details":
                webdeveloper_displayIDClassDetails(document.getElementById("webdeveloper-display-id-class-details-menu"), false);
                break;
            case "webdeveloper-display-image-dimensions":
                webdeveloper_displayImageDimensions(document.getElementById("webdeveloper-display-image-dimensions-menu"), false);
                break;
            case "webdeveloper-display-image-paths":
                webdeveloper_displayImagePaths(document.getElementById("webdeveloper-display-image-paths-menu"), false);
                break;
            case "webdeveloper-display-link-paths":
                webdeveloper_displayImagePaths(document.getElementById("webdeveloper-display-link-paths-menu"), false);
                break;
            case "webdeveloper-display-tab-index":
                webdeveloper_displayTabIndex(document.getElementById("webdeveloper-display-tab-index-menu"), false);
                break;
            case "webdeveloper-display-topographic-information":
                webdeveloper_displayTopographicInformation(document.getElementById("webdeveloper-display-topographic-information-menu"), false);
                break;
            case "webdeveloper-hide-images":
                webdeveloper_hideImages(document.getElementById("webdeveloper-hide-images-menu"), "webdeveloper-hide-images", false);
                break;
            case "webdeveloper-make-images-invisible":
                webdeveloper_makeImagesInvisible(document.getElementById("webdeveloper-make-images-invisible-menu"), "webdeveloper-make-images-invisible", false);
                break;
            case "webdeveloper-outline-block-level-elements":
                webdeveloper_outlineBlockLevelElements(document.getElementById("webdeveloper-outline-block-level-elements-menu"), false);
                break;
            case "webdeveloper-outline-custom-elements":
                webdeveloper_outlineElements(document.getElementById("webdeveloper-outline-custom-elements-menu"), false);
                break;
            case "webdeveloper-outline-deprecated-elements":
                webdeveloper_outlineDeprecatedElements(document.getElementById("webdeveloper-outline-deprecated-elements-menu"), false);
                break;
            case "webdeveloper-outline-frames":
                webdeveloper_outlineFrames(document.getElementById("webdeveloper-outline-frames-menu"), false);
                break;
            case "webdeveloper-outline-images-with-empty-alt-attributes":
                webdeveloper_outlineImagesWithEmptyAltAttributes(document.getElementById("webdeveloper-outline-images-with-empty-alt-attributes-menu"), false);
                break;
            case "webdeveloper-outline-images-without-alt-attributes":
                webdeveloper_outlineImagesWithoutAltAttributes(document.getElementById("webdeveloper-outline-images-without-alt-attributes-menu"), false);
                break;
            case "webdeveloper-outline-images-without-title-attributes":
                webdeveloper_outlineImagesWithoutTitleAttributes(document.getElementById("webdeveloper-outline-images-without-title-attributes-menu"), false);
                break;
            case "webdeveloper-outline-links-without-title-attributes":
                webdeveloper_outlineLinksWithoutTitleAttributes(document.getElementById("webdeveloper-outline-links-without-title-attributes-menu"), false);
                break;
            case "webdeveloper-outline-table-cells":
                webdeveloper_outlineTableCells(document.getElementById("webdeveloper-outline-table-cells-menu"), false);
                break;
            case "webdeveloper-replace-images-with-alt-attributes":
                webdeveloper_replaceImagesWithAltAttributes(document.getElementById("webdeveloper-replace-images-with-alt-attributes-menu"), false);
                break;
            case "webdeveloper-show-comments":
                webdeveloper_toggleComments(document.getElementById("webdeveloper-show-comments-menu"), false);
                break;
            case "webdeveloper-view-style-information":
                webdeveloper_viewStyleInformation(document.getElementById("webdeveloper-view-style-information-menu"), false);
                break;
        }
    }
}

// Changes the options
function webdeveloper_changeOptions()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const toolbar            = document.getElementById("webdeveloper-toolbar");

    var element                   = null;
    var hideMenuPreference        = false;
    var hideContextMenuPreference = false;

    // If the hide menu preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.menu.hide"))
    {
        hideMenuPreference = preferencesService.getBoolPref("webdeveloper.menu.hide");
    }

    // If the hide context menu preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.context.hide"))
    {
        hideContextMenuPreference = preferencesService.getBoolPref("webdeveloper.context.hide");
    }

    // If the toolbar exists
    if(toolbar)
    {
        const toolbarVisible = window.toolbar.visible;

        // If the toolbar is visible and the toolbar icons preference is set
        if(toolbarVisible && preferencesService.prefHasUserValue("webdeveloper.toolbar.icons"))
        {
            const toolbarButtons = toolbar.getElementsByTagName("toolbarbutton");

            var toolbarPreference = preferencesService.getCharPref("webdeveloper.toolbar.icons");

            toolbar.setAttribute("mode", toolbarPreference);

            // If the toolbar preference is set to full
            if(toolbarPreference == "full")
            {
                toolbarPreference = null;
            }
            else if(toolbarPreference == "icons")
            {
                toolbarPreference = "pictures";
            }

            toolbar.setAttribute("buttonstyle", toolbarPreference);

            // Loop through the toolbar buttons
            for(var i = 0; i < toolbarButtons.length; i++)
            {
                toolbarButtons[i].setAttribute("buttonstyle", toolbarPreference);
            }

            // If the toolbar preference is set to text
            if(toolbarPreference == "text")
            {
                element = document.getElementById("webdeveloper-toggle-statusbar");

                // If the element exists
                if(element)
                {
                    element.setAttribute("label", "X");
                }
            }
            else
            {
                element = document.getElementById("webdeveloper-javascript-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }

                element = document.getElementById("webdeveloper-render-mode-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }

                element = document.getElementById("webdeveloper-toggle-statusbar");

                // If the element exists
                if(element)
                {
                    element.removeAttribute("label");
                }
            }
        }
    }

    element = document.getElementById("webdeveloper-menu");
    element.setAttribute("hidden", hideMenuPreference);
    element = document.getElementById("webdeveloper-context");
    element.setAttribute("hidden", hideContextMenuPreference);
    element = document.getElementById("webdeveloper-context-separator");
    element.setAttribute("hidden", hideContextMenuPreference);

    webdeveloper_configureKeyboardShortcuts();
}

// Clears the cache
function webdeveloper_clearCache()
{
    const cacheService = Components.classes["@mozilla.org/network/cache-service;1"].getService(Components.interfaces.nsICacheService);
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    cacheService.evictEntries(Components.interfaces.nsICache.STORE_ON_DISK);
    cacheService.evictEntries(Components.interfaces.nsICache.STORE_IN_MEMORY);

    alert(stringBundle.getString("webdeveloper_clearCacheResult"));
}

// Clears the HTTP authentication
function webdeveloper_clearHTTPAuthentication()
{
    const authenticationManager = Components.classes["@mozilla.org/network/http-auth-manager;1"].getService(Components.interfaces.nsIHttpAuthManager);
    const stringBundle          = document.getElementById("webdeveloper-string-bundle");

    authenticationManager.clearAll();

    alert(stringBundle.getString("webdeveloper_clearHTTPAuthenticationResult"));
}

// Clears all session cookies
function webdeveloper_clearSessionCookies()
{
    const cookieManager = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
    const cookies       = cookieManager.enumerator;
    const stringBundle  = document.getElementById("webdeveloper-string-bundle");

    var removed = 0;

    // Loop through the cookies
    while(cookies.hasMoreElements())
    {
        var cookie = cookies.getNext();

        // If this is a cookie with no expiration
        if(cookie instanceof Components.interfaces.nsICookie && cookie.expires == "0")
        {
            cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
            removed++;
        }
    }

    // If one session cookie was removed
    if(removed == 1)
    {
        alert(stringBundle.getString("webdeveloper_clearSessionCookiesSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_clearSessionCookiesMultipleResult", [removed]));
    }
}

// Configures the equivalent element to whichever one is set
function webdeveloper_configureEquivalentElements(element, attribute, value)
{
    const elementId = element.getAttribute("id");

    var equivalentElement   = null;
    var equivalentElementId = null;

    // If the element exists
    if(element)
    {
        // If setting the value to false
        if(value == "false")
        {
            element.removeAttribute(attribute);
        }
        else
        {
            element.setAttribute(attribute, value);
        }
    }

    // If the element is the context
    if(elementId.indexOf("context") != -1)
    {
        equivalentElementId = elementId.split("context").join("menu");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If setting the value to false
            if(value == "false")
            {
                equivalentElement.removeAttribute(attribute);
            }
            else
            {
                equivalentElement.setAttribute(attribute, value);
            }
        }

        equivalentElementId = elementId.split("context").join("toolbar");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If setting the value to false
            if(value == "false")
            {
                equivalentElement.removeAttribute(attribute);
            }
            else
            {
                equivalentElement.setAttribute(attribute, value);
            }
        }
    }
    else if(elementId.indexOf("menu") != -1)
    {
        equivalentElementId = elementId.split("menu").join("context");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If setting the value to false
            if(value == "false")
            {
                equivalentElement.removeAttribute(attribute);
            }
            else
            {
                equivalentElement.setAttribute(attribute, value);
            }
        }

        equivalentElementId = elementId.split("menu").join("toolbar");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If setting the value to false
            if(value == "false")
            {
                equivalentElement.removeAttribute(attribute);
            }
            else
            {
                equivalentElement.setAttribute(attribute, value);
            }
        }
    }
    else if(elementId.indexOf("toolbar") != -1)
    {
        equivalentElementId = elementId.split("toolbar").join("context");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If setting the value to false
            if(value == "false")
            {
                equivalentElement.removeAttribute(attribute);
            }
            else
            {
                equivalentElement.setAttribute(attribute, value);
            }
        }

        equivalentElementId = elementId.split("toolbar").join("menu");
        equivalentElement   = document.getElementById(equivalentElementId);

        // If the equivalent element exists
        if(equivalentElement)
        {
            // If setting the value to false
            if(value == "false")
            {
                equivalentElement.removeAttribute(attribute);
            }
            else
            {
                equivalentElement.setAttribute(attribute, value);
            }
        }
    }
}

// Configure the keyboard shortcuts
function webdeveloper_configureKeyboardShortcuts()
{
    // If the keyboard shortcuts have not been configured
    if(!webdeveloper_keyboardShortcutsConfigured)
    {
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

        var key = document.getElementById("webdeveloper-disable-styles-key");

        // If the disable styles key exists
        if(key)
        {
            webdeveloper_keyboardShortcutsConfigured = true;

            // If the disable styles key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.disable.styles"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.disable.styles"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.disable.styles", key.getAttribute("key"));
            }
        }

        key = document.getElementById("webdeveloper-open-javascript-console-key");

        // If the JavaScript console key exists
        if(key)
        {
            // If the JavaScript console key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.javascript.console"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.javascript.console"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.javascript.console", key.getAttribute("key"));
            }
        }

        key = document.getElementById("webdeveloper-sidebar-key");

        // If the sidebar key exists
        if(key)
        {
            // If the sidebar key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.sidebar"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.sidebar"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.sidebar", key.getAttribute("key"));
            }
        }

        key = document.getElementById("webdeveloper-validate-html-key");

        // If the validate HTML key exists
        if(key)
        {
            // If the validate HTML key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.validate.html"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.validate.html"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.validate.html", key.getAttribute("key"));
            }
        }

        key = document.getElementById("webdeveloper-validate-local-html-key");

        // If the validate local HTML key exists
        if(key)
        {
            // If the validate local HTML key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.validate.local.html"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.validate.local.html"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.validate.local.html", key.getAttribute("key"));
            }
        }

        key = document.getElementById("webdeveloper-view-css-key");

        // If the view CSS key exists
        if(key)
        {
            // If the view CSS key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.view.css"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.view.css"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.view.css", key.getAttribute("key"));
            }
        }

        key = document.getElementById("webdeveloper-view-source-key");

        // If the view source key exists
        if(key)
        {
            // If the view source key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.view.source"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.view.source"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.view.source", key.getAttribute("key"));
            }
        }

        key = document.getElementById("webdeveloper-view-style-information-key");

        // If the view style information key exists
        if(key)
        {
            // If the view style information key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.view.style.information"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.view.style.information"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.view.style.information", key.getAttribute("key"));
            }
        }

        key = document.getElementById("webdeveloper-zoom-in-key");

        // If the zoom in key exists
        if(key)
        {
            // If the zoom in key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.zoom.in"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.zoom.in"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.zoom.in", key.getAttribute("key"));
            }
        }

        key = document.getElementById("webdeveloper-zoom-out-key");

        // If the zoom out key exists
        if(key)
        {
            // If the zoom out key preference is set
            if(preferencesService.prefHasUserValue("webdeveloper.key.zoom.out"))
            {
                key.setAttribute("key", preferencesService.getCharPref("webdeveloper.key.zoom.out"));
            }
            else
            {
                preferencesService.setCharPref("webdeveloper.key.zoom.out", key.getAttribute("key"));
            }
        }
    }
}

// Resizes the window to a custom size
function webdeveloper_customWindowSize()
{
    window.openDialog("chrome://webdeveloper/content/dialogs/resize.xul", "webdeveloper-resize-dialog", "centerscreen,chrome,modal", window.outerWidth, window.outerHeight);
}

// Deletes all the cookies for the current domain
function webdeveloper_deleteDomainCookies()
{
    const cookieManager = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
    const documentList  = webdeveloper_getDocuments(window.content, new Array());
    const stringBundle  = document.getElementById("webdeveloper-string-bundle");

    var cookie       = null;
    var cookies      = new Array();
    var cookieLength = null;
    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        cookies      = cookies.concat(webdeveloper_getCookies(pageDocument.location.host, false));
    }

    cookieLength = cookies.length;

    // Loop through all the cookies
    for(i = 0 ; i < cookieLength; i++)
    {
        cookie = cookies[i];

        cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
    }

    // If one cookie was found
    if(cookieLength == 1)
    {
        alert(stringBundle.getString("webdeveloper_deleteDomainCookiesSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_deleteDomainCookiesMultipleResult", [cookiesLength]));
    }
}

// Disables the extension
function webdeveloper_disable(forceDisable)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const stringBundle       = document.getElementById("webdeveloper-string-bundle");

    var disable     = true;
    var element     = null;
    var textToolbar = false;

    // If not forcing disable and the disable extension preference is set
    if(!forceDisable && preferencesService.prefHasUserValue("webdeveloper.disabled"))
    {
        disable = !preferencesService.getBoolPref("webdeveloper.disabled");
    }

    // If the toolbar preference has a value and is set to text
    if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons") && preferencesService.getCharPref("webdeveloper.toolbar.icons") == "text")
    {
        textToolbar = true;
    }

    preferencesService.setBoolPref("webdeveloper.disabled", disable);

    webdeveloper_disableElement(document.getElementById("webdeveloper-disable-styles-key"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-open-javascript-console-key"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-sidebar-key"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-validate-html-key"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-validate-local-html-key"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-view-css-key"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-view-source-key"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-view-style-information-key"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-zoom-in-key"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-zoom-out-key"), disable);

    webdeveloper_disableElement(document.getElementById("webdeveloper-context"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-menu"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-sidebar"), disable);

    webdeveloper_disableElement(document.getElementById("webdeveloper-disable-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-css-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-forms-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-images-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-information-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-miscellaneous-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-outline-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-resize-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-validation-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-view-source-toolbar"), disable);
    webdeveloper_disableElement(document.getElementById("webdeveloper-options-toolbar"), disable);

    element = document.getElementById("webdeveloper-render-mode-statusbar");

    // If the element exists
    if(element)
    {
        element.setAttribute("class", "webdeveloper-statusbar-button");
        element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_standardsComplianceModeTooltip"));
        webdeveloper_disableElement(element, disable);

        // If the toolbar is in text mode
        if(textToolbar)
        {
            element.setAttribute("label", stringBundle.getString("webdeveloper_standardsComplianceModeLabel"));
        }
    }

    element = document.getElementById("webdeveloper-javascript-statusbar");

    // If the element exists
    if(element)
    {
        element.setAttribute("class", "webdeveloper-statusbar-button");
        element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_javaScriptNoErrorsTooltip"));
        webdeveloper_disableElement(element, disable);

        // If the toolbar is in text mode
        if(textToolbar)
        {
            element.setAttribute("label", stringBundle.getString("webdeveloper_javaScriptNoErrorsLabel"));
        }
    }

    element = document.getElementById("sidebar-box");

    // If the element exists, is visible and is showing edit CSS
    if(element && !element.getAttribute("hidden") && element.getAttribute("src") == "chrome://webdeveloper/content/sidebar/edit_css.xul")
    {
        toggleSidebar("webdeveloper-sidebar");
    }

    element = document.getElementById("webdeveloper-toggle-statusbar");

    // If the element exists
    if(element)
    {
        // If disabling the extension
        if(disable)
        {
            element.setAttribute("class", "enable webdeveloper-statusbar-button");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_enable"));
        }
        else
        {
            element.setAttribute("class", "webdeveloper-statusbar-button");
            element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_disable"));
        }
    }

    // If disabling
    if(disable)
    {
        // If already listening to the console
        if(webdeveloper_javaScriptConsoleListener)
        {
            const consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService().QueryInterface(Components.interfaces.nsIConsoleService);

            consoleService.unregisterListener(WebDeveloperJavaScriptConsoleListener);
            webdeveloper_javaScriptConsoleListener = false;
        }

        webdeveloper_resetPage();
    }
}

// Disables an element
function webdeveloper_disableElement(element, disable)
{
    // If the element exists
    if(element)
    {
        element.setAttribute("disabled", disable);
    }
}

// Disables the given preference
function webdeveloper_disablePreference(element, preference)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    preferencesService.setBoolPref(preference, !checked);
    webdeveloper_configureEquivalentElements(element, "checked", checked);
}

// Displays all access keys
function webdeveloper_displayAccessKeys(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_access_keys.css", "webdeveloper-display-access-keys", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-access-keys-tooltips", "*:before");
}

// Displays all block sizes
function webdeveloper_displayBlockSize(element, applyStyle)
{
    const display      = element.getAttribute("checked");
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        var blockSizeElement  = null;
        var blockSizeElements = null;
        var j                 = 0;

        pageDocument = documentList[i];

        // If displaying
        if(display)
        {
            const blockSizeElementTypes = new Array("div", "form", "table");

            var blockSize         = null;
            var height            = null;
            var left              = null;
            var top               = null;
            var width             = null;

            // Loop through the block size elements
            for(j = 0; j < blockSizeElementTypes.length; j++)
            {
                blockSizeElements = pageDocument.getElementsByTagName(blockSizeElementTypes[j]);

                // Loop through the block size elements
                for(var k = 0; k < blockSizeElements.length; k++)
                {
                    blockSize        = pageDocument.createElement("span");
                    blockSizeElement = blockSizeElements[k];
                    height           = blockSizeElement.offsetHeight;
                    left             = blockSizeElement.offsetLeft;
                    top              = blockSizeElement.offsetTop;
                    width            = blockSizeElement.offsetWidth;

                    blockSize.innerHTML = width + "x" + height;
                    blockSize.setAttribute("class", "webdeveloper-block-size");
                    blockSize.style.left = left + "px";
                    blockSize.style.position = "absolute";
                    blockSize.style.top = top + "px";

                    blockSizeElement.appendChild(blockSize);
                }
            }
        }
        else
        {
            const treeWalker = pageDocument.createTreeWalker(pageDocument.body, NodeFilter.SHOW_ELEMENT, webdeveloper_displayBlockSizeFilter, false);

            blockSizeElements = new Array();

            // Loop through the block size elements
            while((blockSizeElement = treeWalker.nextNode()) != null)
            {
                blockSizeElements.push(blockSizeElement);
            }

            // Loop through the block size elements
            for(j = 0; j < blockSizeElements.length; j++)
            {
                blockSizeElement = blockSizeElements[j];
                blockSizeElement.parentNode.removeChild(blockSizeElement);
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_block_size.css", "webdeveloper-display-block-size", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-block-size-tooltips", ".webdeveloper-block-size");
}

// Filter for display block size tree walker
function webdeveloper_displayBlockSizeFilter(node)
{
    // If the class of the node is webdeveloper block size
    if(node.getAttribute("class") == "webdeveloper-block-size")
    {
        return NodeFilter.FILTER_ACCEPT;
    }
    else
    {
        return NodeFilter.FILTER_SKIP;
    }
}

// Displays the elements ancestors in the status bar
function webdeveloper_displayElementAncestors(event)
{
    // If there is a target
    if(event.target)
    {
        window.content.status = webdeveloper_getElementAncestors(event.target, "");

        event.preventDefault();
    }
}

// Displays/hides the form details for the page
function webdeveloper_displayFormDetails(element, applyStyle)
{
    const display      = element.getAttribute("checked");
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var inputElement     = null;
    var inputElementList = null;
    var pageDocument     = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        inputElementList = pageDocument.getElementsByTagName("input");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If displaying and the element is hidden
            if(display && inputElement.hasAttribute("type") && inputElement.getAttribute("type") == "hidden")
            {
                inputElement.setAttribute("type", "text");

                // If the element has a class attribute
                if(inputElement.hasAttribute("class"))
                {
                    inputElement.setAttribute("class", inputElement.getAttribute("class") + " webdeveloper-unhidden");
                }
                else
                {
                    inputElement.setAttribute("class", "webdeveloper-unhidden");
                }
            }
            else if(inputElement.hasAttribute("class") && inputElement.getAttribute("class").indexOf("webdeveloper-unhidden") != -1)
            {
                inputElement.setAttribute("type", "hidden");
                inputElement.setAttribute("class", webdeveloper_trim(webdeveloper_removeSubstring(inputElement.getAttribute("class"), "webdeveloper-unhidden")));
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_form_details.css", "webdeveloper-display-form-details", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-form-details-tooltips", "*:before");
}

// Displays ID and class details for the page
function webdeveloper_displayIDClassDetails(element, applyStyle)
{
    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        const documentList       = webdeveloper_getDocuments(window.content, new Array());
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

        var headElementList = null;
        var pageDocument    = null;
        var styleElement    = null;

        // Loop through the documents
        for(var i = 0; i < documentList.length; i++)
        {
            pageDocument    = documentList[i];
            headElementList = pageDocument.getElementsByTagName("head");
            styleElement    = pageDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-display-id-class-details");
            styleElement.setAttribute("type", "text/css");

            // If the class colors are set
            if(preferencesService.prefHasUserValue("webdeveloper.color.class.background") && preferencesService.prefHasUserValue("webdeveloper.color.class.text"))
            {
                styleElement.appendChild(pageDocument.createTextNode("*[class]:before { background-color: " + webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.class.background")) + " !important; color: " + webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.class.text")) + ' !important; content: "class=" attr(class) !important; }'));
            }

            // If the ID colors are set
            if(preferencesService.prefHasUserValue("webdeveloper.color.id.background") && preferencesService.prefHasUserValue("webdeveloper.color.id.text"))
            {
                styleElement.appendChild(pageDocument.createTextNode("*[id]:before { background-color: " + webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.id.background")) + " !important; color: " + webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.id.text")) + ' !important; content: "id=" attr(id) !important; }'));
            }

            // If the ID and class colors are set
            if(preferencesService.prefHasUserValue("webdeveloper.color.id.class.background") && preferencesService.prefHasUserValue("webdeveloper.color.id.class.text"))
            {
                styleElement.appendChild(pageDocument.createTextNode("*[id][class]:before { background-color: " + webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.id.class.background")) + " !important; color: " + webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.id.class.text")) + ' !important; content: "id=" attr(id) ", class=" attr(class) !important; }'));
            }

            // If there is a head element
            if(headElementList.length > 0)
            {
                headElementList[0].appendChild(styleElement);
            }
            else
            {
                pageDocument.documentElement.childNodes[0].appendChild(styleElement);
            }
        }

        // If applying styles
        if(applyStyle)
        {
            webdeveloper_addAppliedStyle("webdeveloper-display-id-class-details");
        }
    }
    else
    {
        webdeveloper_removeStyleSheet("webdeveloper-display-id-class-details", true);
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/imports/before.css", "webdeveloper-display-id-class-details-before", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-id-class-details-tooltips", "*:before");
}

// Displays all image dimensions
function webdeveloper_displayImageDimensions(element, applyStyle)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const heightText   = stringBundle.getString("webdeveloper_height");
    const widthText    = stringBundle.getString("webdeveloper_width");

    var classValue       = null;
    var dimensions       = null;
    var height           = null;
    var imageElement     = null;
    var imageElementList = null;
    var pageDocument     = null;
    var spanElement      = null;
    var spanElementList  = null;
    var width            = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageElementList = pageDocument.getElementsByTagName("img");
        spanElementList  = pageDocument.getElementsByTagName("span");

        // Loop through all the span tags
        for(var j = 0; j < spanElementList.length; j++)
        {
            spanElement = spanElementList[j];
            classValue  = spanElement.getAttribute("class");

            // If the class exists and is set to webdeveloper-path-span
            if(classValue && classValue == "webdeveloper-dimensions-span")
            {
                spanElement.parentNode.removeChild(spanElement);
                j--;
            }
        }

        // Loop through all the img tags
        for(j = 0; j < imageElementList.length; j++)
        {
            imageElement = imageElementList[j];
            height       = imageElement.getAttribute("height");
            spanElement  = pageDocument.createElement("span");
            width        = imageElement.getAttribute("width");

            // If the width and height are set
            if(width && height)
            {
                dimensions = width + "x" + height;
            }
            else if(width)
            {
                dimensions = widthText + "=" + width;
            }
            else if(height)
            {
                dimensions = heightText + "=" + height;
            }

            // If the element is checked and the dimensions are set
            if(element.getAttribute("checked") && dimensions)
            {
                spanElement.setAttribute("class", "webdeveloper-dimensions-span");
                spanElement.appendChild(document.createTextNode(dimensions));
                imageElement.parentNode.insertBefore(spanElement, imageElement);
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_image_dimensions.css", "webdeveloper-display-image-dimensions", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-image-dimensions-tooltips", ".webdeveloper-dimensions-span");
}

// Displays all image paths
function webdeveloper_displayImagePaths(element, applyStyle)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const srcText      = stringBundle.getString("webdeveloper_src");

    var classValue       = null;
    var imageElement     = null;
    var imageElementList = null;
    var pageDocument     = null;
    var spanElement      = null;
    var spanElementList  = null;
    var src              = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageElementList = pageDocument.getElementsByTagName("img");
        spanElementList  = pageDocument.getElementsByTagName("span");

        // Loop through all the span tags
        for(var j = 0; j < spanElementList.length; j++)
        {
            spanElement = spanElementList[j];
            classValue  = spanElement.getAttribute("class");

            // If the class exists and is set to webdeveloper-path-span
            if(classValue && classValue == "webdeveloper-path-span")
            {
                spanElement.parentNode.removeChild(spanElement);
                j--;
            }
        }

        // Loop through all the img tags
        for(j = 0; j < imageElementList.length; j++)
        {
            imageElement = imageElementList[j];
            spanElement  = pageDocument.createElement("span");
            src          = imageElement.getAttribute("src");

            // If the element is checked and the src is set
            if(element.getAttribute("checked") && src)
            {
                spanElement.setAttribute("class", "webdeveloper-path-span");
                spanElement.appendChild(document.createTextNode(srcText + "=" + src));
                imageElement.parentNode.insertBefore(spanElement, imageElement);
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_image_paths.css", "webdeveloper-display-image-paths", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-image-paths-tooltips", ".webdeveloper-path-span");
}

// Displays all link paths
function webdeveloper_displayLinkPaths(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_link_paths.css", "webdeveloper-display-link-paths", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-link-paths-tooltips", "*:before");
}

// Displays the resize menu
function webdeveloper_displayResizeMenu(menu, separatorName, tooltips)
{
    const resizeSeparator    = document.getElementById(separatorName);
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var description           = null;
    var descriptionPreference = null;
    var height                = null;
    var menuItem              = document.createElement("menuitem");
    var width                 = null;

    webdeveloper_removeGeneratedMenuItems(menu);

    // Loop through the possible resize settings
	for(var i = 1; i <= 4; i++)
	{
        description = "webdeveloper.resize." + i + ".description";
        height      = "webdeveloper.resize." + i + ".height";
        width       = "webdeveloper.resize." + i + ".width";

        // If the description, width and height are set
        if(preferencesService.prefHasUserValue(description) && preferencesService.prefHasUserValue(width) && preferencesService.prefHasUserValue(height))
        {
            descriptionPreference = webdeveloper_trim(preferencesService.getCharPref(description));

            // If the description is not blank
            if(descriptionPreference != "")
            {
                menuItem = document.createElement("menuitem");
                menuItem.setAttribute("class", "webdeveloper-generated-menu");
                menuItem.setAttribute("label", descriptionPreference);
                menuItem.setAttribute("oncommand", "webdeveloper_resizeWindow(" + preferencesService.getIntPref(width) + ", " + preferencesService.getIntPref(height) + ")");

                // If displaying tooltips
                if(tooltips)
                {
                    menuItem.setAttribute("tooltiptext", descriptionPreference);
                }

                menu.insertBefore(menuItem, resizeSeparator);
            }
        }
	}
}

// Displays a style sheet
function webdeveloper_displayStyleSheet(pageDocument, styleSheet, generatedPage)
{
    const request        = new XMLHttpRequest();
    const styleSheetHref = styleSheet.href;

    var cssRule       = null;
    var headerElement = null;
    var linkElement   = null;
    var preElement    = null;

    // If the style sheet href is the current document
    if(styleSheetHref == pageDocument.URL)
    {
        const stringBundle = document.getElementById("webdeveloper-string-bundle");

        headerElement = generatedPage.content.document.createElement("h2");
        headerElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getFormattedString("webdeveloper_inlineStyles", [styleSheetHref])));
        generatedPage.content.document.body.appendChild(headerElement);

        // Loop through the the style sheet rules
        for(var k = 0; k < styleSheet.cssRules.length; k++)
        {
            cssRule = styleSheet.cssRules[k];

            preElement = generatedPage.content.document.createElement("pre");
            preElement.appendChild(generatedPage.content.document.createTextNode(cssRule.cssText));
            generatedPage.content.document.body.appendChild(preElement);
        }
    }
    else
    {
        request.open("GET", styleSheetHref, false);
        request.send("");

        headerElement = generatedPage.content.document.createElement("h2");
        linkElement   = generatedPage.content.document.createElement("a");
        linkElement.setAttribute("href", styleSheetHref);
        linkElement.appendChild(generatedPage.content.document.createTextNode(styleSheetHref));
        headerElement.appendChild(linkElement);
        generatedPage.content.document.body.appendChild(headerElement);

        preElement = generatedPage.content.document.createElement("pre");
        preElement.appendChild(generatedPage.content.document.createTextNode(request.responseText));
        generatedPage.content.document.body.appendChild(preElement);
    }

    // Loop through the the style sheet rules
    for(k = 0; k < styleSheet.cssRules.length; k++)
    {
        cssRule = styleSheet.cssRules[k];

        // If this is an import rule
        if(cssRule.type == 3)
        {
            webdeveloper_displayStyleSheet(pageDocument, cssRule.styleSheet, generatedPage);
        }
    }
}

// Displays all tab indices
function webdeveloper_displayTabIndex(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_tab_index.css", "webdeveloper-display-tab-index", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-display-tab-index-tooltips", "*:before");
}

// Displays the topographic information for all elements
function webdeveloper_displayTopographicInformation(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/display_topographic_information.css", "webdeveloper-display-topographic-information", applyStyle);
}

// Displays the current window size
function webdeveloper_displayWindowSize()
{
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    alert(stringBundle.getFormattedString("webdeveloper_displayWindowSize", [window.outerWidth, window.outerHeight, window.content.innerWidth, window.content.innerHeight]));
}

// Displays the current window size in the title bar
function webdeveloper_displayWindowSizeInTitle(element, applyStyle)
{
    const checked = element.getAttribute("checked");

    // If the menu is checked
    if(checked)
    {
        window.content.document.title += " - " + window.outerWidth + "x" + window.outerHeight;
        window.onresize                = webdeveloper_updateWindowSizeInTitle;
    }
    else
    {
        const title = window.content.document.title;

        window.content.document.title = title.substring(0, title.lastIndexOf(" - "));
        window.onresize               = null;
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-display-current-size-title", applyStyle);
}

// Allows the user to edit the CSS of the current page
function webdeveloper_editCSS(force)
{
    toggleSidebar("webdeveloper-sidebar", force);
}

// Enables form auto completion
function webdeveloper_enableFormAutoCompletion()
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    var enabledForms = 0;
    var form         = null;
    var formList     = null;
    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        formList     = pageDocument.forms;

        // Loop through all the forms
        for(var j = 0; j < formList.length; j++)
        {
            form = formList[j];

            // If this form has autocomplete off
            if(form.getAttribute("autocomplete") == "off")
            {
                form.setAttribute("autocomplete", "on");
                enabledForms++;
            }
        }
    }

    // If one form was enabled
    if(enabledForms == 1)
    {
        alert(stringBundle.getString("webdeveloper_enableAutoCompletionSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_enableAutoCompletionMultipleResult", [enabledForms]));
    }
}

// Enables the given preference
function webdeveloper_enablePreference(element, preference)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the element is checked - explicit if required
    if(checked)
    {
        preferencesService.setBoolPref(preference, true);
    }
    else
    {
        preferencesService.setBoolPref(preference, false);
    }

    webdeveloper_configureEquivalentElements(element, "checked", checked);
}

// Finds all the broken images on the page
function webdeveloper_findBrokenImages()
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const oldURL       = window.content.document.URL;
    const request      = new XMLHttpRequest();
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const title        = stringBundle.getFormattedString("webdeveloper_findBrokenImagesTitle", [oldURL]);

    var brokenURLs    = null;
    var generatedPage = null;
    var headerElement = null;
    var image         = null;
    var imageList     = null;
    var linkElement   = null;
    var pageDocument  = null;
    var pElement      = null;
    var preElement    = null;

    generatedPage = webdeveloper_generatePage("about:blank");

    // This must be done to make generated content render
    request.open("GET", oldURL, false);
    request.send("");

    generatedPage.content.document.title = title;

    linkElement = generatedPage.content.document.createElement("link");
    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated_content.css");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    generatedPage.content.document.getElementsByTagName("head")[0].appendChild(linkElement);

    headerElement = generatedPage.content.document.createElement("h1");
    headerElement.appendChild(generatedPage.content.document.createTextNode(title));
    generatedPage.content.document.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        brokenURLs   = "";
        pageDocument = documentList[i];
        imageList    = pageDocument.images;

        headerElement = generatedPage.content.document.createElement("h2");
        linkElement   = generatedPage.content.document.createElement("a");
        linkElement.setAttribute("href", pageDocument.URL);
        linkElement.appendChild(generatedPage.content.document.createTextNode(pageDocument.URL));
        headerElement.appendChild(linkElement);
        generatedPage.content.document.body.appendChild(headerElement);

        // Loop through all the images
        for(var j = 0; j < imageList.length; j++)
        {
            image = imageList[j];

            // If the image is broken
            if(!image.naturalWidth)
            {
                brokenURLs += "\n" + image.src;
            }
        }

        // If there are no broken images
        if(brokenURLs == "")
        {
            pElement = generatedPage.content.document.createElement("p");
            pElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_noBrokenImages")));
            generatedPage.content.document.body.appendChild(pElement);
        }
        else
        {
            preElement = generatedPage.content.document.createElement("pre");
            preElement.appendChild(generatedPage.content.document.createTextNode(brokenURLs));
            generatedPage.content.document.body.appendChild(preElement);
        }
    }
}

// Generates a page in a new tab or window
function webdeveloper_generatePage(url)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var generatedPage = null;

    // If the open in windows preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.open.windows") && preferencesService.getBoolPref("webdeveloper.open.windows"))
    {
        generatedPage = window.open(url);
    }
    else
    {
        var newTab = getBrowser().addTab(url);

        getBrowser().selectedTab = newTab;
        generatedPage = window;
    }

    return generatedPage;
}

// Get the cookies
function webdeveloper_getCookies(host, sort)
{
    const cookieEnumeration = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager).enumerator;

    var cookies = new Array();

    // Loop through the cookies
    while(cookieEnumeration.hasMoreElements())
    {
        const cookie = cookieEnumeration.getNext().QueryInterface(Components.interfaces.nsICookie);

        var cookieHost = cookie.host;

        // If there is a host for this cookie
        if(cookieHost)
        {
            // If the cookie host starts with '.'
            if(cookieHost.charAt(0) == ".")
            {
                cookieHost = cookieHost.substring(1);
            }

            // If the host and cookie host match
            if(host == cookieHost || host.indexOf("." + cookieHost) != -1)
            {
                cookies.push(cookie);
            }
        }
    }

    // If sorting cookies
    if(sort)
    {
        cookies.sort(webdeveloper_sortCookies);
    }

    return cookies;
}

// Gets all the documents from the current page
function webdeveloper_getDocuments(frame, documentList)
{
    const framesList = frame.frames;

    documentList.push(frame.document);

    // Loop through the frames
    for(var i = 0; i < framesList.length; i++)
    {
        webdeveloper_getDocuments(framesList[i], documentList);
    }

    return documentList;
}

// Get an elements ancestors
function webdeveloper_getElementAncestors(element, ancestorList)
{
    const classAttribute = element.getAttribute("class");
    const idAttribute    = element.getAttribute("id");
    const parentElement  = element.parentNode;

    var elementText = element.tagName.toLowerCase();

    // If there is a class attribute
    if(classAttribute)
    {
        elementText += "." + classAttribute;
    }

    // If there is an id attribute
    if(idAttribute)
    {
        elementText += "#" + idAttribute;
    }

    // If there is an ancestor list
    if(ancestorList)
    {
        elementText += " > " + ancestorList
    }

    // If there is a parent element with a tag name
    if(parentElement && parentElement.tagName)
    {
        return webdeveloper_getElementAncestors(parentElement, elementText);
    }
    else
    {
        return elementText;
    }
}

function webdeveloper_getLocaleValue(property)
{
    return document.getElementById("webdeveloper-string-bundle").getString(property);
}

// Hides/shows all the images
function webdeveloper_hideImages(element, id, applyStyle)
{
    const hide         = element.getAttribute("checked");
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var inputElement     = null;
    var inputElementList = null;
    var pageDocument     = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        inputElementList = pageDocument.getElementsByTagName("input");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If hiding images and the element is an image
            if(hide && inputElement.hasAttribute("type") && inputElement.getAttribute("type") == "image")
            {
                inputElement.setAttribute("type", "submit");

                // If the element has a class attribute
                if(inputElement.hasAttribute("class"))
                {
                    inputElement.setAttribute("class", inputElement.getAttribute("class") + " webdeveloper-image");
                }
                else
                {
                    inputElement.setAttribute("class", "webdeveloper-image");
                }
            }
            else if(inputElement.hasAttribute("class") && inputElement.getAttribute("class").indexOf("webdeveloper-image") != -1)
            {
                inputElement.setAttribute("type", "image");
                inputElement.setAttribute("class", webdeveloper_trim(webdeveloper_removeSubstring(inputElement.getAttribute("class"), "webdeveloper-image")));
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/hide_images.css", id, applyStyle);
}

// Initializes the extension
function webdeveloper_initialize()
{
    const documentContent    = document.getElementById("content");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the document content exists
    if(documentContent)
    {
        const tabBox = documentContent.mTabBox;

        tabBox.removeEventListener("select", webdeveloper_tabSelect, true);
        tabBox.addEventListener("select", webdeveloper_tabSelect, true);
    }

    window.removeEventListener("load", webdeveloper_pageLoad, true);
    window.removeEventListener("unload", webdeveloper_pageUnload, true);

    window.addEventListener("load", webdeveloper_pageLoad, true);
    window.addEventListener("unload", webdeveloper_pageUnload, true);

    // Set edit CSS font
    if(!preferencesService.prefHasUserValue("webdeveloper.edit.css.font"))
    {
        preferencesService.setIntPref("webdeveloper.edit.css.font", 12);
    }

    // Set default custom colors
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.1.color"))
    {
        preferencesService.setCharPref("webdeveloper.custom.1.color", "#ff0000");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.2.color"))
    {
        preferencesService.setCharPref("webdeveloper.custom.2.color", "#33ff33");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.3.color"))
    {
        preferencesService.setCharPref("webdeveloper.custom.3.color", "#3333ff");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.4.color"))
    {
        preferencesService.setCharPref("webdeveloper.custom.4.color", "#ff0000");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.custom.5.color"))
    {
        preferencesService.setCharPref("webdeveloper.custom.5.color", "#33ff33");
    }

    // Set default feature tooltip colors
    if(!preferencesService.prefHasUserValue("webdeveloper.color.feature.tooltip.text"))
    {
        preferencesService.setCharPref("webdeveloper.color.feature.tooltip.text", "#000000");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.feature.tooltip.background"))
    {
        preferencesService.setCharPref("webdeveloper.color.feature.tooltip.background", "#ffff99");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.feature.tooltip.opacity"))
    {
        preferencesService.setCharPref("webdeveloper.feature.tooltip.opacity", "0.7");
    }

    // Set default ID & class colors
    if(!preferencesService.prefHasUserValue("webdeveloper.color.class.text"))
    {
        preferencesService.setCharPref("webdeveloper.color.class.text", "#ffffff");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.class.background"))
    {
        preferencesService.setCharPref("webdeveloper.color.class.background", "#990000");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.id.text"))
    {
        preferencesService.setCharPref("webdeveloper.color.id.text", "#ffffff");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.id.background"))
    {
        preferencesService.setCharPref("webdeveloper.color.id.background", "#009900");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.id.class.text"))
    {
        preferencesService.setCharPref("webdeveloper.color.id.class.text", "#ffffff");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.color.id.class.background"))
    {
        preferencesService.setCharPref("webdeveloper.color.id.class.background", "#000099");
    }

    // Set default resize sizes
    if(!preferencesService.prefHasUserValue("webdeveloper.resize.1.description"))
    {
        preferencesService.setCharPref("webdeveloper.resize.1.description", "800x600");
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.resize.1.width"))
    {
        preferencesService.setIntPref("webdeveloper.resize.1.width", 800);
    }
    if(!preferencesService.prefHasUserValue("webdeveloper.resize.1.height"))
    {
        preferencesService.setIntPref("webdeveloper.resize.1.height", 600);
    }

    // Set default CSS validator
    if(!preferencesService.prefHasUserValue("webdeveloper.validator.css"))
    {
        preferencesService.setCharPref("webdeveloper.validator.css", "http://jigsaw.w3.org/css-validator/validator?profile=css2&warning=2&uri=");
    }

    // Set default HTML validator
    if(!preferencesService.prefHasUserValue("webdeveloper.validator.html"))
    {
        preferencesService.setCharPref("webdeveloper.validator.html", "http://validator.w3.org/check?verbose=1&uri=");
    }

    // Set default links validator
    if(!preferencesService.prefHasUserValue("webdeveloper.validator.links"))
    {
        preferencesService.setCharPref("webdeveloper.validator.links", "http://validator.w3.org/checklink?check=Check&hide_type=all&summary=on&uri=");
    }

    // Set default section 508 validator
    if(!preferencesService.prefHasUserValue("webdeveloper.validator.section508"))
    {
        preferencesService.setCharPref("webdeveloper.validator.section508", "http://www.contentquality.com/mynewtester/cynthia.exe?rptmode=-1&url1=");
    }

    // Set default WAI validator
    if(!preferencesService.prefHasUserValue("webdeveloper.validator.wai"))
    {
        preferencesService.setCharPref("webdeveloper.validator.wai", "http://www.contentquality.com/mynewtester/cynthia.exe?rptmode=2&url1=");
    }
}

// Loads the given URL
function webdeveloper_loadURL(url)
{
    webdeveloper_generatePage(url);
}

// Makes all the form fields writable
function webdeveloper_makeFormFieldsWritable()
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    var writableFields      = 0;
    var inputElement        = null;
    var inputElementType    = null;
    var inputElementList    = null;
    var pageDocument        = null;
    var textAreaElement     = null;
    var textAreaElementList = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument        = documentList[i];
        inputElementList    = pageDocument.getElementsByTagName("input");
        textAreaElementList = pageDocument.getElementsByTagName("textarea");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If the input element has a read only attribute
            if(inputElement.hasAttribute("readonly"))
            {
                inputElement.removeAttribute("readonly");
                writableFields++;
            }
        }

        // Loop through all the text area tags
        for(j = 0; j < textAreaElementList.length; j++)
        {
            textAreaElement = textAreaElementList[j];

            // If the text area element has a read only attribute
            if(textAreaElement.hasAttribute("readonly"))
            {
                textAreaElement.removeAttribute("readonly");
                writableFields++;
            }
        }
    }

    // If one field was made writable
    if(writableFields == 1)
    {
        alert(stringBundle.getString("webdeveloper_makeFormFieldsWritableSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_makeFormFieldsWritableMultipleResult", [writableFields]));
    }
}

// Makes all the images invisible
function webdeveloper_makeImagesInvisible(element, id, applyStyle)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const invisible    = element.getAttribute("checked");

    var image            = null;
    var imageList        = null;
    var inputElement     = null;
    var inputElementList = null;
    var pageDocument     = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageList        = pageDocument.images;
        inputElementList = pageDocument.getElementsByTagName("input");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If making images invisible and the element is an image
            if(invisible && inputElement.hasAttribute("type") && inputElement.getAttribute("type") == "image")
            {
                inputElement.setAttribute("type", "submit");

                // If the element has a class attribute
                if(inputElement.hasAttribute("class"))
                {
                    inputElement.setAttribute("class", inputElement.getAttribute("class") + " webdeveloper-image");
                }
                else
                {
                    inputElement.setAttribute("class", "webdeveloper-image");
                }
            }
            else if(inputElement.hasAttribute("class") && inputElement.getAttribute("class").indexOf("webdeveloper-image") != -1)
            {
                inputElement.setAttribute("type", "image");
                inputElement.setAttribute("class", webdeveloper_trim(webdeveloper_removeSubstring(inputElement.getAttribute("class"), "webdeveloper-image")));
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }

        // Loop through all the images
        for(j = 0; j < imageList.length; j++)
        {
            image = imageList[j];

            // If making images invisible
            if(invisible)
            {
                // If the image width is not set and the image is not broken
                if(!image.getAttribute("width") && image.naturalWidth)
                {
                    image.setAttribute("width", image.naturalWidth);
                }

                // If the image height is not set and the image is not broken
                if(!image.getAttribute("height") && image.naturalHeight)
                {
                    image.setAttribute("height", image.naturalHeight);
                }

                image.setAttribute("src", "chrome://webdeveloper/content/spacer.gif?" + image.getAttribute("src"));
            }
            else
            {
                image.setAttribute("src", webdeveloper_removeSubstring(image.getAttribute("src"), "chrome://webdeveloper/content/spacer.gif?"));
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/make_images_invisible.css", id, applyStyle);
}

// Opens the Java Console
function webdeveloper_openJavaConsole()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If Java is enabled
    if(preferencesService.getBoolPref("security.enable_java"))
    {
        Components.classes["@mozilla.org/oji/jvm-mgr;1"].getService(Components.interfaces.nsIJVMManager).showJavaConsole();
    }
    else
    {
        const stringBundle = document.getElementById("webdeveloper-string-bundle");

        alert(stringBundle.getString("webdeveloper_enableJavaConsole"));
    }
}

// Displays the options dialog
function webdeveloper_options()
{
    window.openDialog("chrome://webdeveloper/content/options/options.xul", "webdeveloper-options-dialog", "centerscreen,chrome,modal");

    webdeveloper_changeOptions();
}

// Outlines all block level elements
function webdeveloper_outlineBlockLevelElements(element, applyStyle)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_block_level_elements.css", "webdeveloper-outline-block-level-elements", applyStyle);

    // If the show outlined element names preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.outline.show.element.names") && preferencesService.getBoolPref("webdeveloper.outline.show.element.names"))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_block_level_elements_before.css", "webdeveloper-outline-block-level-elements-before", applyStyle);
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-block-level-elements-before-tooltips", "*:before");
    }
}

// Outlines the given element
function webdeveloper_outlineCustomElements(element)
{
    webdeveloper_outlinedElements = new Array();

    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        window.openDialog("chrome://webdeveloper/content/dialogs/outline_elements.xul", "webdeveloper-outline-elements-dialog", "centerscreen,chrome,modal", webdeveloper_outlinedElements);

        // If the user clicked cancel in the dialog
        if(webdeveloper_outlinedElements.length == 0)
        {
           element.removeAttribute("checked");
        }
    }

    webdeveloper_outlineElements(element, true);
}

// Outlines all deprecated elements
function webdeveloper_outlineDeprecatedElements(element, applyStyle)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_deprecated_elements.css", "webdeveloper-outline-deprecated-elements", applyStyle);

    // If the show outlined element names preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.outline.show.element.names") && preferencesService.getBoolPref("webdeveloper.outline.show.element.names"))
    {
        webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_deprecated_elements_before.css", "webdeveloper-outline-deprecated-elements-before", applyStyle);
        webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-deprecated-elements-before-tooltips", "*:before");
    }
}

// Outlines the given element
function webdeveloper_outlineElements(element, applyStyle)
{
    // If the menu is checked
    if(element.getAttribute("checked") && webdeveloper_outlinedElements.length > 0)
    {
        const documentList       = webdeveloper_getDocuments(window.content, new Array());
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

        var headElementList     = null;
        var outlineColor        = null;
        var outlineElement      = null;
        var outlineElementValue = null;
        var pageDocument        = null;
        var styleElement        = null;

        // Loop through the documents
        for(var i = 0; i < documentList.length; i++)
        {
            pageDocument    = documentList[i];
            headElementList = pageDocument.getElementsByTagName("head");
            styleElement    = pageDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-outline-custom-elements");
            styleElement.setAttribute("type", "text/css");

            // Loop through outline colors and elements
            for(var j = 0; j <= 5; j++)
            {
                outlineColor   = "webdeveloper.custom." + j + ".color";
                outlineElement = "webdeveloper.custom." + j + ".element";

                // If the color and element are set and not blank
                if(preferencesService.prefHasUserValue(outlineColor) && preferencesService.prefHasUserValue(outlineElement) && preferencesService.getCharPref(outlineColor) != "" && webdeveloper_trim(preferencesService.getCharPref(outlineElement)) != "")
                {
                    outlineElements = webdeveloper_trim(preferencesService.getCharPref(outlineElement)).split(",");

                    // Loop through the elements
                    for(var k = 0; k < outlineElements.length; k++)
                    {
                        outlineElementValue = outlineElements[k];
                        styleElement.appendChild(pageDocument.createTextNode(outlineElementValue + " { -moz-outline: 1px dotted " + preferencesService.getCharPref(outlineColor) + " !important; }"));

                        // If the show outlined element names preference is set
                        if(preferencesService.prefHasUserValue("webdeveloper.outline.show.element.names") && preferencesService.getBoolPref("webdeveloper.outline.show.element.names"))
                        {
                            styleElement.appendChild(pageDocument.createTextNode(outlineElementValue + ":before { content: \"<" + outlineElementValue + ">\" !important; }"));
                        }
                    }
                }
            }

            // If there is a head element
            if(headElementList.length > 0)
            {
                headElementList[0].appendChild(styleElement);
            }
            else
            {
                pageDocument.documentElement.childNodes[0].appendChild(styleElement);
            }
        }

        // If applying styles
        if(applyStyle)
        {
            webdeveloper_addAppliedStyle("webdeveloper-outline-custom-elements");
        }
    }
    else
    {
        webdeveloper_removeStyleSheet("webdeveloper-outline-custom-elements", true);
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/imports/before.css", "webdeveloper-outline-custom-elements-before", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-outline-custom-elements-before-tooltips", "*:before");
}

// Outlines all frames
function webdeveloper_outlineFrames(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_frames.css", "webdeveloper-outline-frames", applyStyle);
}

// Outlines all the images with empty alt attributes
function webdeveloper_outlineImagesWithEmptyAltAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_with_empty_alt_attributes.css", "webdeveloper-outline-images-with-empty-alt-attributes", applyStyle);
}

// Outlines all the images without alt attributes
function webdeveloper_outlineImagesWithoutAltAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_without_alt_attributes.css", "webdeveloper-outline-images-without-alt-attributes", applyStyle);
}

// Outlines all the images without title attributes
function webdeveloper_outlineImagesWithoutTitleAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_images_without_title_attributes.css", "webdeveloper-outline-images-without-title-attributes", applyStyle);
}

// Outlines all the links without title attributes
function webdeveloper_outlineLinksWithoutTitleAttributes(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_links_without_title_attributes.css", "webdeveloper-outline-links-without-title-attributes", applyStyle);
}

// Outlines all table cells
function webdeveloper_outlineTableCells(element, applyStyle)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/outline_table_cells.css", "webdeveloper-outline-table-cells", applyStyle);
}

// Handles the page being loaded
function webdeveloper_pageLoad(event)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var disable = false;

    // If the disabled preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.disabled"))
    {
        disable = preferencesService.getBoolPref("webdeveloper.disabled");
    }

    // If the page is the target
    if(event.target.getAttribute && event.target.getAttribute("id") == "content")
    {
        webdeveloper_changeOptions();

        // If the extension should be disabled, but is not
        if(disable && document.getElementById("webdeveloper-toggle-statusbar").getAttribute("tooltiptext") == "Disable Web Developer")
        {
            webdeveloper_disable(true);
        }
        else if(!disable)
        {
            const disableJavaPreference       = !preferencesService.getBoolPref("security.enable_java");
            const disableJavaScriptPreference = !preferencesService.getBoolPref("javascript.enabled");
            const disablePageColorsPreference = !preferencesService.getBoolPref("browser.display.use_document_colors");
            const javaScriptButton            = document.getElementById("webdeveloper-javascript-statusbar");

            var disableCookiesPreference         = false;
            var disableImagesPreference          = false;
            var disableImageAnimationsPreference = false;
            var disableReferrerPreference        = false;
            var element                          = null;
            var persistStyles                    = false;
            var textToolbar                      = false;

            // If the toolbar preference has a value and is set to text
            if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons") && preferencesService.getCharPref("webdeveloper.toolbar.icons") == "text")
            {
                textToolbar = true;
            }

            // If the JavaScript button exists and not already listening to the console
            if(javaScriptButton && !webdeveloper_javaScriptConsoleListener)
            {
                const consoleService = Components.classes["@mozilla.org/consoleservice;1"].getService().QueryInterface(Components.interfaces.nsIConsoleService);

                consoleService.unregisterListener(WebDeveloperJavaScriptConsoleListener);
                consoleService.registerListener(WebDeveloperJavaScriptConsoleListener);

                webdeveloper_javaScriptConsoleListener = true;
            }

            // Try to get the cookie preference
            try
            {
                // If the preference is set to 2
                if(preferencesService.getIntPref("network.cookie.cookieBehavior") == 2)
                {
                    disableCookiesPreference = true;
                }
            }
            catch(exception)
            {
                disableCookiesPreference = !preferencesService.getBoolPref("network.cookie.enable");
            }

            // If the image animation preference is set to none
            if(preferencesService.getCharPref("image.animation_mode") == "none")
            {
                disableImageAnimationsPreference = true;
            }

            // If the image preference is set to 2
            if(preferencesService.getIntPref("network.image.imageBehavior") == 2)
            {
                disableImagesPreference = true;
            }

            // If the referrer preference is set to 0
            if(preferencesService.getIntPref("network.http.sendRefererHeader") == 0)
            {
                disableReferrerPreference = true;
            }

            element = document.getElementById("webdeveloper-view-style-information-menu");

            // If the DOM inspector is not available and the view style information menu is enabled
            if(!Components.classes["@mozilla.org/inspector/dom-utils;1"] && !element.getAttribute("disabled"))
            {
                webdeveloper_configureEquivalentElements(element, "disabled", true);
            }

            element = document.getElementById("webdeveloper-disable-cookies-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableCookiesPreference);

            element = document.getElementById("webdeveloper-view-cookie-information-menu");
            webdeveloper_configureEquivalentElements(element, "disabled", disableCookiesPreference);

            element = document.getElementById("webdeveloper-disable-image-animations-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableImageAnimationsPreference);

            element = document.getElementById("webdeveloper-disable-images-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableImagesPreference);

            element = document.getElementById("webdeveloper-disable-java-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableJavaPreference);

            element = document.getElementById("webdeveloper-disable-javascript-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableJavaScriptPreference);

            element = document.getElementById("webdeveloper-disable-page-colors-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disablePageColorsPreference);

            element = document.getElementById("webdeveloper-disable-referrer-logging-menu");
            webdeveloper_configureEquivalentElements(element, "checked", disableReferrerPreference);

            // If the persist styles preference is set and is true
            if(preferencesService.prefHasUserValue("webdeveloper.styles.persist") && preferencesService.getBoolPref("webdeveloper.styles.persist"))
            {
                persistStyles = true;

                webdeveloper_applyStyleSheets(true);
            }
            else
            {
                webdeveloper_appliedStyles = new Array();
                webdeveloper_resetMenu(true);
            }

            element = document.getElementById("webdeveloper-persist-styles-menu");
            webdeveloper_configureEquivalentElements(element, "checked", persistStyles);

            element = document.getElementById("webdeveloper-render-mode-statusbar");

            // If the render mode button exists
            if(element)
            {
                const renderMode   = window.content.document.compatMode;
                const stringBundle = document.getElementById("webdeveloper-string-bundle");

                // If the render mode is quirks mode
                if(renderMode == "BackCompat")
                {
                    element.setAttribute("class", "quirks webdeveloper-statusbar-button");
                    element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_quirksModeTooltip"));

                    // If the toolbar is in text mode
                    if(textToolbar)
                    {
                        element.setAttribute("label", stringBundle.getString("webdeveloper_quirksModeLabel"));
                    }
                }
                else
                {
                    element.setAttribute("class", "webdeveloper-statusbar-button");
                    element.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_standardsComplianceModeTooltip"));

                    // If the toolbar is in text mode
                    if(textToolbar)
                    {
                        element.setAttribute("label", stringBundle.getString("webdeveloper_standardsComplianceModeLabel"));
                    }
                }
            }
        }
    }
}


// Handles the page being unloaded
function webdeveloper_pageUnload(event)
{
    const javaScriptButton = document.getElementById("webdeveloper-javascript-statusbar");

    // If the JavaScript button exists
    if(javaScriptButton)
    {
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
        const stringBundle       = document.getElementById("webdeveloper-string-bundle");

        javaScriptButton.setAttribute("class", "webdeveloper-statusbar-button");
        javaScriptButton.setAttribute("tooltiptext", stringBundle.getString("webdeveloper_javaScriptNoErrorsTooltip"));

        // If the toolbar preference has a value and is set to text
        if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons") && preferencesService.getCharPref("webdeveloper.toolbar.icons") == "text")
        {
            javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javaScriptNoErrorsLabel"));
        }
    }
}

// Populates the form fields on the page
function webdeveloper_populateFormFields()
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var inputElement        = null;
    var inputElementType    = null;
    var inputElementList    = null;
    var pageDocument        = null;
    var textAreaElement     = null;
    var textAreaElementList = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument        = documentList[i];
        inputElementList    = pageDocument.getElementsByTagName("input");
        textAreaElementList = pageDocument.getElementsByTagName("textarea");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement     = inputElementList[j];
            inputElementType = inputElement.getAttribute("type");

            // If the input element value is not set and has a password or text type
            if(webdeveloper_trim(inputElement.getAttribute("value")) == "" && (inputElementType == "password" || inputElementType == "text"))
            {
                inputElement.setAttribute("value", inputElement.getAttribute("name"));
            }
        }

        // Loop through all the text area tags
        for(j = 0; j < textAreaElementList.length; j++)
        {
            textAreaElement = textAreaElementList[j];

            // If the text area element value is not set
            if(webdeveloper_trim(textAreaElement.value) == "")
            {
                textAreaElement.value = textAreaElement.getAttribute("name");
            }
        }
    }
}

// Remove applied style
function webdeveloper_removeAppliedStyle(id)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the persist styles preference is set and is true
    if(preferencesService.prefHasUserValue("webdeveloper.styles.persist") && preferencesService.getBoolPref("webdeveloper.styles.persist"))
    {
        // Loop through the applied styles
        for(var i = 0; i < webdeveloper_appliedStyles.length; i++)
        {
            // If this style sheet is in the applied styles
            if(webdeveloper_appliedStyles[i] == id)
            {
                webdeveloper_appliedStyles.splice(i, 1);
            }
        }
    }
}

// Removes all the generated menu items from the menu
function webdeveloper_removeGeneratedMenuItems(menu)
{
    var menuItem  = null;
    var menuItems = menu.getElementsByAttribute("class", "webdeveloper-generated-menu");

    // Loop through the menu items
    for(var i = 0; i < menuItems.length; i++)
    {
        menu.removeChild(menuItems[i]);
    }

    menuItems = menu.getElementsByAttribute("class", "webdeveloper-generated-menu");

    // Loop through the menu items again because of the change to the behavior of getElementsByAttribute
    while(menuItems.length > 0)
    {
        menu.removeChild(menuItems[0]);
    }
}

// Removes the style sheet with the given id
function webdeveloper_removeStyleSheet(id, applyStyle)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var element      = null;
    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];

        // Remove all elements with that id
        while((element = pageDocument.getElementById(id)) != null)
        {
            element.parentNode.removeChild(element);
        }
    }

    // If applying style
    if(applyStyle)
    {
        webdeveloper_removeAppliedStyle(id);
    }
}

// Replaces all images with their alt attributes
function webdeveloper_replaceImagesWithAltAttributes(element, applyStyle)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var altAttribute     = null;
    var imageElement     = null;
    var imageElementList = null;
    var pageDocument     = null;
    var previousElement  = null;
    var spanElement      = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        imageElementList = pageDocument.getElementsByTagName("img");

        // Loop through all the img tags
        for(var j = 0; j < imageElementList.length; j++)
        {
            imageElement    = imageElementList[j];
            altAttribute    = imageElement.getAttribute("alt");
            previousElement = imageElement.previousSibling;
            spanElement     = pageDocument.createElement("span");

            // If the previous element is an element with class webdeveloper-alt-span
            if(previousElement && previousElement.nodeType == 1 && previousElement.getAttribute("class") == "webdeveloper-alt-span")
            {
                previousElement.parentNode.removeChild(previousElement);
            }

            // If the element is checked and the alt attribute exists
            if(element.getAttribute("checked") && altAttribute)
            {
                spanElement.setAttribute("class", "webdeveloper-alt-span");
                spanElement.appendChild(document.createTextNode(altAttribute));
                imageElement.parentNode.insertBefore(spanElement, imageElement);
            }
        }
    }

    webdeveloper_hideImages(element, "webdeveloper-replace-images-with-alt-attributes", applyStyle);
}

// Resets the menu
function webdeveloper_resetMenu(disableStylesMenu)
{
    var element = document.getElementById("webdeveloper-add-user-style-sheet-menu");

    webdeveloper_configureEquivalentElements(element, "checked", false);

    // If including the disable styles menu
    if(disableStylesMenu)
    {
        element = document.getElementById("webdeveloper-disable-styles-menu");
        webdeveloper_configureEquivalentElements(element, "checked", false);
    }

    element = document.getElementById("webdeveloper-display-access-keys-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-block-size-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-current-size-title-menu");

    // If the display current size in title menu is checked
    if(element.getAttribute("checked"))
    {
        window.onresize = null;
    }

    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-form-details-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-id-class-details-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-image-dimensions-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-image-paths-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-link-paths-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-tab-index-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-display-topographic-information-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-hide-images-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-make-images-invisible-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-block-level-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-custom-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-deprecated-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-frames-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-images-with-empty-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-images-without-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-images-without-title-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-links-without-title-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-outline-table-cells-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-replace-images-with-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-show-comments-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);

    element = document.getElementById("webdeveloper-view-style-information-menu");
    webdeveloper_configureEquivalentElements(element, "checked", false);
}

// Resets the page
function webdeveloper_resetPage()
{
    webdeveloper_resetMenu(true);
    webdeveloper_applyStyleSheets(false);

    webdeveloper_appliedStyles    = new Array();
    webdeveloper_outlinedElements = new Array();
}

// Resizes the window to the given width and height
function webdeveloper_resizeWindow(width, height)
{
    window.resizeTo(width, height);
}

// Retrieves the style sheet text from a style sheet
function webdeveloper_retrieveStyleSheetText(pageDocument, styleSheet)
{
    const mediaList      = styleSheet.media.mediaText;
    const request        = new XMLHttpRequest();
    const styleSheetHref = styleSheet.href;

    var cssRule    = null;
    var stylesText = "";

    // If this style sheet is for the screen and is not an alternate style sheet
    if((!mediaList || mediaList.indexOf("screen") != -1 || mediaList.indexOf("all") != -1) && (!styleSheet.ownerNode || styleSheet.ownerNode.getAttribute("rel") != "alternate stylesheet"))
    {
        // If the style sheet href is the current document
        if(styleSheetHref == pageDocument.URL)
        {
            const stringBundle = document.getElementById("webdeveloper-string-bundle");

            stylesText += "/* " + stringBundle.getFormattedString("webdeveloper_inlineStyles", [styleSheetHref]) + " */\n\n";

            // Loop through the the style sheet rules
            for(var k = 0; k < styleSheet.cssRules.length; k++)
            {
                cssRule = styleSheet.cssRules[k];

                // If this is not an import rule
                if(cssRule.type != 3)
                {
                    stylesText += cssRule.cssText + "\n\n";
                }
            }
        }
        else
        {
            request.open("GET", styleSheetHref, false);
            request.send("");

            stylesText += "/*  " + styleSheetHref + " */\n\n";
            stylesText += request.responseText;
        }

        // Loop through the the style sheet rules
        for(k = 0; k < styleSheet.cssRules.length; k++)
        {
            cssRule = styleSheet.cssRules[k];

            // If this is an import rule
            if(cssRule.type == 3)
            {
                stylesText += webdeveloper_retrieveStyleSheetText(pageDocument, cssRule.styleSheet);
            }
        }
    }

    return stylesText;
}

// Shows all passwords on a form
function webdeveloper_showPasswords()
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    var inputElement     = null;
    var inputElementList = null;
    var pageDocument     = null;
    var shownPasswords   = 0;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument     = documentList[i];
        inputElementList = pageDocument.getElementsByTagName("input");

        // Loop through all the input tags
        for(var j = 0; j < inputElementList.length; j++)
        {
            inputElement = inputElementList[j];

            // If the element is password
            if(inputElement.getAttribute("type") == "password")
            {
                inputElement.setAttribute("type", "text");
                shownPasswords++;
            }
            else
            {
                // This stops the fields reordering
                inputElement.setAttribute("type", inputElement.getAttribute("type"));
            }
        }
    }

    // If one password was shown
    if(shownPasswords == 1)
    {
        alert(stringBundle.getString("webdeveloper_showPasswordsSingleResult"));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_showPasswordsMultipleResult", [shownPasswords]));
    }
}

// Sorts two cookies
function webdeveloper_sortCookies(cookieOne, cookieTwo)
{
    const cookieOneHost = cookieOne.host;
    const cookieOneName = cookieOne.name;
    const cookieTwoHost = cookieTwo.host;
    const cookieTwoName = cookieOne.name;

    var sortValue = 1;

    // If the cookies are equal
    if(cookieOneHost == cookieTwoHost && cookieOneName == cookieTwoName)
    {
        sortValue = 0;
    }
    else if(cookieOneHost < cookieTwoHost || (cookieOneHost == cookieTwoHost && cookieOneName < cookieTwoName))
    {
        sortValue = -1;
    }

    return sortValue;
}

// Handles a tab being selected
function webdeveloper_tabSelect(event)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const selectedTab        = document.getElementById("content").mTabBox.selectedIndex;

    // If the selected tab is different
    if(selectedTab != webdeveloper_selectedTab)
    {
        webdeveloper_selectedTab = selectedTab;

        // If the persist styles preference is set and is true
        if(preferencesService.prefHasUserValue("webdeveloper.styles.persist") && preferencesService.getBoolPref("webdeveloper.styles.persist"))
        {
            webdeveloper_applyStyleSheets(false);
        }
        else
        {
            webdeveloper_updateMenu();
        }
    }
}

// Toggles comments
function webdeveloper_toggleComments(element, applyStyle)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const show         = element.getAttribute("checked");

    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        webdeveloper_toggleCommentsForDocument(pageDocument, show);
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/show_comments.css", "webdeveloper-show-comments", applyStyle);
    webdeveloper_toggleFeatureTooltipStyles(element, "webdeveloper-show-comments-tooltips", "div.webdeveloper-comment-icon, div.webdeveloper-comment-text, div.webdeveloper-comment-text *");
}

// Toggles cookies
function webdeveloper_toggleCookies(element)
{
    const checked                      = element.getAttribute("checked");
    const preferencesService           = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const viewCookieInformationElement = document.getElementById("webdeveloper-view-cookie-information-menu");

    // Try to get the cookie preference
    try
    {
        preferencesService.getIntPref("network.cookie.cookieBehavior");

        var cookieBehavior = 0;

        // If disabling cookies
        if(checked)
        {
            cookieBehavior = 2;
        }

        preferencesService.setIntPref("network.cookie.cookieBehavior", cookieBehavior);
    }
    catch(exception)
    {
        preferencesService.setBoolPref("network.cookie.enable", !checked);
    }

    webdeveloper_configureEquivalentElements(element, "checked", checked);

    webdeveloper_configureEquivalentElements(viewCookieInformationElement, "disabled", checked);
}

// Toggles the feature tooltip styles
function webdeveloper_toggleFeatureTooltipStyles(element, styleSheetId, selectors)
{
    webdeveloper_removeStyleSheet(styleSheetId, false);

    // If the menu is checked
    if(element.getAttribute("checked"))
    {
        const documentList       = webdeveloper_getDocuments(window.content, new Array());
        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
        const colors             = " background-color: " + preferencesService.getCharPref("webdeveloper.color.feature.tooltip.background") + " !important; color: " + preferencesService.getCharPref("webdeveloper.color.feature.tooltip.text") + " !important; ";
        const opacity            = " -moz-opacity: " + preferencesService.getCharPref("webdeveloper.feature.tooltip.opacity") + " !important; ";

        var headElementList = null;
        var pageDocument    = null;
        var styleElement    = null;

        // Loop through the documents
        for(var i = 0; i < documentList.length; i++)
        {
            pageDocument    = documentList[i];
            headElementList = pageDocument.getElementsByTagName("head");
            styleElement    = pageDocument.createElement("style");

            styleElement.appendChild(pageDocument.createTextNode(selectors + " {" + colors + opacity + "}"));
            styleElement.setAttribute("id", styleSheetId);
            styleElement.setAttribute("type", "text/css");

            // If there is a head element
            if(headElementList.length > 0)
            {
                headElementList[0].appendChild(styleElement);
            }
            else
            {
                pageDocument.documentElement.childNodes[0].appendChild(styleElement);
            }
        }
    }
}

// Toggles form methods
function webdeveloper_toggleFormMethods(method)
{
    const displayFormDetailsMenu = document.getElementById("webdeveloper-display-form-details-menu");
    const documentList           = webdeveloper_getDocuments(window.content, new Array());
    const stringBundle           = document.getElementById("webdeveloper-string-bundle");

    var convertedForms = 0;
    var form           = null;
    var formList       = null;
    var pageDocument   = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        formList     = pageDocument.forms;

        // Loop through all the forms
        for(var j = 0; j < formList.length; j++)
        {
            form = formList[j];

            // If this form is not already the right method
            if(form.getAttribute("method") != method)
            {
                form.setAttribute("method", method);
                convertedForms++;
            }
        }
    }

    // Reapply the display form details style sheet if it is currently on - fixes bug with form method not updating
    if(displayFormDetailsMenu.getAttribute("checked"))
    {
        webdeveloper_removeStyleSheet("webdeveloper-display-form-details", false);
        webdeveloper_displayFormDetails(displayFormDetailsMenu, false);
    }

    // If one form was converted
    if(convertedForms == 1)
    {
        alert(stringBundle.getFormattedString("webdeveloper_toggleFormMethodsSingleResult", [method.toUpperCase()]));
    }
    else
    {
        alert(stringBundle.getFormattedString("webdeveloper_toggleFormMethodsMultipleResult", [convertedForms, method.toUpperCase()]));
    }
}

// Toggles image animations
function webdeveloper_toggleImageAnimations(element)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var imageBehavior = "normal";

    // If disabling images
    if(checked)
    {
        imageBehavior = "none";
    }

    preferencesService.setCharPref("image.animation_mode", imageBehavior);

    webdeveloper_configureEquivalentElements(element, "checked", checked);
    BrowserReloadSkipCache();
}

// Toggles images
function webdeveloper_toggleImages(element)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var imageBehavior = 0;

    // If disabling images
    if(checked)
    {
        imageBehavior = 2;
    }

    preferencesService.setIntPref("network.image.imageBehavior", imageBehavior);

    webdeveloper_configureEquivalentElements(element, "checked", checked);
    BrowserReloadSkipCache();
}

// Toggles all the inline styles in elements on the page
function webdeveloper_toggleInlineStyles(node, disable)
{
    // If the node exists and is an element
    if(node && node.nodeType == 1)
    {
        const childNodes = node.childNodes;

        // If disabling styles and the node has a style attribute
        if(disable && node.hasAttribute("style"))
        {
            node.setAttribute("webdeveloper-inline-style", node.getAttribute("style"));
            node.removeAttribute("style");
        }
        else if(!disable && node.hasAttribute("webdeveloper-inline-style"))
        {
            node.setAttribute("style", node.getAttribute("webdeveloper-inline-style"));
            node.removeAttribute("webdeveloper-inline-style");
        }

        // Loop through the child nodes
        for(var i = 0; i < childNodes.length; i++)
        {
            webdeveloper_toggleInlineStyles(childNodes[i], disable);
        }
    }
}

// Toggles Java
function webdeveloper_toggleJava(element)
{
    const checked                = element.getAttribute("checked");
    const openJavaConsoleElement = document.getElementById("webdeveloper-open-java-console-menu");

    webdeveloper_disablePreference(element, "security.enable_java");

    webdeveloper_configureEquivalentElements(openJavaConsoleElement, "disabled", checked);
}

// Toggles the page colors
function webdeveloper_togglePageColors(element)
{
    webdeveloper_disablePreference(element, "browser.display.use_document_colors");
    BrowserReloadSkipCache();
}

// Toggles referrer logging
function webdeveloper_toggleReferrerLogging(element)
{
    const checked            = element.getAttribute("checked");
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var sendReferrer = 2;

    // If disabling referrer logging
    if(checked)
    {
        sendReferrer = 0;
    }

    preferencesService.setIntPref("network.http.sendRefererHeader", sendReferrer);

    webdeveloper_configureEquivalentElements(element, "checked", checked);
}

// Toggles the styles for the page
function webdeveloper_toggleStyles(element, applyStyle)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var disable        = null;
    var pageDocument   = null;
    var styleSheet     = null;
    var styleSheetList = null;

    // If the element is not set we are coming from a keyboard shortcut
    if(!element)
    {
        element = document.getElementById("webdeveloper-disable-styles-menu");

        // If the element has a checked attribute
        if(element.getAttribute("checked") == "true")
        {
            element.removeAttribute("checked");
        }
        else
        {
            element.setAttribute("checked", true);
        }
    }

    disable = element.getAttribute("checked");
    webdeveloper_configureEquivalentElements(element, "checked", disable);

    // Explictly convert the value of disable to a boolean
    if(disable == "true")
    {
        disable = true;
    }
    else
    {
        disable = false;
    }

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument   = documentList[i];
        styleSheetList = pageDocument.styleSheets;

        // Loop through all the stylesheets
        for(var j = 0; j < styleSheetList.length; j++)
        {
            styleSheet = styleSheetList[j];

            // If this is not an alternate style
            if(styleSheet.ownerNode.getAttribute("rel") != "alternate stylesheet")
            {
                styleSheet.disabled = disable;
            }
        }

        webdeveloper_toggleInlineStyles(pageDocument.documentElement, disable);
    }

    // If disabling styles
    if(disable)
    {
        webdeveloper_resetMenu(false);
    }
    else
    {
        webdeveloper_updateMenu();
    }

    // If applying styles
    if(applyStyle)
    {
        // If style sheets are being disabled
        if(disable)
        {
            webdeveloper_addAppliedStyle("webdeveloper-disable-styles");
        }
        else
        {
            webdeveloper_removeAppliedStyle("webdeveloper-disable-styles");
        }
    }
}

// Toggles the style sheet with the given id
function webdeveloper_toggleStyleSheet(element, location, id, applyStyle)
{
    const checked = element.getAttribute("checked");

    webdeveloper_configureEquivalentElements(element, "checked", checked);
    webdeveloper_removeStyleSheet(id, applyStyle);

    // If the menu is checked
    if(checked)
    {
        webdeveloper_addStyleSheet(location, id, applyStyle);
    }
}

// Toggles all links on the page between visited and unvisited
function webdeveloper_toggleVisitedLinks(visited)
{
    const browserHistory = Components.classes["@mozilla.org/browser/global-history;1"].getService(Components.interfaces.nsIBrowserHistory);
    const documentList   = webdeveloper_getDocuments(window.content, new Array());
    const globalHistory  = Components.classes["@mozilla.org/browser/global-history;1"].getService(Components.interfaces.nsIGlobalHistory);

    var href         = null;
    var link         = null;
    var linkList     = null;
    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        linkList     = pageDocument.links;

        // Loop through all the links
        for(var j = 0; j < linkList.length; j++)
        {
            link = linkList[j];
            href = link.href;

            // If this link has an href
            if(href)
            {
                // If marking links as visited
                if(visited && !globalHistory.isVisited(href))
                {
                    globalHistory.addPage(href);
                }
                else if(globalHistory.isVisited(href))
                {
                    browserHistory.removePage(href);
                }

                // Force the browser to recheck the history by changing the href
                link.href = "";
                link.href = href;
            }
        }
    }
}

// Updates the menu
function webdeveloper_updateMenu()
{
    const content                                       = document.getElementById("content");
    const currentDocument                               = content.browsers[content.mTabBox.selectedIndex].contentDocument;
    const addUserStylesheet                             = currentDocument.getElementById("webdeveloper-add-user-style-sheet");
    const displayAccessKeysStylesheet                   = currentDocument.getElementById("webdeveloper-display-access-keys");
    const displayBlockSizeStylesheet                    = currentDocument.getElementById("webdeveloper-display-block-size");
    const displayCurrentSizeTitleStylesheet             = currentDocument.getElementById("webdeveloper-display-current-size-title");
    const displayFormDetailsStylesheet                  = currentDocument.getElementById("webdeveloper-display-form-details");
    const displayIDClassDetailsStylesheet               = currentDocument.getElementById("webdeveloper-display-id-class-details");
    const displayImageDimensionsStylesheet              = currentDocument.getElementById("webdeveloper-display-image-dimensions");
    const displayImagePathsStylesheet                   = currentDocument.getElementById("webdeveloper-display-image-paths");
    const displayLinkPathsStylesheet                    = currentDocument.getElementById("webdeveloper-display-link-paths");
    const displayTabIndexStylesheet                     = currentDocument.getElementById("webdeveloper-display-tab-index");
    const displayTopographicInformationStylesheet       = currentDocument.getElementById("webdeveloper-display-tab-index");
    const hideImagesStylesheet                          = currentDocument.getElementById("webdeveloper-hide-images");
    const makeImagesInvisibleStylesheet                 = currentDocument.getElementById("webdeveloper-make-images-invisible");
    const outlineBlockLevelElementsStylesheet           = currentDocument.getElementById("webdeveloper-outline-block-level-elements");
    const outlineCustomElementsStylesheet               = currentDocument.getElementById("webdeveloper-outline-custom-elements");
    const outlineDeprecatedElementsStylesheet           = currentDocument.getElementById("webdeveloper-outline-deprecated-elements");
    const outlineFramesStylesheet                       = currentDocument.getElementById("webdeveloper-outline-frames");
    const outlineImagesWithEmptyAltAttributesStylesheet = currentDocument.getElementById("webdeveloper-outline-images-with-empty-alt-attributes");
    const outlineImagesWithoutAltAttributesStylesheet   = currentDocument.getElementById("webdeveloper-outline-images-without-alt-attributes");
    const outlineImagesWithoutTitleAttributesStylesheet = currentDocument.getElementById("webdeveloper-outline-images-without-title-attributes");
    const outlineLinksWithoutTitleAttributesStylesheet  = currentDocument.getElementById("webdeveloper-outline-links-without-title-attributes");
    const outlineTableCellsStylesheet                   = currentDocument.getElementById("webdeveloper-outline-table-cells");
    const replaceImagesWithAltAttributesStylesheet      = currentDocument.getElementById("webdeveloper-replace-images-with-alt-attributes");
    const showCommentsStylesheet                        = currentDocument.getElementById("webdeveloper-show-comments");
    const viewStyleInformationStylesheet                = currentDocument.getElementById("webdeveloper-view-style-information");

    var checked = false;
    var element = null;

    checked = addUserStylesheet && !addUserStylesheet.disabled;
    element = document.getElementById("webdeveloper-add-user-style-sheet-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayAccessKeysStylesheet && !displayAccessKeysStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-access-keys-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayBlockSizeStylesheet && !displayBlockSizeStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-block-size-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayCurrentSizeTitleStylesheet && !displayCurrentSizeTitleStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-current-size-title-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayFormDetailsStylesheet && !displayFormDetailsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-form-details-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayIDClassDetailsStylesheet && !displayIDClassDetailsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-id-class-details-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayImageDimensionsStylesheet && !displayImageDimensionsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-image-dimensions-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayImagePathsStylesheet && !displayImagePathsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-image-paths-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayLinkPathsStylesheet && !displayLinkPathsStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-link-paths-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayTabIndexStylesheet && !displayTabIndexStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-tab-index-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = displayTopographicInformationStylesheet && !displayTopographicInformationStylesheet.disabled;
    element = document.getElementById("webdeveloper-display-topographic-information-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = hideImagesStylesheet && !hideImagesStylesheet.disabled;
    element = document.getElementById("webdeveloper-hide-images-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = makeImagesInvisibleStylesheet && !makeImagesInvisibleStylesheet.disabled;
    element = document.getElementById("webdeveloper-make-images-invisible-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineBlockLevelElementsStylesheet && !outlineBlockLevelElementsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-block-level-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineCustomElementsStylesheet && !outlineCustomElementsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-custom-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineDeprecatedElementsStylesheet && !outlineDeprecatedElementsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-deprecated-elements-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineFramesStylesheet && !outlineFramesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-frames-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineImagesWithEmptyAltAttributesStylesheet && !outlineImagesWithEmptyAltAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-images-with-empty-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineImagesWithoutAltAttributesStylesheet && !outlineImagesWithoutAltAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-images-without-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineImagesWithoutTitleAttributesStylesheet && !outlineImagesWithoutTitleAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-images-without-title-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineLinksWithoutTitleAttributesStylesheet && !outlineLinksWithoutTitleAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-links-without-title-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = outlineTableCellsStylesheet && !outlineTableCellsStylesheet.disabled;
    element = document.getElementById("webdeveloper-outline-table-cells-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = replaceImagesWithAltAttributesStylesheet && !replaceImagesWithAltAttributesStylesheet.disabled;
    element = document.getElementById("webdeveloper-replace-images-with-alt-attributes-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = showCommentsStylesheet && !showCommentsStylesheet.disabled;
    element = document.getElementById("webdeveloper-show-comments-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);

    checked = viewStyleInformationStylesheet && !viewStyleInformationStylesheet.disabled;
    element = document.getElementById("webdeveloper-view-style-information-menu");
    webdeveloper_configureEquivalentElements(element, "checked", checked);
}

// Updates the window size in the title bar
function webdeveloper_updateWindowSizeInTitle()
{
    const title = window.content.document.title;

    window.content.document.title = title.substring(0, title.lastIndexOf(" - ")) + " - " + window.outerWidth + "x" + window.outerHeight;
}

// Validates local CSS
function webdeveloper_validateLocalCSS()
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const oldURL       = window.content.document.URL;
    const request      = new XMLHttpRequest();

    var cssRule        = null;
    var formElement    = null;
    var generatedPage  = null;
    var inputElement   = null;
    var pageDocument   = null;
    var styleSheet     = null;
    var styleSheetHref = null;
    var styleSheetList = null;
    var styleText      = "";

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument   = documentList[i];
        styleSheetList = pageDocument.styleSheets;

        // Loop through the style sheets
        for(var j = 0; j < styleSheetList.length; j++)
        {
            styleText += webdeveloper_retrieveStyleSheetText(pageDocument, styleSheetList[j]);
        }
    }

    generatedPage = webdeveloper_generatePage("about:blank");

    // This must be done to make generated content render
    request.open("GET", oldURL, false);
    request.send("");

    formElement = generatedPage.content.document.createElement("form")
    formElement.setAttribute("method", "get");
    formElement.setAttribute("action", "http://jigsaw.w3.org/css-validator/validator");

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "profile");
    inputElement.setAttribute("value", "css2");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "usermedium");
    inputElement.setAttribute("value", "all");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "warning");
    inputElement.setAttribute("value", "2");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input")
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "text");
    inputElement.setAttribute("value", styleText);
    formElement.appendChild(inputElement);

    generatedPage.content.document.body.appendChild(formElement);
    formElement.submit();
}

// Validates a local HTML file
function webdeveloper_validateLocalHTML()
{
    const oldURL  = window.content.document.URL;
    const request = new XMLHttpRequest();

    var formElement   = null;
    var generatedPage = null;
    var inputElement  = null;

    generatedPage = webdeveloper_generatePage("about:blank");

    // This must be done to make generated content render
    request.open("GET", oldURL, false);
    request.send("");

    formElement = generatedPage.content.document.createElement("form")
    formElement.setAttribute("method", "post");
    formElement.setAttribute("action", "http://www.htmlhelp.com/cgi-bin/validate.cgi");

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "input");
    inputElement.setAttribute("value", "yes");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input");
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "warnings");
    inputElement.setAttribute("value", "yes");
    formElement.appendChild(inputElement);

    inputElement = generatedPage.content.document.createElement("input")
    inputElement.setAttribute("type", "hidden");
    inputElement.setAttribute("name", "area");
    inputElement.setAttribute("value", request.responseText);
    formElement.appendChild(inputElement);

    generatedPage.content.document.body.appendChild(formElement);
    formElement.submit();
}

// Validates the page against the validator
function webdeveloper_validateURL(validator)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var validatorURL = "";

    // If the validator preference is set
    if(preferencesService.prefHasUserValue(validator) && webdeveloper_trim(preferencesService.getCharPref(validator)) != "")
    {
        validatorURL = webdeveloper_trim(preferencesService.getCharPref(validator));
    }
    else
    {
        const stringBundle = document.getElementById("webdeveloper-string-bundle");

        alert(stringBundle.getString("webdeveloper_validateURLConfigure"));
        webdeveloper_options();

        // If the validator preference is set
        if(preferencesService.prefHasUserValue(validator))
        {
            validatorURL = webdeveloper_trim(preferencesService.getCharPref(validator));
        }
    }

    // If the validator URL is not empty
    if(validatorURL != "")
    {
        webdeveloper_loadURL(validatorURL + escape(window.content.document.location.href));
    }
}

// Displays all the cookies for the page
function webdeveloper_viewCookieInformation()
{
    const dateService  = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].getService(Components.interfaces.nsIScriptableDateFormat);
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const oldURL       = window.content.document.URL;
    const request      = new XMLHttpRequest();
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const title        = stringBundle.getFormattedString("webdeveloper_viewCookieInformationTitle", [oldURL]);

    var cellDataElement   = null;
    var cellHeaderElement = null;
    var cookie            = null;
    var cookieExpires     = null;
    var cookieHost        = null;
    var cookieLength      = null;
    var cookies           = null;
    var date              = null;
    var generatedPage     = null;
    var headerElement     = null;
    var linkElement       = null;
    var pageDocument      = null;
    var pElement          = null;
    var preElement        = null;
    var tableElement      = null;
    var tableRowElement   = null;

    generatedPage = webdeveloper_generatePage("about:blank");

    // This must be done to make generated content render
    request.open("GET", oldURL, false);
    request.send("");

    generatedPage.content.document.title = title;

    linkElement = generatedPage.content.document.createElement("link");
    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated_content.css");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    generatedPage.content.document.getElementsByTagName("head")[0].appendChild(linkElement);

    headerElement = generatedPage.content.document.createElement("h1");
    headerElement.appendChild(generatedPage.content.document.createTextNode(title));
    generatedPage.content.document.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        cookies      = webdeveloper_getCookies(pageDocument.location.host, true);
        cookieLength = cookies.length;

        headerElement = generatedPage.content.document.createElement("h2");
        linkElement   = generatedPage.content.document.createElement("a");
        linkElement.setAttribute("href", pageDocument.URL);
        linkElement.appendChild(generatedPage.content.document.createTextNode(pageDocument.URL));
        headerElement.appendChild(linkElement);
        generatedPage.content.document.body.appendChild(headerElement);

        // If there are no cookies
        if(cookieLength == 0)
        {
            pElement = generatedPage.content.document.createElement("p");
            pElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_noCookies")));
            generatedPage.content.document.body.appendChild(pElement);
        }
        else
        {
            // Loop through the cookies
            for(var j = 0; j < cookieLength; j++)
            {
                cookie       = cookies[j];
                cookieHost   = cookie.host;
                tableElement = generatedPage.content.document.createElement("table");

                //  Cookie name
                cellDataElement   = generatedPage.content.document.createElement("td");
                cellHeaderElement = generatedPage.content.document.createElement("th");
                tableRowElement   = generatedPage.content.document.createElement("tr");

                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewCookieInformationName")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(cookie.name));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Cookie value
                cellDataElement   = generatedPage.content.document.createElement("td");
                cellHeaderElement = generatedPage.content.document.createElement("th");
                tableRowElement   = generatedPage.content.document.createElement("tr");

                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewCookieInformationValue")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(cookie.value));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                // If the cookie host starts with '.'
                if(cookieHost.charAt(0) == ".")
                {
                    cookieHost = cookieHost.substring(1);
                }

                //  Cookie host
                cellDataElement   = generatedPage.content.document.createElement("td");
                cellHeaderElement = generatedPage.content.document.createElement("th");
                tableRowElement   = generatedPage.content.document.createElement("tr");

                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewCookieInformationHost")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(cookieHost));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                //  Cookie path
                cellDataElement   = generatedPage.content.document.createElement("td");
                cellHeaderElement = generatedPage.content.document.createElement("th");
                tableRowElement   = generatedPage.content.document.createElement("tr");

                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewCookieInformationPath")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(cookie.path));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                // If the cookie has an expiration date
                if(cookie.expires)
                {
                    date          = new Date(cookie.expires * 1000);
                    cookieExpires = dateService.FormatDateTime("", dateService.dateFormatLong, dateService.timeFormatSeconds, date.getFullYear(), date.getMonth()+1, date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
                }
                else
                {
                    cookieExpires = stringBundle.getString("webdeveloper_viewCookieInformationSession");
                }

                //  Cookie expires
                cellDataElement   = generatedPage.content.document.createElement("td");
                cellHeaderElement = generatedPage.content.document.createElement("th");
                tableRowElement   = generatedPage.content.document.createElement("tr");

                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewCookieInformationExpires")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(cookieExpires));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                generatedPage.content.document.body.appendChild(tableElement);

                pElement = generatedPage.content.document.createElement("p");
                generatedPage.content.document.body.appendChild(pElement);
            }
        }
    }
}

// View CSS
function webdeveloper_viewCSS()
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const oldURL       = window.content.document.URL;
    const request      = new XMLHttpRequest();
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const title        = stringBundle.getFormattedString("webdeveloper_viewCSSTitle", [oldURL]);

    var generatedPage  = null;
    var headerElement  = null;
    var linkElement    = null;
    var pageDocument   = null;
    var styleSheetList = new Array();

    generatedPage = webdeveloper_generatePage("about:blank");

    // This must be done to make generated content render
    request.open("GET", oldURL, false);
    request.send("");

    generatedPage.content.document.title = title;

    linkElement = generatedPage.content.document.createElement("link");
    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated_content.css");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    generatedPage.content.document.getElementsByTagName("head")[0].appendChild(linkElement);

    headerElement = generatedPage.content.document.createElement("h1");
    headerElement.appendChild(generatedPage.content.document.createTextNode(title));
    generatedPage.content.document.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument   = documentList[i];
        styleSheetList = pageDocument.styleSheets;

        headerElement = generatedPage.content.document.createElement("h2");
        linkElement   = generatedPage.content.document.createElement("a");
        linkElement.setAttribute("href", pageDocument.URL);
        linkElement.appendChild(generatedPage.content.document.createTextNode(pageDocument.URL));
        headerElement.appendChild(linkElement);
        generatedPage.content.document.body.appendChild(headerElement);

        // Loop through the style sheets
        for(var j = 0; j < styleSheetList.length; j++)
        {
            webdeveloper_displayStyleSheet(pageDocument, styleSheetList[j], generatedPage);
        }
    }
}

// Displays all the forms for the page
function webdeveloper_viewFormInformation()
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const oldURL       = window.content.document.URL;
    const request      = new XMLHttpRequest();
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const title        = stringBundle.getFormattedString("webdeveloper_viewFormInformationTitle", [oldURL]);

    var cellDataElement   = null;
    var cellHeaderElement = null;
    var elementType       = null;
    var elementValue      = null;
    var form              = null;
    var formElement       = null;
    var formElementList   = null;
    var formLength        = null;
    var formList          = null;
    var headerElement     = null;
    var linkElement       = null;
    var pageDocument      = null;
    var pElement          = null;
    var preElement        = null;
    var ruleElement       = null;
    var tableElement      = null;
    var tableRowElement   = null;

    generatedPage = webdeveloper_generatePage("about:blank");

    // This must be done to make generated content render
    request.open("GET", oldURL, false);
    request.send("");

    generatedPage.content.document.title = title;

    linkElement = generatedPage.content.document.createElement("link");
    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated_content.css");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    generatedPage.content.document.getElementsByTagName("head")[0].appendChild(linkElement);

    headerElement = generatedPage.content.document.createElement("h1");
    headerElement.appendChild(generatedPage.content.document.createTextNode(title));
    generatedPage.content.document.body.appendChild(headerElement);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        formList     = pageDocument.forms;
        formLength   = formList.length;

        headerElement = generatedPage.content.document.createElement("h2");
        linkElement   = generatedPage.content.document.createElement("a");
        linkElement.setAttribute("href", pageDocument.URL);
        linkElement.appendChild(generatedPage.content.document.createTextNode(pageDocument.URL));
        headerElement.appendChild(linkElement);
        generatedPage.content.document.body.appendChild(headerElement);

        // If there are no forms
        if(formLength == 0)
        {
            pElement = generatedPage.content.document.createElement("p");
            pElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_noForms")));
            generatedPage.content.document.body.appendChild(pElement);
        }
        else
        {
            // Loop through the forms
            for(var j = 0; j < formLength; j++)
            {
                form            = formList[j];
                formElementList = form.elements;
                headerElement   = generatedPage.content.document.createElement("h2");
                ruleElement     = generatedPage.content.document.createElement("hr");
                tableElement    = generatedPage.content.document.createElement("table");
                tableRowElement = generatedPage.content.document.createElement("tr");

                headerElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationForm")));
                generatedPage.content.document.body.appendChild(headerElement);

                //  Form id heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationId")));
                tableRowElement.appendChild(cellHeaderElement);

                //  Form name heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationName")));
                tableRowElement.appendChild(cellHeaderElement);

                //  Form method heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationMethod")));
                tableRowElement.appendChild(cellHeaderElement);

                //  Form action heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationAction")));
                tableRowElement.appendChild(cellHeaderElement);
                tableElement.appendChild(tableRowElement);

                tableRowElement = generatedPage.content.document.createElement("tr");

                //  Form id
                cellDataElement = generatedPage.content.document.createElement("td");
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(form.getAttribute("id")));
                tableRowElement.appendChild(cellDataElement);

                //  Form name
                cellDataElement = generatedPage.content.document.createElement("td");
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(form.getAttribute("name")));
                tableRowElement.appendChild(cellDataElement);

                //  Form method
                cellDataElement = generatedPage.content.document.createElement("td");
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(form.getAttribute("method")));
                tableRowElement.appendChild(cellDataElement);

                //  Form action
                cellDataElement = generatedPage.content.document.createElement("td");
                cellDataElement.appendChild(generatedPage.content.document.createTextNode(form.getAttribute("action")));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                generatedPage.content.document.body.appendChild(tableElement);

                pElement = generatedPage.content.document.createElement("p");
                generatedPage.content.document.body.appendChild(pElement);

                headerElement = generatedPage.content.document.createElement("h2");
                tableElement  = generatedPage.content.document.createElement("table");
                tableRowElement = generatedPage.content.document.createElement("tr");

                headerElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationElements")));
                generatedPage.content.document.body.appendChild(headerElement);

                //  Element id heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationId")));
                tableRowElement.appendChild(cellHeaderElement);

                //  Element name heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationName")));
                tableRowElement.appendChild(cellHeaderElement);
                tableElement.appendChild(tableRowElement);

                //  Element type heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationType")));
                tableRowElement.appendChild(cellHeaderElement);
                tableElement.appendChild(tableRowElement);

                //  Element value heading
                cellHeaderElement = generatedPage.content.document.createElement("th");
                cellHeaderElement.appendChild(generatedPage.content.document.createTextNode(stringBundle.getString("webdeveloper_viewFormInformationValue")));
                tableRowElement.appendChild(cellHeaderElement);
                tableElement.appendChild(tableRowElement);

                // Loop through the form elements
                for(var k = 0; k < formElementList.length; k++)
                {
                    formElement     = formElementList[k];
                    elementType     = formElement.tagName.toLowerCase();
                    elementValue    = "";
                    tableRowElement = generatedPage.content.document.createElement("tr");

                    // If this is an input element
                    if(elementType == "input")
                    {
                        elementType  = formElement.getAttribute("type");
                        elementValue = formElement.value;
                    }
                    else if(elementType == "textarea")
                    {
                        elementValue = formElement.value;
                    }

                    //  Element id
                    cellDataElement = generatedPage.content.document.createElement("td");
                    cellDataElement.appendChild(generatedPage.content.document.createTextNode(formElement.getAttribute("id")));
                    tableRowElement.appendChild(cellDataElement);

                    //  Element name
                    cellDataElement = generatedPage.content.document.createElement("td");
                    cellDataElement.appendChild(generatedPage.content.document.createTextNode(formElement.getAttribute("name")));
                    tableRowElement.appendChild(cellDataElement);
                    tableElement.appendChild(tableRowElement);

                    //  Element type
                    cellDataElement = generatedPage.content.document.createElement("td");
                    cellDataElement.appendChild(generatedPage.content.document.createTextNode(elementType));
                    tableRowElement.appendChild(cellDataElement);
                    tableElement.appendChild(tableRowElement);

                    //  Element value
                    cellDataElement = generatedPage.content.document.createElement("td");
                    cellDataElement.appendChild(generatedPage.content.document.createTextNode(elementValue));
                    tableRowElement.appendChild(cellDataElement);
                    tableElement.appendChild(tableRowElement);
                }

                generatedPage.content.document.body.appendChild(tableElement);
                generatedPage.content.document.body.appendChild(ruleElement);
            }
        }
    }
}

// View page information
function webdeveloper_viewPageInformation(chromeLocation)
{
    window.openDialog(chromeLocation, "webdeveloper-page-information-dialog", "chrome,dialog=no,resizable", window.content.document);
}

// View the response headers
function webdeveloper_viewResponseHeaders()
{
    const oldURL       = window.content.document.URL;
    const request      = new XMLHttpRequest();
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const title        = stringBundle.getFormattedString("webdeveloper_viewResponseHeadersTitle", [oldURL]);

    var generatedPage   = null;
    var headerElement   = null;
    var linkElement     = null;
    var preElement      = null;
    var responseHeaders = null;

    generatedPage = webdeveloper_generatePage("about:blank");

    // This must be done to make generated content render
    request.open("GET", oldURL, false);
    request.send("");
    responseHeaders = request.getAllResponseHeaders();

    generatedPage.content.document.title = title;

    linkElement = generatedPage.content.document.createElement("link");
    linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated_content.css");
    linkElement.setAttribute("rel", "stylesheet");
    linkElement.setAttribute("type", "text/css");
    generatedPage.content.document.getElementsByTagName("head")[0].appendChild(linkElement);

    headerElement = generatedPage.content.document.createElement("h1");
    headerElement.appendChild(generatedPage.content.document.createTextNode(title));
    generatedPage.content.document.body.appendChild(headerElement);

    preElement = generatedPage.content.document.createElement("pre");
    preElement.appendChild(generatedPage.content.document.createTextNode(responseHeaders));
    generatedPage.content.document.body.appendChild(preElement);
}

// View source
function webdeveloper_viewSource()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the view source in tab preference is set to true
    if(preferencesService.prefHasUserValue("webdeveloper.view.source.tab") && preferencesService.getBoolPref("webdeveloper.view.source.tab"))
    {
        const newTab = getBrowser().addTab("view-source:" + window.content.document.URL);

        getBrowser().selectedTab = newTab;
    }
    else
    {
        BrowserViewSourceOfDocument(window.content.document);
    }
}

// View style information
function webdeveloper_viewStyleInformation(element, applyStyle)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var checked      = null;
    var pageDocument = null;

    // If the element is not set we are coming from a keyboard shortcut
    if(!element)
    {
        element = document.getElementById("webdeveloper-view-style-information-menu");

        if(element.getAttribute("checked"))
        {
            element.removeAttribute("checked");
        }
        else
        {
            element.setAttribute("checked", true);
        }
    }

    checked = element.getAttribute("checked");

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];

        // If viewing style information
        if(checked)
        {
            pageDocument.addEventListener("mouseover", webdeveloper_displayElementAncestors, true);
            pageDocument.addEventListener("click", webdeveloper_viewStyleInformationForElement, true);
        }
        else
        {
            pageDocument.removeEventListener("mouseover", webdeveloper_displayElementAncestors, true);
            pageDocument.removeEventListener("click", webdeveloper_viewStyleInformationForElement, true);
            window.content.status = null;
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/view_style_information.css", "webdeveloper-view-style-information", applyStyle);
}

// View style information for an element
function webdeveloper_viewStyleInformationForElement(event)
{
    // If there is an event target and the click was not a right click
    if(event.target && event.button != 2)
    {
        const domUtils     = Components.classes["@mozilla.org/inspector/dom-utils;1"].getService(Components.interfaces.inIDOMUtils);
        const oldURL       = window.content.document.URL;
        const request      = new XMLHttpRequest();
        const ruleList     = domUtils.getCSSStyleRules(event.target);
        const stringBundle = document.getElementById("webdeveloper-string-bundle");
        const title        = stringBundle.getFormattedString("webdeveloper_viewStyleInformationTitle", [oldURL]);

        var elementRule     = null;
        var generatedPage   = null;
        var headerElement   = null;
        var line            = null;
        var linkElement     = null;
        var preElement      = null;
        var styleRule       = null;
        var styleRuleList   = null;
        var styleSheetArray = new Array();
        var styleSheet      = null;
        var styleText       = null;

        generatedPage = webdeveloper_generatePage("about:blank");

        // This must be done to make generated content render
        request.open("GET", oldURL, false);
        request.send("");

        generatedPage.content.document.title = title;

        linkElement = generatedPage.content.document.createElement("link");
        linkElement.setAttribute("href", "chrome://webdeveloper/content/stylesheets/generated_content.css");
        linkElement.setAttribute("rel", "stylesheet");
        linkElement.setAttribute("type", "text/css");
        generatedPage.content.document.getElementsByTagName("head")[0].appendChild(linkElement);

        headerElement = generatedPage.content.document.createElement("h1");
        headerElement.appendChild(generatedPage.content.document.createTextNode(title));
        generatedPage.content.document.body.appendChild(headerElement);

        // Loop through the element rules
        for(var i = 0; i < ruleList.Count(); i++)
        {
            elementRule = ruleList.GetElementAt(i).QueryInterface(Components.interfaces.nsIDOMCSSStyleRule);
            line        = domUtils.getRuleLine(elementRule);

            // If there is a parent style sheet
            if(elementRule.parentStyleSheet)
            {
                styleSheet = elementRule.parentStyleSheet.href;
            }

            // If it's not a rule from the browser
            if(styleSheet && styleSheet.indexOf("resource://") == -1 && styleSheet.indexOf("about:PreferenceStyleSheet") == -1 && styleSheet.indexOf("jar:file://") == -1)
            {
                styleRuleList = elementRule.style;
                styleText     = elementRule.selectorText + "    (" + stringBundle.getString("webdeveloper_viewStyleInformationLine") + " " + line + ")\n{";

                // Loop through the style rules
                for(var j = 0; j < styleRuleList.length; j++)
                {
                    styleRule  = styleRuleList[j];
                    styleText += "\n    " + styleRule + ": " + styleRuleList.getPropertyValue(styleRule) + ";";
                }

                styleText += "\n}\n\n";

                // If this style sheet has rules already stored
                if(styleSheetArray[styleSheet])
                {
                    styleSheetArray[styleSheet] += styleText;
                }
                else
                {
                    styleSheetArray[styleSheet] = styleText;
                }
            }
        }

        // Loop through the style sheets
        for(styleSheet in styleSheetArray)
        {
            linkElement = generatedPage.content.document.createElement("a");
            linkElement.setAttribute("href", styleSheet);
            linkElement.appendChild(generatedPage.content.document.createTextNode(styleSheet));
            generatedPage.content.document.body.appendChild(linkElement);

            preElement = generatedPage.content.document.createElement("pre");
            preElement.appendChild(generatedPage.content.document.createTextNode(styleSheetArray[styleSheet]));
            generatedPage.content.document.body.appendChild(preElement);
        }

        event.preventDefault();
    }
}

// Zooms the content
function webdeveloper_zoom(factor)
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());

    var image        = null;
    var imageList    = null;
    var pageDocument = null;

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument = documentList[i];
        imageList    = pageDocument.images;

        webdeveloper_zoomText(pageDocument.documentElement, factor);

        // Loop through the images
        for(var j = 0; j < imageList.length; j++)
        {
            image = imageList[j];

            image.setAttribute("width", parseInt(image.getAttribute("width") * factor));
            image.setAttribute("height", parseInt(image.getAttribute("height") * factor));
        }
    }
}

// Zooms the text
function webdeveloper_zoomText(node, factor)
{
    const childNodeList = node.childNodes;
    const lineHeight    = window.getComputedStyle(node, "").getPropertyValue("line-height");
    const textSize      = window.getComputedStyle(node, "").getPropertyValue("font-size");

    var childNode = null;

    // Loop through the child nodes
    for(var i = 0; i < childNodeList.length; i++)
    {
        childNode = childNodeList[i];

        // If this is an element
        if(childNode.nodeType == 1)
        {
            webdeveloper_zoomText(childNode, factor);
        }
    }

    node.style.fontSize = parseInt(textSize.substr(0, textSize.length - 2) * factor) + "px";

    // If the line height is not normal
    if(lineHeight != "normal")
    {
        node.style.lineHeight = parseInt(lineHeight.substr(0, lineHeight.length - 2) * factor) + "px";
    }
}

// JavaScript console listener
var WebDeveloperJavaScriptConsoleListener =
{
    // Observes changes in the console
    observe: function(error)
    {
        // If the document, error and error message are set
        if(document && error && error.message)
        {
            const javaScriptButton = document.getElementById("webdeveloper-javascript-statusbar");

            // If the JavaScript button is set
            if(javaScriptButton)
            {
                // Try to convert the error to a script error
                try
                {
                    const tempError = error.QueryInterface(Components.interfaces.nsIScriptError);

                    // If the error category is set and is content javascript
                    if(error.category && error.category == "content javascript")
                    {
                        const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
                        const stringBundle       = document.getElementById("webdeveloper-string-bundle");
                        const warning            = error.flags & error.warningFlag != 0;

                        var textToolbar = false;

                        // If the toolbar preference has a value and is set to text
                        if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons") && preferencesService.getCharPref("webdeveloper.toolbar.icons") == "text")
                        {
                            textToolbar = true;
                        }

                        // If this is a warning
                        if(warning)
                        {
                            javaScriptButton.setAttribute("class", "warning webdeveloper-statusbar-button");
                            javaScriptButton.setAttribute("tooltiptext", stringBundle.getFormattedString("webdeveloper_javaScriptWarningTooltip", [error.message]));

                            // If the toolbar is in text mode
                            if(textToolbar)
                            {
                                javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javascriptWarningLabel"));
                            }
                        }
                        else
                        {
                            javaScriptButton.setAttribute("class", "error webdeveloper-statusbar-button");
                            javaScriptButton.setAttribute("tooltiptext", stringBundle.getFormattedString("webdeveloper_javaScriptErrorTooltip", [error.message]));

                            // If the toolbar is in text mode
                            if(textToolbar)
                            {
                                javaScriptButton.setAttribute("label", stringBundle.getString("webdeveloper_javascriptErrorLabel"));
                            }
                        }
                    }
                }
                catch(exception)
                {
                    // Do nothing
                }
            }
        }

        return false;
    }
}
