var webdeveloper_timeoutID = null;

// Clear the CSS
function webdeveloper_clearCSS()
{
    webdeveloper_getSelectedPanel().firstChild.value = "";
}

// Reinitializes the sidebar when the page changes
function webdeveloper_contentPageLoad(event)
{
    // If the page is the target
    if(event.target.getAttribute && event.target.getAttribute("id") == "content")
    {
        webdeveloper_resetCSS();
    }
}

// Handles a tab being selected
function webdeveloper_editCSSTabSelect(event)
{
    const selectedTab         = document.getElementById("webdeveloper-edit-css-tab-box").selectedTab;
    const nextTab             = selectedTab.nextSibling;
    const previousTab         = selectedTab.previousSibling;
    const selectedTabPosition = selectedTab.boxObject.y;

    // If the previous tab exists and is on a different row
    if(previousTab && previousTab.boxObject.y != selectedTabPosition)
    {
        previousTab.removeAttribute("beforeselected");
    }

    // If the next tab exists and is on a different row
    if(nextTab && nextTab.boxObject.y != selectedTabPosition)
    {
        nextTab.removeAttribute("afterselected");
    }
}

// Unloads edit CSS
function webdeveloper_editCSSUnload()
{
    const documentList = webdeveloper_getDocuments(window.content, new Array());
    const styleElement = window.content.document.getElementById("webdeveloper-edit-css-style");

    var pageDocument   = null;
    var styleSheet     = null;
    var styleSheetList = null;

    window.clearTimeout(webdeveloper_timeoutID);
    window.top.removeEventListener("load", webdeveloper_contentPageLoad, true);

    styleElement.parentNode.removeChild(styleElement);

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument   = documentList[i];
        styleSheetList = pageDocument.styleSheets;

        // Loop through all the stylesheets
        for(var j = 0; j < styleSheetList.length; j++)
        {
            styleSheet = styleSheetList[j];

            // If this is not an alternate style
            if(styleSheet.ownerNode.getAttribute("rel") != "alternate stylesheet")
            {
                styleSheet.disabled = false;
            }
        }
    }
}

// Returns the selected panel
function webdeveloper_getSelectedPanel()
{
    var selectedPanel = document.getElementById("webdeveloper-edit-css-tab-panels").selectedPanel;

    // If the selected panel is not set
    if(!selectedPanel)
    {
        selectedPanel = document.getElementById("webdeveloper-edit-css-tab-panels").firstChild;
    }

    return selectedPanel;
}

// Initializes the edit CSS sidebar
function webdeveloper_initializeEditCSS()
{
    const headElementList = window.content.document.getElementsByTagName("head");
    const tabBox          = document.getElementById("webdeveloper-edit-css-tab-box");
    const textBoxes       = document.getElementById("webdeveloper-edit-css-tab-panels").getElementsByTagName("textbox");

    var styleElement = window.content.document.createElement("style");
    var styleText    = "";

    window.top.removeEventListener("load", webdeveloper_contentPageLoad, true);
    window.top.addEventListener("load", webdeveloper_contentPageLoad, true);
    tabBox.removeEventListener("select", webdeveloper_editCSSTabSelect, true);
    tabBox.addEventListener("select", webdeveloper_editCSSTabSelect, true);

    webdeveloper_retrieveCSS();

    styleElement.setAttribute("id", "webdeveloper-edit-css-style");
    styleElement.setAttribute("type", "text/css");

    // If there is a head element
    if(headElementList.length > 0)
    {
        headElementList[0].appendChild(styleElement);
    }
    else
    {
        window.content.document.documentElement.childNodes[0].appendChild(styleElement);
    }

    // Loop through the text boxes
    for(var i = 0; i < textBoxes.length; i++)
    {
        styleText += textBoxes[i].value;
    }

    styleElement.innerHTML = styleText;

    webdeveloper_refreshStyles();
}

// Loads new CSS
function webdeveloper_loadCSS()
{
    const filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    const stringBundle = document.getElementById("webdeveloper-string-bundle");

    filePicker.appendFilter(stringBundle.getString("webdeveloper_styleSheetDescription"), "*.css");
    filePicker.init(window, stringBundle.getString("webdeveloper_editCSSLoadStyleSheetTitle"), filePicker.modeOpen);

    // If the user selected a style sheet
    if(filePicker.show() == filePicker.returnOK)
    {
        const inputStream      = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
        const scriptableStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);

        inputStream.init(filePicker.file, 0x01, 0444, null);
        scriptableStream.init(inputStream);

        webdeveloper_getSelectedPanel().firstChild.value = scriptableStream.read(scriptableStream.available());

        scriptableStream.close();
        inputStream.close();
    }
}

// Refreshes the styles on the page
function webdeveloper_refreshStyles()
{
    const styleElement = window.content.document.getElementById("webdeveloper-edit-css-style");
    const textBoxes    = document.getElementById("webdeveloper-edit-css-tab-panels").getElementsByTagName("textbox");

    var styleText = "";

    // Loop through the text boxes
    for(var i = 0; i < textBoxes.length; i++)
    {
        styleText += textBoxes[i].value;
    }

    // If the style element exists and the style text is different
    if(styleElement && styleText != styleElement.innerHTML)
    {
        styleElement.innerHTML = styleText;
    }

	webdeveloper_timeoutID = window.setTimeout(webdeveloper_refreshStyles, 250);
}

// Resets the edited CSS
function webdeveloper_resetCSS()
{
    const styleElement      = window.content.document.getElementById("webdeveloper-edit-css-style");
    const tabPanels         = document.getElementById("webdeveloper-edit-css-tab-panels");
    const tabPanelsChildren = tabPanels.childNodes;
    const tabs              = document.getElementById("webdeveloper-edit-css-tabs");
    const tabsChildren      = tabs.childNodes;

    // If the style element exists
    if(styleElement)
    {
        styleElement.parentNode.removeChild(styleElement);
    }

    // Loop through the tab panels
    for(var i = 0; i < tabPanelsChildren.length; i++)
    {
        tabPanels.removeChild(tabPanelsChildren[i]);
    }

    // Loop through the tabs
    for(i = 0; i < tabsChildren.length; i++)
    {
        tabs.removeChild(tabsChildren[i]);
    }

    webdeveloper_initializeEditCSS();
}

// Retrieves the CSS from the current page
function webdeveloper_retrieveCSS()
{
    const documentList       = webdeveloper_getDocuments(window.content, new Array());
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const tabs               = document.getElementById("webdeveloper-edit-css-tabs");
    const tabPanels          = document.getElementById("webdeveloper-edit-css-tab-panels");

    var mediaList      = null;
    var pageDocument   = null;
    var result         = null;
    var results        = new Array();
    var styleSheet     = null;
    var styleSheetList = null;
    var tab            = null;
    var tabPanel       = null;
    var textBox        = null;
    var textBoxStyle   = "";

    // If the edit CSS font preference is set
    if(preferencesService.prefHasUserValue("webdeveloper.edit.css.font"))
    {
        textBoxStyle = "font-size: " + preferencesService.getIntPref("webdeveloper.edit.css.font") + "px";
    }

    // Loop through the documents
    for(var i = 0; i < documentList.length; i++)
    {
        pageDocument   = documentList[i];
        styleSheetList = pageDocument.styleSheets;

        // Loop through the style sheets
        for(var j = 0; j < styleSheetList.length; j++)
        {
            styleSheet = styleSheetList[j];
            mediaList  = styleSheet.media.mediaText;

            // If this style sheet is for the screen and is not an alternate style sheet
            if((!mediaList || mediaList.indexOf("screen") != -1 || mediaList.indexOf("all") != -1) && (!styleSheet.ownerNode || styleSheet.ownerNode.getAttribute("rel") != "alternate stylesheet"))
            {
                webdeveloper_retrieveStyleSheetDetails(pageDocument, styleSheet, textBoxStyle, results);
            }
        }
    }

    // Loop through the results
    for(i = 0; i < results.length; i++)
    {
        result = results[i];

        tabs.appendChild(result[0]);
        tabPanels.appendChild(result[1]);
    }

    // If there are no tabs
    if(tabs.childNodes.length == 0)
    {
        const stringBundle = document.getElementById("webdeveloper-string-bundle");

        tab      = document.createElement("tab");
        tabPanel = document.createElement("tabpanel");
        textBox  = document.createElement("textbox");

        tab.setAttribute("label", stringBundle.getString("webdeveloper_editCSS"));
        textBox.setAttribute("flex", "1");
        textBox.setAttribute("multiline", "true");
        textBox.setAttribute("style", textBoxStyle);
        textBox.setAttribute("wrap", "true");

        tabs.appendChild(tab);
        tabPanel.appendChild(textBox);
        tabPanels.appendChild(tabPanel);
    }

    tabs.selectedIndex = 0;
}

// Retrieves the style sheet details
function webdeveloper_retrieveStyleSheetDetails(pageDocument, styleSheet, textBoxStyle, results)
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const styleSheetHref     = styleSheet.href;
    const position           = styleSheetHref.lastIndexOf("/");

    var cssRule    = null;
    var path       = styleSheetHref;
    var stylesText = "";
    var tab        = null;
    var tabPanel   = null;
    var textBox    = null;

    // Remove path from style sheet href
    if(position != -1)
    {
        path = styleSheetHref.substring(position + 1);
    }

    // If the style sheet href is the current document
    if(styleSheetHref == pageDocument.URL)
    {
        const stringBundle = document.getElementById("webdeveloper-string-bundle");

        tab      = document.createElement("tab");
        tabPanel = document.createElement("tabpanel");
        textBox  = document.createElement("textbox");

        // Loop through the the style sheet rules
        for(var i = 0; i < styleSheet.cssRules.length; i++)
        {
            cssRule = styleSheet.cssRules[i];

            // If this is not an import rule
            if(cssRule.type != 3)
            {
                stylesText += cssRule.cssText + "\n\n";
            }
        }

        tab.setAttribute("label", stringBundle.getString("webdeveloper_editCSSInlineStyles"));
        textBox.setAttribute("flex", "1");
        textBox.setAttribute("multiline", "true");
        textBox.setAttribute("style", textBoxStyle);
        textBox.setAttribute("wrap", "true");
        textBox.setAttribute("value", stylesText);
        tabPanel.appendChild(textBox);

        results.push(new Array(tab, tabPanel));
    }
    else
    {
        const request = new XMLHttpRequest();

        tab      = document.createElement("tab");
        tabPanel = document.createElement("tabpanel");
        textBox  = document.createElement("textbox");

        request.open("GET", styleSheetHref, false);
        request.send("");

        stylesText = request.responseText;

        tab.setAttribute("label", path);
        textBox.setAttribute("flex", "1");
        textBox.setAttribute("multiline", "true");
        textBox.setAttribute("style", textBoxStyle);
        textBox.setAttribute("wrap", "true");
        textBox.setAttribute("value", stylesText);
        tabPanel.appendChild(textBox);

        results.push(new Array(tab, tabPanel));
    }

    // Loop through the the style sheet rules
    for(i = 0; i < styleSheet.cssRules.length; i++)
    {
        cssRule = styleSheet.cssRules[i];

        // If this is an import rule
        if(cssRule.type == 3)
        {
            webdeveloper_retrieveStyleSheetDetails(pageDocument, cssRule.styleSheet, textBoxStyle, results);
        }
    }

    styleSheet.disabled = true;

    return results;
}

// Saves the CSS
function webdeveloper_saveCSS()
{
    const filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
    const stringBundle = document.getElementById("webdeveloper-string-bundle");
    const styleText    = webdeveloper_getSelectedPanel().firstChild.value;

    var result = null;

    filePicker.appendFilter(stringBundle.getString("webdeveloper_styleSheetDescription"), "*.css");
    filePicker.init(window, stringBundle.getString("webdeveloper_editCSSSaveStyleSheetTitle"), filePicker.modeSave);
    result = filePicker.show();

    // If the user selected a style sheet
    if(result == filePicker.returnOK || result == filePicker.returnReplace)
    {
        const outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

        // If the file does not exist
        if(!filePicker.file.exists())
        {
            filePicker.file.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 444);
        }

        outputStream.init(filePicker.file, 0x04, 0444, null);

        outputStream.write(styleText, styleText.length);
        outputStream.close();
    }
}