var webdeveloper_optionsDataBoolean = new Array();
var webdeveloper_optionsDataInteger = new Array();
var webdeveloper_optionsDataString  = new Array();

// Handles changing the options page
function webdeveloper_changePage(pageList)
{
    webdeveloper_storeOptions();

    document.getElementById("webdeveloper-options-iframe").setAttribute("src", pageList.selectedItem.getAttribute("value"));
}

// Initializes the colors page
function webdeveloper_initializeColors()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the feature tooltip text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.feature.tooltip.text").color = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.text"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.feature.tooltip.text"))
    {
        pageDocument.getElementById("webdeveloper.color.feature.tooltip.text").color = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.feature.tooltip.text"));
    }

    // If the feature tooltip background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.feature.tooltip.background").color = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.background"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.feature.tooltip.background"))
    {
        pageDocument.getElementById("webdeveloper.color.feature.tooltip.background").color = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.feature.tooltip.background"));
    }

    // If the feature tooltip opacity is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.feature.tooltip.opacity"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.opacity").value = webdeveloper_optionsDataString["webdeveloper.feature.tooltip.opacity"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.feature.tooltip.opacity"))
    {
        pageDocument.getElementById("webdeveloper.feature.tooltip.opacity").value = preferencesService.getCharPref("webdeveloper.feature.tooltip.opacity");
    }

    // If the class text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.class.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.class.text").color = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.color.class.text"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.class.text"))
    {
        pageDocument.getElementById("webdeveloper.color.class.text").color = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.class.text"));
    }

    // If the class background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.class.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.class.background").color = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.color.class.background"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.class.background"))
    {
        pageDocument.getElementById("webdeveloper.color.class.background").color = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.class.background"));
    }

    // If the ID text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.id.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.id.text").color = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.color.id.text"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.id.text"))
    {
        pageDocument.getElementById("webdeveloper.color.id.text").color = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.id.text"));
    }

    // If the ID background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.id.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.id.background").color = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.color.id.background"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.id.background"))
    {
        pageDocument.getElementById("webdeveloper.color.id.background").color = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.id.background"));
    }

    // If the ID and class text color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.id.class.text"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.id.class.text").color = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.color.id.class.text"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.id.class.text"))
    {
        pageDocument.getElementById("webdeveloper.color.id.class.text").color = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.id.class.text"));
    }

    // If the ID and class background color is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.color.id.class.background"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.color.id.class.background").color = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.color.id.class.background"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.color.id.class.background"))
    {
        pageDocument.getElementById("webdeveloper.color.id.class.background").color = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.color.id.class.background"));
    }
}

// Initializes the general page
function webdeveloper_initializeGeneral()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the open windows preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.open.windows"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.open.windows").checked = webdeveloper_optionsDataBoolean["webdeveloper.open.windows"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.open.windows"))
    {
        pageDocument.getElementById("webdeveloper.open.windows").checked = preferencesService.getBoolPref("webdeveloper.open.windows");
    }

    // If the view source in tab preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.view.source.tab"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.view.source.tab").checked = webdeveloper_optionsDataBoolean["webdeveloper.view.source.tab"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.view.source.tab"))
    {
        pageDocument.getElementById("webdeveloper.view.source.tab").checked = preferencesService.getBoolPref("webdeveloper.view.source.tab");
    }

    // If the hide menu preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.menu.hide"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.menu.hide").checked = webdeveloper_optionsDataBoolean["webdeveloper.menu.hide"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.menu.hide"))
    {
        pageDocument.getElementById("webdeveloper.menu.hide").checked = preferencesService.getBoolPref("webdeveloper.menu.hide");
    }

    // If the hide context menu preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.context.hide"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.context.hide").checked = webdeveloper_optionsDataBoolean["webdeveloper.context.hide"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.context.hide"))
    {
        pageDocument.getElementById("webdeveloper.context.hide").checked = preferencesService.getBoolPref("webdeveloper.context.hide");
    }

    // If the show outlined element names preference is set
    if(typeof webdeveloper_optionsDataBoolean["webdeveloper.outline.show.element.names"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.outline.show.element.names").checked = webdeveloper_optionsDataBoolean["webdeveloper.outline.show.element.names"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.outline.show.element.names"))
    {
        pageDocument.getElementById("webdeveloper.outline.show.element.names").checked = preferencesService.getBoolPref("webdeveloper.outline.show.element.names");
    }

    // If the toolbar icons preference is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.toolbar.icons"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.toolbar.icons").value = webdeveloper_optionsDataString["webdeveloper.toolbar.icons"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.toolbar.icons"))
    {
        pageDocument.getElementById("webdeveloper.toolbar.icons").value = preferencesService.getCharPref("webdeveloper.toolbar.icons");
    }
}

// Initializes the keyboard page
function webdeveloper_initializeKeyboard()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the disable styles key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.disable.styles"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.disable.styles").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.disable.styles"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.disable.styles"))
    {
        pageDocument.getElementById("webdeveloper.key.disable.styles").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.disable.styles"));
    }

    // If the JavaScript console key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.javascript.console"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.javascript.console").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.javascript.console"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.javascript.console"))
    {
        pageDocument.getElementById("webdeveloper.key.javascript.console").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.javascript.console"));
    }

    // If the sidebar key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.sidebar"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.sidebar").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.sidebar"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.sidebar"))
    {
        pageDocument.getElementById("webdeveloper.key.sidebar").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.sidebar"));
    }

    // If the validate HTML key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.validate.html"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.validate.html").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.validate.html"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.validate.html"))
    {
        pageDocument.getElementById("webdeveloper.key.validate.html").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.validate.html"));
    }

    // If the validate local HTML key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.validate.local.html"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.validate.local.html").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.validate.local.html"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.validate.local.html"))
    {
        pageDocument.getElementById("webdeveloper.key.validate.local.html").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.validate.local.html"));
    }

    // If the view CSS key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.view.css"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.view.css").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.view.css"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.view.css"))
    {
        pageDocument.getElementById("webdeveloper.key.view.css").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.view.css"));
    }

    // If the view source key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.view.source"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.view.source").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.view.source"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.view.source"))
    {
        pageDocument.getElementById("webdeveloper.key.view.source").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.view.source"));
    }

    // If the view style information key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.view.style.information"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.view.style.information").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.view.style.information"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.view.style.information"))
    {
        pageDocument.getElementById("webdeveloper.key.view.style.information").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.view.style.information"));
    }

    // If the zoom in key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.zoom.in"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.zoom.in").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.zoom.in"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.zoom.in"))
    {
        pageDocument.getElementById("webdeveloper.key.zoom.in").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.zoom.in"));
    }

    // If the zoom out key is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.key.zoom.out"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.key.zoom.out").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.key.zoom.out"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.key.zoom.out"))
    {
        pageDocument.getElementById("webdeveloper.key.zoom.out").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.key.zoom.out"));
    }
}

// Initializes the options dialog
function webdeveloper_initializeOptions()
{
    const selectedPage = document.getElementById("webdeveloper-page-list").selectedItem.getAttribute("value");

    // If this is the colors page
    if(selectedPage.indexOf("colors") != -1)
    {
        webdeveloper_initializeColors();
    }
    else if(selectedPage.indexOf("general") != -1)
    {
        webdeveloper_initializeGeneral();
    }
    else if(selectedPage.indexOf("keyboard") != -1)
    {
        webdeveloper_initializeKeyboard();
    }
    else if(selectedPage.indexOf("resize") != -1)
    {
        webdeveloper_initializeResize();
    }
    else if(selectedPage.indexOf("sidebar") != -1)
    {
        webdeveloper_initializeSidebar();
    }
    else if(selectedPage.indexOf("validators") != -1)
    {
        webdeveloper_initializeValidators();
    }
}

// Initializes the resize page
function webdeveloper_initializeResize()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var description = null;
    var height      = null;
    var width       = null;

    // Loop through the possible resize settings
    for(var i = 1; i <= 4; i++)
    {
        description = "webdeveloper.resize." + i + ".description";
        height      = "webdeveloper.resize." + i + ".height";
        width       = "webdeveloper.resize." + i + ".width";

        // If the description is set
        if(typeof webdeveloper_optionsDataString[description] != "undefined")
        {
            pageDocument.getElementById(description).value = webdeveloper_trim(webdeveloper_optionsDataString[description]);
        }
        else if(preferencesService.prefHasUserValue(description))
        {
            pageDocument.getElementById(description).value = webdeveloper_trim(preferencesService.getCharPref(description));
        }

        // If the width is set
        if(typeof webdeveloper_optionsDataInteger[width] != "undefined")
        {
            pageDocument.getElementById(width).value = webdeveloper_optionsDataInteger[width];
        }
        else if(preferencesService.prefHasUserValue(width))
        {
            pageDocument.getElementById(width).value = preferencesService.getIntPref(width);
        }

        // If the height is set
        if(typeof webdeveloper_optionsDataInteger[height] != "undefined")
        {
            pageDocument.getElementById(height).value = webdeveloper_optionsDataInteger[height];
        }
        else if(preferencesService.prefHasUserValue(height))
        {
            pageDocument.getElementById(height).value = preferencesService.getIntPref(height);
        }
    }
}

// Initializes the sidebar page
function webdeveloper_initializeSidebar()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the edit CSS font preference is set
    if(typeof webdeveloper_optionsDataInteger["webdeveloper.edit.css.font"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.edit.css.font").value = webdeveloper_optionsDataInteger["webdeveloper.edit.css.font"];
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.edit.css.font"))
    {
        pageDocument.getElementById("webdeveloper.edit.css.font").value = preferencesService.getIntPref("webdeveloper.edit.css.font");
    }
}

// Initializes the validators page
function webdeveloper_initializeValidators()
{
    const pageDocument       = document.getElementById("webdeveloper-options-iframe").contentDocument;
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    // If the CSS validator is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.validator.css"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validator.css").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.validator.css"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.validator.css"))
    {
        pageDocument.getElementById("webdeveloper.validator.css").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.validator.css"));
    }

    // If the HTML validator is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.validator.html"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validator.html").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.validator.html"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.validator.html"))
    {
        pageDocument.getElementById("webdeveloper.validator.html").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.validator.html"));
    }

    // If the links validator is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.validator.links"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validator.links").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.validator.links"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.validator.links"))
    {
        pageDocument.getElementById("webdeveloper.validator.links").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.validator.links"));
    }

    // If the section 508 validator is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.validator.section508"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validator.section508").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.validator.section508"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.validator.section508"))
    {
        pageDocument.getElementById("webdeveloper.validator.section508").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.validator.section508"));
    }

    // If the WAI validator is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.validator.wai"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validator.wai").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.validator.wai"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.validator.wai"))
    {
        pageDocument.getElementById("webdeveloper.validator.wai").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.validator.wai"));
    }

    // If the custom validator is set
    if(typeof webdeveloper_optionsDataString["webdeveloper.validator.custom"] != "undefined")
    {
        pageDocument.getElementById("webdeveloper.validator.custom").value = webdeveloper_trim(webdeveloper_optionsDataString["webdeveloper.validator.custom"]);
    }
    else if(preferencesService.prefHasUserValue("webdeveloper.validator.custom"))
    {
        pageDocument.getElementById("webdeveloper.validator.custom").value = webdeveloper_trim(preferencesService.getCharPref("webdeveloper.validator.custom"));
    }
}

// Saves the user's options
function webdeveloper_saveOptions()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var option      = null;
    var optionValue = null;

    // Make sure current page is stored
    webdeveloper_storeOptions();

    // Loop through the boolean options
    for(option in webdeveloper_optionsDataBoolean)
    {
        preferencesService.setBoolPref(option, webdeveloper_optionsDataBoolean[option]);
    }

    // Loop through the integer options
    for(option in webdeveloper_optionsDataInteger)
    {
        optionValue = webdeveloper_optionsDataInteger[option];

        // If the option value is set
        if(optionValue)
        {
            preferencesService.setIntPref(option, optionValue);
        }
        else if(preferencesService.prefHasUserValue(option))
        {
            preferencesService.clearUserPref(option);
        }
    }

    // Loop through the string options
    for(option in webdeveloper_optionsDataString)
    {
        optionValue = webdeveloper_optionsDataString[option];

        // If the option value is set or the preference currently has a value
        if(optionValue || preferencesService.prefHasUserValue(option))
        {
            preferencesService.setCharPref(option, optionValue);
        }
    }
}

// Stores the user's options to be saved later
function webdeveloper_storeOptions()
{
    const iFrame       = document.getElementById("webdeveloper-options-iframe");
    const iFrameSrc    = iFrame.getAttribute("src");
    const pageDocument = iFrame.contentDocument;

    // If this is the colors page
    if(iFrameSrc.indexOf("colors") != -1)
    {
        webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.text"]       = pageDocument.getElementById("webdeveloper.color.feature.tooltip.text").color;
        webdeveloper_optionsDataString["webdeveloper.color.feature.tooltip.background"] = pageDocument.getElementById("webdeveloper.color.feature.tooltip.background").color;
        webdeveloper_optionsDataString["webdeveloper.feature.tooltip.opacity"]          = pageDocument.getElementById("webdeveloper.feature.tooltip.opacity").value;
        webdeveloper_optionsDataString["webdeveloper.color.class.text"]                 = pageDocument.getElementById("webdeveloper.color.class.text").color;
        webdeveloper_optionsDataString["webdeveloper.color.class.background"]           = pageDocument.getElementById("webdeveloper.color.class.background").color;
        webdeveloper_optionsDataString["webdeveloper.color.id.text"]                    = pageDocument.getElementById("webdeveloper.color.id.text").color;
        webdeveloper_optionsDataString["webdeveloper.color.id.background"]              = pageDocument.getElementById("webdeveloper.color.id.background").color;
        webdeveloper_optionsDataString["webdeveloper.color.id.class.text"]              = pageDocument.getElementById("webdeveloper.color.id.class.text").color;
        webdeveloper_optionsDataString["webdeveloper.color.id.class.background"]        = pageDocument.getElementById("webdeveloper.color.id.class.background").color;
    }
    else if(iFrameSrc.indexOf("general") != -1)
    {
        webdeveloper_optionsDataBoolean["webdeveloper.open.windows"]               = pageDocument.getElementById("webdeveloper.open.windows").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.view.source.tab"]            = pageDocument.getElementById("webdeveloper.view.source.tab").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.menu.hide"]                  = pageDocument.getElementById("webdeveloper.menu.hide").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.context.hide"]               = pageDocument.getElementById("webdeveloper.context.hide").checked;
        webdeveloper_optionsDataBoolean["webdeveloper.outline.show.element.names"] = pageDocument.getElementById("webdeveloper.outline.show.element.names").checked;
        webdeveloper_optionsDataString["webdeveloper.toolbar.icons"]               = pageDocument.getElementById("webdeveloper.toolbar.icons").value;
    }
    else if(iFrameSrc.indexOf("keyboard") != -1)
    {
        webdeveloper_optionsDataString["webdeveloper.key.disable.styles"]         = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.disable.styles").value);
        webdeveloper_optionsDataString["webdeveloper.key.javascript.console"]     = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.javascript.console").value);
        webdeveloper_optionsDataString["webdeveloper.key.sidebar"]                = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.sidebar").value);
        webdeveloper_optionsDataString["webdeveloper.key.validate.html"]          = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.validate.html").value);
        webdeveloper_optionsDataString["webdeveloper.key.validate.local.html"]    = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.validate.local.html").value);
        webdeveloper_optionsDataString["webdeveloper.key.view.css"]               = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.view.css").value);
        webdeveloper_optionsDataString["webdeveloper.key.view.source"]            = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.view.source").value);
        webdeveloper_optionsDataString["webdeveloper.key.view.style.information"] = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.view.style.information").value);
        webdeveloper_optionsDataString["webdeveloper.key.zoom.in"]                = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.zoom.in").value);
        webdeveloper_optionsDataString["webdeveloper.key.zoom.out"]               = webdeveloper_trim(pageDocument.getElementById("webdeveloper.key.zoom.out").value);
    }
    else if(iFrameSrc.indexOf("resize") != -1)
    {
        var description = null;
        var height      = null;
        var heightValue = null;
        var width       = null;
        var widthValue  = null;

        // Loop through the possible resize settings
        for(var i = 1; i <= 4; i++)
        {
            description = "webdeveloper.resize." + i + ".description";
            height      = "webdeveloper.resize." + i + ".height";
            heightValue = webdeveloper_trim(pageDocument.getElementById(height).value);
            width       = "webdeveloper.resize." + i + ".width";
            widthValue  = webdeveloper_trim(pageDocument.getElementById(width).value);

            webdeveloper_optionsDataString[description] = webdeveloper_trim(pageDocument.getElementById(description).value);

            // If the width is valid
            if(widthValue && parseInt(widthValue) == widthValue && widthValue > 0)
            {
                webdeveloper_optionsDataInteger[width] = widthValue;
            }
            else
            {
                webdeveloper_optionsDataInteger[width] = "";
            }

            // If the height is valid
            if(heightValue && parseInt(heightValue) == heightValue && heightValue > 0)
            {
                webdeveloper_optionsDataInteger[height] = heightValue;
            }
            else
            {
                webdeveloper_optionsDataInteger[height] = "";
            }
        }
    }
    else if(iFrameSrc.indexOf("sidebar") != -1)
    {
        webdeveloper_optionsDataInteger["webdeveloper.edit.css.font"] = pageDocument.getElementById("webdeveloper.edit.css.font").value;
    }
    else if(iFrameSrc.indexOf("validators") != -1)
    {
        webdeveloper_optionsDataString["webdeveloper.validator.css"]        = webdeveloper_trim(pageDocument.getElementById("webdeveloper.validator.css").value);
        webdeveloper_optionsDataString["webdeveloper.validator.html"]       = webdeveloper_trim(pageDocument.getElementById("webdeveloper.validator.html").value);
        webdeveloper_optionsDataString["webdeveloper.validator.links"]      = webdeveloper_trim(pageDocument.getElementById("webdeveloper.validator.links").value);
        webdeveloper_optionsDataString["webdeveloper.validator.section508"] = webdeveloper_trim(pageDocument.getElementById("webdeveloper.validator.section508").value);
        webdeveloper_optionsDataString["webdeveloper.validator.wai"]        = webdeveloper_trim(pageDocument.getElementById("webdeveloper.validator.wai").value);
        webdeveloper_optionsDataString["webdeveloper.validator.custom"]     = webdeveloper_trim(pageDocument.getElementById("webdeveloper.validator.custom").value);
    }
}
