// Cancels the outline elements
function webdeveloper_cancelOutlineElements()
{
    window.opener.document.getElementById("webdeveloper-outline-custom-elements-menu").setAttribute("checked", false);

    window.close();
}

// Initializes the outline elements dialog
function webdeveloper_initializeOutlineElements()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var color   = null;
    var element = null;

    // Loop through the possible custom elements
	for(var i = 1; i <= 5; i++)
	{
	    color   = "webdeveloper.custom." + i + ".color";
	    element = "webdeveloper.custom." + i + ".element";

        // If the color is set
        if(preferencesService.prefHasUserValue(color))
        {
		    document.getElementById(color).color = webdeveloper_trim(preferencesService.getCharPref(color));
		}

        // If the element is set
        if(preferencesService.prefHasUserValue(element))
        {
		    document.getElementById(element).value = webdeveloper_trim(preferencesService.getCharPref(element));
		}
	}
}

// Saves the list of colors and elements to outline
function webdeveloper_saveOutlineElements()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

    var color   = null;
    var element = null;

    // Loop through the possible custom elements
	for(var i = 1; i <= 5; i++)
	{
	    color   = "webdeveloper.custom." + i + ".color";
	    element = "webdeveloper.custom." + i + ".element";

        preferencesService.setCharPref(color, document.getElementById(color).color);
        preferencesService.setCharPref(element, webdeveloper_trim(document.getElementById(element).value));
	}

	window.arguments[0].push(true);
}