// Removes a substring from a string
function webdeveloper_removeSubstring(string, substring)
{
    // If the string was not empty
    if(string)
    {
        const substringStart = string.indexOf(substring);

        // If the substring was found in the string
        if(substring && substringStart != -1)
        {
            return string.substring(0, substringStart) + string.substring(substringStart + substring.length, string.length);
        }
        else
        {
            return string;
        }
    }
    else
    {
        return "";
    }
}

// Trims leading and trailing spaces from a string
function webdeveloper_trim(string)
{
    // If the string is not empty
    if(string)
    {
        return string.replace(/^\s*|\s*$/g, "");
    }
    else
    {
        return "";
    }
}
