/**
 * Author: Davide Ficano
 * Date  : 06-02-2005
 */
function ViewSourceTreeView(items, defaultItem) {
    this.items = items;
    this.defaultItem = defaultItem;
    this.treebox = null;
}

ViewSourceTreeView.prototype = {

    invalidate : function() {
        this.treebox.invalidate();
    },

    swap : function(idx1, idx2) {
        if ((idx1 == idx2) || (idx1 < 0) || (idx2 < 0)) {
            return;
        }
        var temp = this.items[idx1];
        
        this.items[idx1] = this.items[idx2];
        this.items[idx2] = temp;
        
        if (this.defaultItem == idx1) {
            this.defaultItem = idx2;
        } else if (this.defaultItem == idx2) {
            this.defaultItem = idx1;
        }
    },

    insertItem : function(newItem) {
        try {
            this.items.push(newItem);
            
            // 1 means add (> 0)
            this.treebox.rowCountChanged(this.rowCount, 1);
        } catch (err) {
            alert(err);
        }
    },
        
    deleteSelectedItem : function() {
        try {
            var selIdx = this.selection.currentIndex;
            
            if (selIdx < 0) {
                return;
            }
            var newItems = new Array();
            
            for (var i = 0; i < this.items.length; i++) {
                if (i != selIdx) {
                    newItems.push(this.items[i]);
                }
            }
            
            // the item removed is the default item
            if (selIdx == this.defaultItem) {
                this.defaultItem = -1;
            }
            this.items = newItems;
            // -1 means remove (< 0)
            this.treebox.rowCountChanged(selIdx, -1);
            
            if (newItems.length > 0) {
                this.selection.select(selIdx == 0 ? 0 : selIdx - 1);
            }
        } catch (err) {
            alert(err);
        }
    },
    
    getCellText : function(row,column){
		if (column == "defaultEditor") {
			return row == this.defaultItem ? "Y" : "N";
		}
        if (column == "descr") {
            return this.items[row].description;
        }        

        if (column == "path") {
            return this.items[row].path;
        }
        
        return "";
    },

	get rowCount() {
		return this.items.length;
	},
    
	cycleCell: function (row, column) {
		if (column == "defaultEditor") {
			if (row == this.defaultItem) {
				this.defaultItem = -1;
			} else {
			    var currDef = this.defaultItem;
				this.defaultItem = row;
				// default item is always visible
				this.items[row].isVisible = true;
                this.treebox.invalidateCell(currDef, column);
			}
		} else if (column == "show") {
			if (row != this.defaultItem) {
		        this.items[row].isVisible = !this.items[row].isVisible;
		    }
		}
        this.treebox.selection.select(row);
        this.treebox.invalidateRow(row);
	},

	getImageSrc: function (row, column) {
		if (column == "defaultEditor") {
			if (row == this.defaultItem) {
                return "chrome://viewsourcewith/skin/default.png";
            }
		} else if (column == "show") {
		    if(this.items[row].isVisible) {
                return "chrome://viewsourcewith/skin/showEditor.png";
		    }
		}
	    return null;
	},

    setTree: function(treebox){ 
        this.treebox = treebox;
    },
    
    isContainer: function(row){ return false; },
    isSeparator: function(row){ return false; },
    isSorted: function(row){ return false; },
    getLevel: function(row){ return 0; },
    getRowProperties: function(row,props){},
    getCellProperties: function(row,col,props){},
    getColumnProperties: function(colid,col,props){}
};
