/**
 * Author: Davide Ficano
 * Date  : 22-Nov-04
 * Fix description  : 15-Jan-05
 */
var gViewSourceSettings = {
    onLoad : function() {
        sizeToContent();
        gViewSourceSettings.prefs = new ViewSourceWithPrefs(true);
        gViewSourceSettings.initControls();
    },

    onAccept : function() {
        var isValid = false;
        var thiz = gViewSourceSettings;
        
        try {
            isValid = thiz.checkDestFolder();
    
            if (isValid) {
                thiz.prefs.destFolder = thiz.oDestFolder.value;
                thiz.prefs.configPath = thiz.oConfigPath.value;
                var treeView = thiz.gViewSourceTreeView;
                
                if (treeView.defaultItem < 0 && treeView.items.length > 0) {
                    treeView.defaultItem = 0;
                }
                thiz.prefs.editorData = treeView.items;
                thiz.prefs.editorDefaultIndex = treeView.defaultItem;
                thiz.prefs.savePrefs();
                ViewSourceWithCommon.getObserverService()
                    .notifyObservers(null, "viewsource-with-configuration-changed", "");
            }
        } catch (err) {
            alert("viewsourcewithsettings.onAccept: " + err);
        }
    
        return isValid;
    },

    checkDestFolder : function() {
        var isValid = false;
        
        try {
            var destFile = ViewSourceWithCommon.makeLocalFile(
                                gViewSourceSettings.oDestFolder.value);
            isValid = destFile.isDirectory();
        } catch (err) {
        }
            
        if (!isValid) {
            alert(ViewSourceWithCommon.getLocalizedMessage("err.invalidSourceFolder"));
        }
        return isValid;
    },

    onPickDestFolder : function() {
        const nsIFilePicker = Components.interfaces.nsIFilePicker;
        
        var fp = ViewSourceWithCommon.makeFilePicker(window, 
                        ViewSourceWithCommon.getLocalizedMessage("picktitle.destfolder"), 
                        nsIFilePicker.modeGetFolder);
        gViewSourceSettings.setDisplayDirectory(fp, gViewSourceSettings.oDestFolder.value);
        
        var res = fp.show();
        if (res == nsIFilePicker.returnOK) {
            gViewSourceSettings.oDestFolder.value = fp.file.path;
        }    
        return true;
    },

    setDisplayDirectory : function(filePicker, path) {
        try {
            var currDir = ViewSourceWithCommon.makeLocalFile(path);
            if (currDir.isFile()) {
                currDir = currDir.parent;
            }
            if (currDir.isDirectory()) {
                filePicker.displayDirectory = currDir;
            }
        } catch (err) {
            // simply don't set displayDirectory
        }
    },

    initControls : function() {
        var thiz = gViewSourceSettings;
        
        thiz.oDestFolder = document.getElementById("destFolder");
        thiz.oConfigPath = document.getElementById("configPath");
        thiz.oTreeEditor = document.getElementById("vswTreeEditor");
    
        thiz.oDestFolder.value = thiz.prefs.destFolder;
        thiz.oConfigPath.value = thiz.prefs.configPath;
        // http://www.xulplanet.com/tutorials/xultu/treeview.html
        // Complex example http://www.xulplanet.com/tutorials/xulqa/q_treebview.html
        thiz.gViewSourceTreeView
            = new ViewSourceTreeView(thiz.prefs.editorData, 
                                     thiz.prefs.editorDefaultIndex);
        thiz.oTreeEditor.view = thiz.gViewSourceTreeView;
        thiz.onSelectItem();
    },

    newEditor : function() {
        var thiz = gViewSourceSettings;
        var item = new ViewSourceEditorData("T", "", "");
        
        window.openDialog("chrome://viewsourcewith/content/settings/chooseEditor.xul", 
                          "_blank", 
                          "chrome,modal,resizable=yes,dependent=yes",
                          item);
        if (item.path != "" && item.description != "") {
            thiz.gViewSourceTreeView.insertItem(item);
            thiz.gViewSourceTreeView.invalidate();
        }
    },

    editEditor : function() {
        var thiz = gViewSourceSettings;
        var selIdx = thiz.oTreeEditor.view.selection.currentIndex;

        if (selIdx < 0) {
            return;
        }
        window.openDialog("chrome://viewsourcewith/content/settings/chooseEditor.xul", 
                          "_blank", 
                          "chrome,modal,resizable=yes,dependent=yes",
                          thiz.gViewSourceTreeView.items[selIdx]);
        thiz.gViewSourceTreeView.invalidate();
    },

    deleteEditor : function() {
        gViewSourceSettings.gViewSourceTreeView.deleteSelectedItem();
        gViewSourceSettings.oTreeEditor.focus();
    },

    moveEditor : function(moveUp) {
        var thiz = gViewSourceSettings;
        var treeView = thiz.gViewSourceTreeView;
        var fromIdx = thiz.oTreeEditor.view.selection.currentIndex;
        var toIdx;
        
        gViewSourceSettings.oTreeEditor.focus();
        if (moveUp) {
            if (fromIdx <= 0) {
                return;
            }
            toIdx = fromIdx - 1;
        } else {
            if (fromIdx >= treeView.rowCount - 1) {
                return;
            }
            toIdx = fromIdx + 1;
        }
        treeView.swap(fromIdx, toIdx);
        treeView.invalidate();
        thiz.oTreeEditor.view.selection.select(toIdx);
    },
    
    onSelectItem : function() {
        var thiz = gViewSourceSettings;
        var selIdx = thiz.oTreeEditor.view.selection.currentIndex;
        var rowCount = thiz.gViewSourceTreeView.rowCount;
        
        document.getElementById("upEditor").disabled = selIdx <= 0;
        document.getElementById("downEditor").disabled = selIdx < 0 || selIdx >= rowCount - 1;
        document.getElementById("deleteEditor").disabled = selIdx < 0;
        document.getElementById("editEditor").disabled = selIdx < 0;
        
        return true;
    },

    getNavigationWindow : function() {
        var windowManager = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService();
        var windowManagerInterface = windowManager.QueryInterface( Components.interfaces.nsIWindowMediator);
        var win = windowManagerInterface.getMostRecentWindow("navigator:browser");
        
        if (!win) {
            win = window.openDialog(
                "chrome://browser/content/browser.xul", 
                "_blank", 
                "chrome,all,dialog=no", 
                "about:blank", null, null);
        }
        
        return win;
    },
    
    openUrl : function(aEvent) {
        var navWin = gViewSourceSettings.getNavigationWindow();
        var browser = navWin.document.getElementById("content");
        var url = aEvent.currentTarget.getAttribute("url");
        
        browser.selectedTab = browser.addTab(url);
    },

    onPickConfigPath : function() {
        var thiz = gViewSourceSettings;
        const nsIFilePicker = Components.interfaces.nsIFilePicker;
        
        try {
        var fp = ViewSourceWithCommon.makeFilePicker(window, 
                        ViewSourceWithCommon.getLocalizedMessage("picktitle.configPath"), 
                        nsIFilePicker.modeOpen);
        fp.appendFilters(nsIFilePicker.filterXML);
        thiz.setDisplayDirectory(fp, thiz.oConfigPath.value);
        
        var res = fp.show();
        if (res == nsIFilePicker.returnOK) {
            thiz.oConfigPath.value = fp.file.path;
            thiz.prefs.readPrefs(fp.file.path);
            thiz.initControls();
        }    
        } catch (err) {
            alert(err);
        }
        return true;
    },

};
