/**
 * Author: Davide Ficano
 * Date  : 05-Feb-05
 */
var gViewSourceChooseEditor = {
    onLoad : function() {
        sizeToContent();
        gViewSourceChooseEditor.initControls();
    },

    onAccept : function() {
        var thiz = gViewSourceChooseEditor;
        var isValid = false;
        
        try {
            isValid = thiz.checkEditor()
                      && thiz.checkDescription();
            var item = window.arguments[0];
    
            if (isValid && item) {
                item.path = thiz.oEditorAppPath.value;
                item.description = thiz.oDescription.value;
            }
        } catch (err) {
            alert("chooseEditor.onAccept: " + err);
        }
    
        return isValid;
    },

    checkDescription : function() {
        var thiz = gViewSourceChooseEditor;
        var isValid = false;
        
        try {
            isValid = thiz.oDescription.value != "";
            if (!isValid) {
                isValid = confirm(ViewSourceWithCommon
                        .getLocalizedMessage("warning.invalidDescription"));
                if (isValid) {
                    thiz.oDescription.value = thiz.getDescriptionFromFileName();
                }
            }
        } catch (err) {
        }
        // Shift focus to allow text input
        if (!isValid) {
            thiz.oDescription.focus();
        }
        return isValid;
    },

    getDescriptionFromFileName : function() {
        var thiz = gViewSourceChooseEditor;

        var descr = ViewSourceWithCommon.makeLocalFile(
                                thiz.oEditorAppPath.value).leafName;
        // remove extension (if any)
        descr = descr.replace(/\.[^\.]*/, "");
        
        return descr;
    },

    checkEditor : function() {
        var isValid = false;
        
        try {
            var editorFile = ViewSourceWithCommon.makeLocalFile(
                                gViewSourceChooseEditor.oEditorAppPath.value);
            isValid = editorFile.isFile() && editorFile.isExecutable();
        } catch (err) {
        }
        if (!isValid) {
            alert(ViewSourceWithCommon.getLocalizedMessage("err.invalidEditor"));
        }
        return isValid;
    },

    onPickEditor : function() {
        const nsIFilePicker = Components.interfaces.nsIFilePicker;
        
        var fp = ViewSourceWithCommon.makeFilePicker(window, 
                    ViewSourceWithCommon.getLocalizedMessage("picktitle.editor"));
        fp.appendFilters(nsIFilePicker.filterApps);
        gViewSourceChooseEditor.setDisplayDirectory(fp, gViewSourceChooseEditor.oEditorAppPath.value);
        
        var res = fp.show();
        if (res == nsIFilePicker.returnOK) {
            gViewSourceChooseEditor.oEditorAppPath.value = fp.file.path;
        }    
        return true;
    },

    setDisplayDirectory : function(filePicker, path) {
        try {
            var currDir = ViewSourceWithCommon.makeLocalFile(path);
            if (currDir.isFile()) {
                currDir = currDir.parent;
            }
            if (currDir.isDirectory()) {
                filePicker.displayDirectory = currDir;
            }
        } catch (err) {
            // simply don't set displayDirectory
        }
    },

    initControls : function() {
        var thiz = gViewSourceChooseEditor;
        
        thiz.oEditorAppPath = document.getElementById("editorpath");
        thiz.oDescription = document.getElementById("description");

        var item = window.arguments[0];
        if (item) {
            thiz.oEditorAppPath.value = item.path;
            thiz.oDescription.value = item.description;
        }
    }
};

