/**
 * Author: Davide Ficano
 * Date  : 22-Nov-04
**/

function ViewSourceWithCommon() {
    this.gPathSeparator = top.window.navigator.platform.indexOf("Win") < 0 ? "/" : "\\";

    return this;
}

ViewSourceWithCommon.makeWebBrowserPersist = function() {
    return Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"]
            .createInstance(Components.interfaces.nsIWebBrowserPersist);
}

ViewSourceWithCommon.makeLocalFile = function(path, arrayAppendPaths) {
    var file = Components.classes["@mozilla.org/file/local;1"]
               .createInstance(Components.interfaces.nsILocalFile);
    file.initWithPath(path);
    
    if (arrayAppendPaths != null 
        && arrayAppendPaths != undefined 
        && arrayAppendPaths.length) {
        for (i = 0; i < arrayAppendPaths.length; i++) {
            file.append(arrayAppendPaths[i]);
        }
    }
    return file;
}

ViewSourceWithCommon.makeFileURL = function(aFile) {
    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);
    return ioService.newFileURI(aFile);
}

ViewSourceWithCommon.makeURL = function(aURL) {
    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                            .getService(Components.interfaces.nsIIOService);
    return ioService.newURI(aURL, null, null);
}

ViewSourceWithCommon.makeLocalFileByUrl = function(url) {
    return ViewSourceWithCommon.makeURL(url)
            .QueryInterface(Components.interfaces.nsIFileURL)
            .file.clone(Components.interfaces.nsILocalFile);
}

ViewSourceWithCommon.runProgram = function(theFile, theArgs) {
    const nsIProcess                    = Components.interfaces.nsIProcess;
    const nsILocalFile                  = Components.interfaces.nsILocalFile;
    const CONTRACTID_PROCESS            = "@mozilla.org/process/util;1";
    const CONTRACTID_LOCAL_FILE         = "@mozilla.org/file/local;1";

    var execFile = Components.classes[CONTRACTID_LOCAL_FILE].createInstance(nsILocalFile);
    execFile.initWithPath(theFile);
    
    var theProcess = Components.classes[CONTRACTID_PROCESS].createInstance(nsIProcess);
    theProcess.init(execFile);
    var numArgs = theArgs ? theArgs.length : 0;

    theProcess.run(false, theArgs, numArgs, {});
}

ViewSourceWithCommon.getLocalizedMessage = function(msg) {
    return document.getElementById("viewsourcewith.locale").getString(msg);
}
    
ViewSourceWithCommon.getFormattedMessage = function(msg, ar) {
    return document.getElementById("viewsourcewith.locale")
            .getFormattedString(msg, ar);
}
    
ViewSourceWithCommon.makeFilePicker = function(win, title, mode) {
    const nsIFilePicker                 = Components.interfaces.nsIFilePicker;
    const CONTRACTID_FILE_PICKER        = "@mozilla.org/filepicker;1";
    
    if (mode == null || mode == undefined) {
        mode = nsIFilePicker.modeOpen;
    }
    var fp = Components.classes[CONTRACTID_FILE_PICKER]
                .createInstance(nsIFilePicker);
    fp.init(win, title, mode);
    
    return fp;
}
    
ViewSourceWithCommon.getMIMEService = function () {
    const CONTRACTID_MIME = "@mozilla.org/mime;1";
    const nsMIMEService = Components.interfaces.nsIMIMEService;
    
    return Components.classes[CONTRACTID_MIME].getService(nsMIMEService);
}

ViewSourceWithCommon.getObserverService = function () {
    const CONTRACTID_OBSERVER = "@mozilla.org/observer-service;1";
    const nsObserverService = Components.interfaces.nsIObserverService;
    
    return Components.classes[CONTRACTID_OBSERVER].getService(nsObserverService);
}

ViewSourceWithCommon.makeOutputStream = function(fileName, append) {
    const CONTRACTID_FOS = "@mozilla.org/network/file-output-stream;1";
    const nsFos = Components.interfaces.nsIFileOutputStream;

    var os = Components.classes[CONTRACTID_FOS].createInstance(nsFos);
    var flags = 0x02 | 0x08 | 0x20; // wronly | create | truncate
    if (append != null && append != undefined && append) {
        flags = 0x02 | 0x10; // wronly | append
    }
    os.init(ViewSourceWithCommon.makeLocalFile(fileName), flags, 0664, 0);
    
    return os;
}

ViewSourceWithCommon.read = function(file) {
    const CONTRACTID_FIS = "@mozilla.org/network/file-input-stream;1";
    const nsFis = Components.interfaces.nsIFileInputStream;
    const CONTRACTID_SIS = "@mozilla.org/scriptableinputstream;1";
    const nsSis = Components.interfaces.nsIScriptableInputStream;


    var str = "";
    var fiStream = Components.classes[CONTRACTID_FIS].createInstance(nsFis);
    var siStream = Components.classes[CONTRACTID_SIS].createInstance(nsSis);
    
    fiStream.init(file, 1, 0, false);
    siStream.init(fiStream);
    str += siStream.read(-1);
    siStream.close();
    fiStream.close();
    return str;
}

ViewSourceWithCommon.getUserHome = function () {
    const CONTRACTID_DIR = "@mozilla.org/file/directory_service;1";
    const nsDir = Components.interfaces.nsIProperties;

    var dirService = Components.classes[CONTRACTID_DIR].getService(nsDir);
    var homeDir = dirService.get("DefProfRt", Components.interfaces.nsILocalFile);
                       
    return homeDir;
}
