/**
 * Author           : Davide Ficano
 * Date             : 06-Mar-05
 * These routines are stolen from contentAreaUtils.js
 */
 
function ViewSourceWithBrowserHelper() {
}

ViewSourceWithBrowserHelper.isContentFrame = function(aFocusedWindow) {
    if (!aFocusedWindow)
        return false;

    var focusedTop = Components.lookupMethod(aFocusedWindow, 'top')
                        .call(aFocusedWindow);
    return (focusedTop == window.content);
}

ViewSourceWithBrowserHelper.getContentFrameURI = function(aFocusedWindow) {
    var contentFrame = ViewSourceWithBrowserHelper.isContentFrame(aFocusedWindow) 
                        ? aFocusedWindow : window.content;
    if (contentFrame)
        return Components.lookupMethod(contentFrame, 'location')
                    .call(contentFrame).href;
    else
        return null;
}

ViewSourceWithBrowserHelper.getReferrer = function(doc) {
    var focusedWindow = doc.commandDispatcher.focusedWindow;
    var sourceURL = ViewSourceWithBrowserHelper.getContentFrameURI(focusedWindow);
    
    if (sourceURL) {
        try {
            return ViewSourceWithCommon.makeURL(sourceURL);
        }
        catch (e) {
        }
    }
    return null;
}

ViewSourceWithBrowserHelper.getPostData = function() {
    try {
        var sessionHistory = getWebNavigation().sessionHistory;
        entry = sessionHistory.getEntryAtIndex(sessionHistory.index, false);
        entry = entry.QueryInterface(Components.interfaces.nsISHEntry);
        return entry.postData;
    } catch (e) {
    }
    return null;
}

