/**
 * Author: Davide Ficano
 */

var gViewSourceWithMain = {

    onLoad : function() {
        var thiz = gViewSourceWithMain;
        thiz.prefs = new ViewSourceWithPrefs();
        thiz.common = new ViewSourceWithCommon();
        var ctxMenu = document.getElementById("contentAreaContextMenu");
        ctxMenu.addEventListener("popupshowing", 
                              thiz.initCtxMenu, false);

        var viewMenu = document.getElementById("menu_viewPopup");
        viewMenu.addEventListener("popupshowing", 
                              thiz.initViewMenu, false);
                              
        thiz.gEditorData = null;
        thiz.gEditorDefaultIndex = -1;
        
        var obs = thiz.common.getObserverService();
        obs.addObserver(thiz, 
                        "viewsource-with-configuration-changed", false);
        obs.notifyObservers(null, "viewsource-with-configuration-changed", "");
    },

    initCtxMenu : function(event) {
        gViewSourceWithMain.insertMenuItems(
                document.getElementById("viewsourcewithMenuPopup"), 
                "viewPageFromCtxMenu");
        return true;
    },
    
    initViewMenu : function(event) {
        gViewSourceWithMain.insertMenuItems(
                document.getElementById("viewsourcewith-viewMenuPopup"), 
                "viewPageFromViewMenu");
        return true;
    },

    initToolbarMenu : function(event) {
        gViewSourceWithMain.insertMenuItems(
                document.getElementById("viewsourcewith-toolbarMenuPopup"), 
                "viewPageFromViewMenu");
        return true;
    },

    viewPageFromCtxMenu : function(editorDataIdx) {
        gViewSourceWithMain.viewPage(gContextMenu.target.ownerDocument, editorDataIdx);
    },
    
    viewPageFromViewMenu : function(editorDataIdx) {
        var showWarning = gViewSourceWithMain.prefs.showWarning;
        
        if (showWarning) {
            gViewSourceWithMain.openDlgWarning();
        }
        
        var focusedWindow = document.commandDispatcher.focusedWindow;
        // Don't get url from browser widgets (e.g. google bar, address bar)
        if (focusedWindow == window) {
            focusedWindow = _content;
        }

        gViewSourceWithMain.viewPage(focusedWindow.document, editorDataIdx);
    },

    viewPage : function(documentToSave, editorDataIdx) {
        try {
            var urlToSave       = documentToSave.location.href;//documentToSave.URL;
            var filePath;
            var thiz            = gViewSourceWithMain;
            var editorPath      = thiz.gEditorData[editorDataIdx].path;

            if (editorPath == "") {
                return;
            }
            if (thiz.isLocalPage(urlToSave)) {
                // view file without save it
                filePath = thiz.common.makeLocalFileByUrl(urlToSave);
            } else {
                filePath = thiz.common.makeLocalFile(
                                    thiz.prefs.destFolder, 
                                    [thiz.getFileName(documentToSave)]);
                thiz.saveSourcePage(urlToSave, filePath);
            }
            thiz.common.runProgram(editorPath, [filePath.path]);
        } catch (err) {
            alert("viewPage: " + err);
        }
    },
    
    openDlgSettings : function() {
        window.openDialog("chrome://viewsourcewith/content/settings.xul", 
                          "_blank", 
                          "chrome,resizable=yes,dependent=yes");
    },
    
    openDlgWarning : function() {
        window.openDialog("chrome://viewsourcewith/content/warning-frame.xul", 
                          "_blank", 
                          "chrome,modal,resizable=yes,dependent=yes");
    },
    
    isLocalPage : function(url) {
        return url.substring(0, 7) == "file://";
    },
    
    getFileName : function(doc) {
        const contractIDStdURL = "@mozilla.org/network/standard-url;1";
        const nsIURL = Components.interfaces.nsIURL;
        var uri = Components.classes[contractIDStdURL].createInstance(nsIURL);
    
        uri.filePath = doc.location.href;

        var fileName;
        // This url contains only directory name (e.g. http://www.xulplanet.com/)
        var re = /\/([^\/]+)\/$/;
        var path = uri.path.match(re);
        if (path && path.length > 1) {
            fileName = path[1];
        } else {
            fileName = uri.fileName;
        }
        // Handle cases like 
        // http://host.com/path/?noFileName=before_question_mark_no_name
        if (fileName == "") {
            path = uri.directory.match(re);
            if (path && path.length > 1) {
                fileName = path[1];
            } else {
                fileName = "index";
            }
        }
        // Check if fileName ends with .htm or .html
        re = /\.(htm|html|xml)$/i;
        if (!fileName.match(re)) {
            fileName += "." + gViewSourceWithMain.common
                                .getMIMEService()
                                    .getPrimaryExtension(doc.contentType, null)
        }
        return gViewSourceWithMain.getPortableFileName(fileName);
    },
    
    /**
     * Replace following chars with underscore (_)
     * \ / : * ? " < > |
     */
    getPortableFileName : function(fileName) {
        return fileName.replace(/[\\\/\:\*\?\"\<\>\| ]+/g, "_");
    },
    
    saveSourcePage : function(url, file) {
        var uri = gViewSourceWithMain.common.makeURL(url);
        var target = gViewSourceWithMain.common.makeFileURL(file);
    
        const nsIWBP = Components.interfaces.nsIWebBrowserPersist;
        var persist = gViewSourceWithMain.common.makeWebBrowserPersist();
        persist.persistFlags = nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES
                               | nsIWBP.PERSIST_FLAGS_FROM_CACHE;
        persist.saveURI(uri, null, null, null, null, target);
    },

    insertMenuItems : function(menu, fnViewPage) {
        var thiz = gViewSourceWithMain;

        thiz.removeMenuItems(menu);

        thiz.gEditorData = thiz.prefs.editorData;
        thiz.gEditorDefaultIndex = thiz.prefs.editorDefaultIndex;
        
        thiz.insertDefaultItemMenu(menu, fnViewPage);

        var hasVisibleItems = false;
        for (var i = 0; i < thiz.gEditorData.length; i++) {
            if (i != thiz.gEditorDefaultIndex && thiz.gEditorData[i].isVisible) {
                hasVisibleItems = true;
                break;
            }
        }

        // add separator only if there is at least one editor visible
        if (hasVisibleItems) {
	        menu.appendChild(document.createElement("menuseparator"));
	    }

        for (var i = 0; i < thiz.gEditorData.length; i++) {
            if (i != thiz.gEditorDefaultIndex && thiz.gEditorData[i].isVisible) {
                thiz.insertEditorMenuItem(menu, i, fnViewPage);
            }
        }
    },

    removeMenuItems : function(menu) {
    	var children = menu.childNodes;
    	
    	for (var i = children.length - 1; i >= 0; i--) {
    		menu.removeChild(children[i]);
    	}
    },

    insertDefaultItemMenu : function(menu, fnViewPage) {
        var thiz = gViewSourceWithMain;
        var hasDefault = thiz.gEditorDefaultIndex >= 0;

        if (hasDefault) {
    		var item = document.createElement("menuitem");
    		
    		item.setAttribute("label", thiz.gEditorData[thiz.gEditorDefaultIndex].description);
    		item.setAttribute("oncommand", "gViewSourceWithMain." 
    		                        + fnViewPage + "(" + thiz.gEditorDefaultIndex + ");");
            item.setAttribute("id", "viewsourcewith-viewMenuItemDefault");
            // setting key after appendChild doesn't work
            item.setAttribute("key", "key_viewsourcewith");
    		menu.appendChild(item);
        }
        thiz.insertSettingsMenuItem(menu, !hasDefault);
    },

    insertSettingsMenuItem : function(menu, hasShortCutKey) {
		var item = document.createElement("menuitem");
		
		item.setAttribute("label", 
	            gViewSourceWithMain.common.getLocalizedMessage("menu.settings.label"));
		item.setAttribute("oncommand", "gViewSourceWithMain.openDlgSettings();");
        if (hasShortCutKey) {
            item.setAttribute("id", "viewsourcewith-viewMenuItemDefault");
            item.setAttribute("key", "key_viewsourcewith");
        }
		menu.appendChild(item);
		
		return item;
	},
    
    insertEditorMenuItem : function(menu, editorDataIdx, fnViewPage) {
		var item = document.createElement("menuitem");
        var label = gViewSourceWithMain.gEditorData[editorDataIdx].description;
        
		item.setAttribute("id", "viewsourcewithEditor" + label);
		item.setAttribute("label", label);
		item.setAttribute("oncommand", "gViewSourceWithMain." 
		                        + fnViewPage + "(" + editorDataIdx + ");");
		menu.appendChild(item);

		return item;
    },
    
    runDefaultEditor : function(event) {
        var thiz = gViewSourceWithMain;

        thiz.gEditorData = thiz.prefs.editorData;
        thiz.gEditorDefaultIndex = thiz.prefs.editorDefaultIndex;

        if (thiz.gEditorDefaultIndex < 0) {
            thiz.openDlgSettings();
        } else {
            thiz.viewPageFromViewMenu(thiz.gEditorDefaultIndex);
        }
    },

    observe : function(subject, topic, state)  {
        if (topic == "viewsource-with-configuration-changed") {
            // ensure shortkeys are assigned
            gViewSourceWithMain.initViewMenu(null);
        }
    }
};

window.addEventListener("load", gViewSourceWithMain.onLoad, false);
