/**
 * Author: Davide Ficano
 * Date  : 22-Nov-04
 * Fix description  : 15-Jan-05
 */
var gViewSourceSettings = {
    onLoad : function() {
        sizeToContent();
        gViewSourceSettings.prefs = new ViewSourceWithPrefs();
        gViewSourceSettings.common = new ViewSourceWithCommon();
        gViewSourceSettings.initControls();
    },

    onAccept : function() {
        var isValid = false;
        var thiz = gViewSourceSettings;
        
        try {
            isValid = thiz.checkDestFolder();
    
            if (isValid) {
                thiz.prefs.destFolder = thiz.oDestFolder.value;
                var treeView = thiz.gViewSourceTreeView;
                
                if (treeView.defaultItem < 0 && treeView.items.length > 0) {
                    treeView.defaultItem = 0;
                }
                thiz.prefs.editorData = treeView.items;
                thiz.prefs.editorDefaultIndex = treeView.defaultItem;
                thiz.common.getObserverService()
                    .notifyObservers(null, "viewsource-with-configuration-changed", "");
            }
        } catch (err) {
            alert("viewsourcewithsettings.onAccept: " + err);
        }
    
        return isValid;
    },

    checkDestFolder : function() {
        var isValid = false;
        
        try {
            var destFile = gViewSourceSettings.common.makeLocalFile(
                                gViewSourceSettings.oDestFolder.value);
            isValid = destFile.isDirectory();
        } catch (err) {
        }
            
        if (!isValid) {
            alert(gViewSourceSettings.common.getLocalizedMessage("err.invalidSourceFolder"));
        }
        return isValid;
    },

    onPickDestFolder : function() {
        const nsIFilePicker = Components.interfaces.nsIFilePicker;
        
        var fp = gViewSourceSettings.common.makeFilePicker(window, 
                        gViewSourceSettings.common.getLocalizedMessage("picktitle.destfolder"), 
                        nsIFilePicker.modeGetFolder);
        gViewSourceSettings.setDisplayDirectory(fp, gViewSourceSettings.oDestFolder.value);
        
        var res = fp.show();
        if (res == nsIFilePicker.returnOK) {
            gViewSourceSettings.oDestFolder.value = fp.file.path;
        }    
        return true;
    },

    setDisplayDirectory : function(filePicker, path) {
        try {
            var currDir = gViewSourceSettings.common.makeLocalFile(path);
            if (currDir.isFile()) {
                currDir = currDir.parent;
            }
            if (currDir.isDirectory()) {
                filePicker.displayDirectory = currDir;
            }
        } catch (err) {
            // simply don't set displayDirectory
        }
    },

    initControls : function() {
        var thiz = gViewSourceSettings;
        
        thiz.oDestFolder = document.getElementById("destFolder");
        thiz.oTreeEditor = document.getElementById("vswTreeEditor");
    
        thiz.oDestFolder.value = thiz.prefs.destFolder;
        // http://www.xulplanet.com/tutorials/xultu/treeview.html
        // Complex example http://www.xulplanet.com/tutorials/xulqa/q_treebview.html
        thiz.gViewSourceTreeView
            = new ViewSourceTreeView(thiz.prefs.editorData, 
                                     thiz.prefs.editorDefaultIndex);
        thiz.oTreeEditor.view = thiz.gViewSourceTreeView;
        thiz.onSelectItem();
    },

    newEditor : function() {
        var thiz = gViewSourceSettings;
        var item = new ViewSourceEditorData("T", "", "");
        
        window.openDialog("chrome://viewsourcewith/content/chooseEditor.xul", 
                          "_blank", 
                          "chrome,modal,resizable=yes,dependent=yes",
                          item);
        if (item.path != "" && item.description != "") {
            thiz.gViewSourceTreeView.insertItem(item);
            thiz.gViewSourceTreeView.invalidate();
        }
    },

    editEditor : function() {
        var thiz = gViewSourceSettings;
        var selIdx = thiz.oTreeEditor.view.selection.currentIndex;

        if (selIdx < 0) {
            return;
        }
        window.openDialog("chrome://viewsourcewith/content/chooseEditor.xul", 
                          "_blank", 
                          "chrome,modal,resizable=yes,dependent=yes",
                          thiz.gViewSourceTreeView.items[selIdx]);
        thiz.gViewSourceTreeView.invalidate();
    },

    deleteEditor : function() {
        gViewSourceSettings.gViewSourceTreeView.deleteSelectedItem();
        gViewSourceSettings.oTreeEditor.focus();
    },

    moveEditor : function(moveUp) {
        var thiz = gViewSourceSettings;
        var treeView = thiz.gViewSourceTreeView;
        var fromIdx = thiz.oTreeEditor.view.selection.currentIndex;
        var toIdx;
        
        gViewSourceSettings.oTreeEditor.focus();
        if (moveUp) {
            if (fromIdx <= 0) {
                return;
            }
            toIdx = fromIdx - 1;
        } else {
            if (fromIdx >= treeView.rowCount - 1) {
                return;
            }
            toIdx = fromIdx + 1;
        }
        treeView.swap(fromIdx, toIdx);
        treeView.invalidate();
        thiz.oTreeEditor.view.selection.select(toIdx);
    },
    
    onSelectItem : function() {
        var thiz = gViewSourceSettings;
        var selIdx = thiz.oTreeEditor.view.selection.currentIndex;
        var rowCount = thiz.gViewSourceTreeView.rowCount;
        
        document.getElementById("upEditor").disabled = selIdx <= 0;
        document.getElementById("downEditor").disabled = selIdx < 0 || selIdx >= rowCount - 1;
        document.getElementById("deleteEditor").disabled = selIdx < 0;
        document.getElementById("editEditor").disabled = selIdx < 0;
        
        return true;
    },

    getNavigationWindow : function() {
        var windowManager = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService();
        var windowManagerInterface = windowManager.QueryInterface( Components.interfaces.nsIWindowMediator);
        var win = windowManagerInterface.getMostRecentWindow("navigator:browser");
        
        if (!win) {
            win = window.openDialog(
                "chrome://browser/content/browser.xul", 
                "_blank", 
                "chrome,all,dialog=no", 
                "about:blank", null, null);
        }
        
        return win;
    },
    
    openUrl : function(aEvent) {
        var navWin = gViewSourceSettings.getNavigationWindow();
        var browser = navWin.document.getElementById("content");
        var Url = aEvent.currentTarget.getAttribute("url");
    
        browser.loadURI(Url);
    }
};

function ViewSourceTreeView(items, defaultItem) {
    this.items = items;
    this.defaultItem = defaultItem;
    this.treebox = null;
}

ViewSourceTreeView.prototype = {

    invalidate : function() {
        this.treebox.invalidate();
    },

    swap : function(idx1, idx2) {
        if ((idx1 == idx2) || (idx1 < 0) || (idx2 < 0)) {
            return;
        }
        var temp = this.items[idx1];
        
        this.items[idx1] = this.items[idx2];
        this.items[idx2] = temp;
        
        if (this.defaultItem == idx1) {
            this.defaultItem = idx2;
        } else if (this.defaultItem == idx2) {
            this.defaultItem = idx1;
        }
    },

    insertItem : function(newItem) {
        try {
            this.items.push(newItem);
            
            // 1 means add (> 0)
            this.treebox.rowCountChanged(this.rowCount, 1);
        } catch (err) {
            alert(err);
        }
    },
        
    deleteSelectedItem : function() {
        try {
            var selIdx = this.selection.currentIndex;
            
            if (selIdx < 0) {
                return;
            }
            var newItems = new Array();
            
            for (var i = 0; i < this.items.length; i++) {
                if (i != selIdx) {
                    newItems.push(this.items[i]);
                }
            }
            
            // the item removed is the default item
            if (selIdx == this.defaultItem) {
                this.defaultItem = -1;
            }
            this.items = newItems;
            // -1 means remove (< 0)
            this.treebox.rowCountChanged(selIdx, -1);
            
            if (newItems.length > 0) {
                this.selection.select(selIdx == 0 ? 0 : selIdx - 1);
            }
        } catch (err) {
            alert(err);
        }
    },
    
    getCellText : function(row,column){
		if (column == "defaultEditor") {
			return row == this.defaultItem ? "Y" : "N";
		}
        if (column == "descr") {
            return this.items[row].description;
        }        

        if (column == "path") {
            return this.items[row].path;
        }
        
        return "";
    },

	get rowCount() {
		return this.items.length;
	},
    
	cycleCell: function (row, column) {
		if (column == "defaultEditor") {
			if (row == this.defaultItem) {
				this.defaultItem = -1;
			} else {
			    var currDef = this.defaultItem;
				this.defaultItem = row;
				// default item is always visible
				this.items[row].isVisible = true;
                this.treebox.invalidateCell(currDef, column);
			}
		} else if (column == "show") {
		    this.items[row].isVisible = !this.items[row].isVisible;
		}
        this.treebox.invalidateRow(row);
	},

	getImageSrc: function (row, column) {
		if (column == "defaultEditor") {
			if (row == this.defaultItem) {
                return "chrome://viewsourcewith/skin/default.png";
            }
		} else if (column == "show") {
		    if(this.items[row].isVisible) {
                return "chrome://viewsourcewith/skin/showEditor.png";
		    }
		}
	    return null;
	},

    setTree: function(treebox){ 
        this.treebox = treebox;
    },
    
    isContainer: function(row){ return false; },
    isSeparator: function(row){ return false; },
    isSorted: function(row){ return false; },
    getLevel: function(row){ return 0; },
    getRowProperties: function(row,props){},
    getCellProperties: function(row,col,props){},
    getColumnProperties: function(colid,col,props){}
};
