/**
 * Author: Davide Ficano
 * Date  : 22-Nov-04
 * Fix description  : 15-Jan-05
 */

const VSW_PREF_SOURCE_FOLDER    = "dafi.viewsource.destFolder";
const VSW_PREF_SHOW_WARNING     = "dafi.viewsource.showWarning";

const VSW_PREF_EDITOR_ITEM      = "dafi.viewsource.editorItem";
const VSW_PREF_EDITOR_DEFAULT_INDEX = "dafi.viewsource.editorDefault";

function ViewSourceEditorData(isVisible, description, path) {
    this.isVisible = isVisible == "T";
    this.description = description;
    this.path = path;
}

function ViewSourceWithPrefs() {
    this.prefBranch = Components.classes['@mozilla.org/preferences-service;1']
                      .getService()
                      .QueryInterface(Components.interfaces.nsIPrefBranch);
    this.common = new ViewSourceWithCommon();
}

ViewSourceWithPrefs.prototype = {
    get destFolder() {
        return this.getString(VSW_PREF_SOURCE_FOLDER, "");
    },

    set destFolder(folder) {
        if (folder != null && folder.length > 0) {
            this.setString(VSW_PREF_SOURCE_FOLDER, folder);
        }
    },

    get showWarning() {
        return this.getBool(VSW_PREF_SHOW_WARNING, true);
    },

    set showWarning(b) {
        this.setBool(VSW_PREF_SHOW_WARNING, b);
    },

    getString : function(prefName, defValue) {
        var prefValue;
        try {
            prefValue = this.prefBranch.getCharPref(prefName);
        } catch (ex) {
            prefValue = null;
        }
        return prefValue == null ? defValue : prefValue;
    },

    setString : function(prefName, prefValue) {
        this.prefBranch.setCharPref(prefName, prefValue);
    },

    getBool : function(prefName, defValue) {
        var prefValue;
        try {
            prefValue = this.prefBranch.getBoolPref(prefName);
        } catch (ex) {
            prefValue = null;
        }
        return prefValue == null ? defValue : prefValue;
    },

    setBool : function(prefName, prefValue) {
        this.prefBranch.setBoolPref(prefName, prefValue);
    },
    
    get editorData() {
        var ar = new Array();
        
        var item = null;
        for (var i = 0; (item = this.getString(VSW_PREF_EDITOR_ITEM + i, null)) != null; i++) {
            if (item == "LAST_ITEM") {
                break;
            }
            var s = item.split("\t");
            if (s.length >= 3) {
                ar.push(new ViewSourceEditorData(s[0], s[1], s[2]));
            } else {
                alert("skipped " + item);
            }
        }
        
        return ar;
    },
    
    set editorData(newData) {
        try {
            for (var i = 0; i < newData.length; i++) {
                var item = (newData[i].isVisible ? "T" : "F") + "\t"
                           + newData[i].description + "\t"
                           + newData[i].path;
                this.setString(VSW_PREF_EDITOR_ITEM + i, item);
            }
            this.setString(VSW_PREF_EDITOR_ITEM + newData.length, "LAST_ITEM");
        } catch (err) {
            alert("editorData " + err);
        }
    },

    get editorDefaultIndex() {
        return this.getString(VSW_PREF_EDITOR_DEFAULT_INDEX, "-1");
    },

    set editorDefaultIndex(newDefaultIndex) {
        this.setString(VSW_PREF_EDITOR_DEFAULT_INDEX, newDefaultIndex);
    }

};

