const gViewSourceWarning = {
    onLoad : function() {
        gViewSourceWarning.common = new ViewSourceWithCommon();
        gViewSourceWarning.prefs = new ViewSourceWithPrefs();
        gViewSourceWarning.countDown = 2;
        var okButton = document.documentElement.getButton("accept");
        
        okButton.label = gViewSourceWarning.common.getFormattedMessage(
                                "warning.button.disabled.label", 
                                [gViewSourceWarning.countDown]);
        okButton.disabled = true;
        okButton.focus();

        var checkbox = document.getElementById("vswWarningShowMessage");
        checkbox.disabled = true;
        
        gViewSourceWarning.countdownInterval = setInterval(
            "gViewSourceWarning.checkCountDown()", 1000);
    },

    checkCountDown : function() {
        var okButton = document.documentElement.getButton("accept");
        
        if (gViewSourceWarning.countDown-- <= 1) {
            clearInterval(gViewSourceWarning.countdownInterval);

            okButton.label = gViewSourceWarning.common.getLocalizedMessage(
                                "warning.button.enabled.label");
            okButton.disabled = false;

            var checkbox = document.getElementById("vswWarningShowMessage");
            checkbox.disabled = false;
        }
        else {
            okButton.label = gViewSourceWarning.common.getFormattedMessage(
                                    "warning.button.disabled.label", 
                                    [gViewSourceWarning.countDown]);
        }
    },

    onOK : function() {
        var checkbox = document.getElementById("vswWarningShowMessage");
        gViewSourceWarning.prefs.showWarning = !checkbox.checked;
        return true;
    }
};