/**
 * Author: Davide Ficano
**/

var gViewSourceWithMain = {

    onLoad : function() {
        gViewSourceWithMain.prefs = new ViewSourceWithPrefs();
        gViewSourceWithMain.common = new ViewSourceWithCommon();
        var ctxMenu = document.getElementById("contentAreaContextMenu");
        ctxMenu.addEventListener("popupshowing", 
                              gViewSourceWithMain.initCtxMenu, false);

        var viewMenu = document.getElementById("menu_viewPopup");
        viewMenu.addEventListener("popupshowing", 
                              gViewSourceWithMain.initViewMenu, false);
    },

    initCtxMenu : function(event) {
        var editorDescr = gViewSourceWithMain.prefs.editorDescription;
        
        var item = document.getElementById("viewsourcewithMenuItem");
        item.label = gViewSourceWithMain.common.getFormattedMessage(
                        "ctx.viewMenu.label", 
                        [editorDescr]);
        return true;
    },
    
    initViewMenu : function(event) {
        var editorDescr = gViewSourceWithMain.prefs.editorDescription;
        
        var item = document.getElementById("viewsourcewith-viewMenuItem");
        item.label = gViewSourceWithMain.common.getFormattedMessage(
                        "menu.viewMenu.label", 
                        [editorDescr]);

        return true;
    },

    viewPageFromCtxMenu : function() {
        gViewSourceWithMain.viewPage(gContextMenu.target.ownerDocument);
    },
    
    viewPageFromViewMenu : function() {
        var showWarning = gViewSourceWithMain.prefs.showWarning;
        
        if (showWarning) {
            gViewSourceWithMain.openDlgWarning();
        }
        
        var focusedWindow = document.commandDispatcher.focusedWindow;
        // Don't get url from browser widgets (e.g. google bar, address bar)
        if (focusedWindow == window) {
            focusedWindow = _content;
        }

        gViewSourceWithMain.viewPage(focusedWindow.document);
    },

    viewPage : function(documentToSave) {
        try {
            var urlToSave       = documentToSave.location.href;//documentToSave.URL;
            var editorPath      = gViewSourceWithMain.getEditorPath();
            var filePath;
            var thiz            = gViewSourceWithMain;
    
            if (editorPath == "") {
                return;
            }
            if (thiz.isLocalPage(urlToSave)) {
                // view file without save it
                filePath = thiz.common.makeLocalFileByUrl(urlToSave);
            } else {
                filePath = thiz.common.makeLocalFile(
                                    thiz.prefs.destFolder, 
                                    [thiz.getFileName(documentToSave)]);
                thiz.saveSourcePage(urlToSave, filePath);
            }
            thiz.common.runProgram(editorPath, [filePath.path]);
        } catch (err) {
            alert("viewPage: " + err);
        }
    },
    
    getEditorPath : function() {
        var editorPath = gViewSourceWithMain.prefs.editorPath;
        
        if (editorPath == "" || gViewSourceWithMain.prefs.destFolder == "") {
            gViewSourceWithMain.openDlgSettings();
            editorPath = gViewSourceWithMain.prefs.editorPath;
        }
        return editorPath;
    },
    
    openDlgSettings : function() {
        window.openDialog("chrome://viewsourcewith/content/settings.xul", 
                          "_blank", 
                          "chrome,resizable=yes,dependent=yes");
    },
    
    openDlgWarning : function() {
        window.openDialog("chrome://viewsourcewith/content/warning-frame.xul", 
                          "_blank", 
                          "chrome,modal,resizable=yes,dependent=yes");
    },
    
    isLocalPage : function(url) {
        return url.substring(0, 7) == "file://";
    },
    
    getFileName : function(doc) {
        const contractIDStdURL = "@mozilla.org/network/standard-url;1";
        const nsIURL = Components.interfaces.nsIURL;
        var uri = Components.classes[contractIDStdURL].createInstance(nsIURL);
    
        uri.filePath = doc.location.href;

        var fileName;
        // This url contains only directory name (e.g. http://www.xulplanet.com/)
        var re = /\/([^\/]+)\/$/;
        var path = uri.path.match(re);
        if (path && path.length > 1) {
            fileName = path[1];
        } else {
            fileName = uri.fileName;
        }
        // Handle cases like 
        // http://host.com/path/?noFileName=before_question_mark_no_name
        if (fileName == "") {
            path = uri.directory.match(re);
            if (path && path.length > 1) {
                fileName = path[1];
            } else {
                fileName = "index";
            }
        }
        // Check if fileName ends with .htm or .html
        re = /\.(htm|html|xml)$/i;
        if (!fileName.match(re)) {
            fileName += "." + gViewSourceWithMain.common
                                .getMIMEService()
                                    .getPrimaryExtension(doc.contentType, null)
        }
        return gViewSourceWithMain.getPortableFileName(fileName);
    },
    
    /**
     * Replace following chars with underscore (_)
     * \ / : * ? " < > |
     */
    getPortableFileName : function(fileName) {
        return fileName.replace(/[\\\/\:\*\?\"\<\>\| ]+/g, "_");
    },
    
    saveSourcePage : function(url, file) {
        var uri = gViewSourceWithMain.common.makeURL(url);
        var target = gViewSourceWithMain.common.makeFileURL(file);
    
        const nsIWBP = Components.interfaces.nsIWebBrowserPersist;
        var persist = gViewSourceWithMain.common.makeWebBrowserPersist();
        persist.persistFlags = nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES
                               | nsIWBP.PERSIST_FLAGS_FROM_CACHE;
        persist.saveURI(uri, null, null, null, null, target);
    }
};

window.addEventListener("load", gViewSourceWithMain.onLoad, false);
