/****************
Desc: Installation script For Mozilla Suite, Firefox prior to 0.9
****************** */
const author              = "Davide Ficano";
const displayName         = "Visualizza la pagina con un editor esterno";
const name                = "viewsourcewith";
const version             = "0.1";
var contentFlag           = CONTENT | PROFILE_CHROME;
var error                 = null;
var folder                = getFolder("Profile", "chrome");
var localeFlag            = LOCALE | PROFILE_CHROME;
var skinFlag              = SKIN | PROFILE_CHROME;
var jarName               = name + ".jar";
var existsInApplication   = File.exists(getFolder(getFolder("chrome"), jarName));
var existsInProfile       = File.exists(getFolder(folder, jarName));
const SUCCESS_MESSAGE     = " e' stato installato correttamente";

initInstall(displayName, name, version);

// If the extension exists in the application folder or 
//it doesn't exist in the profile folder and the user 
//doesn't want it installed to the profile folder
if(existsInApplication || (!existsInProfile && !confirm("Vuoi installare " 
 	+"questa estensione nella cartella del tuo profilo?\n(Premendo Cancel questa estensione "
	+"verra' installata nella cartella principale del tuo Browser)")))
{
    contentFlag = CONTENT | DELAYED_CHROME;
    folder      = getFolder("chrome");
    localeFlag  = LOCALE | DELAYED_CHROME;
    skinFlag    = SKIN | DELAYED_CHROME;
}

setPackageFolder(folder);
error = addFile(author, version, 'chrome/' + jarName, folder, null);
// If adding the JAR file succeeded
if(error == SUCCESS)
{
    folder = getFolder(folder, jarName);
    registerChrome(contentFlag, folder, "content/" + name + "/");    

    error = performInstall();

    // If the install failed
    if(error == SUCCESS || error == 999)
    {
      alert(displayName+" "+version+" e' stata installata con successo.\n");
    }else{
      alert("Installazione non riuscita. Codice errore:" + error);
      cancelInstall(error);
    }
}
else
{
	alert("L'installazione della estensione non e' riuscita.\n" + error + "\n" 
	      +"Non sono riuscito a creare " +jarName+ " \n"
	      +"Controlla di avere tutti i permessi per effettuare tale operazione");
	cancelInstall(error);
} 
