/**
 * Author: Davide Ficano
**/

var gViewSourceWithMain = {

    onLoad : function() {
        gViewSourceWithMain.prefs = new ViewSourceWithPrefs();
        gViewSourceWithMain.common = new ViewSourceWithCommon();
        var menu = document.getElementById("contentAreaContextMenu");
        menu.addEventListener("popupshowing", gViewSourceWithMain.initMenu, false);
    },

    initMenu : function(event) {
        var item = document.getElementById("viewsourcewithMenuItem");
        item.label = gViewSourceWithMain.common.getFormattedMessage("ctx.viewMenu.label", 
                        [gViewSourceWithMain.prefs.editorDescription]);
        
        return true;
    },
    
    viewPage : function() {
        try {
            var urlToSave       = gContextMenu.target.ownerDocument.URL;
            var editorPath      = gViewSourceWithMain.getEditorPath();
            var filePath;
    
            if (editorPath == "") {
                return;
            }
            if (gViewSourceWithMain.isLocalPage(urlToSave)) {
                // view file without save it
                filePath = gViewSourceWithMain.common.makeLocalFileByUrl(urlToSave);
            } else {
                filePath = gViewSourceWithMain.common.makeLocalFile(
                                    gViewSourceWithMain.prefs.destFolder, 
                                    [gViewSourceWithMain.getFileName(urlToSave)]);
                gViewSourceWithMain.saveSourcePage(urlToSave, filePath);
            }
            gViewSourceWithMain.common.runProgram(editorPath, [filePath.path]);
        } catch (err) {
            alert("viewPage: " + err);
        }
    },
    
    getEditorPath : function() {
        var editorPath = gViewSourceWithMain.prefs.editorPath;
        
        if (editorPath == "" || gViewSourceWithMain.prefs.destFolder == "") {
            gViewSourceWithMain.openDlgSettings();
            editorPath = gViewSourceWithMain.prefs.editorPath;
        }
        return editorPath;
    },
    
    openDlgSettings : function() {
        window.openDialog("chrome://viewsourcewith/content/settings.xul", 
                          "_blank", 
                          "chrome,resizable=yes,dependent=yes");
    },
    
    isLocalPage : function(url) {
        return url.substring(0, 7) == "file://";
    },
    
    getFileName : function(url) {
        //const CONTRACTID_STANDARD_URL   = "@mozilla.org/network/standard-url;1";
        //const nsIStandardURL            = Components.interfaces.nsIStandardURL;
        //var uri = Components.classes[CONTRACTID_STANDARD_URL].createInstance(nsIStandardURL);
        const contractIDStdURL = "@mozilla.org/network/standard-url;1";
        const nsIURL = Components.interfaces.nsIURL;
        var uri = Components.classes[contractIDStdURL].createInstance(nsIURL);
    
        uri.filePath = url;
    
        // This url contains only directory name (e.g. http://www.xulplanet.com/)
        var re = /\/([^\/]+)\/$/;
        var path = uri.path.match(re);
        if (path && path.length > 1) {
            return gViewSourceWithMain.getPortableFileName(path[1]);
        }
        return gViewSourceWithMain.getPortableFileName(uri.fileName);
    },
    
    /**
     * Replace following chars with underscore (_)
     * \ / : * ? " < > |
     */
    getPortableFileName : function(fileName) {
        return fileName.replace(/[\\\/\:\*\?\"\<\>\| ]+/g, "_");
    },
    
    saveSourcePage : function(url, file) {
        var uri = gViewSourceWithMain.common.makeURL(url);
        var target = gViewSourceWithMain.common.makeFileURL(file);
    
        const nsIWBP = Components.interfaces.nsIWebBrowserPersist;
        var persist = gViewSourceWithMain.common.makeWebBrowserPersist();
        persist.persistFlags = nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES
                               | nsIWBP.PERSIST_FLAGS_FROM_CACHE;
        persist.saveURI(uri, null, null, null, null, target);
    }
};

window.addEventListener("load", gViewSourceWithMain.onLoad, false);
