/**
 * Author: Davide Ficano
 * Date  : 22-Nov-04
**/
var gViewSourceSettings = {
    onLoad : function() {
        sizeToContent();
        gViewSourceSettings.prefs = new ViewSourceWithPrefs();
        gViewSourceSettings.common = new ViewSourceWithCommon();
        gViewSourceSettings.initControls();
    },

    onAccept : function() {
        var isValid = false;
        
        try {
            isValid = gViewSourceSettings.checkEditor() 
                      && gViewSourceSettings.checkDestFolder();
    
            if (isValid) {
                gViewSourceSettings.prefs.editorPath = gViewSourceSettings.oEditorAppPath.value;
                gViewSourceSettings.prefs.destFolder = gViewSourceSettings.oDestFolder.value;
            }
        } catch (err) {
            alert("viewsourcewithsettings.onAccept: " + err);
        }
    
        return isValid;
    },

    checkEditor : function() {
        var isValid = false;
        
        try {
            var editorFile = gViewSourceSettings.common.makeLocalFile(
                                gViewSourceSettings.oEditorAppPath.value);
            isValid = editorFile.isFile() && editorFile.isExecutable();
        } catch (err) {
        }
        if (!isValid) {
            alert(gViewSourceSettings.common.getLocalizedMessage("err.invalidEditor"));
        }
        return isValid;
    },

    checkDestFolder : function() {
        var isValid = false;
        
        try {
            var destFile = gViewSourceSettings.common.makeLocalFile(
                                gViewSourceSettings.oDestFolder.value);
            isValid = destFile.isDirectory();
        } catch (err) {
        }
            
        if (!isValid) {
            alert(gViewSourceSettings.common.getLocalizedMessage("err.invalidSourceFolder"));
        }
        return isValid;
    },

    onPickEditor : function() {
        const nsIFilePicker = Components.interfaces.nsIFilePicker;
        
        var fp = gViewSourceSettings.common.makeFilePicker(window, 
                    gViewSourceSettings.common.getLocalizedMessage("picktitle.editor"));
        fp.appendFilters(nsIFilePicker.filterApps);
        gViewSourceSettings.setDisplayDirectory(fp, gViewSourceSettings.oEditorAppPath.value);
        
        var res = fp.show();
        if (res == nsIFilePicker.returnOK) {
            gViewSourceSettings.oEditorAppPath.value = fp.file.path;
        }    
        return true;
    },

    onPickDestFolder : function() {
        const nsIFilePicker = Components.interfaces.nsIFilePicker;
        
        var fp = gViewSourceSettings.common.makeFilePicker(window, 
                        gViewSourceSettings.common.getLocalizedMessage("picktitle.destfolder"), 
                        nsIFilePicker.modeGetFolder);
        gViewSourceSettings.setDisplayDirectory(fp, gViewSourceSettings.oDestFolder.value);
        
        var res = fp.show();
        if (res == nsIFilePicker.returnOK) {
            gViewSourceSettings.oDestFolder.value = fp.file.path;
        }    
        return true;
    },

    setDisplayDirectory : function(filePicker, path) {
        try {
            var currDir = gViewSourceSettings.common.makeLocalFile(path);
            if (currDir.isFile()) {
                currDir = currDir.parent;
            }
            if (currDir.isDirectory()) {
                filePicker.displayDirectory = currDir;
            }
        } catch (err) {
            // simply don't set displayDirectory
        }
    },

    initControls : function() {
        gViewSourceSettings.oEditorAppPath = document.getElementById("editorpath");
        gViewSourceSettings.oDestFolder = document.getElementById("destFolder");
    
        gViewSourceSettings.oEditorAppPath.value = gViewSourceSettings.prefs.editorPath;
        gViewSourceSettings.oDestFolder.value = gViewSourceSettings.prefs.destFolder;
    }
};
