/**
 * Author: Davide Ficano
 * Date  : 22-Nov-04
**/

const VSW_PREF_EDITOR_PATH = "dafi.viewsource.editorPath";
const VSW_PREF_SOURCE_FOLDER = "dafi.viewsource.destFolder";

function ViewSourceWithPrefs() {
    this.prefBranch = Components.classes['@mozilla.org/preferences-service;1']
                      .getService()
                      .QueryInterface(Components.interfaces.nsIPrefBranch);
    this.editorDescr = "";
    this.common = new ViewSourceWithCommon();
}

ViewSourceWithPrefs.prototype = {
    get editorPath() {
        var path = this.getString(VSW_PREF_EDITOR_PATH);
        return path == null ? "" : path;
    },

    set editorPath(path) {
        if (path != null && path.length > 0) {
            this.setString(VSW_PREF_EDITOR_PATH, path);
            this.editorDescr = "";
        }
    },

    get editorDescription() {
        var name = this.editorDescr;
        try {
            if (name == "" && this.editorPath != "") {
                name = this.common.makeLocalFile(this.editorPath).leafName;
                // remove extension (if any)
                name = name.replace(/\.[^\.]*/, "");
                if (name.length > 8) {
                    name = name.substring(0, 8);
                }
                this.editorDescr = name;
            }
        } catch (err) {
            //alert(err);
        }
        return this.editorDescr;
    },
    
    get destFolder() {
        var folder = this.getString(VSW_PREF_SOURCE_FOLDER);
        return folder == null ? "" : folder;
    },

    set destFolder(folder) {
        if (folder != null && folder.length > 0) {
            this.setString(VSW_PREF_SOURCE_FOLDER, folder);
        }
    },

    getString : function(prefName, defValue) {
        var prefValue;
        try {
            prefValue = this.prefBranch.getCharPref(prefName);
        } catch (ex) {
            prefValue = null;
        }
        return prefValue == null ? defValue : prefValue;
    },

    setString : function(prefName, prefValue) {
        this.prefBranch.setCharPref(prefName, prefValue);
    }
};
