/**
 * Author: Davide Ficano
 * Date  : 22-Nov-04
**/

function ViewSourceWithCommon() {
    this.gPathSeparator = top.window.navigator.platform.indexOf("Win") < 0 ? "/" : "\\";

    return this;
}

ViewSourceWithCommon.prototype = {
    makeWebBrowserPersist : function() {
      return Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"]
                .createInstance(Components.interfaces.nsIWebBrowserPersist);
    },

    makeLocalFile : function(path, arrayAppendPaths) {
        var file = Components.classes["@mozilla.org/file/local;1"]
                   .createInstance(Components.interfaces.nsILocalFile);
        file.initWithPath(path);
        
        if (arrayAppendPaths != null 
            && arrayAppendPaths != undefined 
            && arrayAppendPaths.length) {
            for (i = 0; i < arrayAppendPaths.length; i++) {
                file.append(arrayAppendPaths[i]);
            }
        }
        return file;
    },
    
    makeFileURL : function(aFile) {
      var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                        .getService(Components.interfaces.nsIIOService);
      return ioService.newFileURI(aFile);
    },

    makeURL : function(aURL) {
      var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                                .getService(Components.interfaces.nsIIOService);
      return ioService.newURI(aURL, null, null);
    },
    
    makeLocalFileByUrl : function(url) {
        return this.makeURL(url)
                .QueryInterface(Components.interfaces.nsIFileURL)
                .file.clone(Components.interfaces.nsILocalFile);
    },
    
    runProgram : function(theFile, theArgs) {
        const nsIProcess                    = Components.interfaces.nsIProcess;
        const nsILocalFile                  = Components.interfaces.nsILocalFile;
        const CONTRACTID_PROCESS            = "@mozilla.org/process/util;1";
        const CONTRACTID_LOCAL_FILE         = "@mozilla.org/file/local;1";
    
    	var execFile = Components.classes[CONTRACTID_LOCAL_FILE].createInstance(nsILocalFile);
    	execFile.initWithPath(theFile);
    	
    	var theProcess = Components.classes[CONTRACTID_PROCESS].createInstance(nsIProcess)
    	theProcess.init(execFile);
    	var numArgs = theArgs ? theArgs.length : 0;
    
    	theProcess.run(false, theArgs, numArgs, {});
    },
    
    getLocalizedMessage : function(msg) {
        return document.getElementById("viewsourcewith.locale").getString(msg);
    },
    
    getFormattedMessage : function(msg, ar) {
        return document.getElementById("viewsourcewith.locale")
                .getFormattedString(msg, ar);
    },
    
    makeFilePicker : function(win, title, mode) {
        const nsIFilePicker                 = Components.interfaces.nsIFilePicker;
        const CONTRACTID_FILE_PICKER        = "@mozilla.org/filepicker;1";
        
        if (mode == null || mode == undefined) {
            mode = nsIFilePicker.modeOpen;
        }
        var fp = Components.classes[CONTRACTID_FILE_PICKER]
                    .createInstance(nsIFilePicker);
        fp.init(win, title, mode);
        
        return fp;
    },
};    
