/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is ToolbarMode for mozilla.
 *
 * The Initial Developer of the Original Code is Martin Rademacher.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Martin Rademacher
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


/* ++++ clicked toolbar +++++++++++++++++++++++++++++++++*/
var toolbarmode_clickedToolbar = null;


/* ++++ interupt event +++++++++++++++++++++++++++++++++*/
function toolbarmode_onPopupShowing(event) {
	event.stopPropagation();
}

function toolbarmode_setToolbarMode(elt) {
	if (toolbarmode_clickedToolbar) {
		var mode = elt.value;
		toolbarmode_clickedToolbar.setAttribute("mode", mode);

		// persist mode; see toolkit/content/global/customizeToolbar.js
		var toolboxDoc = document.getElementById("navigator-toolbox").ownerDocument;
		dump('toolboxDoc ='+toolboxDoc + '\n');
  	toolboxDoc.persist(toolbarmode_clickedToolbar.id, "mode");
	}
	toolbarmode_clickedToolbar = null;
}

function toolbarmode_setToolbarIcons(elt) {
	if (toolbarmode_clickedToolbar) {
		var val = 'small' == elt.value ? "small" : null;
		
		toolbarmode_clickedToolbar.setAttribute("iconsize", val);

		// persist mode; see toolkit/content/global/customizeToolbar.js
		var toolboxDoc = document.getElementById("navigator-toolbox").ownerDocument;
		dump('toolboxDoc ='+toolboxDoc + '\n');
  	toolboxDoc.persist(toolbarmode_clickedToolbar.id, "iconsize");
		}
	toolbarmode_clickedToolbar = null;
}

function toolbarmode_click(event) {
	if (2 == event.button) {
		// right click
		toolbarmode_clickedToolbar = null;
		var node = event.target;
		// if there are more levels, there is no hope...
		for (var ii=0; ii < 8; ++ii) {
			if ("toolbar" == node.nodeName) {
				toolbarmode_clickedToolbar = node;
				break;
			}
			node = node.parentNode;
		}
		if (toolbarmode_clickedToolbar) {
			dump('toolbar context click ' + toolbarmode_clickedToolbar.id + '\n');
			var mode = toolbarmode_clickedToolbar.getAttribute("mode");
			dump('current mode is ' + mode + '\n');
			if ('' == mode) {
				// uses browser setting
				var navBar = document.getElementById("nav-bar");
				if (navBar) {
					mode = navBar.getAttribute("mode");
				}
				dump('using browser mode ' + mode + '\n');
			}

			// check current mode
			var modeMenu = document.getElementById("toolbarmode-mode-menu");
			if (modeMenu) {
				var popupMenu = modeMenu.childNodes[0];
				for (var ii=0; ii < popupMenu.childNodes.length; ++ii) {
					var child = popupMenu.childNodes[ii];
      		child.setAttribute("checked", mode == child.getAttribute("value"));
				}
			}

			var icons = toolbarmode_clickedToolbar.getAttribute("iconsize");
			if (!icons) {
				icons = 'large';
			}
			dump('current icons is ' + icons + '\n');

			// check current icons
			var iconsMenu = document.getElementById("toolbarmode-icons-menu");
			if (iconsMenu) {
				var popupMenu = iconsMenu.childNodes[0];
				for (var ii=0; ii < popupMenu.childNodes.length; ++ii) {
					var child = popupMenu.childNodes[ii];
      		child.setAttribute("checked", icons == child.getAttribute("value"));
				}
			}
		}
	} else {
			toolbarmode_clickedToolbar = null;
	}
}

function getMainWindow() {
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
  var eb = windowManagerInterface.getEnumerator("navigator:browser");
  if (eb.hasMoreElements()) {
    return eb.getNext().QueryInterface(Components.interfaces.nsIDOMWindow);
	}
	return null;
}

function toolbarmode_isEnabled() {
	var toolbarmodePrefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	try {
		return toolbarmodePrefs.getBoolPref("extensions.toolbarmode.contextMenu");
	} catch (e) {
		return false;
	}
	return false;
}

function toolbarmode_setState(state) {
	var domWin = getMainWindow();
	dump('set toolbar context menu state=' + state + '\n');
	var modeMenu = domWin.document.getElementById("toolbarmode-context-menu");
	if (!modeMenu)
		return;
	modeMenu.setAttribute("hidden", !state);
	var sep = domWin.document.getElementById("toolbarmode-sep");
	sep.setAttribute("hidden", !state);
}

function toolbarmode_refreshState() {
	toolbarmode_setState(toolbarmode_isEnabled());
}

window.addEventListener("click", toolbarmode_click, true);
