
const gTinyUrl_Version		= "0.6";
const gTinyUrl_DownloadSite	= "http://jgillick.nettripper.com/tinyurl/";

var oDialog		 	= null;
var oLongUrlField 	= null;
var oTabBox		 	= null;
var oSavedTree	 	= null;
var oSavedTreeItems	= null;

var oTinyUrlRequest	= null;
	
var sFormMethod			= "POST";
var sFormSubmit			= "http://tinyurl.com/create.php";
var sFormArgument		= "url";

var sTinyUrlRegExp		= new Array();
	sTinyUrlRegExp[0]	= "<input\\s*type\\s*=\\s*('|\")?hidden('|\")?\\s*name\\s*=\\s*('|\")?tinyurl('|\")?\\s*value\\s*=\\s*('|\")?(http:\\/\\/tinyurl\\.com\\/[^\"'\\s>]*)('|\")?\\s*\\/?\\s*>";
	sTinyUrlRegExp[1]	= "<blockquote>http:\\/\\/tinyurl.com\\/([^\\s<]*)</blockquote>";

function tinyurl_overlayInit(){
	try{
		var oContext = document.getElementById("contentAreaContextMenu");
			oContext.setAttribute("onpopupshowing", "tinyurl_contextShowing(event); "+ oContext.getAttribute("onpopupshowing"));
	} catch(err) { alert(err); }
}
	
function tinyurl_load(){
	oDialog			= document.getElementById("tinyurlDialogMain");
	oLongUrlField 	= document.getElementById("longurl-field");
	oTabBox			= document.getElementById("tinyurl-tabs");
	oSavedTree		= document.getElementById("saved-tree");
	oSavedTreeItems	= document.getElementById("saved-items");
	
	//Check for updates
	setTimeout("tinyurl_autoUpdate()", 500);
	
	// Is RDF Present
	tinyurl_saved_rdfCreate();
	
	// Load Saved Data
	tinyurl_saved_read();
	
	// Preload Field
	if(opener.gBrowser && opener.gBrowser.currentURI){
		oLongUrlField.value = opener.gBrowser.currentURI.spec;
	}
	
	// Goto Save Tab
	if(window.arguments.length > 0 && window.arguments[0] == "saved"){
		oTabBox.selectedTab		= document.getElementById("tinyurl-saved-tab");
		oTabBox.selectedPanel	= document.getElementById("tinyurl-saved-tabpanel");
	}
}

// Pass currentl URL onto tinyurl_create
function tinyurl_createFromCurrent(){
	tinyurl_create(gBrowser.currentURI.spec, window._content.document.title);
}

// Pass url entered in dialog to tinyurl_create
function tinyurl_createNew(){
	try{
		
		// If not in main tab
		if(oTabBox.selectedTab.id != "tinyurl-create-tab")
			return;
		
		// Validate
		if(oLongUrlField == null || oLongUrlField.value == ""){
			alert("You have not entered a long url");
			return;
		}
		
		// Title
		var sTitle = "";
		if(opener && oLongUrlField.value == opener.gBrowser.currentURI.spec)
			sTitle = opener.window._content.document.title;
		
		// Get TinyUrl
		var sTiny = tinyurl_create(oLongUrlField.value, sTitle, false);
		
		// Output
		if(sTiny != null){
			document.getElementById("tinyurl-field").value = sTiny;
			document.getElementById("copy-button").disabled = false;
			document.getElementById("save-button").setAttribute("oncommand", "tinyurl_saved_add('"+ sTiny +"', '"+ oLongUrlField.value +"');");
			document.getElementById("save-button").disabled = false;
		}
		
		document.getElementById('tinyurlDialogMain').style.cursor = 'default';
		
	}catch(err){ alert("Error 120\nAn unknown error occurred\n"+ err); }
}

// Create from Context Menu on Anchor
function tinyurl_createFromAncor(){
	if(gContextMenu != null && gContextMenu.linkURL() != null){
		tinyurl_create(gContextMenu.linkURL(), null, true);
	}
}

// Returns TinyUrl from sUrl
function tinyurl_create(sUrl, sTitle, sAlert){
	try{
		var oAbort = window.setTimeout("tinyurl_abort();", 5000); // Abort after 5 seconds
	
		// Make Request	
		oTinyUrlRequest	= new XMLHttpRequest();
		oTinyUrlRequest.open(sFormMethod, sFormSubmit, false);
		oTinyUrlRequest.setRequestHeader("User-Agent", navigator.userAgent);
		oTinyUrlRequest.setRequestHeader("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,video/x-mng,image/png,image/jpeg,image/gif;q=0.2,*/*;q=0.1");
		oTinyUrlRequest.setRequestHeader("Accept-Language", navigator.language);
		oTinyUrlRequest.setRequestHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
		oTinyUrlRequest.setRequestHeader("Referer", "http://tinyurl.com/");
		oTinyUrlRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
       	oTinyUrlRequest.send(sFormArgument +"="+ escape(sUrl));
		
		// Cancel abort
		window.clearTimeout(oAbort);
		
		// If aborted
		if(oTinyUrlRequest == null)
			return;
		
		//Parse Response
		var sResponse = oTinyUrlRequest.responseText;
		
		//Find tiny url
		var sTinyUrl = null;
		
			//First Pass
			var oRegExp = new RegExp(sTinyUrlRegExp[0], "i");
			var aFound	= oRegExp.exec(sResponse);
			if(aFound != null && aFound.length > 0)
				sTinyUrl = aFound[6];
			
			//Second Pass
			if(sTinyUrl == null){
				oRegExp = new RegExp(sTinyUrlRegExp[1], "i");
				aFound	= oRegExp.exec(sResponse);
				if(aFound != null && aFound.length > 0)
					sTinyUrl = aFound[1];
			}
		
		//Send no-worky alert
		if(sTinyUrl == null){
			setTimeout("alert('Could not create that TinyUrl...is your internet connection up?')", 50);
			try{
				var oErrorRequest = new XMLHttpRequest();
					oErrorRequest.open("POST", "http://jgillick.nettripper.com/tinyurl/noworky.php", true);
					oErrorRequest.setRequestHeader("Keep-Alive", "300");
					oErrorRequest.setRequestHeader("Connection", "keep-alive");
					oErrorRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		        	oErrorRequest.send("url="+ escape(sUrl) +"&version="+ escape(gTinyUrl_Version) +"&exp1="+ escape(sTinyUrlRegExp[0]) +"&exp2="+ escape(sTinyUrlRegExp[1]) +"&action="+ escape(sFormSubmit) +"&content="+ escape(sResponse));
			}catch(err){ }
		}
		
		// Copy and alert user
		else if(sAlert == null || sAlert == true){
			tinyurl_copyText(sTinyUrl);
			tinyurl_alertUser(sTinyUrl, sUrl, sTitle);
		}
		
		// Return
		else{
			return sTinyUrl;
		}
		
	}catch(err){ oTinyUrlRequest = null; alert("Could not create that TinyUrl...is your internet connection up?"); }
}

// Abort TinyUrl Creation
function tinyurl_abort(){
	if(oTinyUrlRequest != null){
		oTinyUrlRequest.abort();
		alert("Could not contact TinyUrl service.");
		oTinyUrlRequest = null;
	}
}

//Send text to tinyurl_copyText()
function tinyurl_copy(){
	try{
		var oField = document.getElementById("tinyurl-field");
		
		if(oField == null || oField.value == ""){
			return;
		}
		
		//Copy
	  	tinyurl_copyText(oField.value);
		
	}catch(err){ alert("Error 140\nCouldn't copy to clipboard"); }
}

// Comand from key stroke
function tinyurl_copy_command(){
	if(oTabBox.selectedTab.id == "tinyurl-create-tab"){
		tinyurl_copy();
	}
	else if(oTabBox.selectedTab.id == "tinyurl-saved-tab"){
		tinyurl_saved_copy();
	}
}

//Copies str to clipboard
function tinyurl_copyText(str){
	try{
		//Copy
		var oClipboard 	= Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
	  		oClipboard.copyString(str);
			
	}catch(err){ throw err }
}

// Alert User of tinyurl creation
function tinyurl_alertUser(tinyUrl, realUrl, title){
	var oPrefs 	= Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
	var sModal	= ", modal";

	// Not Modal
	if(oPrefs.prefHasUserValue("tinyurl.confirmation.hide") && oPrefs.getBoolPref("tinyurl.confirmation.hide"))
		sModal = "";	

	window.openDialog('chrome://tinyurl/content/done.xul','TinyUrlDone','centerscreen, chrome'+ sModal, tinyUrl, realUrl, title).focus();
}

//If there is a new version, returns the XPI url, else returns false
function tinyurl_needsUpgrade(){
	
	try{
		// Get current version and XPI from remote RDF
		var oRdf			= Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
		var oDs				= oRdf.GetDataSourceBlocking("http://jgillick.nettripper.com/plugins.rdf?p=tinyurl&rand="+  Math.round(Math.random() * 200));
		var oTinyUrl		= oRdf.GetResource("http://jgillick.nettripper.com/rdf/tinyurl");
				
		var sVersion		= oDs.GetTarget(oTinyUrl, oRdf.GetResource("http://jgillick.nettripper.com/rdf#version"), true);
		var sXpi			= oDs.GetTarget(oTinyUrl, oRdf.GetResource("http://jgillick.nettripper.com/rdf#xpi"), true);
						
		//Not literals
		if( !(sVersion instanceof Components.interfaces.nsIRDFLiteral)
			|| !(sXpi instanceof Components.interfaces.nsIRDFLiteral)){
			return false;
		}
		//No Update
		else if(gTinyUrl_Version >= sVersion.Value){
			return false
		}
		else{
			return sXpi.Value;
		}
	}catch(err){ return false; }
}

//Alert user of new version
function tinyurl_autoUpdate(){
		
	try{
	
		//Alert User
		var oPrefs	= Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
		if(!oPrefs.prefHasUserValue("tinyurl.update.notify") || oPrefs.getBoolPref("tinyurl.update.notify")){
		
			//Has 24 hours past since last notification
			var iYesterday = ((new Date()).getTime() / 1000) - 86400;
			if((!oPrefs.prefHasUserValue("tinyurl.update.notify.time") || oPrefs.getIntPref("tinyurl.update.notify.time") <= iYesterday)
				&& (sXpi = tinyurl_needsUpgrade()) != false){
				
				//Update timestamp
				oPrefs.setIntPref("tinyurl.update.notify.time", ((new Date()).getTime() / 1000));
				
				//Show Notification Dialog
				window.openDialog("chrome://tinyurl/content/dialogs/update.xul","tinyUrlUpdate","centerscreen, chrome, modal", sXpi);
			}
		}
		
	}catch(err){ }
}

// Context Showing
function tinyurl_contextShowing(event){
	try{
		if(document.popupNode.nodeName.toUpperCase() == "A"){
			document.getElementById("tinyurl-context-link-menu").setAttribute("collapsed", false);
		}
		else {
			document.getElementById("tinyurl-context-link-menu").setAttribute("collapsed", true);
		}
	} catch(e) {}
}

//Opens http://tinyurl.com
function tinyurl_gotoTinyUrl(){
	opener.focus();
	self.focus();
	
	if(opener.gBrowser.addTab)
		opener.gBrowser.selectedTab = opener.gBrowser.addTab("http://tinyurl.com");
	else
		window.open("http://tinyurl.com");
}