
var oProps 		= Components.classes["@mozilla.org/file/directory_service;1"].getService(Components.interfaces.nsIProperties);
var sUserChrome	= (oProps.get("UChrm", Components.interfaces.nsIFile)).path;
var sPathSeperator = "\\";
if(sUserChrome[0].indexOf("/") > -1) sPathSeperator = "/";

var sTinyRdfName	= "tinyurl.rdf";
var sTinyRdfPath	= sUserChrome + sPathSeperator + sTinyRdfName;

// RDF Vars
var gTinyRdf		= null;
var gTinyDs			= null;
var gTinyRdfUtil	= null;
var gTinyRdfC 		= null;
var gTinyRdfRoot	= "http://jgillick.nettripper.com/tinyurl";

// Create RDF File if it does not exist
function tinyurl_saved_rdfCreate(){
	try{
		
		var oFileLocal	= Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);	
			oFileLocal.initWithPath(sTinyRdfPath);	
		
		// Doesn't Exist?
		if(!oFileLocal.exists()){
					
			// Read RDF
			var oRequest	= new XMLHttpRequest();
				oRequest.open("GET", "chrome://tinyurl/content/"+ sTinyRdfName, false);
	        	oRequest.send("");
			var sContent	= oRequest.responseText;
			
			// Write
			oFileLocal.create(0x00, 0666);
			var oFileOut = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
				oFileOut.init(oFileLocal, 0x20 | 0x02, 00666, null);
				oFileOut.write(sContent, sContent.length);
				oFileOut.flush();
				oFileOut.close();
		}
	
	}catch(err){ }
		
}

// Enable Buttons
function tinyurl_saved_disable(dis){
	document.getElementById('go-saved-button').disabled = dis;
	document.getElementById('copy-saved-button').disabled = dis;
	document.getElementById('edit-saved-button').disabled = dis;
	document.getElementById('remove-saved-button').disabled = dis;
	
	if(dis){
		document.getElementById('go-saved-button').image = "chrome://tinyurl/content/icons/go_off.png";
		document.getElementById('copy-saved-button').image = "chrome://tinyurl/content/icons/copy_off.png";
		document.getElementById('edit-saved-button').image = "chrome://tinyurl/content/icons/edit_off.png";
		document.getElementById('remove-saved-button').image = "chrome://tinyurl/content/icons/remove_off.png";
	}
	else{
		document.getElementById('go-saved-button').image = "chrome://tinyurl/content/icons/go.png";
		document.getElementById('copy-saved-button').image = "chrome://tinyurl/content/icons/copy.png";
		document.getElementById('edit-saved-button').image = "chrome://tinyurl/content/icons/edit.png";
		document.getElementById('remove-saved-button').image = "chrome://tinyurl/content/icons/remove.png";
	}
}

// Goto Saved Url
function tinyurl_saved_go(){
	var sUri = oSavedTree.contentView.getItemAtIndex(oSavedTree.currentIndex).getAttribute("uri");
	
	// Get Real Url
	try{
		var aProps = tinyurl_saved_getEntry(sUri);
		
		if(opener){
			opener.gBrowser.selectedTab = opener.gBrowser.addTab(aProps["realurl"]);
		}
		else{
			window.open(aProps["realurl"]);
		}
		
		setTimeout("self.focus()", 100);
		
	}catch(err) { alert("Error: 560\n Could not access that URL\n"+ err); }
}

// Copy TinyUrl
function tinyurl_saved_copy(){
	if(oSavedTree.currentIndex > -1){
		var sUri = oSavedTree.contentView.getItemAtIndex(oSavedTree.currentIndex).getAttribute("uri");
		try{
			var aProps = tinyurl_saved_getEntry(sUri);
			tinyurl_copyText(aProps["tinyurl"]);		
		}catch(err){ alert("Error: 580\n Could not copy that URL\n"+ err); }
	}
}

// Open Edit Dialog
function tinyurl_saved_openEdit(){
	var sUri = oSavedTree.contentView.getItemAtIndex(oSavedTree.currentIndex).getAttribute("uri");
	
	if(sUri != null && sUri != "")
		window.openDialog('chrome://tinyurl/content/tinyurl_edit.xul','TinyUrlEditDialog','centerscreen, chrome, modal, resizable', sUri).focus()
}

// Read RDF Entries
function tinyurl_saved_read(){
	if(oSavedTreeItems == null)
		return;
		
	try{
		tinyurl_saved_initRdf();
		
		// Remove All Existing
		while(oSavedTreeItems.childNodes.length > 0)
			oSavedTreeItems.removeChild(oSavedTreeItems.firstChild);
			
		// Read From RDF
		var aProps		= null;
		var oTrgt		= null;
		var oTreeItem	= null;
		var oTreeRow	= null;
		var oTreeCell	= null;
		var aElements	= gTinyRdfC.GetElements();
		while(aElements.hasMoreElements()){
			try{
				var oRes = aElements.getNext();
					oRes = oRes.QueryInterface(Components.interfaces.nsIRDFResource);
				
				oTreeItem	= document.createElement("treeitem");
				oTreeItem.setAttribute("uri", oRes.Value);
				oTreeRow	= oTreeItem.appendChild(document.createElement("treerow"));
				
				aProps = tinyurl_saved_getEntry(oRes.Value);
				
				// Title
				oTreeRow.appendChild(document.createElement("treecell")).setAttribute("label", aProps["title"])
				// TinyUrl
				oTreeRow.appendChild(document.createElement("treecell")).setAttribute("label", aProps["tinyurl"])
				// Real Url
				oTreeRow.appendChild(document.createElement("treecell")).setAttribute("label", aProps["realurl"])
				
				oSavedTreeItems.appendChild(oTreeItem);
				
			}catch(err){ }
		}
		
		tinyurl_saved_disable(true);
		
	}catch(err) { alert("Error 500\nAn unknown error occurred loading saved data\n"+ err); }
}

// Remvoe RDF Entry
function tinyurl_saved_remove(){
	
	var sUri 	= oSavedTree.contentView.getItemAtIndex(oSavedTree.currentIndex).getAttribute("uri");
	var iSelect	= oSavedTree.currentIndex;
	
	if(sUri != null && sUri != "" && confirm("Are you SURE you want to remove this entry?")){
		try{
			tinyurl_saved_initRdf();
			
			var oRes 		= gTinyRdf.GetResource(sUri);
			
			// Remove All Archs
			var aArchs		= null;
			var hasArchs	= true;
			while(hasArchs){
				aArchs 		= gTinyDs.ArcLabelsOut(oRes);
				hasArchs 	= aArchs.hasMoreElements();
				while(aArchs.hasMoreElements()){
					oArch = aArchs.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
					
					//Remove
					gTinyDs.Unassert(oRes, oArch, gTinyDs.GetTarget(oRes, oArch, true));
				}
			}
			
			// Remove Element
			gTinyRdfC.RemoveElement(oRes, true);
			
			// Rewrite Tree
			tinyurl_saved_read()
			
			// Select Row
			if(iSelect > oSavedTree.view.rowCount - 1)
				oSavedTree.view.selection.select(oSavedTree.view.rowCount - 1);
			else
				oSavedTree.view.selection.select(iSelect);
			
		}catch(err){ alert("Error 520\nCould not remove that entry.\n"+ err); }
	}
}

// Add RDF Entry
function tinyurl_saved_add(tinyUrl, realUrl, title){
	var sTitle		= "";
	var sTimestamp	= (new Date()).getTime();
	var sTiny		= tinyUrl;
	var sReal		= realUrl;
	var sPageTitle	= (title == null) ? "" : title;
	var sUri		= "http://jgillick.nettripper.com/tinyurl/";
	var oRes		= null;
	
	tinyurl_saved_rdfCreate();
	
	// Get Uri
	if(sTiny.length > "http://tinyurl.com/".length){
		sUri += sTiny.substring(("http://tinyurl.com/".length));
	}
	else{ sUri = null; }
	
	// Is this TinyUrl already saved?
	try{
		tinyurl_saved_initRdf();
		oRes = gTinyRdf.GetResource(sUri);
		
		if(gTinyRdfC.IndexOf(oRes) > -1){
			if(message != null && message != ""){
				alert(message)
			}
			return;
		}		
	}catch(err){ }
	
	if(!sTiny || !sReal)
		return;
	
	// Check Uri
	if(sUri == null){
		alert("Error 540\nCould not save that TinyUrl.\n"+ tinyUrl);
		return;
	}
	
	// Get Title
	while(true){
		sTitle = prompt("Title to save it under:", sPageTitle);
		
		// Empty
		if(sTitle == ""){
			alert("You must enter a title.");
		}
		// null (cancel)
		else if(sTitle == null){
			break;
		}
		// Duplicate
		else if(tinyurl_saved_getUriForTitle(sTitle) != null){
			alert("A saved TinyUrl entry already exists with that title.");
		}
		else{
			break;
		}
	}
	
	if(sTitle != null){
		try{
			tinyurl_saved_initRdf()
			var oRes = gTinyRdf.GetResource(sUri);
			gTinyRdfC.AppendElement(oRes);
			gTinyDs.Assert(oRes, gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#title"), gTinyRdf.GetLiteral(sTitle), true);
			gTinyDs.Assert(oRes, gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#tinyurl"), gTinyRdf.GetLiteral(sTiny), true);
			gTinyDs.Assert(oRes, gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#realurl"), gTinyRdf.GetLiteral(sReal), true);
			gTinyDs.Assert(oRes, gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#created"), gTinyRdf.GetLiteral(sTimestamp), true);
			
		}catch(err){ alert("Error 541\nCould not save that TinyUrl.\n"+ err); }
		
		// Rewrite Tree
		tinyurl_saved_read();
	}
}

// Get favicon.ico for url
function tinyurl_saved_getFavIcon(sUrl){
	if(opener){
		
		// Get Url for favicon.ico
		var oUri 		= Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
			oUri.spec	= sUrl;
		var sFavUri		= opener.gBrowser.buildFavIconString(oUri);
				
		// Verify Exists
		try{
			var oRequest	= new XMLHttpRequest();
				oRequest.open("GET", sFavUri, false);
				oRequest.send("");
			
			if(oRequest.status == 200)
				return sFavUri;
			
		}catch(err) {  }
	}
	
	return "";
}


// Get Data From Entry
function tinyurl_saved_getEntry(sUri){
	var aProps	= new Array();
	
	try{
		tinyurl_saved_initRdf();
		
		var oRes 	= gTinyRdf.GetResource(sUri);
		
		// Get Resources
		aProps["title"]		= gTinyDs.GetTarget(oRes, gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#title"), true);
		aProps["tinyurl"]	= gTinyDs.GetTarget(oRes, gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#tinyurl"), true);
		aProps["realurl"]	= gTinyDs.GetTarget(oRes, gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#realurl"), true);
		aProps["created"]	= gTinyDs.GetTarget(oRes, gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#created"), true);
		
		// Get Values
		(aProps["title"] 	instanceof Components.interfaces.nsIRDFLiteral) ? aProps["title"] 	= aProps["title"].Value 	: aProps["title"] 	= "";
		(aProps["tinyurl"] 	instanceof Components.interfaces.nsIRDFLiteral) ? aProps["tinyurl"] = aProps["tinyurl"].Value 	: aProps["tinyurl"] = "";
		(aProps["realurl"] 	instanceof Components.interfaces.nsIRDFLiteral) ? aProps["realurl"] = aProps["realurl"].Value 	: aProps["realurl"] = "";
		(aProps["created"] 	instanceof Components.interfaces.nsIRDFLiteral) ? aProps["created"] = aProps["created"].Value 	: aProps["created"] = "";
		
	}catch(err){ throw err; }
	
	return aProps;
}

// Get Uri for title
function tinyurl_saved_getUriForTitle(sTitle){
	try{
		tinyurl_saved_initRdf();
	
		var oSubject	= gTinyDs.GetSource(gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#title"), gTinyRdf.GetLiteral(sTitle), true);
		if(oSubject instanceof Components.interfaces.nsIRDFResource)
			return oSubject.Value
			
	}catch(err) { throw err; }
	
	return null;
}

// Change Title to sTitle for sUri
function tinyurl_saved_changeTitle(sUri, sTitle){
	try{
		tinyurl_saved_initRdf();
		
		var oRes	= gTinyRdf.GetResource(sUri);
		var oProp	= gTinyRdf.GetResource("http://jgillick.nettripper.com/tinyurl/rdf#title");
		var sOld 	= gTinyDs.GetTarget(oRes, oProp, true); // Old Value
		
		//Change
		gTinyDs.Change(oRes, oProp, sOld, gTinyRdf.GetLiteral(sTitle));
			
	}catch(err) { throw err; }
	
	return null;
}


// Init RDF Objects
function tinyurl_saved_initRdf(){
	try{
		if(gTinyRdf == null)
			gTinyRdf = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);
		if(gTinyDs == null)
			gTinyDs	= gTinyRdf.GetDataSourceBlocking("file:///"+ sTinyRdfPath);
		if(gTinyRdfUtil == null)
			gTinyRdfUtil = Components.classes["@mozilla.org/rdf/container-utils;1"].getService(Components.interfaces.nsIRDFContainerUtils);
		if(gTinyRdfC == null){
			gTinyRdfC = Components.classes["@mozilla.org/rdf/container;1"].createInstance(Components.interfaces.nsIRDFContainer);
			
			//Get or Add Sequence
			if(gTinyRdfUtil.IsSeq(gTinyDs, gTinyRdf.GetResource(gTinyRdfRoot))){
				gTinyRdfC.Init(gTinyDs, gTinyRdf.GetResource(gTinyRdfRoot)); 
			}else{
				gTinyRdfC = gTinyRdfUtil.MakeSeq(gTinyDs, gTinyRdf.GetResource(gTinyRdfRoot)); //Create
			}
		}
				
	}catch(err){throw err}
}