// License: http://creativecommons.org/licenses/by-nc-sa/2.0/

var gSyncMarks = null;
var gBMFolderId = "";

////////////////////////////////////////////////////////////////////////////////
// Saves all settings to internal preferences.

function flush() {
  // save general settings
  gSyncMarks.settings.method = document.getElementById("method").selectedItem.value;
  gSyncMarks.settings.syncOnLoad = document.getElementById("autoload").checked;
  gSyncMarks.settings.syncOnExit = document.getElementById("autosave").checked;
  gSyncMarks.settings.fastSync = document.getElementById("fast-sync").checked;
  gSyncMarks.settings.bmFolder = gBMFolderId;

  // save favorites settings
  gSyncMarks.settings.favsFolder = document.getElementById("favs-folder").value;
  gSyncMarks.settings.favoritesEnabled = document.getElementById("enable-favs").checked;
  gSyncMarks.settings.favsClean = document.getElementById("favs-clean").checked;

  // save xml settings
  gSyncMarks.settings.xmlEnabled = document.getElementById("enable-xml").checked;
  gSyncMarks.settings.xmlFile = document.getElementById("xml-file").value;

  // save html settings
  gSyncMarks.settings.htmlEnabled = document.getElementById("enable-html").checked;
  gSyncMarks.settings.htmlBlank = document.getElementById("html-blank").checked;
  gSyncMarks.settings.htmlFile = document.getElementById("html-file").value;
  gSyncMarks.settings.htmlTitle = document.getElementById("html-title").value;

  // save ftp settings
  gSyncMarks.settings.ftpEnabled = document.getElementById("enable-ftp").checked;
  gSyncMarks.settings.ftpHost = document.getElementById("ftp-host").value;
  gSyncMarks.settings.ftpUser = document.getElementById("ftp-user").value;
  gSyncMarks.settings.ftpPasswd = document.getElementById("ftp-passwd").value;
  gSyncMarks.settings.ftpPath = document.getElementById("ftp-path").value;
  gSyncMarks.settings.ftpFormat = document.getElementById("ftp-format").selectedItem.value;
  gSyncMarks.settings.ftpProtocol = document.getElementById("ftp-protocol").selectedItem.value;
} //END: flush()

////////////////////////////////////////////////////////////////////////////////
// Sets all UI components based on saved internal settings.

function reload() {
  // restore general settings
  initBMFolder(gSyncMarks.settings.bmFolder);
  document.getElementById("autoload").checked = gSyncMarks.settings.syncOnLoad;
  document.getElementById("autosave").checked = gSyncMarks.settings.syncOnExit;
  document.getElementById("fast-sync").checked = gSyncMarks.settings.fastSync;
  document.getElementById("method").selectedItem =
    document.getElementById(gSyncMarks.settings.method);

  // restore favorites settings
  document.getElementById("enable-favs").checked = gSyncMarks.settings.favoritesEnabled;
  document.getElementById("favs-folder").value = gSyncMarks.settings.favsFolder;
  document.getElementById("favs-clean").checked = gSyncMarks.settings.favsClean;

  // restore xml settings
  document.getElementById("enable-xml").checked = gSyncMarks.settings.xmlEnabled;
  document.getElementById("xml-file").value = gSyncMarks.settings.xmlFile;

  // restore html settings
  document.getElementById("enable-html").checked = gSyncMarks.settings.htmlEnabled;
  document.getElementById("html-blank").checked = gSyncMarks.settings.htmlBlank;
  document.getElementById("html-file").value = gSyncMarks.settings.htmlFile;
  document.getElementById("html-title").value = gSyncMarks.settings.htmlTitle;

  // restore ftp settings
  document.getElementById("enable-ftp").checked = gSyncMarks.settings.ftpEnabled;
  document.getElementById("ftp-host").value = gSyncMarks.settings.ftpHost;
  document.getElementById("ftp-user").value = gSyncMarks.settings.ftpUser;
  document.getElementById("ftp-passwd").value = gSyncMarks.settings.ftpPasswd;
  document.getElementById("ftp-path").value = gSyncMarks.settings.ftpPath;
  document.getElementById("ftp-format").selectedItem =
    document.getElementById("ftp-" + gSyncMarks.settings.ftpFormat);
  document.getElementById("ftp-protocol").selectedItem =
    document.getElementById("ftp-" + gSyncMarks.settings.ftpProtocol);
} //END: reload()

////////////////////////////////////////////////////////////////////////////////
// Initialized the bookmark folder based on a given RDF URI.

function initBMFolder(uri) {
  var res = RDF.GetResource(uri);

  if (! BMSVC.isBookmarkedResource(res)){
    res = RDF.GetResource("NC:BookmarksRoot");
  }

  var nameArc = RDF.GetResource(NC_NS + "Name");
  var target = BMDS.GetTarget(res, nameArc, true);
  var name = (target) ? target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value : "";

  gBMFolderId = res.Value;
  document.getElementById("bm-folder").value = name;
} //END: initBMFolder

////////////////////////////////////////////////////////////////////////////////
// Beginns the sync operation when the "Synchronize Now" button is pressed.
// NOTE: settings are automatically saved prior to sync.

function synch() {
  flush();
  window.open("chrome://syncmarks/content/sync.xul", "_blank", "chrome,resizable,titlebar=no");
} //END: synch()

////////////////////////////////////////////////////////////////////////////////
// Displays file picker to select location of Windows Favorites folder.

function selectFavoritesFolder() {
  filePicker("favs-folder", "Specify Favorites Directory", true);
} //END: selectFavoritesFolder

////////////////////////////////////////////////////////////////////////////////
// Displays file picker to select location of HTML file.

function selectHTMLFile() {
  filePicker("html-file", "Select HTML Target", false);
} //END: selectHTMLFile

////////////////////////////////////////////////////////////////////////////////
// Displays file picker to select location of XML file.

function selectXMLFile() {
  filePicker("xml-file", "Select XML Target", false);
} //END: selectHTMLFile

////////////////////////////////////////////////////////////////////////////////
// Opens a picker to choose a file or folder.

function filePicker(formId, title, foldersOnly) {
  // the element that will be updated with the choice
  var docElement = document.getElementById(formId);

  // used to choose file
  const nsIFilePicker = Components.interfaces.nsIFilePicker;
  var picker = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);

  // currently selected XML file
  const nsILocalFile = Components.interfaces.nsILocalFile;
  var file = Components.classes["@mozilla.org/file/local;1"].createInstance(nsILocalFile);
  if (docElement.value) {
    try {
      file.initWithPath(docElement.value);
    } catch (e) {
      docElement.value = "";
    }
  }

  // initialize file picker
  picker.init(window, title, (foldersOnly) ? nsIFilePicker.modeGetFolder : nsIFilePicker.modeSave);
  picker.appendFilters(nsIFilePicker.filterAll);
  if (file.exists()) {
    picker.displayDirectory = file;
  }

  // display file picker & set text box accordingly
  var pick = picker.show();
  if ((pick == nsIFilePicker.returnOK) || (pick == nsIFilePicker.returnReplace)) {
    docElement.value = picker.file.path;
  }
} //END: filePicker

////////////////////////////////////////////////////////////////////////////////
// Opens a picker to choose bookmark folder.

function selectBMFolder() {
  window.open("chrome://syncmarks/content/selectBMFolder.xul", "_blank", "chrome,resizable,modal");
} //END: selectBMFolder

////////////////////////////////////////////////////////////////////////////////
// Called when FTP settings change.

function updateFtpUri() {
  document.getElementById("ftp-uri").value = gSyncMarks.settings.ftpURI;
} //END: updateFtpURI

////////////////////////////////////////////////////////////////////////////////
// Event Handler: called when "Ok" button is pressed.

function onOK() {
  flush();
} //END: onOK

////////////////////////////////////////////////////////////////////////////////

function onLoad() {
  gSyncMarks = new SyncMarks();
  reload();
} //END: onLoad

