// License: http://creativecommons.org/licenses/by-nc-sa/2.0/

function SyncMarksHandlerHTML(syncMarks) {
  this._init(syncMarks);
}

////////////////////////////////////////////////////////////////////////////////

SyncMarksHandlerHTML.prototype = {
  _syncMarks:null,
  _marks:null,

////////////////////////////////////////////////////////////////////////////////
// Initialize the bookmarks iterator.

  _init:function(syncMarks) {
    this._syncMarks = syncMarks;
    this._marks = this._syncMarks.bookmarks;
  },

////////////////////////////////////////////////////////////////////////////////
// The user's bookmarks represented as an HTML document.

  get _source() {
    var source = "<HTML><HEAD>\n";
    source += "<TITLE>" + this._syncMarks.settings.htmlTitle + "</TITLE>\n";
    source += "<HEAD><BODY>\n";
    source += this._getSource(this._marks.bookmarks);
    source += "\n</BODY></HTML>";

    return source;
  },


////////////////////////////////////////////////////////////////////////////////
// The specified bookmarks represented as an HTML document.

  _getSource:function(bmarks) {
    // walk through all the bookmarks and do their thang...
    var source = "<TABLE WIDTH=\"100%\"";
    source += " BORDER=\"0\" CELLPADDING=\"1\" CELLSPACING=\"0\"";
    source += ">\n";
    for (var idx = 0; idx < bmarks.length; idx++) {
      switch (bmarks[idx].type) {
        // if the bookmark is a folder, set its children...
        case "Folder":
        case "IEFavoriteFolder":
        case "PersonalToolbarFolder":
          source += "<TR><TH COLSPAN=\"2\" ALIGN=\"left\">";
          source += bmarks[idx].name;
          source += "</TH></TR>\n";

          source += "<TR><TD>&nbsp;&nbsp;</TD>";
          source += "<TD>\n";
          if (bmarks[idx].children != null) {
            source += this._getSource(bmarks[idx].children);
          }
          source += "</TD></TR>";
          break;

        // if the bookmark is a regular bookmark, create the new link file
        case "Bookmark":
        case "IEFavorite":
        case "ImmutableBookmark":
        case "Livemark":
          source += "<TR><TD COLSPAN=\"2\">";
          source += this._createHtmlLink(bmarks[idx]);
          source += "</TD></TR>\n";
          break;

        // add an HR for separators...
        case "BookmarkSeparator":
          source += "<TR BGCOLOR=\"#444444\"><TD COLSPAN=\"2\">";
          source += "<FONT SIZE=\"1\">&nbsp;</FONT>";
          source += "</TD></TR>";
          break;

        // ignore everything else
        default: break;
      }
    }
    source += "</TABLE>\n";

    return source;
  },

////////////////////////////////////////////////////////////////////////////////
// Returns the specified bookmark as an HTML string.

  _createHtmlLink:function(bmark) {
    var link = "<A HREF=\"" + bmark.url + "\"";
    if (this._syncMarks.settings.htmlBlank) {
      link += " TARGET=\"_blank\"";
    }
    link += ">" + bmark.name + "</A>";
    return link;
  },

////////////////////////////////////////////////////////////////////////////////
// Overwrite the HTML file with the Firefox bookmarks.

  push:function() {
    var folder = this._syncMarks.settings.favsFolder;

    // create the HTML file that will be used
    var file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
    file.initWithPath(this._syncMarks.settings.htmlFile); 
    if (! file.exists()) {
      file.create(0, 0644);
    }

    // set up the output stream to the file
    var outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
    outputStream.init(file, 0x20 | 0x02, 00004, null);

    // write the HTML source to the file
    var source = this._source;
    var result = outputStream.write(source, source.length);
    outputStream.flush();
    outputStream.close();
  },

////////////////////////////////////////////////////////////////////////////////
// Overwrite Firefox with the HTML file.

  pull:function() {
  },

////////////////////////////////////////////////////////////////////////////////
// Merge Firefox with the HTML file.

  merge:function() {
  },

////////////////////////////////////////////////////////////////////////////////
};

