// License: http://creativecommons.org/licenses/by-nc-sa/2.0/

function SyncMarksHandlerFTP(syncMarks) {
  this._init(syncMarks);
}

////////////////////////////////////////////////////////////////////////////////

SyncMarksHandlerFTP.prototype = {
  _syncMarks:null,
  _settings:null,
  _marks:null,
  _ioService:null,

////////////////////////////////////////////////////////////////////////////////
// Initialize the bookmarks iterator.

  _init:function(syncMarks) {
    this._syncMarks = syncMarks;
    this._settings = this._syncMarks.settings;
    this._marks = this._syncMarks.bookmarks;
    this._ioService = Components.classes["@mozilla.org/network/io-service;1"]
                      .getService(Components.interfaces.nsIIOService);
  },

////////////////////////////////////////////////////////////////////////////////
// Overwrite the FTP server data file with the Firefox bookmarks.

  push:function() {
    gBookmarksSynchronizerUploadService.start(this._source,
                                              this._uri,
                                              "text/" + this._settings.ftpFormat,
                                              this._uploadCallback);
  },

////////////////////////////////////////////////////////////////////////////////
// Overwrite Firefox with the FTP server data file.

  pull:function() {
  },

////////////////////////////////////////////////////////////////////////////////
// Merge Firefox with the FTP server data file.

  merge:function() {
  },

////////////////////////////////////////////////////////////////////////////////
// Gets the appropriate source from the current bookmarks.

  get _source() {
    switch (this._settings.ftpFormat) {
      case "xml":
        var xmlHandler = new SyncMarksHandlerXML(this._syncMarks);
        var document = xmlHandler.document;
        var serializer = new XMLSerializer();
        return "<?xml version=\"1.0\"?>\n" + serializer.serializeToString(document);

      case "html":
        var htmlHandler = new SyncMarksHandlerHTML(this._syncMarks);
        return htmlHandler._source;

      default: return null;
    }
  },

////////////////////////////////////////////////////////////////////////////////
// Gets the URI for transferring the data.

  get _uri() {
    var uri = this._settings.ftpProtocol + "://";

    if (this._settings.ftpUser != "") {
      uri += this._settings.ftpUser;
      if (this._settings.ftpPasswd != "") {
        uri += ":" + this._settings.ftpPasswd;
      }
      uri += "@";
    }

    var ftpPath = this._settings.ftpPath;
    if (! ftpPath.charAt(0) == '/') {
      ftpPath = "/" + ftpPath;
    }

    uri += this._settings.ftpHost + ftpPath;
    return this._ioService.newURI(uri, "UTF-8", null);
  },

////////////////////////////////////////////////////////////////////////////////

  _uploadCallback:function(stat, err) {
    if ((stat != "done") && (err == 0)) {
      return;
    }

    switch (err) {
      case -2:
      case 0:
      case -3:
      default:
        break;
    }

    setTimeout(close, 1000);
  },

////////////////////////////////////////////////////////////////////////////////
};
