// License: http://creativecommons.org/licenses/by-nc-sa/2.0/

function SyncMarks() { this._init(); }

////////////////////////////////////////////////////////////////////////////////

SyncMarks.prototype = {
  settings:null,
  bookmarks:null,

  _console:null,

////////////////////////////////////////////////////////////////////////////////

  // initialize this object
  _init:function() {
    this._console = Components.classes["@mozilla.org/consoleservice;1"]
                    .getService(Components.interfaces.nsIConsoleService);

    this.settings = new SyncMarksSettings(this);
    this.bookmarks = new SyncMarksBookmarks(this);
  },

////////////////////////////////////////////////////////////////////////////////

  get _timestamp() { return parseInt((new Date()).getTime()); },

////////////////////////////////////////////////////////////////////////////////

  // do all desired synchronize operations
  sync:function() {
    // if user wants fast sync, only go if one or more bookmarks has changed
    if (this.settings.fastSync && (! this.bookmarks.changed)) {
      return;
    }

    window.setCursor("wait");
    if (this.settings.favoritesEnabled) { this._syncFavorites(); }
    if (this.settings.xmlEnabled) { this._syncXML(); }
    if (this.settings.htmlEnabled) { this._syncHTML(); }
    if (this.settings.ftpEnabled) { this._syncFTP(); }
    window.setCursor("auto");
    
    this.settings.lastSync = this._timestamp;
  },

////////////////////////////////////////////////////////////////////////////////

  _syncHandler:function(handler) {
    switch (this.settings.method) {
      case "push":  handler.push();  break;
      case "pull":  handler.pull();  break;
      case "merge": handler.merge(); break;
    }
  },

////////////////////////////////////////////////////////////////////////////////

  // synchronize with the Windows Favorites folder
  _syncFavorites:function() {
    this._syncHandler(new SyncMarksHandlerFavorites(this));
  },

////////////////////////////////////////////////////////////////////////////////

  // synchronize with an HTML source
  _syncHTML:function() {
    this._syncHandler(new SyncMarksHandlerHTML(this));
  },

////////////////////////////////////////////////////////////////////////////////

  // synchronize with an XML source
  _syncXML:function() {
    this._syncHandler(new SyncMarksHandlerXML(this));
  },

////////////////////////////////////////////////////////////////////////////////

  // synchronize with the FTP server
  _syncFTP:function() {
    this._syncHandler(new SyncMarksHandlerFTP(this));
  },

////////////////////////////////////////////////////////////////////////////////
};
