// License: http://creativecommons.org/licenses/by-nc-sa/2.0/

function SyncMarksSettings(syncMarks) { this._init(syncMarks); }

////////////////////////////////////////////////////////////////////////////////

SyncMarksSettings.prototype = {
  _syncMarks:null,

////////////////////////////////////////////////////////////////////////////////

  _init:function(syncMarks) { this._syncMarks = syncMarks; },

////////////////////////////////////////////////////////////////////////////////
  
  get _prefroot() { return "extensions.syncmarks.opts."; },

////////////////////////////////////////////////////////////////////////////////

  set method(str) { this._setPref("gen", "method", str); },
  get method() { return this._getPref("gen", "method", "push"); },

  set fastSync(b) { this._setBool("gen", "fast-sync", b); },
  get fastSync() { return this._getBool("gen", "fast-sync", true); },

////////////////////////////////////////////////////////////////////////////////

  // this is stored in seconds, not milliseconds
  set lastSync(val) { this._setInt("gen", "last-sync", val / 1000); },
  get lastSync() { return this._getInt("gen", "last-sync", 0) * 1000; },

////////////////////////////////////////////////////////////////////////////////

  set bmFolder(str) { this._setPref("gen", "bookmark-folder", str); },
  get bmFolder() {
    var folder = this._getPref("gen", "bookmark-folder", "");
    return (folder) ? folder : "NC:BookmarksRoot";
  },

////////////////////////////////////////////////////////////////////////////////

  set xmlFile(str) { this._setPref("xml", "file", str); },
  get xmlFile() { return this._getPref("xml", "file", ""); },

////////////////////////////////////////////////////////////////////////////////

  set htmlFile(str) { this._setPref("html", "file", str); },
  get htmlFile() { return this._getPref("html", "file", ""); },

  set htmlTitle(str) { this._setPref("html", "title", str); },
  get htmlTitle() { return this._getPref("html", "title", "Bookmarks"); },

  set htmlBlank(b) { this._setBool("html", "_blank", b); },
  get htmlBlank() { return this._getBool("html", "_blank", false); },

////////////////////////////////////////////////////////////////////////////////

  set favsFolder(str) { this._setPref("favs", "folder", str); },
  get favsFolder() { return this._getPref("favs", "folder", this.winFavsDir); },

  set favsClean(b) { this._setBool("favs", "clean", b); },
  get favsClean() { return this._getBool("favs", "clean", false); },

////////////////////////////////////////////////////////////////////////////////

  set ftpFormat(str) { this._setPref("ftp", "format", str); },
  get ftpFormat() { return this._getPref("ftp", "format", "xml"); },

  set ftpHost(str) { this._setPref("ftp", "host", str); },
  get ftpHost() { return this._getPref("ftp", "host", ""); },

  set ftpUser(str) { this._setPref("ftp", "user", str); },
  get ftpUser() { return this._getPref("ftp", "user", ""); },

  set ftpPasswd(str) { this._setPref("ftp", "passwd", str); },
  get ftpPasswd() { return this._getPref("ftp", "passwd", ""); },

  set ftpPath(str) { this._setPref("ftp", "path", str); },
  get ftpPath() { return this._getPref("ftp", "path", ""); },

////////////////////////////////////////////////////////////////////////////////

  set syncOnLoad(b) { this._setBool("gen", "autoload", b); },
  get syncOnLoad() { return this._getBool("gen", "autoload", false); },

  set syncOnExit(b) { this._setBool("gen", "autosave", b); },
  get syncOnExit() { return this._getBool("gen", "autosave", false); },

////////////////////////////////////////////////////////////////////////////////

  set favoritesEnabled(b) { this._setBool("favs", "enable", b); },
  get favoritesEnabled() { return this._getBool("favs", "enable", false); },

  set xmlEnabled(b) { this._setBool("xml", "enable", b); },
  get xmlEnabled() { return this._getBool("xml", "enable", false); },

  set htmlEnabled(b) { this._setBool("html", "enable", b); },
  get htmlEnabled() { return this._getBool("html", "enable", false); },

  set ftpEnabled(b) { this._setBool("ftp", "enable", b); },
  get ftpEnabled() { return this._getBool("ftp", "enable", false); },

////////////////////////////////////////////////////////////////////////////////

  // access the common opts elements
  _setOpts:function(mod, str) { nsPreferences.setUnicharPref(this._prefroot + mod, str); },
  _getOpts:function(mod) { return nsPreferences.copyUnicharPref(this._prefroot + mod, ""); },

////////////////////////////////////////////////////////////////////////////////

  // settings with integer values
  _setInt:function(mod, name, value) { this._setPref(mod, name, value); },
  _getInt:function(mod, name, dfault) { return parseInt(this._getPref(mod, name, dfault)); },

  // settings with boolean values
  _setBool:function(mod, name, value) { this._setInt(mod, name, (value) ? 1 : 0); },
  _getBool:function(mod, name, dfault) { return (this._getInt(mod, name, dfault) == 1) ? true : false; },

////////////////////////////////////////////////////////////////////////////////

  // settings with string values
  _setPref:function(mod, name, value) {
    var newopts = "";

    // remove the name from the current options, if it exists
    var pairs = this._getOpts(mod).split("&");
    for (var idx = 0; idx < pairs.length; idx++) {
      var pair = pairs[idx].split("=");
      if ((pair[0] != name) && (pairs[idx] != "")) {
        newopts += pairs[idx] + "&";
      }
    }

    // add the new string to the options & save the options
    newopts += name + "=" + escape(value);
    this._setOpts(mod, newopts);
  },

////////////////////////////////////////////////////////////////////////////////

  _getPref:function(mod, name, dfault) {
    // scan for the name
    var pairs = this._getOpts(mod).split("&");
    for (var idx = 0; idx < pairs.length; idx++) {
      var pair = pairs[idx].split("=");
      if (pair[0] == name) {
        return unescape(pair[1]);
      }
    }

    // still here?  not found...
    return dfault;
  },

////////////////////////////////////////////////////////////////////////////////

  get winFavsDir() {
    var svc = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
    var winFavorites = svc.get('Favs', Components.interfaces.nsILocalFile);
    return (winFavorites.exists()) ? winFavorites.path : "";
  },

////////////////////////////////////////////////////////////////////////////////
};

